#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 Allure
version:              0.11.0.0
visibility:           public
id:                   Allure-0.11.0.0-IkzJzflXZcw61La1Ldnek
key:                  Allure-0.11.0.0-IkzJzflXZcw61La1Ldnek
license:              AGPL-3.0-or-later
maintainer:           Mikolaj Konarski <mikolaj.konarski@funktory.com>
author:               Andres Loeh, Mikolaj Konarski and others
homepage:             http://allureofthestars.com
synopsis:             Near-future Sci-Fi roguelike and tactical squad combat game
description:
    Allure of the Stars is a near-future Sci-Fi roguelike
    and tactical squad combat game. Binaries and the game manual
    are available at the homepage. You can also try the game out
    in the browser at <http://allureofthestars.com/play>.

    Not a single image in this game. You have to imagine everything
    yourself, like with a book (a grown-up book, without pictures).
    Once you learn to imagine things, though, you can keep exploring
    and mastering the world and making up stories for a long time.

    The game is written in Haskell using the LambdaHack roguelike
    game engine <http://hackage.haskell.org/package/LambdaHack>.
    Please see the changelog file for recent improvements
    and the issue tracker for short-term plans. Long term goals
    are high replayability and auto-balancing through procedural
    content generation and persistent content modification
    based on player behaviour. Contributions are welcome.

    This is a workaround .cabal file, flattened to eliminate
    internal libraries until generating haddocks for them
    is fixed. The original .cabal file is in .cabal.bkp file.

category:             Game
abi:                  35f4333fc131782dbeea11df0508e742
exposed:              True
exposed-modules:
    Client.UI.Content.Input Client.UI.Content.Screen Content.CaveKind
    Content.FactionKind Content.ItemKind Content.ItemKindActor
    Content.ItemKindBlast Content.ItemKindEmbed Content.ItemKindOrgan
    Content.ItemKindTemporary Content.ModeKind Content.PlaceKind
    Content.RuleKind Content.TileKind
    Implementation.MonadClientImplementation
    Implementation.MonadServerImplementation TieKnot

hidden-modules:       Paths_Allure
import-dirs:          /usr/lib/ghc-9.2.8/site-local/Allure-0.11.0.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/Allure-0.11.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/allure
hs-libraries:         HSAllure-0.11.0.0-IkzJzflXZcw61La1Ldnek
depends:
    LambdaHack-0.11.0.1-CbK7JKf7t2Q9D9yw6YUWAb
    async-2.2.5-L1pFc6v09ikFDHHjgXlurp base-4.16.4.0
    enummapset-0.7.2.0-JOw5aK6AW8hEz99TfsosWS
    file-embed-0.0.15.0-4hNEx1vJ7JTC58fR03LKND filepath-1.4.2.2
    ghc-compact-0.1.0.0 hsini-0.5.2.2-2ERUgdn6khGA37s75z9oHw
    optparse-applicative-0.17.1.0-Jx8WaQbsFK9BJBRr9ePa2T
    primitive-0.7.4.0-IuAkHfsD4drDvErljoigXB
    splitmix-0.1.0.5-WVelSx5elFIbW9HNAfaBT template-haskell-2.18.0.0
    text-1.2.5.0 th-lift-instances-0.1.20-7md2lkWNOf8FA0lQCdfq6w
    transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/allure/html/Allure.haddock
haddock-html:         /usr/share/doc/allure/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

