#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 arch-hs
version:              0.11.1.0
visibility:           public
id:                   arch-hs-0.11.1.0-2wZ4bNpg2xG2NktsngmpTY
key:                  arch-hs-0.11.1.0-2wZ4bNpg2xG2NktsngmpTY
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  a96727474d81c7aea5b4199c9789fb2e
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.2.8/site-local/arch-hs-0.11.1.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/arch-hs-0.11.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.11.1.0-2wZ4bNpg2xG2NktsngmpTY
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.2.8/site-local/arch-hs-0.11.1.0/include
depends:
    Cabal-3.6.3.0 Diff-0.4.1-B9thiVs2y2uAiqx3tkly0v
    aeson-2.1.2.1-3hy4hA3togDsVnwRqQAZI
    algebraic-graphs-0.7-2uIOzeIR9ddJkq0YQ5i6ym
    arch-web-0.2-A2anPbyyS81JBJ5zbBv6vR base-4.16.4.0
    bytestring-0.11.4.0 conduit-1.3.5-ALk6mfAxZFYZaKKv4bOWs
    conduit-extra-1.3.6-AphCoy0M4zlHtSPxz4pMHB containers-0.6.5.1
    deepseq-1.4.6.1 directory-1.3.6.2 filepath-1.4.2.2
    hackage-db-2.1.3-Ab3Lbpb7MWvKrEv4dRgLy1
    http-client-0.7.15-1GC6b5Bmyn71sLeqrm25Gs
    http-client-tls-0.3.6.3-Cu35gZGVC8nBMMXS4AX6Fr
    megaparsec-9.5.0-7z3AThgMzs3rnIZVIvVtE
    microlens-0.4.13.1-HPplyG5VOciEIF62YegSgA
    microlens-th-0.4.3.15-BttKu46tg2TPgxEFeI4m6
    neat-interpolation-0.5.1.4-IY9P6ZBL4pA4wJyBvwWj9A
    optparse-simple-0.1.1.4-6l9g6l4Ell0JxfI741HtfD
    polysemy-1.9.1.3-BVnAnNMvfLsseQkn0grXc
    prettyprinter-1.7.1-1GpgcfSKvbVDLlexa0B7T5
    prettyprinter-ansi-terminal-1.1.3-Bk17MJ24jKO9mtEtdKdzwP
    servant-client-0.20-CNRGOoLkNXe7Ikk7h1Wuib
    split-0.2.5-FikGR5xLeivE3fJUC4tXgQ
    tar-conduit-0.4.1-6hR8UoOLnYVBPcPWOO3sPH template-haskell-2.18.0.0
    text-1.2.5.0

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

