/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.asn1;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.pqc.asn1.SPHINCSPLUSPublicKey;
import org.bouncycastle.util.Arrays;

public class SPHINCSPLUSPrivateKey
extends ASN1Object {
    private int version;
    private byte[] skseed;
    private byte[] skprf;
    private SPHINCSPLUSPublicKey PublicKey;

    public int getVersion() {
        return this.version;
    }

    public byte[] getSkseed() {
        return Arrays.clone(this.skseed);
    }

    public byte[] getSkprf() {
        return Arrays.clone(this.skprf);
    }

    public SPHINCSPLUSPublicKey getPublicKey() {
        return this.PublicKey;
    }

    public SPHINCSPLUSPrivateKey(int version, byte[] skseed, byte[] skprf) {
        this(version, skseed, skprf, null);
    }

    public SPHINCSPLUSPrivateKey(int version, byte[] skseed, byte[] skprf, SPHINCSPLUSPublicKey publicKey) {
        this.version = version;
        this.skseed = skseed;
        this.skprf = skprf;
        this.PublicKey = publicKey;
    }

    public SPHINCSPLUSPrivateKey(ASN1Sequence seq) {
        this.version = ASN1Integer.getInstance(seq.getObjectAt(0)).intValueExact();
        if (this.version != 0) {
            throw new IllegalArgumentException("unrecognized version");
        }
        this.skseed = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(1)).getOctets());
        this.skprf = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(2)).getOctets());
        if (seq.size() == 4) {
            this.PublicKey = SPHINCSPLUSPublicKey.getInstance(seq.getObjectAt(3));
        }
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(this.version));
        v.add(new DEROctetString(this.skseed));
        v.add(new DEROctetString(this.skprf));
        if (this.PublicKey != null) {
            v.add(new SPHINCSPLUSPublicKey(this.PublicKey.getPkseed(), this.PublicKey.getPkroot()));
        }
        return new DERSequence(v);
    }

    public static SPHINCSPLUSPrivateKey getInstance(Object o) {
        if (o instanceof SPHINCSPLUSPrivateKey) {
            return (SPHINCSPLUSPrivateKey)o;
        }
        if (o != null) {
            return new SPHINCSPLUSPrivateKey(ASN1Sequence.getInstance(o));
        }
        return null;
    }
}

