/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.bike;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.pqc.crypto.bike.BIKEEngine;
import org.bouncycastle.pqc.crypto.bike.BIKEKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.bike.BIKEPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.bike.BIKEPublicKeyParameters;

public class BIKEKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;
    private int r;
    private int l;
    private int L_BYTE;
    private int R_BYTE;
    private BIKEKeyGenerationParameters bikeKeyGenerationParameters;

    @Override
    public void init(KeyGenerationParameters params) {
        this.bikeKeyGenerationParameters = (BIKEKeyGenerationParameters)params;
        this.random = params.getRandom();
        this.r = this.bikeKeyGenerationParameters.getParameters().getR();
        this.l = this.bikeKeyGenerationParameters.getParameters().getL();
        this.L_BYTE = this.l / 8;
        this.R_BYTE = (this.r + 7) / 8;
    }

    private AsymmetricCipherKeyPair genKeyPair() {
        BIKEEngine engine = this.bikeKeyGenerationParameters.getParameters().getEngine();
        byte[] h0 = new byte[this.R_BYTE];
        byte[] h1 = new byte[this.R_BYTE];
        byte[] h = new byte[this.R_BYTE];
        byte[] sigma = new byte[this.L_BYTE];
        engine.genKeyPair(h0, h1, sigma, h, this.random);
        BIKEPublicKeyParameters publicKey = new BIKEPublicKeyParameters(this.bikeKeyGenerationParameters.getParameters(), h);
        BIKEPrivateKeyParameters privateKey = new BIKEPrivateKeyParameters(this.bikeKeyGenerationParameters.getParameters(), h0, h1, sigma);
        return new AsymmetricCipherKeyPair(publicKey, privateKey);
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

