
#ifndef CALENDARSUPPORT_EXPORT_H
#define CALENDARSUPPORT_EXPORT_H

#ifdef CALENDARSUPPORT_STATIC_DEFINE
#  define CALENDARSUPPORT_EXPORT
#  define CALENDARSUPPORT_NO_EXPORT
#else
#  ifndef CALENDARSUPPORT_EXPORT
#    ifdef KPim6CalendarSupport_EXPORTS
        /* We are building this library */
#      define CALENDARSUPPORT_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define CALENDARSUPPORT_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef CALENDARSUPPORT_NO_EXPORT
#    define CALENDARSUPPORT_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef CALENDARSUPPORT_DECL_DEPRECATED
#  define CALENDARSUPPORT_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef CALENDARSUPPORT_DECL_DEPRECATED_EXPORT
#  define CALENDARSUPPORT_DECL_DEPRECATED_EXPORT CALENDARSUPPORT_EXPORT CALENDARSUPPORT_DECL_DEPRECATED
#endif

#ifndef CALENDARSUPPORT_DECL_DEPRECATED_NO_EXPORT
#  define CALENDARSUPPORT_DECL_DEPRECATED_NO_EXPORT CALENDARSUPPORT_NO_EXPORT CALENDARSUPPORT_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef CALENDARSUPPORT_NO_DEPRECATED
#    define CALENDARSUPPORT_NO_DEPRECATED
#  endif
#endif

#define CALENDARSUPPORT_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#if defined(CALENDARSUPPORT_NO_DEPRECATED)
#  undef CALENDARSUPPORT_DEPRECATED
#  define CALENDARSUPPORT_DEPRECATED_EXPORT CALENDARSUPPORT_EXPORT
#  define CALENDARSUPPORT_DEPRECATED_NO_EXPORT CALENDARSUPPORT_NO_EXPORT
#elif defined(CALENDARSUPPORT_NO_DEPRECATED_WARNINGS)
#  define CALENDARSUPPORT_DEPRECATED
#  define CALENDARSUPPORT_DEPRECATED_EXPORT CALENDARSUPPORT_EXPORT
#  define CALENDARSUPPORT_DEPRECATED_NO_EXPORT CALENDARSUPPORT_NO_EXPORT
#else
#  define CALENDARSUPPORT_DEPRECATED CALENDARSUPPORT_DECL_DEPRECATED
#  define CALENDARSUPPORT_DEPRECATED_EXPORT CALENDARSUPPORT_DECL_DEPRECATED_EXPORT
#  define CALENDARSUPPORT_DEPRECATED_NO_EXPORT CALENDARSUPPORT_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define CALENDARSUPPORT_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define CALENDARSUPPORT_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef CALENDARSUPPORT_NO_DEPRECATED
#  define CALENDARSUPPORT_DISABLE_DEPRECATED_BEFORE_AND_AT 0x60102
#endif
#ifdef CALENDARSUPPORT_NO_DEPRECATED_WARNINGS
#  define CALENDARSUPPORT_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef CALENDARSUPPORT_DEPRECATED_WARNINGS_SINCE
#  ifdef CALENDARSUPPORT_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define CALENDARSUPPORT_DEPRECATED_WARNINGS_SINCE CALENDARSUPPORT_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define CALENDARSUPPORT_DEPRECATED_WARNINGS_SINCE 0x60102
#  endif
#endif

#ifndef CALENDARSUPPORT_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define CALENDARSUPPORT_DISABLE_DEPRECATED_BEFORE_AND_AT 0x60000
#endif

#ifdef CALENDARSUPPORT_DEPRECATED
#  define CALENDARSUPPORT_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > CALENDARSUPPORT_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define CALENDARSUPPORT_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if CALENDARSUPPORT_DEPRECATED_WARNINGS_SINCE >= 0x51800
#  define CALENDARSUPPORT_DEPRECATED_VERSION_5_24(text) CALENDARSUPPORT_DECL_DEPRECATED_TEXT(text)
#else
#  define CALENDARSUPPORT_DEPRECATED_VERSION_5_24(text)
#endif
#define CALENDARSUPPORT_DEPRECATED_VERSION_5(minor, text)      CALENDARSUPPORT_DEPRECATED_VERSION_5_##minor(text)
#define CALENDARSUPPORT_DEPRECATED_VERSION(major, minor, text) CALENDARSUPPORT_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define CALENDARSUPPORT_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) CALENDARSUPPORT_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define CALENDARSUPPORT_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) CALENDARSUPPORT_DEPRECATED_VERSION(major, minor, text)
#  define CALENDARSUPPORT_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) CALENDARSUPPORT_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define CALENDARSUPPORT_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define CALENDARSUPPORT_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* CALENDARSUPPORT_EXPORT_H */
