let _ = Mltop.add_known_module "coq-core.plugins.ltac2"

# 13 "plugins/ltac2/g_ltac2.mlg"
 

open Pp
open Util
open Names
open Pcoq
open Attributes
open Constrexpr
open Tac2expr
open Tac2qexpr
open Ltac_plugin

let lk_ident_or_anti =
  Pcoq.Lookahead.(lk_ident <+> (lk_kw "$" >> lk_ident >> check_no_space))

(* lookahead for (x:=t), (?x:=t) and (1:=t) *)
let test_lpar_idnum_coloneq =
  let open Pcoq.Lookahead in
  to_entry "test_lpar_idnum_coloneq" begin
    lk_kw "(" >> (lk_ident_or_anti <+> lk_nat) >> lk_kw ":="
  end

(* lookahead for (x:t), (?x:t) *)
let test_lpar_id_colon =
  let open Pcoq.Lookahead in
  to_entry "test_lpar_id_colon" begin
    lk_kw "(" >> lk_ident_or_anti >> lk_kw ":"
  end

(* Hack to recognize "(x := t)" and "($x := t)" *)
let test_lpar_id_coloneq =
  let open Pcoq.Lookahead in
  to_entry "test_lpar_id_coloneq" begin
    lk_kw "(" >> lk_ident_or_anti >> lk_kw ":="
  end

(* Hack to recognize "(x)" *)
let test_lpar_id_rpar =
  let open Pcoq.Lookahead in
  to_entry "test_lpar_id_rpar" begin
    lk_kw "(" >> lk_ident >> lk_kw ")"
  end

let test_ampersand_ident =
  let open Pcoq.Lookahead in
  to_entry "test_ampersand_ident" begin
    lk_kw "&" >> lk_ident >> check_no_space
  end

let test_dollar_ident =
  let open Pcoq.Lookahead in
  to_entry "test_dollar_ident" begin
    lk_kw "$" >> lk_ident >> check_no_space
  end

let test_dollar_ident_colon_ident =
  let open Pcoq.Lookahead in
  to_entry "test_dollar_ident_colon_ident" begin
    lk_kw "$" >> lk_ident >> lk_kw ":" >> lk_ident >> check_no_space
  end

let test_ltac1_env =
  let open Pcoq.Lookahead in
  to_entry "test_ltac1_env" begin
    lk_ident_list >> lk_kw "|-"
  end

let test_qualid_with_or_lpar_or_rbrac =
  let open Pcoq.Lookahead in
  to_entry "test_qualid_with_or_lpar_or_rbrac" begin
    (lk_qualid >> lk_kw "with") <+> lk_kw "(" <+> lk_kw "{"
  end

let test_array_opening =
  let open Pcoq.Lookahead in
  to_entry "test_array_opening" begin
    lk_kw "[" >> lk_kw "|" >> check_no_space
  end

let test_array_closing =
  let open Pcoq.Lookahead in
  to_entry "test_array_closing" begin
    lk_kw "|" >> lk_kw "]" >> check_no_space
  end

let test_leftsquarebracket_equal =
  let open Pcoq.Lookahead in
  to_entry "test_leftsquarebracket_equal" begin
    lk_kw "[" >> lk_kw "=" >> check_no_space
  end

let ltac2_expr = Tac2entries.Pltac.ltac2_expr
let _ltac2_expr = ltac2_expr
let ltac2_type = Entry.make "ltac2_type"
let tac2def_val = Entry.make "tac2def_val"
let tac2def_typ = Entry.make "tac2def_typ"
let tac2def_ext = Entry.make "tac2def_ext"
let tac2def_syn = Entry.make "tac2def_syn"
let tac2def_mut = Entry.make "tac2def_mut"
let tac2mode = Entry.make "ltac2_command"

let ltac_expr = Pltac.ltac_expr
let tac2expr_in_env = Tac2entries.Pltac.tac2expr_in_env

let inj_wit wit loc x = CAst.make ~loc @@ CTacExt (wit, x)
let inj_open_constr loc c = inj_wit Tac2quote.wit_open_constr loc c
let inj_pattern loc c = inj_wit Tac2quote.wit_pattern loc c
let inj_reference loc c = inj_wit Tac2quote.wit_reference loc c
let inj_ltac1 loc e = inj_wit Tac2quote.wit_ltac1 loc e
let inj_ltac1val loc e = inj_wit Tac2quote.wit_ltac1val loc e

let pattern_of_qualid qid =
  if Tac2env.is_constructor qid then CAst.make ?loc:qid.CAst.loc @@ CPatRef (RelId qid, [])
  else
    let open Libnames in
    if qualid_is_ident qid then CAst.make ?loc:qid.CAst.loc @@ CPatVar (Name (qualid_basename qid))
    else
      CErrors.user_err ?loc:qid.CAst.loc (Pp.str "Syntax error")

let opt_fun ?loc args ty e =
  let e = match ty with
  | None -> e
  | Some ty -> CAst.make ?loc:e.CAst.loc (CTacCnv (e, ty))
  in
  match args with
  | [] -> e
  | _ :: _ -> CAst.make ?loc (CTacFun (args, e))



let _ = let tac2pat = Pcoq.Entry.make "tac2pat"
        and atomic_tac2pat = Pcoq.Entry.make "atomic_tac2pat"
        and array_literal = Pcoq.Entry.make "array_literal"
        and list_literal = Pcoq.Entry.make "list_literal"
        and branches = Pcoq.Entry.make "branches"
        and branch = Pcoq.Entry.make "branch"
        and rec_flag = Pcoq.Entry.make "rec_flag"
        and mut_flag = Pcoq.Entry.make "mut_flag"
        and ltac2_typevar = Pcoq.Entry.make "ltac2_typevar"
        and tactic_atom = Pcoq.Entry.make "tactic_atom"
        and ltac1_expr_in_env = Pcoq.Entry.make "ltac1_expr_in_env"
        and type_cast = Pcoq.Entry.make "type_cast"
        and let_clause = Pcoq.Entry.make "let_clause"
        and let_binder = Pcoq.Entry.make "let_binder"
        and locident = Pcoq.Entry.make "locident"
        and binder = Pcoq.Entry.make "binder"
        and input_fun = Pcoq.Entry.make "input_fun"
        and tac2def_body = Pcoq.Entry.make "tac2def_body"
        and tac2typ_knd = Pcoq.Entry.make "tac2typ_knd"
        and tac2alg_constructors = Pcoq.Entry.make "tac2alg_constructors"
        and tac2alg_constructor = Pcoq.Entry.make "tac2alg_constructor"
        and tac2rec_fields = Pcoq.Entry.make "tac2rec_fields"
        and tac2rec_field = Pcoq.Entry.make "tac2rec_field"
        and tac2rec_fieldexprs = Pcoq.Entry.make "tac2rec_fieldexprs"
        and tac2rec_fieldexpr = Pcoq.Entry.make "tac2rec_fieldexpr"
        and tac2rec_fieldpats = Pcoq.Entry.make "tac2rec_fieldpats"
        and tac2rec_fieldpat = Pcoq.Entry.make "tac2rec_fieldpat"
        and tac2typ_prm = Pcoq.Entry.make "tac2typ_prm"
        and tac2typ_def = Pcoq.Entry.make "tac2typ_def"
        and tac2type_body = Pcoq.Entry.make "tac2type_body"
        and syn_node = Pcoq.Entry.make "syn_node"
        and ltac2_scope = Pcoq.Entry.make "ltac2_scope"
        and syn_level = Pcoq.Entry.make "syn_level"
        and lident = Pcoq.Entry.make "lident"
        and globref = Pcoq.Entry.make "globref"
        in
        let () = assert (Pcoq.Entry.is_empty tac2pat) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:0")
        tac2pat
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(Some ("1"), Some (Gramlib.Gramext.LeftA),
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm tac2pat)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("as")))))
                                                  ((Pcoq.Symbol.nterm lident)))
                                  (fun id _ p loc -> 
# 160 "plugins/ltac2/g_ltac2.mlg"
                                            CAst.make ~loc @@ CPatAs (p,id) 
                                                     );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm tac2pat)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("|")))))
                                                 ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterm tac2pat)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                                 (fun pl _ p loc -> 
# 158 "plugins/ltac2/g_ltac2.mlg"
          let pl = p :: pl in
          CAst.make ~loc @@ CPatOr pl 
                                                    );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm tac2pat)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("::")))))
                                                 ((Pcoq.Symbol.nterm tac2pat)))
                                 (fun p2 _ p1 loc -> 
# 156 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CPatRef (AbsKn (Other Tac2core.Core.c_cons), [p1; p2])
                                                     );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm Prim.qualid)))
                                 (fun qid loc -> 
# 153 "plugins/ltac2/g_ltac2.mlg"
                               pattern_of_qualid qid 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm Prim.qualid)))
                                                 ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterml tac2pat ("0"))))))
                                 (fun pl qid loc -> 
# 148 "plugins/ltac2/g_ltac2.mlg"
                                                            
        if Tac2env.is_constructor qid then
          CAst.make ~loc @@ CPatRef (RelId qid, pl)
        else
          CErrors.user_err ~loc (Pp.str "Syntax error") 
                                                    )]);
                                (Some ("0"), None,
                                [Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("[")))))
                                                                 ((Pcoq.Symbol.list0sep ((Pcoq.Symbol.nterm tac2pat)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD (";"))])) false)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("]")))))
                                 (fun _ pats _ loc -> 
# 171 "plugins/ltac2/g_ltac2.mlg"
         
          let nil = CAst.make ~loc @@ CPatRef (AbsKn (Other Tac2core.Core.c_nil), []) in
          let cons hd tl = CAst.make ~loc @@ CPatRef (AbsKn (Other Tac2core.Core.c_cons), [hd;tl]) in
          List.fold_right cons pats nil
        
                                                      );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                (Pcoq.Rule.stop)
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("{")))))
                                                                ((Pcoq.Symbol.nterm tac2rec_fieldpats)))
                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("}")))))
                                (fun _ a _ loc -> 
# 169 "plugins/ltac2/g_ltac2.mlg"
                                             CAst.make ~loc @@ CPatRecord a 
                                                  );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                (Pcoq.Rule.stop)
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                ((Pcoq.Symbol.nterm atomic_tac2pat)))
                                                ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                (fun _ p _ loc -> 
# 168 "plugins/ltac2/g_ltac2.mlg"
                                          p 
                                                  );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                ((Pcoq.Symbol.nterm Prim.qualid)))
                                (fun qid loc -> 
# 167 "plugins/ltac2/g_ltac2.mlg"
                               pattern_of_qualid qid 
                                                );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                ((Pcoq.Symbol.nterm Prim.string)))
                                (fun s loc -> 
# 166 "plugins/ltac2/g_ltac2.mlg"
                             CAst.make ~loc @@ CPatAtm (AtmStr s) 
                                              );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                ((Pcoq.Symbol.nterm Prim.integer)))
                                (fun n loc -> 
# 165 "plugins/ltac2/g_ltac2.mlg"
                              CAst.make ~loc @@ CPatAtm (AtmInt n) 
                                              );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("()")))))
                                (fun _ loc -> 
# 164 "plugins/ltac2/g_ltac2.mlg"
                  CAst.make ~loc @@ CPatRef (AbsKn (Tuple 0), []) 
                                              );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("_")))))
                                (fun _ loc -> 
# 163 "plugins/ltac2/g_ltac2.mlg"
                 CAst.make ~loc @@ CPatVar Anonymous 
                                              )])]))
        in let () = assert (Pcoq.Entry.is_empty atomic_tac2pat) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:1")
        atomic_tac2pat
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm tac2pat)))
                                  (fun p loc -> 
# 186 "plugins/ltac2/g_ltac2.mlg"
                         p 
                                                );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm tac2pat)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (",")))))
                                                 ((Pcoq.Symbol.list0sep ((Pcoq.Symbol.nterm tac2pat)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD (","))])) false)))
                                 (fun pl _ p loc -> 
# 184 "plugins/ltac2/g_ltac2.mlg"
          let pl = p :: pl in
          CAst.make ~loc @@ CPatRef (AbsKn (Tuple (List.length pl)), pl) 
                                                    );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm tac2pat)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                 ((Pcoq.Symbol.nterm ltac2_type)))
                                 (fun t _ p loc -> 
# 182 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CPatCnv (p, t) 
                                                   );
                                 Pcoq.Production.make (Pcoq.Rule.stop)
                                 (fun loc -> 
# 180 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CPatRef (AbsKn (Tuple 0), []) 
                                             )])]))
        in let () = assert (Pcoq.Entry.is_empty ltac2_expr) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:2")
        ltac2_expr
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(Some ("6"), Some (Gramlib.Gramext.RightA),
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  (Pcoq.Symbol.self))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (";")))))
                                                  (Pcoq.Symbol.self))
                                  (fun e2 _ e1 loc -> 
# 191 "plugins/ltac2/g_ltac2.mlg"
                                         CAst.make ~loc @@ CTacSeq (e1, e2) 
                                                      )]);
                                (Some ("5"), None,
                                [Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("if")))))
                                                                 ((Pcoq.Symbol.nterml ltac2_expr ("5"))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("then")))))
                                                                 ((Pcoq.Symbol.nterml ltac2_expr ("5"))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("else")))))
                                                 ((Pcoq.Symbol.nterml ltac2_expr ("5"))))
                                 (fun e2 _ e1 _ e _ loc -> 
# 202 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacIft (e, e1, e2) 
                                                           );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.stop)
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("match")))))
                                                                ((Pcoq.Symbol.nterml ltac2_expr ("5"))))
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("with")))))
                                                                ((Pcoq.Symbol.nterm branches)))
                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("end")))))
                                (fun _ bl _ e _ loc -> 
# 200 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacCse (e, bl) 
                                                       );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.stop)
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("let")))))
                                                                ((Pcoq.Symbol.nterm rec_flag)))
                                                                ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterm let_clause)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("with"))])) false)))
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("in")))))
                                                ((Pcoq.Symbol.nterml ltac2_expr ("6"))))
                                (fun e _ lc isrec _ loc -> 
# 198 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacLet (isrec, lc, e) 
                                                           );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.stop)
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("fun")))))
                                                                ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm input_fun)))))
                                                                ((Pcoq.Symbol.nterm type_cast)))
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("=>")))))
                                                ((Pcoq.Symbol.nterml ltac2_expr ("6"))))
                                (fun body _ ty it _ loc -> 
# 194 "plugins/ltac2/g_ltac2.mlg"
          opt_fun ~loc it ty body 
                                                           )]);
                                (Some ("4"), Some (Gramlib.Gramext.LeftA),
                                []);
                                (Some ("3"), None,
                                [Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 (Pcoq.Symbol.self))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (",")))))
                                                 ((Pcoq.Symbol.list1sep (Pcoq.Symbol.next) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD (","))])) false)))
                                 (fun el _ e0 loc -> 
# 206 "plugins/ltac2/g_ltac2.mlg"
          let el = e0 :: el in
          CAst.make ~loc @@ CTacApp (CAst.make ~loc @@ CTacCst (AbsKn (Tuple (List.length el))), el) 
                                                     )]);
                                (Some ("2"), Some (Gramlib.Gramext.RightA),
                                [Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm ltac2_expr)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("::")))))
                                                 ((Pcoq.Symbol.nterm ltac2_expr)))
                                 (fun e2 _ e1 loc -> 
# 210 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacApp (CAst.make ~loc @@ CTacCst (AbsKn (Other Tac2core.Core.c_cons)), [e1; e2]) 
                                                     )]);
                                (Some ("1"), Some (Gramlib.Gramext.LeftA),
                                [Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 (Pcoq.Symbol.self))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (".(")))))
                                                                 ((Pcoq.Symbol.nterm Prim.qualid)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                 ((Pcoq.Symbol.nterml ltac2_expr ("5"))))
                                 (fun r _ _ qid _ e loc -> 
# 218 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacSet (e, RelId qid, r) 
                                                           );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.stop)
                                                                (Pcoq.Symbol.self))
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD (".(")))))
                                                                ((Pcoq.Symbol.nterm Prim.qualid)))
                                                ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                (fun _ qid _ e loc -> 
# 216 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacPrj (e, RelId qid) 
                                                      );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                ((Pcoq.Symbol.nterm ltac2_expr)))
                                                ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterml ltac2_expr ("0"))))))
                                (fun el e loc -> 
# 214 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacApp (e, el) 
                                                 )]);
                                (Some ("0"), None,
                                [Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm tactic_atom)))
                                 (fun a loc -> 
# 233 "plugins/ltac2/g_ltac2.mlg"
                             a 
                                               );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                (Pcoq.Rule.stop)
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("{")))))
                                                                ((Pcoq.Symbol.nterm tac2rec_fieldexprs)))
                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("}")))))
                                (fun _ a _ loc -> 
# 232 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacRec (None, a) 
                                                  );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.stop)
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("{")))))
                                                                ((Pcoq.Symbol.nterm test_qualid_with_or_lpar_or_rbrac)))
                                                                ((Pcoq.Symbol.nterml ltac2_expr ("0"))))
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("with")))))
                                                                ((Pcoq.Symbol.nterm tac2rec_fieldexprs)))
                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("}")))))
                                (fun _ a _ e _ _ loc -> 
# 230 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacRec (Some e, a) 
                                                        );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                ((Pcoq.Symbol.nterm list_literal)))
                                (fun a loc -> 
# 228 "plugins/ltac2/g_ltac2.mlg"
                              a 
                                              );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                ((Pcoq.Symbol.nterm array_literal)))
                                (fun a loc -> 
# 227 "plugins/ltac2/g_ltac2.mlg"
                               a 
                                              );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                (fun _ _ loc -> 
# 226 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacCst (AbsKn (Tuple 0)) 
                                                );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("()")))))
                                (fun _ loc -> 
# 224 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacCst (AbsKn (Tuple 0)) 
                                              );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.stop)
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                (Pcoq.Symbol.self))
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                                ((Pcoq.Symbol.nterm ltac2_type)))
                                                ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                (fun _ t _ a _ loc -> 
# 222 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ CTacCnv (a, t) 
                                                      );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                (Pcoq.Rule.stop)
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                (Pcoq.Symbol.self))
                                                ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                (fun _ a _ loc -> 
# 220 "plugins/ltac2/g_ltac2.mlg"
                                a 
                                                  )])]))
        in let () = assert (Pcoq.Entry.is_empty array_literal) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:3")
        array_literal
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm test_array_opening)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("[")))))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("|")))))
                                                                  ((Pcoq.Symbol.list0sep ((Pcoq.Symbol.nterml ltac2_expr ("5"))) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD (";"))])) false)))
                                                                  ((Pcoq.Symbol.nterm test_array_closing)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("|")))))
                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("]")))))
                                  (fun _ _ _ a _ _ _ loc -> 
# 238 "plugins/ltac2/g_ltac2.mlg"
        Tac2quote.array_of_list (Tac2quote.of_list ~loc (fun x -> x) a) 
                                                            )])]))
        in let () = assert (Pcoq.Entry.is_empty list_literal) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:4")
        list_literal
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("[")))))
                                                                  ((Pcoq.Symbol.list0sep ((Pcoq.Symbol.nterml ltac2_expr ("5"))) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD (";"))])) false)))
                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("]")))))
                                  (fun _ a _ loc -> 
# 242 "plugins/ltac2/g_ltac2.mlg"
         Tac2quote.of_list ~loc (fun x -> x) a 
                                                    )])]))
        in let () = assert (Pcoq.Entry.is_empty branches) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:5")
        branches
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterm branch)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                                  (fun bl loc -> 
# 247 "plugins/ltac2/g_ltac2.mlg"
                                     bl 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("|")))))
                                                 ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterm branch)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                                 (fun bl _ loc -> 
# 246 "plugins/ltac2/g_ltac2.mlg"
                                          bl 
                                                  );
                                 Pcoq.Production.make (Pcoq.Rule.stop)
                                 (fun loc -> 
# 245 "plugins/ltac2/g_ltac2.mlg"
           [] 
                                             )])]))
        in let () = assert (Pcoq.Entry.is_empty branch) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:6")
        branch
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm atomic_tac2pat)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("=>")))))
                                                  ((Pcoq.Symbol.nterml ltac2_expr ("6"))))
                                  (fun e _ pat loc -> 
# 251 "plugins/ltac2/g_ltac2.mlg"
                                                                (pat, e) 
                                                      )])]))
        in let () = assert (Pcoq.Entry.is_empty rec_flag) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:7")
        rec_flag
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 255 "plugins/ltac2/g_ltac2.mlg"
             false 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                 ("rec"))))))
                                 (fun _ loc -> 
# 254 "plugins/ltac2/g_ltac2.mlg"
                         true 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty mut_flag) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:8")
        mut_flag
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 259 "plugins/ltac2/g_ltac2.mlg"
             false 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                 ("mutable"))))))
                                 (fun _ loc -> 
# 258 "plugins/ltac2/g_ltac2.mlg"
                             true 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty ltac2_typevar) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:9")
        ltac2_typevar
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("'")))))
                                                  ((Pcoq.Symbol.nterm Prim.ident)))
                                  (fun id _ loc -> 
# 262 "plugins/ltac2/g_ltac2.mlg"
                                  id 
                                                   )])]))
        in let () = assert (Pcoq.Entry.is_empty tactic_atom) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:10")
        tactic_atom
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                  ("ltac1val"))))))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                  ((Pcoq.Symbol.nterm ltac1_expr_in_env)))
                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                  (fun _ qid _ _ _ loc -> 
# 282 "plugins/ltac2/g_ltac2.mlg"
                                                                      inj_ltac1val loc qid 
                                                          );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("ltac1"))))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                 ((Pcoq.Symbol.nterm ltac1_expr_in_env)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                 (fun _ qid _ _ _ loc -> 
# 281 "plugins/ltac2/g_ltac2.mlg"
                                                                   inj_ltac1 loc qid 
                                                         );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("reference"))))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                 ((Pcoq.Symbol.nterm globref)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                 (fun _ c _ _ _ loc -> 
# 280 "plugins/ltac2/g_ltac2.mlg"
                                                           inj_reference loc c 
                                                       );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("pat"))))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                 ((Pcoq.Symbol.nterm Constr.cpattern)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                 (fun _ c _ _ _ loc -> 
# 279 "plugins/ltac2/g_ltac2.mlg"
                                                             inj_pattern loc c 
                                                       );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("ident"))))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                 ((Pcoq.Symbol.nterm lident)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                 (fun _ c _ _ _ loc -> 
# 278 "plugins/ltac2/g_ltac2.mlg"
                                                      Tac2quote.of_ident c 
                                                       );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("preterm"))))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                 ((Pcoq.Symbol.nterm Constr.lconstr)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                 (fun _ c _ _ _ loc -> 
# 277 "plugins/ltac2/g_ltac2.mlg"
                                                                Tac2quote.of_preterm c 
                                                       );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("open_constr"))))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                 ((Pcoq.Symbol.nterm Constr.lconstr)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                 (fun _ c _ _ _ loc -> 
# 276 "plugins/ltac2/g_ltac2.mlg"
                                                                    Tac2quote.of_open_constr c 
                                                       );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("constr"))))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                 ((Pcoq.Symbol.nterm Constr.lconstr)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                 (fun _ c _ _ _ loc -> 
# 275 "plugins/ltac2/g_ltac2.mlg"
                                                               Tac2quote.of_constr c 
                                                       );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("'")))))
                                                 ((Pcoq.Symbol.nterm Constr.constr)))
                                 (fun c _ loc -> 
# 274 "plugins/ltac2/g_ltac2.mlg"
                                    inj_open_constr loc c 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("&")))))
                                                 ((Pcoq.Symbol.nterm lident)))
                                 (fun id _ loc -> 
# 273 "plugins/ltac2/g_ltac2.mlg"
                              Tac2quote.of_hyp ~loc id 
                                                  );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("@")))))
                                                 ((Pcoq.Symbol.nterm Prim.ident)))
                                 (fun id _ loc -> 
# 272 "plugins/ltac2/g_ltac2.mlg"
                                  Tac2quote.of_ident (CAst.make ~loc id) 
                                                  );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm Prim.qualid)))
                                 (fun qid loc -> 
# 268 "plugins/ltac2/g_ltac2.mlg"
        if Tac2env.is_constructor qid then
          CAst.make ~loc @@ CTacCst (RelId qid)
        else
          CAst.make ~loc @@ CTacRef (RelId qid) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm Prim.string)))
                                 (fun s loc -> 
# 266 "plugins/ltac2/g_ltac2.mlg"
                             CAst.make ~loc @@ CTacAtm (AtmStr s) 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm Prim.integer)))
                                 (fun n loc -> 
# 265 "plugins/ltac2/g_ltac2.mlg"
                              CAst.make ~loc @@ CTacAtm (AtmInt n) 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty ltac1_expr_in_env) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:11")
        ltac1_expr_in_env
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm ltac_expr)))
                                  (fun e loc -> 
# 287 "plugins/ltac2/g_ltac2.mlg"
                           [], e 
                                                );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm test_ltac1_env)))
                                                                 ((Pcoq.Symbol.list0 (Pcoq.Symbol.nterm locident))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("|-")))))
                                                 ((Pcoq.Symbol.nterm ltac_expr)))
                                 (fun e _ ids _ loc -> 
# 286 "plugins/ltac2/g_ltac2.mlg"
                                                                       ids, e 
                                                       )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2expr_in_env) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:12")
        tac2expr_in_env
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm ltac2_expr)))
                                  (fun tac loc -> 
# 299 "plugins/ltac2/g_ltac2.mlg"
                              [], tac 
                                                  );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm test_ltac1_env)))
                                                                 ((Pcoq.Symbol.list0 (Pcoq.Symbol.nterm locident))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("|-")))))
                                                 ((Pcoq.Symbol.nterm ltac2_expr)))
                                 (fun e _ ids _ loc -> 
# 292 "plugins/ltac2/g_ltac2.mlg"
        let check { CAst.v = id; CAst.loc = loc } =
          if Tac2env.is_constructor (Libnames.qualid_of_ident ?loc id) then
            CErrors.user_err ?loc Pp.(str "Invalid bound Ltac2 identifier " ++ Id.print id)
        in
        let () = List.iter check ids in
        (ids, e)
      
                                                       )])]))
        in let () = assert (Pcoq.Entry.is_empty type_cast) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:13")
        type_cast
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                  ((Pcoq.Symbol.nterm ltac2_type)))
                                  (fun ty _ loc -> 
# 304 "plugins/ltac2/g_ltac2.mlg"
                                  Some ty 
                                                   );
                                 Pcoq.Production.make (Pcoq.Rule.stop)
                                 (fun loc -> 
# 303 "plugins/ltac2/g_ltac2.mlg"
             None 
                                             )])]))
        in let () = assert (Pcoq.Entry.is_empty let_clause) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:14")
        let_clause
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm let_binder)))
                                                                  ((Pcoq.Symbol.nterm type_cast)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                  ((Pcoq.Symbol.nterm ltac2_expr)))
                                  (fun te _ ty binder loc -> 
# 309 "plugins/ltac2/g_ltac2.mlg"
        let (pat, fn) = binder in
        let te = opt_fun ~loc fn ty te in
        (pat, te) 
                                                             )])]))
        in let () = assert (Pcoq.Entry.is_empty let_binder) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:15")
        let_binder
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm input_fun)))))
                                  (fun pats loc -> 
# 316 "plugins/ltac2/g_ltac2.mlg"
        match pats with
        | [{CAst.v=CPatVar _} as pat] -> (pat, [])
        | ({CAst.v=CPatVar (Name id)} as pat) :: args -> (pat, args)
        | [pat] -> (pat, [])
        | _ -> CErrors.user_err ~loc (str "Invalid pattern") 
                                                   )])]))
        in let () = assert (Pcoq.Entry.is_empty ltac2_type) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:16")
        ltac2_type
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(Some ("5"), Some (Gramlib.Gramext.RightA),
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm ltac2_type)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("->")))))
                                                  ((Pcoq.Symbol.nterm ltac2_type)))
                                  (fun t2 _ t1 loc -> 
# 325 "plugins/ltac2/g_ltac2.mlg"
                                                    CAst.make ~loc @@ CTypArrow (t1, t2) 
                                                      )]);
                                (Some ("2"), None,
                                [Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm ltac2_type)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("*")))))
                                                 ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterml ltac2_type ("1"))) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("*"))])) false)))
                                 (fun tl _ t loc -> 
# 328 "plugins/ltac2/g_ltac2.mlg"
        let tl = t :: tl in
        CAst.make ~loc @@ CTypRef (AbsKn (Tuple (List.length tl)), tl) 
                                                    )]);
                                (Some ("1"), Some (Gramlib.Gramext.LeftA),
                                [Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 (Pcoq.Symbol.self))
                                                 ((Pcoq.Symbol.nterm Prim.qualid)))
                                 (fun qid t loc -> 
# 331 "plugins/ltac2/g_ltac2.mlg"
                                         CAst.make ~loc @@ CTypRef (RelId qid, [t]) 
                                                   )]);
                                (Some ("0"), None,
                                [Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm Prim.qualid)))
                                 (fun qid loc -> 
# 341 "plugins/ltac2/g_ltac2.mlg"
                               CAst.make ~loc @@ CTypRef (RelId qid, []) 
                                                 );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("_")))))
                                (fun _ loc -> 
# 340 "plugins/ltac2/g_ltac2.mlg"
                 CAst.make ~loc @@ CTypVar Anonymous 
                                              );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                ((Pcoq.Symbol.nterm ltac2_typevar)))
                                (fun id loc -> 
# 339 "plugins/ltac2/g_ltac2.mlg"
                                CAst.make ~loc @@ CTypVar (Name id) 
                                               );
                                Pcoq.Production.make
                                (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.stop)
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterml ltac2_type ("5"))) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD (","))])) false)))
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                                ((Pcoq.Symbol.opt (Pcoq.Symbol.nterm Prim.qualid))))
                                (fun qid _ p _ loc -> 
# 334 "plugins/ltac2/g_ltac2.mlg"
          match p, qid with
          | [t], None -> t
          | _, None -> CErrors.user_err ~loc (Pp.str "Syntax error")
          | ts, Some qid -> CAst.make ~loc @@ CTypRef (RelId qid, p)
        
                                                      )])]))
        in let () = assert (Pcoq.Entry.is_empty locident) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:17")
        locident
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm Prim.ident)))
                                  (fun id loc -> 
# 345 "plugins/ltac2/g_ltac2.mlg"
                             CAst.make ~loc id 
                                                 )])]))
        in let () = assert (Pcoq.Entry.is_empty binder) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:18")
        binder
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm Prim.ident)))
                                  (fun l loc -> 
# 349 "plugins/ltac2/g_ltac2.mlg"
                            CAst.make ~loc (Name l) 
                                                );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("_")))))
                                 (fun _ loc -> 
# 348 "plugins/ltac2/g_ltac2.mlg"
                 CAst.make ~loc Anonymous 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty input_fun) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:19")
        input_fun
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterml tac2pat ("0"))))
                                  (fun b loc -> 
# 352 "plugins/ltac2/g_ltac2.mlg"
                                   b 
                                                )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2def_body) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:20")
        tac2def_body
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm binder)))
                                                                  ((Pcoq.Symbol.list0 (Pcoq.Symbol.nterm input_fun))))
                                                                  ((Pcoq.Symbol.nterm type_cast)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                  ((Pcoq.Symbol.nterm ltac2_expr)))
                                  (fun e _ ty it name loc -> 
# 356 "plugins/ltac2/g_ltac2.mlg"
        (name, opt_fun ~loc it ty e) 
                                                             )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2def_val) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:21")
        tac2def_val
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm mut_flag)))
                                                                  ((Pcoq.Symbol.nterm rec_flag)))
                                                  ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterm tac2def_body)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("with"))])) false)))
                                  (fun l isrec mut loc -> 
# 361 "plugins/ltac2/g_ltac2.mlg"
          StrVal (mut, isrec, l) 
                                                          )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2def_mut) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:22")
        tac2def_mut
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("Set")))))
                                                                  ((Pcoq.Symbol.nterm Prim.qualid)))
                                                                  ((Pcoq.Symbol.opt (Pcoq.Symbol.rules 
                                                                  [Pcoq.Rules.make 
                                                                  (Pcoq.Rule.next_norec 
                                                                  (Pcoq.Rule.next_norec 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("as")))))
                                                                  ((Pcoq.Symbol.nterm locident)))
                                                                  (fun id _
                                                                  loc -> 
                                                                  
# 365 "plugins/ltac2/g_ltac2.mlg"
                                                                       id 
                                                                  )]))))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                  ((Pcoq.Symbol.nterm ltac2_expr)))
                                  (fun e _ old qid _ loc -> 
# 365 "plugins/ltac2/g_ltac2.mlg"
                                                                                                         StrMut (qid, old, e) 
                                                            )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2typ_knd) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:23")
        tac2typ_knd
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("{")))))
                                                                  ((Pcoq.Symbol.nterm tac2rec_fields)))
                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("}")))))
                                  (fun _ t _ loc -> 
# 371 "plugins/ltac2/g_ltac2.mlg"
                                         CTydRec t 
                                                    );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("[")))))
                                                                 ((Pcoq.Symbol.nterm tac2alg_constructors)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("]")))))
                                 (fun _ t _ loc -> 
# 370 "plugins/ltac2/g_ltac2.mlg"
                                                CTydAlg t 
                                                   );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("[")))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("..")))))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("]")))))
                                 (fun _ _ _ loc -> 
# 369 "plugins/ltac2/g_ltac2.mlg"
                            CTydOpn 
                                                   );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm ltac2_type)))
                                 (fun t loc -> 
# 368 "plugins/ltac2/g_ltac2.mlg"
                            CTydDef (Some t) 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2alg_constructors)
        in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:24")
        tac2alg_constructors
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.list0sep ((Pcoq.Symbol.nterm tac2alg_constructor)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                                  (fun cs loc -> 
# 375 "plugins/ltac2/g_ltac2.mlg"
                                                    cs 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("|")))))
                                                 ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterm tac2alg_constructor)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                                 (fun cs _ loc -> 
# 374 "plugins/ltac2/g_ltac2.mlg"
                                                         cs 
                                                  )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2alg_constructor)
        in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:25")
        tac2alg_constructor
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm Prim.ident)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                  ((Pcoq.Symbol.list0sep ((Pcoq.Symbol.nterm ltac2_type)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD (","))])) false)))
                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                  (fun _ args _ c loc -> 
# 379 "plugins/ltac2/g_ltac2.mlg"
                                                                      (c, args) 
                                                         );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm Prim.ident)))
                                 (fun c loc -> 
# 378 "plugins/ltac2/g_ltac2.mlg"
                            (c, []) 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2rec_fields) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:26")
        tac2rec_fields
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 385 "plugins/ltac2/g_ltac2.mlg"
             [] 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm tac2rec_field)))
                                 (fun f loc -> 
# 384 "plugins/ltac2/g_ltac2.mlg"
                               [f] 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm tac2rec_field)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (";")))))
                                 (fun _ f loc -> 
# 383 "plugins/ltac2/g_ltac2.mlg"
                                    [f] 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm tac2rec_field)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (";")))))
                                                 ((Pcoq.Symbol.nterm tac2rec_fields)))
                                 (fun l _ f loc -> 
# 382 "plugins/ltac2/g_ltac2.mlg"
                                                        f :: l 
                                                   )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2rec_field) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:27")
        tac2rec_field
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm mut_flag)))
                                                                  ((Pcoq.Symbol.nterm Prim.ident)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                  ((Pcoq.Symbol.nterm ltac2_type)))
                                  (fun t _ id mut loc -> 
# 388 "plugins/ltac2/g_ltac2.mlg"
                                                                  (id, mut, t) 
                                                         )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2rec_fieldexprs)
        in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:28")
        tac2rec_fieldexprs
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 394 "plugins/ltac2/g_ltac2.mlg"
             [] 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm tac2rec_fieldexpr)))
                                 (fun f loc -> 
# 393 "plugins/ltac2/g_ltac2.mlg"
                                  [f] 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm tac2rec_fieldexpr)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (";")))))
                                 (fun _ f loc -> 
# 392 "plugins/ltac2/g_ltac2.mlg"
                                        [f] 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm tac2rec_fieldexpr)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (";")))))
                                                 ((Pcoq.Symbol.nterm tac2rec_fieldexprs)))
                                 (fun l _ f loc -> 
# 391 "plugins/ltac2/g_ltac2.mlg"
                                                                f :: l 
                                                   )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2rec_fieldexpr) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:29")
        tac2rec_fieldexpr
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm Prim.qualid)))
                                                  ((Pcoq.Symbol.opt (Pcoq.Symbol.rules 
                                                  [Pcoq.Rules.make (Pcoq.Rule.next_norec 
                                                                   (Pcoq.Rule.next_norec 
                                                                   (Pcoq.Rule.stop)
                                                                   ((Pcoq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                                   ((Pcoq.Symbol.nterml ltac2_expr ("1"))))
                                                                   (fun e _
                                                                   loc -> 
                                                                   
# 397 "plugins/ltac2/g_ltac2.mlg"
                                                                         e 
                                                                   )]))))
                                  (fun e qid loc -> 
# 398 "plugins/ltac2/g_ltac2.mlg"
          let e = match e with
          | Some e -> e
          | None ->
            (* punning: [Foo.bar] becomes [Foo.bar := bar] *)
            let id = Libnames.qualid_basename qid in
            CAst.make ~loc @@ CTacRef (RelId (Libnames.qualid_of_ident ~loc id))
          in
          RelId qid, e 
                                                    )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2rec_fieldpats) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:30")
        tac2rec_fieldpats
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 412 "plugins/ltac2/g_ltac2.mlg"
             [] 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm tac2rec_fieldpat)))
                                 (fun f loc -> 
# 411 "plugins/ltac2/g_ltac2.mlg"
                                 [f] 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm tac2rec_fieldpat)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (";")))))
                                 (fun _ f loc -> 
# 410 "plugins/ltac2/g_ltac2.mlg"
                                       [f] 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm tac2rec_fieldpat)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (";")))))
                                                 ((Pcoq.Symbol.nterm tac2rec_fieldpats)))
                                 (fun l _ f loc -> 
# 409 "plugins/ltac2/g_ltac2.mlg"
                                                              f :: l 
                                                   )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2rec_fieldpat) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:31")
        tac2rec_fieldpat
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm Prim.qualid)))
                                                  ((Pcoq.Symbol.opt (Pcoq.Symbol.rules 
                                                  [Pcoq.Rules.make (Pcoq.Rule.next_norec 
                                                                   (Pcoq.Rule.next_norec 
                                                                   (Pcoq.Rule.stop)
                                                                   ((Pcoq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                                   ((Pcoq.Symbol.nterml tac2pat ("1"))))
                                                                   (fun e _
                                                                   loc -> 
                                                                   
# 415 "plugins/ltac2/g_ltac2.mlg"
                                                                      e 
                                                                   )]))))
                                  (fun e qid loc -> 
# 416 "plugins/ltac2/g_ltac2.mlg"
          let e = match e with
          | Some e -> e
          | None ->
            (* punning: [Foo.bar] becomes [Foo.bar := bar] *)
            let id = Libnames.qualid_basename qid in
            CAst.make ~loc @@ CPatVar (Name id)
          in
          RelId qid, e 
                                                    )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2typ_prm) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:32")
        tac2typ_prm
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                  ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.rules 
                                                                  [Pcoq.Rules.make 
                                                                  (Pcoq.Rule.next_norec 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm ltac2_typevar)))
                                                                  (fun id
                                                                  loc -> 
                                                                  
# 429 "plugins/ltac2/g_ltac2.mlg"
                                                   CAst.make ~loc id 
                                                                  )])) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD (","))])) false)))
                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                  (fun _ ids _ loc -> 
# 429 "plugins/ltac2/g_ltac2.mlg"
                                                                                           ids 
                                                      );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm ltac2_typevar)))
                                 (fun id loc -> 
# 428 "plugins/ltac2/g_ltac2.mlg"
                                [CAst.make ~loc id] 
                                                );
                                 Pcoq.Production.make (Pcoq.Rule.stop)
                                 (fun loc -> 
# 427 "plugins/ltac2/g_ltac2.mlg"
             [] 
                                             )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2typ_def) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:33")
        tac2typ_def
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm tac2typ_prm)))
                                                                  ((Pcoq.Symbol.nterm Prim.qualid)))
                                                  ((Pcoq.Symbol.nterm tac2type_body)))
                                  (fun b id prm loc -> 
# 433 "plugins/ltac2/g_ltac2.mlg"
                                                                    let (r, e) = b in (id, r, (prm, e)) 
                                                       )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2type_body) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:34")
        tac2type_body
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("::=")))))
                                                  ((Pcoq.Symbol.nterm tac2typ_knd)))
                                  (fun e _ loc -> 
# 438 "plugins/ltac2/g_ltac2.mlg"
                                    true, e 
                                                  );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                 ((Pcoq.Symbol.nterm tac2typ_knd)))
                                 (fun e _ loc -> 
# 437 "plugins/ltac2/g_ltac2.mlg"
                                   false, e 
                                                 );
                                 Pcoq.Production.make (Pcoq.Rule.stop)
                                 (fun loc -> 
# 436 "plugins/ltac2/g_ltac2.mlg"
             false, CTydDef None 
                                             )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2def_typ) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:35")
        tac2def_typ
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("Type")))))
                                                                  ((Pcoq.Symbol.nterm rec_flag)))
                                                  ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterm tac2typ_def)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("with"))])) false)))
                                  (fun l isrec _ loc -> 
# 443 "plugins/ltac2/g_ltac2.mlg"
          StrTyp (isrec, l) 
                                                        )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2def_ext) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:36")
        tac2def_ext
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("@")))))
                                                                  ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                  ("external"))))))
                                                                  ((Pcoq.Symbol.nterm locident)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                                  ((Pcoq.Symbol.nterml ltac2_type ("5"))))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                                  ((Pcoq.Symbol.nterm Prim.string)))
                                                  ((Pcoq.Symbol.nterm Prim.string)))
                                  (fun name plugin _ t _ id _ _ loc -> 
# 449 "plugins/ltac2/g_ltac2.mlg"
        let ml = { mltac_plugin = plugin; mltac_tactic = name } in
        StrPrm (id, t, ml) 
                                                                    )])]))
        in let () = assert (Pcoq.Entry.is_empty syn_node) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:37")
        syn_node
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm Prim.ident)))
                                  (fun id loc -> 
# 455 "plugins/ltac2/g_ltac2.mlg"
                             CAst.make ~loc (Some id) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("_")))))
                                 (fun _ loc -> 
# 454 "plugins/ltac2/g_ltac2.mlg"
                 CAst.make ~loc None 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty ltac2_scope) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:38")
        ltac2_scope
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm syn_node)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                  ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterm ltac2_scope)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD (","))])) false)))
                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                  (fun _ tok _ id loc -> 
# 463 "plugins/ltac2/g_ltac2.mlg"
          SexprRec (loc, id, tok) 
                                                         );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm syn_node)))
                                 (fun id loc -> 
# 461 "plugins/ltac2/g_ltac2.mlg"
                           SexprRec (loc, id, []) 
                                                );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm Prim.integer)))
                                 (fun n loc -> 
# 460 "plugins/ltac2/g_ltac2.mlg"
                              SexprInt (CAst.make ~loc n) 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm Prim.string)))
                                 (fun s loc -> 
# 459 "plugins/ltac2/g_ltac2.mlg"
                             SexprStr (CAst.make ~loc s) 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty syn_level) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:39")
        syn_level
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                  ((Pcoq.Symbol.nterm Prim.natural)))
                                  (fun n _ loc -> 
# 468 "plugins/ltac2/g_ltac2.mlg"
                                   Some n 
                                                  );
                                 Pcoq.Production.make (Pcoq.Rule.stop)
                                 (fun loc -> 
# 467 "plugins/ltac2/g_ltac2.mlg"
             None 
                                             )])]))
        in let () = assert (Pcoq.Entry.is_empty tac2def_syn) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:40")
        tac2def_syn
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm ltac2_scope)))))
                                                                  ((Pcoq.Symbol.nterm syn_level)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                  ((Pcoq.Symbol.nterm ltac2_expr)))
                                  (fun e _ n toks loc -> 
# 474 "plugins/ltac2/g_ltac2.mlg"
          (toks, n, e) 
                                                         )])]))
        in let () = assert (Pcoq.Entry.is_empty lident) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:41")
        lident
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm Prim.ident)))
                                  (fun id loc -> 
# 478 "plugins/ltac2/g_ltac2.mlg"
                             CAst.make ~loc id 
                                                 )])]))
        in let () = assert (Pcoq.Entry.is_empty globref) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:42")
        globref
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm Prim.qualid)))
                                  (fun qid loc -> 
# 482 "plugins/ltac2/g_ltac2.mlg"
                               CAst.make ~loc @@ QReference qid 
                                                  );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("&")))))
                                                 ((Pcoq.Symbol.nterm Prim.ident)))
                                 (fun id _ loc -> 
# 481 "plugins/ltac2/g_ltac2.mlg"
                                  CAst.make ~loc (QHypothesis id) 
                                                  )])]))
        in ()


# 489 "plugins/ltac2/g_ltac2.mlg"
 

open Tac2entries.Pltac



let _ = let anti = Pcoq.Entry.make "anti"
        and ident_or_anti = Pcoq.Entry.make "ident_or_anti"
        and lident = Pcoq.Entry.make "lident"
        and lnatural = Pcoq.Entry.make "lnatural"
        and qhyp = Pcoq.Entry.make "qhyp"
        and simple_binding = Pcoq.Entry.make "simple_binding"
        and bindings = Pcoq.Entry.make "bindings"
        and intropatterns = Pcoq.Entry.make "intropatterns"
        and or_and_intropattern = Pcoq.Entry.make "or_and_intropattern"
        and equality_intropattern = Pcoq.Entry.make "equality_intropattern"
        and naming_intropattern = Pcoq.Entry.make "naming_intropattern"
        and nonsimple_intropattern = Pcoq.Entry.make "nonsimple_intropattern"
        and simple_intropattern = Pcoq.Entry.make "simple_intropattern"
        and simple_intropattern_closed =
          Pcoq.Entry.make "simple_intropattern_closed"
        and nat_or_anti = Pcoq.Entry.make "nat_or_anti"
        and eqn_ipat = Pcoq.Entry.make "eqn_ipat"
        and with_bindings = Pcoq.Entry.make "with_bindings"
        and constr_with_bindings = Pcoq.Entry.make "constr_with_bindings"
        and destruction_arg = Pcoq.Entry.make "destruction_arg"
        and as_or_and_ipat = Pcoq.Entry.make "as_or_and_ipat"
        and occs_nums = Pcoq.Entry.make "occs_nums"
        and occs = Pcoq.Entry.make "occs"
        and hypident = Pcoq.Entry.make "hypident"
        and hypident_occ = Pcoq.Entry.make "hypident_occ"
        and in_clause = Pcoq.Entry.make "in_clause"
        and clause = Pcoq.Entry.make "clause"
        and concl_occ = Pcoq.Entry.make "concl_occ"
        and induction_clause = Pcoq.Entry.make "induction_clause"
        and conversion = Pcoq.Entry.make "conversion"
        and rewriter = Pcoq.Entry.make "rewriter"
        and oriented_rewriter = Pcoq.Entry.make "oriented_rewriter"
        and tactic_then_last = Pcoq.Entry.make "tactic_then_last"
        and for_each_goal = Pcoq.Entry.make "for_each_goal"
        and ltac2_red_flag = Pcoq.Entry.make "ltac2_red_flag"
        and refglobal = Pcoq.Entry.make "refglobal"
        and refglobals = Pcoq.Entry.make "refglobals"
        and delta_flag = Pcoq.Entry.make "delta_flag"
        and strategy_flag = Pcoq.Entry.make "strategy_flag"
        and hintdb = Pcoq.Entry.make "hintdb"
        and match_pattern = Pcoq.Entry.make "match_pattern"
        and match_rule = Pcoq.Entry.make "match_rule"
        and match_list = Pcoq.Entry.make "match_list"
        and gmatch_hyp_pattern = Pcoq.Entry.make "gmatch_hyp_pattern"
        and gmatch_pattern = Pcoq.Entry.make "gmatch_pattern"
        and gmatch_rule = Pcoq.Entry.make "gmatch_rule"
        and goal_match_list = Pcoq.Entry.make "goal_match_list"
        and move_location = Pcoq.Entry.make "move_location"
        and as_name = Pcoq.Entry.make "as_name"
        and pose = Pcoq.Entry.make "pose"
        and as_ipat = Pcoq.Entry.make "as_ipat"
        and by_tactic = Pcoq.Entry.make "by_tactic"
        and assertion = Pcoq.Entry.make "assertion"
        in
        let () = assert (Pcoq.Entry.is_empty anti) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:43")
        anti
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("$")))))
                                                  ((Pcoq.Symbol.nterm Prim.ident)))
                                  (fun id _ loc -> 
# 501 "plugins/ltac2/g_ltac2.mlg"
                                  QAnti (CAst.make ~loc id) 
                                                   )])]))
        in let () = assert (Pcoq.Entry.is_empty ident_or_anti) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:44")
        ident_or_anti
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("$")))))
                                                  ((Pcoq.Symbol.nterm Prim.ident)))
                                  (fun id _ loc -> 
# 505 "plugins/ltac2/g_ltac2.mlg"
                                  QAnti (CAst.make ~loc id) 
                                                   );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm lident)))
                                 (fun id loc -> 
# 504 "plugins/ltac2/g_ltac2.mlg"
                         QExpr id 
                                                )])]))
        in let () = assert (Pcoq.Entry.is_empty lident) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:45")
        lident
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm Prim.ident)))
                                  (fun id loc -> 
# 509 "plugins/ltac2/g_ltac2.mlg"
                             CAst.make ~loc id 
                                                 )])]))
        in let () = assert (Pcoq.Entry.is_empty lnatural) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:46")
        lnatural
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm Prim.natural)))
                                  (fun n loc -> 
# 512 "plugins/ltac2/g_ltac2.mlg"
                              CAst.make ~loc n 
                                                )])]))
        in let () = assert (Pcoq.Entry.is_empty q_ident) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:47")
        q_ident
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm ident_or_anti)))
                                  (fun id loc -> 
# 515 "plugins/ltac2/g_ltac2.mlg"
                                id 
                                                 )])]))
        in let () = assert (Pcoq.Entry.is_empty qhyp) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:48")
        qhyp
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm lident)))
                                  (fun id loc -> 
# 520 "plugins/ltac2/g_ltac2.mlg"
                         QExpr (CAst.make ~loc @@ QNamedHyp id) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm lnatural)))
                                 (fun n loc -> 
# 519 "plugins/ltac2/g_ltac2.mlg"
                          QExpr (CAst.make ~loc @@ QAnonHyp n) 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm anti)))
                                 (fun x loc -> 
# 518 "plugins/ltac2/g_ltac2.mlg"
                      x 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty simple_binding) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:49")
        simple_binding
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                  ((Pcoq.Symbol.nterm qhyp)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                                  ((Pcoq.Symbol.nterm Constr.lconstr)))
                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                  (fun _ c _ h _ loc -> 
# 525 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc (h, c) 
                                                        )])]))
        in let () = assert (Pcoq.Entry.is_empty bindings) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:50")
        bindings
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm Constr.constr)))))
                                  (fun bl loc -> 
# 532 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QImplicitBindings bl 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm test_lpar_idnum_coloneq)))
                                                 ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm simple_binding)))))
                                 (fun bl _ loc -> 
# 530 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QExplicitBindings bl 
                                                  )])]))
        in let () = assert (Pcoq.Entry.is_empty q_bindings) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:51")
        q_bindings
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm bindings)))
                                  (fun bl loc -> 
# 536 "plugins/ltac2/g_ltac2.mlg"
                           bl 
                                                 )])]))
        in let () = assert (Pcoq.Entry.is_empty q_with_bindings) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:52")
        q_with_bindings
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm with_bindings)))
                                  (fun bl loc -> 
# 539 "plugins/ltac2/g_ltac2.mlg"
                                bl 
                                                 )])]))
        in let () = assert (Pcoq.Entry.is_empty intropatterns) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:53")
        intropatterns
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.list0 (Pcoq.Symbol.nterm nonsimple_intropattern))))
                                  (fun l loc -> 
# 542 "plugins/ltac2/g_ltac2.mlg"
                                              CAst.make ~loc l 
                                                )])]))
        in let () = assert (Pcoq.Entry.is_empty or_and_intropattern)
        in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:54")
        or_and_intropattern
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                  ((Pcoq.Symbol.nterm simple_intropattern)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("&")))))
                                                                  ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterm simple_intropattern)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("&"))])) false)))
                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                  (fun _ tc _ si _ loc -> 
# 557 "plugins/ltac2/g_ltac2.mlg"
          let rec pairify = function
            | ([]|[_]|[_;_]) as l -> CAst.make ~loc l
            | t::q ->
              let q =
                CAst.make ~loc @@
                  QIntroAction (CAst.make ~loc @@
                    QIntroOrAndPattern (CAst.make ~loc @@
                      QIntroAndPattern (pairify q)))
              in
              CAst.make ~loc [t; q]
          in CAst.make ~loc @@ QIntroAndPattern (pairify (si::tc)) 
                                                          );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                 ((Pcoq.Symbol.nterm simple_intropattern)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (",")))))
                                                                 ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterm simple_intropattern)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD (","))])) false)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                 (fun _ tc _ si _ loc -> 
# 553 "plugins/ltac2/g_ltac2.mlg"
               CAst.make ~loc @@ QIntroAndPattern (CAst.make ~loc (si::tc)) 
                                                         );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                 ((Pcoq.Symbol.nterm simple_intropattern)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                 (fun _ si _ loc -> 
# 550 "plugins/ltac2/g_ltac2.mlg"
                                                CAst.make ~loc @@ QIntroAndPattern (CAst.make ~loc [si]) 
                                                    );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("()")))))
                                 (fun _ loc -> 
# 549 "plugins/ltac2/g_ltac2.mlg"
                  CAst.make ~loc @@ QIntroAndPattern (CAst.make ~loc []) 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("[")))))
                                                                 ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterm intropatterns)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("]")))))
                                 (fun _ tc _ loc -> 
# 548 "plugins/ltac2/g_ltac2.mlg"
                                                        CAst.make ~loc @@ QIntroOrPattern tc 
                                                    )])]))
        in let () = assert (Pcoq.Entry.is_empty equality_intropattern)
        in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:55")
        equality_intropattern
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm test_leftsquarebracket_equal)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("[")))))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("=")))))
                                                                  ((Pcoq.Symbol.nterm intropatterns)))
                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("]")))))
                                  (fun _ tc _ _ _ loc -> 
# 572 "plugins/ltac2/g_ltac2.mlg"
                                                                             CAst.make ~loc @@ QIntroInjection tc 
                                                         );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("<-")))))
                                 (fun _ loc -> 
# 571 "plugins/ltac2/g_ltac2.mlg"
                  CAst.make ~loc @@ QIntroRewrite false 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("->")))))
                                 (fun _ loc -> 
# 570 "plugins/ltac2/g_ltac2.mlg"
                  CAst.make ~loc @@ QIntroRewrite true 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty naming_intropattern)
        in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:56")
        naming_intropattern
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm ident_or_anti)))
                                  (fun id loc -> 
# 582 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QIntroIdentifier id 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("?")))))
                                 (fun _ loc -> 
# 580 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QIntroAnonymous 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("?$")))))
                                                 ((Pcoq.Symbol.nterm lident)))
                                 (fun id _ loc -> 
# 578 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QIntroFresh (QAnti id) 
                                                  );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PLEFTQMARK))))
                                                 ((Pcoq.Symbol.nterm lident)))
                                 (fun id _ loc -> 
# 576 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QIntroFresh (QExpr id) 
                                                  )])]))
        in let () = assert (Pcoq.Entry.is_empty nonsimple_intropattern)
        in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:57")
        nonsimple_intropattern
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("**")))))
                                  (fun _ loc -> 
# 588 "plugins/ltac2/g_ltac2.mlg"
                  CAst.make ~loc @@ QIntroForthcoming false 
                                                );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("*")))))
                                 (fun _ loc -> 
# 587 "plugins/ltac2/g_ltac2.mlg"
                  CAst.make ~loc @@ QIntroForthcoming true 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm simple_intropattern)))
                                 (fun l loc -> 
# 586 "plugins/ltac2/g_ltac2.mlg"
                                     l 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty simple_intropattern)
        in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:58")
        simple_intropattern
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm simple_intropattern_closed)))
                                  (fun pat loc -> 
# 594 "plugins/ltac2/g_ltac2.mlg"
          pat 
                                                  )])]))
        in let () = assert (Pcoq.Entry.is_empty simple_intropattern_closed)
        in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:59")
        simple_intropattern_closed
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm naming_intropattern)))
                                  (fun pat loc -> 
# 605 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QIntroNaming pat 
                                                  );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("_")))))
                                 (fun _ loc -> 
# 603 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QIntroAction (CAst.make ~loc @@ QIntroWildcard) 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm equality_intropattern)))
                                 (fun pat loc -> 
# 601 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QIntroAction pat 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm or_and_intropattern)))
                                 (fun pat loc -> 
# 599 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QIntroAction (CAst.make ~loc @@ QIntroOrAndPattern pat) 
                                                 )])]))
        in let () = assert (Pcoq.Entry.is_empty q_intropatterns) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:60")
        q_intropatterns
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm intropatterns)))
                                  (fun ipat loc -> 
# 609 "plugins/ltac2/g_ltac2.mlg"
                                  ipat 
                                                   )])]))
        in let () = assert (Pcoq.Entry.is_empty q_intropattern) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:61")
        q_intropattern
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm simple_intropattern)))
                                  (fun ipat loc -> 
# 612 "plugins/ltac2/g_ltac2.mlg"
                                        ipat 
                                                   )])]))
        in let () = assert (Pcoq.Entry.is_empty nat_or_anti) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:62")
        nat_or_anti
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("$")))))
                                                  ((Pcoq.Symbol.nterm Prim.ident)))
                                  (fun id _ loc -> 
# 616 "plugins/ltac2/g_ltac2.mlg"
                                  QAnti (CAst.make ~loc id) 
                                                   );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm lnatural)))
                                 (fun n loc -> 
# 615 "plugins/ltac2/g_ltac2.mlg"
                          QExpr n 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty eqn_ipat) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:63")
        eqn_ipat
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 621 "plugins/ltac2/g_ltac2.mlg"
             None 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("eqn"))))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                 ((Pcoq.Symbol.nterm naming_intropattern)))
                                 (fun pat _ _ loc -> 
# 620 "plugins/ltac2/g_ltac2.mlg"
                                                         Some pat 
                                                     )])]))
        in let () = assert (Pcoq.Entry.is_empty with_bindings) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:64")
        with_bindings
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 625 "plugins/ltac2/g_ltac2.mlg"
                                               CAst.make ~loc @@ QNoBindings 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("with")))))
                                                 ((Pcoq.Symbol.nterm bindings)))
                                 (fun bl _ loc -> 
# 625 "plugins/ltac2/g_ltac2.mlg"
                                   bl 
                                                  )])]))
        in let () = assert (Pcoq.Entry.is_empty constr_with_bindings)
        in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:65")
        constr_with_bindings
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm Constr.constr)))
                                                  ((Pcoq.Symbol.nterm with_bindings)))
                                  (fun l c loc -> 
# 628 "plugins/ltac2/g_ltac2.mlg"
                                                  CAst.make ~loc @@ (c, l) 
                                                  )])]))
        in let () = assert (Pcoq.Entry.is_empty destruction_arg) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:66")
        destruction_arg
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm constr_with_bindings)))
                                  (fun c loc -> 
# 633 "plugins/ltac2/g_ltac2.mlg"
                                      CAst.make ~loc @@ QElimOnConstr c 
                                                );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm lident)))
                                 (fun id loc -> 
# 632 "plugins/ltac2/g_ltac2.mlg"
                         CAst.make ~loc @@ QElimOnIdent id 
                                                );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm lnatural)))
                                 (fun n loc -> 
# 631 "plugins/ltac2/g_ltac2.mlg"
                          CAst.make ~loc @@ QElimOnAnonHyp n 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty q_destruction_arg) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:67")
        q_destruction_arg
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm destruction_arg)))
                                  (fun arg loc -> 
# 637 "plugins/ltac2/g_ltac2.mlg"
                                   arg 
                                                  )])]))
        in let () = assert (Pcoq.Entry.is_empty as_or_and_ipat) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:68")
        as_or_and_ipat
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 641 "plugins/ltac2/g_ltac2.mlg"
             None 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("as")))))
                                                 ((Pcoq.Symbol.nterm or_and_intropattern)))
                                 (fun ipat _ loc -> 
# 640 "plugins/ltac2/g_ltac2.mlg"
                                              Some ipat 
                                                    )])]))
        in let () = assert (Pcoq.Entry.is_empty occs_nums) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:69")
        occs_nums
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("-")))))
                                                                  ((Pcoq.Symbol.nterm nat_or_anti)))
                                                  ((Pcoq.Symbol.list0 (Pcoq.Symbol.nterm nat_or_anti))))
                                  (fun nl n _ loc -> 
# 647 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QAllOccurrencesBut (n::nl) 
                                                     );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm nat_or_anti)))))
                                 (fun nl loc -> 
# 645 "plugins/ltac2/g_ltac2.mlg"
                                    CAst.make ~loc @@ QOnlyOccurrences nl 
                                                )])]))
        in let () = assert (Pcoq.Entry.is_empty occs) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:70")
        occs
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 651 "plugins/ltac2/g_ltac2.mlg"
                                                  CAst.make ~loc QAllOccurrences 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("at")))))
                                                 ((Pcoq.Symbol.nterm occs_nums)))
                                 (fun occs _ loc -> 
# 651 "plugins/ltac2/g_ltac2.mlg"
                                    occs 
                                                    )])]))
        in let () = assert (Pcoq.Entry.is_empty hypident) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:71")
        hypident
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                  ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                  ("value"))))))
                                                                  ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                  ("of"))))))
                                                                  ((Pcoq.Symbol.nterm ident_or_anti)))
                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                  (fun _ id _ _ _ loc -> 
# 659 "plugins/ltac2/g_ltac2.mlg"
          id,Locus.InHypValueOnly 
                                                         );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("type"))))))
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("of"))))))
                                                                 ((Pcoq.Symbol.nterm ident_or_anti)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                 (fun _ id _ _ _ loc -> 
# 657 "plugins/ltac2/g_ltac2.mlg"
          id,Locus.InHypTypeOnly 
                                                        );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm ident_or_anti)))
                                 (fun id loc -> 
# 655 "plugins/ltac2/g_ltac2.mlg"
          id,Locus.InHyp 
                                                )])]))
        in let () = assert (Pcoq.Entry.is_empty hypident_occ) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:72")
        hypident_occ
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm hypident)))
                                                  ((Pcoq.Symbol.nterm occs)))
                                  (fun occs h loc -> 
# 663 "plugins/ltac2/g_ltac2.mlg"
                                   let (id,l) = h in ((occs,id),l) 
                                                     )])]))
        in let () = assert (Pcoq.Entry.is_empty in_clause) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:73")
        in_clause
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.list0sep ((Pcoq.Symbol.nterm hypident_occ)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD (","))])) false)))
                                  (fun hl loc -> 
# 673 "plugins/ltac2/g_ltac2.mlg"
          { q_onhyps = Some hl; q_concl_occs = CAst.make ~loc QNoOccurrences } 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.list0sep ((Pcoq.Symbol.nterm hypident_occ)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD (","))])) false)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("|-")))))
                                                 ((Pcoq.Symbol.nterm concl_occ)))
                                 (fun occs _ hl loc -> 
# 671 "plugins/ltac2/g_ltac2.mlg"
          { q_onhyps = Some hl; q_concl_occs = occs } 
                                                       );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("*")))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("|-")))))
                                                 ((Pcoq.Symbol.nterm concl_occ)))
                                 (fun occs _ _ loc -> 
# 669 "plugins/ltac2/g_ltac2.mlg"
          { q_onhyps = None; q_concl_occs = occs } 
                                                      );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("*")))))
                                                 ((Pcoq.Symbol.nterm occs)))
                                 (fun occs _ loc -> 
# 667 "plugins/ltac2/g_ltac2.mlg"
          { q_onhyps = None; q_concl_occs = occs } 
                                                    )])]))
        in let () = assert (Pcoq.Entry.is_empty clause) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:74")
        clause
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("at")))))
                                                  ((Pcoq.Symbol.nterm occs_nums)))
                                  (fun occs _ loc -> 
# 679 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ { q_onhyps = Some []; q_concl_occs = occs } 
                                                     );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("in")))))
                                                 ((Pcoq.Symbol.nterm in_clause)))
                                 (fun cl _ loc -> 
# 677 "plugins/ltac2/g_ltac2.mlg"
                                  CAst.make ~loc @@ cl 
                                                  )])]))
        in let () = assert (Pcoq.Entry.is_empty q_clause) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:75")
        q_clause
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm clause)))
                                  (fun cl loc -> 
# 683 "plugins/ltac2/g_ltac2.mlg"
                         cl 
                                                 )])]))
        in let () = assert (Pcoq.Entry.is_empty concl_occ) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:76")
        concl_occ
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 687 "plugins/ltac2/g_ltac2.mlg"
             CAst.make ~loc QNoOccurrences 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("*")))))
                                                 ((Pcoq.Symbol.nterm occs)))
                                 (fun occs _ loc -> 
# 686 "plugins/ltac2/g_ltac2.mlg"
                              occs 
                                                    )])]))
        in let () = assert (Pcoq.Entry.is_empty induction_clause) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:77")
        induction_clause
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm destruction_arg)))
                                                                  ((Pcoq.Symbol.nterm as_or_and_ipat)))
                                                                  ((Pcoq.Symbol.nterm eqn_ipat)))
                                                  ((Pcoq.Symbol.opt (Pcoq.Symbol.nterm clause))))
                                  (fun cl eq pat c loc -> 
# 693 "plugins/ltac2/g_ltac2.mlg"
        CAst.make ~loc @@ {
          indcl_arg = c;
          indcl_eqn = eq;
          indcl_as = pat;
          indcl_in = cl;
        } 
                                                          )])]))
        in let () = assert (Pcoq.Entry.is_empty q_induction_clause)
        in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:78")
        q_induction_clause
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm induction_clause)))
                                  (fun cl loc -> 
# 702 "plugins/ltac2/g_ltac2.mlg"
                                   cl 
                                                 )])]))
        in let () = assert (Pcoq.Entry.is_empty conversion) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:79")
        conversion
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm Constr.constr)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("with")))))
                                                  ((Pcoq.Symbol.nterm Constr.constr)))
                                  (fun c2 _ c1 loc -> 
# 708 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QConvertWith (c1, c2) 
                                                      );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm Constr.constr)))
                                 (fun c loc -> 
# 706 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ QConvert c 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty q_conversion) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:80")
        q_conversion
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm conversion)))
                                  (fun c loc -> 
# 712 "plugins/ltac2/g_ltac2.mlg"
                            c 
                                                )])]))
        in let () = assert (Pcoq.Entry.is_empty q_orient) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:81")
        q_orient
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 717 "plugins/ltac2/g_ltac2.mlg"
             CAst.make ~loc None 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("<-")))))
                                 (fun _ loc -> 
# 716 "plugins/ltac2/g_ltac2.mlg"
                  CAst.make ~loc (Some false) 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("->")))))
                                 (fun _ loc -> 
# 715 "plugins/ltac2/g_ltac2.mlg"
                  CAst.make ~loc (Some true) 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty rewriter) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:82")
        rewriter
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm constr_with_bindings)))
                                  (fun c loc -> 
# 732 "plugins/ltac2/g_ltac2.mlg"
          (CAst.make ~loc @@ QPrecisely (CAst.make 1), c) 
                                                );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm lnatural)))
                                                 ((Pcoq.Symbol.nterm constr_with_bindings)))
                                 (fun c n loc -> 
# 730 "plugins/ltac2/g_ltac2.mlg"
          (CAst.make ~loc @@ QPrecisely n,c) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm lnatural)))
                                                                 ((Pcoq.Symbol.rules 
                                                                 [Pcoq.Rules.make 
                                                                 (Pcoq.Rule.next_norec 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PLEFTQMARK))))
                                                                 (fun _
                                                                 loc -> 
                                                                 
# 727 "plugins/ltac2/g_ltac2.mlg"
                                                      () 
                                                                 );
                                                                 Pcoq.Rules.make 
                                                                 (Pcoq.Rule.next_norec 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("?")))))
                                                                 (fun _
                                                                 loc -> 
                                                                 
# 727 "plugins/ltac2/g_ltac2.mlg"
                                () 
                                                                 )])))
                                                 ((Pcoq.Symbol.nterm constr_with_bindings)))
                                 (fun c _ n loc -> 
# 728 "plugins/ltac2/g_ltac2.mlg"
          (CAst.make ~loc @@ QUpTo n,c) 
                                                   );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm lnatural)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("!")))))
                                                 ((Pcoq.Symbol.nterm constr_with_bindings)))
                                 (fun c _ n loc -> 
# 726 "plugins/ltac2/g_ltac2.mlg"
          (CAst.make ~loc @@ QPrecisely n,c) 
                                                   );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.rules 
                                                                 [Pcoq.Rules.make 
                                                                 (Pcoq.Rule.next_norec 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PLEFTQMARK))))
                                                                 (fun _
                                                                 loc -> 
                                                                 
# 723 "plugins/ltac2/g_ltac2.mlg"
                                         () 
                                                                 );
                                                                 Pcoq.Rules.make 
                                                                 (Pcoq.Rule.next_norec 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("?")))))
                                                                 (fun _
                                                                 loc -> 
                                                                 
# 723 "plugins/ltac2/g_ltac2.mlg"
                   () 
                                                                 )])))
                                                 ((Pcoq.Symbol.nterm constr_with_bindings)))
                                 (fun c _ loc -> 
# 724 "plugins/ltac2/g_ltac2.mlg"
          (CAst.make ~loc @@ QRepeatStar,c) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("!")))))
                                                 ((Pcoq.Symbol.nterm constr_with_bindings)))
                                 (fun c _ loc -> 
# 722 "plugins/ltac2/g_ltac2.mlg"
          (CAst.make ~loc @@ QRepeatPlus,c) 
                                                 )])]))
        in let () = assert (Pcoq.Entry.is_empty oriented_rewriter) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:83")
        oriented_rewriter
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm q_orient)))
                                                  ((Pcoq.Symbol.nterm rewriter)))
                                  (fun r b loc -> 
# 737 "plugins/ltac2/g_ltac2.mlg"
        let (m, c) = r in
        CAst.make ~loc @@ {
        rew_orient = b;
        rew_repeat = m;
        rew_equatn = c;
      } 
                                                  )])]))
        in let () = assert (Pcoq.Entry.is_empty q_rewriting) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:84")
        q_rewriting
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm oriented_rewriter)))
                                  (fun r loc -> 
# 746 "plugins/ltac2/g_ltac2.mlg"
                                   r 
                                                )])]))
        in let () = assert (Pcoq.Entry.is_empty tactic_then_last) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:85")
        tactic_then_last
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 750 "plugins/ltac2/g_ltac2.mlg"
             [] 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("|")))))
                                                 ((Pcoq.Symbol.list0sep ((Pcoq.Symbol.opt (Pcoq.Symbol.nterml ltac2_expr ("6")))) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                                 (fun lta _ loc -> 
# 749 "plugins/ltac2/g_ltac2.mlg"
                                                                 lta 
                                                   )])]))
        in let () = assert (Pcoq.Entry.is_empty for_each_goal) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:86")
        for_each_goal
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 759 "plugins/ltac2/g_ltac2.mlg"
             ([None], None) 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("|")))))
                                                 ((Pcoq.Symbol.nterm for_each_goal)))
                                 (fun tg _ loc -> 
# 758 "plugins/ltac2/g_ltac2.mlg"
                                     let (first,last) = tg in (None :: first, last) 
                                                  );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm ltac2_expr)))
                                 (fun ta loc -> 
# 757 "plugins/ltac2/g_ltac2.mlg"
                             ([Some ta], None) 
                                                );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("..")))))
                                                 ((Pcoq.Symbol.nterm tactic_then_last)))
                                 (fun l _ loc -> 
# 756 "plugins/ltac2/g_ltac2.mlg"
                                        ([], Some (None, l)) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm ltac2_expr)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("..")))))
                                                 ((Pcoq.Symbol.nterm tactic_then_last)))
                                 (fun l _ ta loc -> 
# 755 "plugins/ltac2/g_ltac2.mlg"
                                                         ([], Some (Some ta, l)) 
                                                    );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm ltac2_expr)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("|")))))
                                                 ((Pcoq.Symbol.nterm for_each_goal)))
                                 (fun tg _ ta loc -> 
# 754 "plugins/ltac2/g_ltac2.mlg"
                                                      let (first,last) = tg in (Some ta :: first, last) 
                                                     )])]))
        in let () = assert (Pcoq.Entry.is_empty q_dispatch) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:87")
        q_dispatch
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm for_each_goal)))
                                  (fun d loc -> 
# 763 "plugins/ltac2/g_ltac2.mlg"
                               CAst.make ~loc d 
                                                )])]))
        in let () = assert (Pcoq.Entry.is_empty q_occurrences) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:88")
        q_occurrences
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm occs)))
                                  (fun occs loc -> 
# 766 "plugins/ltac2/g_ltac2.mlg"
                         occs 
                                                   )])]))
        in let () = assert (Pcoq.Entry.is_empty ltac2_red_flag) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:89")
        ltac2_red_flag
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                  ("head"))))))
                                  (fun _ loc -> 
# 776 "plugins/ltac2/g_ltac2.mlg"
                          CAst.make ~loc @@ QHead 
                                                );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("delta"))))))
                                                 ((Pcoq.Symbol.nterm delta_flag)))
                                 (fun d _ loc -> 
# 775 "plugins/ltac2/g_ltac2.mlg"
                                           d 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                 ("zeta"))))))
                                 (fun _ loc -> 
# 774 "plugins/ltac2/g_ltac2.mlg"
                          CAst.make ~loc @@ QZeta 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                 ("cofix"))))))
                                 (fun _ loc -> 
# 773 "plugins/ltac2/g_ltac2.mlg"
                           CAst.make ~loc @@ QCofix 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                 ("fix"))))))
                                 (fun _ loc -> 
# 772 "plugins/ltac2/g_ltac2.mlg"
                         CAst.make ~loc @@ QFix 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                 ("match"))))))
                                 (fun _ loc -> 
# 771 "plugins/ltac2/g_ltac2.mlg"
                           CAst.make ~loc @@ QMatch 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                 ("iota"))))))
                                 (fun _ loc -> 
# 770 "plugins/ltac2/g_ltac2.mlg"
                          CAst.make ~loc @@ QIota 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                 ("beta"))))))
                                 (fun _ loc -> 
# 769 "plugins/ltac2/g_ltac2.mlg"
                          CAst.make ~loc @@ QBeta 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty refglobal) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:90")
        refglobal
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("$")))))
                                                  ((Pcoq.Symbol.nterm Prim.ident)))
                                  (fun id _ loc -> 
# 782 "plugins/ltac2/g_ltac2.mlg"
                                  QAnti (CAst.make ~loc id) 
                                                   );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm Prim.qualid)))
                                 (fun qid loc -> 
# 781 "plugins/ltac2/g_ltac2.mlg"
                               QExpr (CAst.make ~loc @@ QReference qid) 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("&")))))
                                                 ((Pcoq.Symbol.nterm Prim.ident)))
                                 (fun id _ loc -> 
# 780 "plugins/ltac2/g_ltac2.mlg"
                                  QExpr (CAst.make ~loc @@ QHypothesis id) 
                                                  )])]))
        in let () = assert (Pcoq.Entry.is_empty q_reference) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:91")
        q_reference
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm refglobal)))
                                  (fun r loc -> 
# 786 "plugins/ltac2/g_ltac2.mlg"
                           r 
                                                )])]))
        in let () = assert (Pcoq.Entry.is_empty refglobals) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:92")
        refglobals
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm refglobal)))))
                                  (fun gl loc -> 
# 789 "plugins/ltac2/g_ltac2.mlg"
                                  CAst.make ~loc gl 
                                                 )])]))
        in let () = assert (Pcoq.Entry.is_empty delta_flag) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:93")
        delta_flag
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 794 "plugins/ltac2/g_ltac2.mlg"
             CAst.make ~loc @@ QDeltaBut (CAst.make ~loc []) 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("[")))))
                                                                 ((Pcoq.Symbol.nterm refglobals)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("]")))))
                                 (fun _ idl _ loc -> 
# 793 "plugins/ltac2/g_ltac2.mlg"
                                        CAst.make ~loc @@ QConst idl 
                                                     );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("-")))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("[")))))
                                                                 ((Pcoq.Symbol.nterm refglobals)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("]")))))
                                 (fun _ idl _ _ loc -> 
# 792 "plugins/ltac2/g_ltac2.mlg"
                                             CAst.make ~loc @@ QDeltaBut idl 
                                                       )])]))
        in let () = assert (Pcoq.Entry.is_empty strategy_flag) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:94")
        strategy_flag
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm delta_flag)))
                                  (fun d loc -> 
# 800 "plugins/ltac2/g_ltac2.mlg"
        CAst.make ~loc
          [CAst.make ~loc QBeta; CAst.make ~loc QIota; CAst.make ~loc QZeta; d] 
                                                );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm ltac2_red_flag)))))
                                 (fun s loc -> 
# 798 "plugins/ltac2/g_ltac2.mlg"
                                      CAst.make ~loc s 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty q_strategy_flag) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:95")
        q_strategy_flag
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm strategy_flag)))
                                  (fun flag loc -> 
# 805 "plugins/ltac2/g_ltac2.mlg"
                                  flag 
                                                   )])]))
        in let () = assert (Pcoq.Entry.is_empty hintdb) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:96")
        hintdb
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm ident_or_anti)))))
                                  (fun l loc -> 
# 809 "plugins/ltac2/g_ltac2.mlg"
                                     CAst.make ~loc @@ QHintDbs l 
                                                );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("*")))))
                                 (fun _ loc -> 
# 808 "plugins/ltac2/g_ltac2.mlg"
                 CAst.make ~loc @@ QHintAll 
                                               )])]))
        in let () = assert (Pcoq.Entry.is_empty q_hintdb) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:97")
        q_hintdb
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm hintdb)))
                                  (fun db loc -> 
# 813 "plugins/ltac2/g_ltac2.mlg"
                         db 
                                                 )])]))
        in let () = assert (Pcoq.Entry.is_empty match_pattern) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:98")
        match_pattern
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm Constr.cpattern)))
                                  (fun pat loc -> 
# 818 "plugins/ltac2/g_ltac2.mlg"
                                   CAst.make ~loc @@ QConstrMatchPattern pat 
                                                  );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("context"))))))
                                                                 ((Pcoq.Symbol.opt (Pcoq.Symbol.nterm Prim.ident))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("[")))))
                                                                 ((Pcoq.Symbol.nterm Constr.cpattern)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("]")))))
                                 (fun _ pat _ id _ loc -> 
# 817 "plugins/ltac2/g_ltac2.mlg"
                                               CAst.make ~loc @@ QConstrMatchContext (id, pat) 
                                                          )])]))
        in let () = assert (Pcoq.Entry.is_empty match_rule) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:99")
        match_rule
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm match_pattern)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("=>")))))
                                                  ((Pcoq.Symbol.nterm ltac2_expr)))
                                  (fun tac _ mp loc -> 
# 822 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ (mp, tac) 
                                                       )])]))
        in let () = assert (Pcoq.Entry.is_empty match_list) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:100")
        match_list
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("|")))))
                                                  ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterm match_rule)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                                  (fun mrl _ loc -> 
# 827 "plugins/ltac2/g_ltac2.mlg"
                                                 CAst.make ~loc @@ mrl 
                                                    );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterm match_rule)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                                 (fun mrl loc -> 
# 826 "plugins/ltac2/g_ltac2.mlg"
                                            CAst.make ~loc @@ mrl 
                                                 )])]))
        in let () = assert (Pcoq.Entry.is_empty q_constr_matching) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:101")
        q_constr_matching
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm match_list)))
                                  (fun m loc -> 
# 830 "plugins/ltac2/g_ltac2.mlg"
                            m 
                                                )])]))
        in let () = assert (Pcoq.Entry.is_empty gmatch_hyp_pattern)
        in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:102")
        gmatch_hyp_pattern
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm Prim.name)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                  ((Pcoq.Symbol.nterm match_pattern)))
                                  (fun bod _ na loc -> 
# 837 "plugins/ltac2/g_ltac2.mlg"
          let bod, ty = match bod.CAst.v with
              | QConstrMatchPattern { CAst.v = CCast (t, Some DEFAULTcast, ty) } ->
                let t = CAst.make ?loc:t.loc @@ QConstrMatchPattern t in
                let ty = CAst.make ?loc:ty.loc @@ QConstrMatchPattern ty in
                t, ty
              | _ ->
                let ty = CAst.make @@ QConstrMatchPattern (CAst.make @@ CHole None) in
                bod, ty
          in
          (na, Some bod, ty) 
                                                       );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm Prim.name)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("[")))))
                                                                 ((Pcoq.Symbol.nterm match_pattern)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("]")))))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                 ((Pcoq.Symbol.nterm match_pattern)))
                                 (fun pat _ _ bod _ _ na loc -> 
# 835 "plugins/ltac2/g_ltac2.mlg"
          (na, Some bod, pat) 
                                                                );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm Prim.name)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                 ((Pcoq.Symbol.nterm match_pattern)))
                                 (fun pat _ na loc -> 
# 833 "plugins/ltac2/g_ltac2.mlg"
                                                      (na, None, pat) 
                                                      )])]))
        in let () = assert (Pcoq.Entry.is_empty gmatch_pattern) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:103")
        gmatch_pattern
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("[")))))
                                                                  ((Pcoq.Symbol.list0sep ((Pcoq.Symbol.nterm gmatch_hyp_pattern)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD (","))])) false)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("|-")))))
                                                                  ((Pcoq.Symbol.nterm match_pattern)))
                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("]")))))
                                  (fun _ p _ hl _ loc -> 
# 851 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ {
          q_goal_match_concl = p;
          q_goal_match_hyps = hl;
        } 
                                                         )])]))
        in let () = assert (Pcoq.Entry.is_empty gmatch_rule) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:104")
        gmatch_rule
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm gmatch_pattern)))
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("=>")))))
                                                  ((Pcoq.Symbol.nterm ltac2_expr)))
                                  (fun tac _ mp loc -> 
# 859 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc @@ (mp, tac) 
                                                       )])]))
        in let () = assert (Pcoq.Entry.is_empty goal_match_list) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:105")
        goal_match_list
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("|")))))
                                                  ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterm gmatch_rule)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                                  (fun mrl _ loc -> 
# 864 "plugins/ltac2/g_ltac2.mlg"
                                                  CAst.make ~loc @@ mrl 
                                                    );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.list1sep ((Pcoq.Symbol.nterm gmatch_rule)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                                 (fun mrl loc -> 
# 863 "plugins/ltac2/g_ltac2.mlg"
                                             CAst.make ~loc @@ mrl 
                                                 )])]))
        in let () = assert (Pcoq.Entry.is_empty q_goal_matching) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:106")
        q_goal_matching
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm goal_match_list)))
                                  (fun m loc -> 
# 867 "plugins/ltac2/g_ltac2.mlg"
                                 m 
                                                )])]))
        in let () = assert (Pcoq.Entry.is_empty move_location) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:107")
        move_location
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                  ("before"))))))
                                                  ((Pcoq.Symbol.nterm ident_or_anti)))
                                  (fun id _ loc -> 
# 873 "plugins/ltac2/g_ltac2.mlg"
                                                CAst.make ~loc @@ QMoveBefore id 
                                                   );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                 ("after"))))))
                                                 ((Pcoq.Symbol.nterm ident_or_anti)))
                                 (fun id _ loc -> 
# 872 "plugins/ltac2/g_ltac2.mlg"
                                               CAst.make ~loc @@ QMoveAfter id 
                                                  );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("at")))))
                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                 ("bottom"))))))
                                 (fun _ _ loc -> 
# 871 "plugins/ltac2/g_ltac2.mlg"
                                  CAst.make ~loc @@ QMoveLast 
                                                 );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("at")))))
                                                 ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                 ("top"))))))
                                 (fun _ _ loc -> 
# 870 "plugins/ltac2/g_ltac2.mlg"
                               CAst.make ~loc @@ QMoveFirst 
                                                 )])]))
        in let () = assert (Pcoq.Entry.is_empty q_move_location) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:108")
        q_move_location
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm move_location)))
                                  (fun mv loc -> 
# 877 "plugins/ltac2/g_ltac2.mlg"
                                mv 
                                                 )])]))
        in let () = assert (Pcoq.Entry.is_empty as_name) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:109")
        as_name
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("as")))))
                                                  ((Pcoq.Symbol.nterm ident_or_anti)))
                                  (fun id _ loc -> 
# 881 "plugins/ltac2/g_ltac2.mlg"
                                      Some id 
                                                   );
                                 Pcoq.Production.make (Pcoq.Rule.stop)
                                 (fun loc -> 
# 880 "plugins/ltac2/g_ltac2.mlg"
             None 
                                             )])]))
        in let () = assert (Pcoq.Entry.is_empty pose) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:110")
        pose
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm Constr.constr)))
                                                  ((Pcoq.Symbol.nterm as_name)))
                                  (fun na c loc -> 
# 887 "plugins/ltac2/g_ltac2.mlg"
                                             CAst.make ~loc (na, c) 
                                                   );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm test_lpar_id_coloneq)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                 ((Pcoq.Symbol.nterm ident_or_anti)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                                 ((Pcoq.Symbol.nterm Constr.lconstr)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                 (fun _ c _ id _ _ loc -> 
# 886 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc (Some id, c) 
                                                          )])]))
        in let () = assert (Pcoq.Entry.is_empty q_pose) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:111")
        q_pose
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm pose)))
                                  (fun p loc -> 
# 891 "plugins/ltac2/g_ltac2.mlg"
                      p 
                                                )])]))
        in let () = assert (Pcoq.Entry.is_empty as_ipat) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:112")
        as_ipat
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 895 "plugins/ltac2/g_ltac2.mlg"
             None 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("as")))))
                                                 ((Pcoq.Symbol.nterm simple_intropattern)))
                                 (fun ipat _ loc -> 
# 894 "plugins/ltac2/g_ltac2.mlg"
                                              Some ipat 
                                                    )])]))
        in let () = assert (Pcoq.Entry.is_empty by_tactic) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:113")
        by_tactic
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make (Pcoq.Rule.stop)
                                  (fun loc -> 
# 900 "plugins/ltac2/g_ltac2.mlg"
             None 
                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("by")))))
                                                 ((Pcoq.Symbol.nterml ltac2_expr ("5"))))
                                 (fun tac _ loc -> 
# 899 "plugins/ltac2/g_ltac2.mlg"
                                              Some tac 
                                                   )])]))
        in let () = assert (Pcoq.Entry.is_empty assertion) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:114")
        assertion
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm Constr.constr)))
                                                                  ((Pcoq.Symbol.nterm as_ipat)))
                                                  ((Pcoq.Symbol.nterm by_tactic)))
                                  (fun tac ipat c loc -> 
# 910 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc (QAssertType (ipat, c, tac)) 
                                                         );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm test_lpar_id_colon)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                 ((Pcoq.Symbol.nterm ident_or_anti)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":")))))
                                                                 ((Pcoq.Symbol.nterm Constr.lconstr)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                                 ((Pcoq.Symbol.nterm by_tactic)))
                                 (fun tac _ c _ id _ _ loc -> 
# 907 "plugins/ltac2/g_ltac2.mlg"
        let ipat = CAst.make ~loc @@ QIntroNaming (CAst.make ~loc @@ QIntroIdentifier id) in
        CAst.make ~loc (QAssertType (Some ipat, c, tac)) 
                                                              );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm test_lpar_id_coloneq)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                 ((Pcoq.Symbol.nterm ident_or_anti)))
                                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                                 ((Pcoq.Symbol.nterm Constr.lconstr)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD (")")))))
                                 (fun _ c _ id _ _ loc -> 
# 905 "plugins/ltac2/g_ltac2.mlg"
          CAst.make ~loc (QAssertValue (id, c)) 
                                                          )])]))
        in let () = assert (Pcoq.Entry.is_empty q_assert) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:115")
        q_assert
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm assertion)))
                                  (fun a loc -> 
# 914 "plugins/ltac2/g_ltac2.mlg"
                           a 
                                                )])]))
        in ()


# 938 "plugins/ltac2/g_ltac2.mlg"
 

let () =

let open Tok in
let (++) r s = Pcoq.Rule.next r s in
let rules = [
  Pcoq.(
    Production.make
      (Rule.stop ++ Symbol.nterm test_dollar_ident ++ Symbol.token (PKEYWORD "$") ++ Symbol.nterm Prim.ident)
    begin fun id _ _ loc ->
      let id = CAst.make ~loc id in
      let arg = Genarg.in_gen (Genarg.rawwit Tac2env.wit_ltac2_var_quotation) (None, id) in
      CAst.make ~loc (CGenarg arg)
    end
  );

  Pcoq.(
    Production.make
      (Rule.stop ++ Symbol.nterm test_dollar_ident_colon_ident ++
       Symbol.token (PKEYWORD "$") ++ Symbol.nterm Prim.identref ++
       Symbol.token (PKEYWORD ":") ++ Symbol.nterm Prim.identref)
    begin fun id _ kind _ _ loc ->
      let arg = Genarg.in_gen (Genarg.rawwit Tac2env.wit_ltac2_var_quotation) (Some kind, id) in
      CAst.make ~loc (CGenarg arg)
    end
  );

  Pcoq.(
    Production.make
      (Rule.stop ++ Symbol.nterm test_ampersand_ident ++ Symbol.token (PKEYWORD "&") ++ Symbol.nterm Prim.ident)
    begin fun id _ _ loc ->
      let tac = Tac2quote.of_exact_hyp ~loc (CAst.make ~loc id) in
      let arg = Genarg.in_gen (Genarg.rawwit Tac2env.wit_ltac2_constr) tac in
      CAst.make ~loc (CGenarg arg)
    end
  );

  Pcoq.(
    Production.make
      (Rule.stop ++ Symbol.token (PIDENT (Some "ltac2")) ++ Symbol.token (PKEYWORD ":") ++
       Symbol.token (PKEYWORD "(") ++ Symbol.nterm ltac2_expr ++ Symbol.token (PKEYWORD ")"))
    begin fun _ tac _ _ _ loc ->
      let arg = Genarg.in_gen (Genarg.rawwit Tac2env.wit_ltac2_constr) tac in
      CAst.make ~loc (CGenarg arg)
    end
  )
] in

  Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:adhoc1")
    Pcoq.Constr.term (Pcoq.Reuse (Some"0", rules))





# 993 "plugins/ltac2/g_ltac2.mlg"
 

let pr_ltac2entry _ = mt () (* FIXME *)
let pr_ltac2expr _ = mt () (* FIXME *)



let (wit_ltac2_entry, ltac2_entry) = Vernacextend.vernac_argument_extend ~plugin:"coq-core.plugins.ltac2" ~name:"ltac2_entry" 
                                     {
                                     Vernacextend.arg_parsing = Vernacextend.Arg_rules (
                                                                [(Pcoq.Production.make
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm tac2def_mut)))
                                                                  (fun e
                                                                  loc -> 
                                                                  
# 1005 "plugins/ltac2/g_ltac2.mlg"
                          e 
                                                                  ));
                                                                (Pcoq.Production.make
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm tac2def_ext)))
                                                                 (fun e
                                                                 loc -> 
                                                                 
# 1004 "plugins/ltac2/g_ltac2.mlg"
                          e 
                                                                 ));
                                                                (Pcoq.Production.make
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm tac2def_typ)))
                                                                 (fun t
                                                                 loc -> 
                                                                 
# 1003 "plugins/ltac2/g_ltac2.mlg"
                          t 
                                                                 ));
                                                                (Pcoq.Production.make
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm tac2def_val)))
                                                                 (fun v
                                                                 loc -> 
                                                                 
# 1002 "plugins/ltac2/g_ltac2.mlg"
                          v 
                                                                 ))]);
                                     Vernacextend.arg_printer = fun env sigma -> 
                                     
# 1001 "plugins/ltac2/g_ltac2.mlg"
             pr_ltac2entry 
                                     ;
                                     }
let _ = (wit_ltac2_entry, ltac2_entry)

let (wit_ltac2def_syn, ltac2def_syn) = Vernacextend.vernac_argument_extend ~plugin:"coq-core.plugins.ltac2" ~name:"ltac2def_syn" 
                                       {
                                       Vernacextend.arg_parsing = Vernacextend.Arg_alias (tac2def_syn);
                                       Vernacextend.arg_printer = fun env sigma -> 
                                       
# 1009 "plugins/ltac2/g_ltac2.mlg"
             pr_ltac2entry 
                                       ;
                                       }
let _ = (wit_ltac2def_syn, ltac2def_syn)

let (wit_ltac2_expr, ltac2_expr) = Vernacextend.vernac_argument_extend ~plugin:"coq-core.plugins.ltac2" ~name:"ltac2_expr" 
                                   {
                                   Vernacextend.arg_parsing = Vernacextend.Arg_alias (_ltac2_expr);
                                   Vernacextend.arg_printer = fun env sigma -> 
                                   
# 1014 "plugins/ltac2/g_ltac2.mlg"
             pr_ltac2expr 
                                   ;
                                   }
let _ = (wit_ltac2_expr, ltac2_expr)

let () = Vernacextend.static_vernac_extend ~plugin:(Some "coq-core.plugins.ltac2") ~command:"VernacDeclareTactic2Definition"  ?entry:None 
         [(Vernacextend.TyML (false, Vernacextend.TyTerminal ("Ltac2", 
                                     Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_ltac2_entry), 
                                     Vernacextend.TyNil)), (let coqpp_body e
                                                           raw_attributes = 
                                                           Vernactypes.vtdefault (fun () -> 
                                                           
# 1019 "plugins/ltac2/g_ltac2.mlg"
                                                                                             
  Tac2entries.register_struct raw_attributes e
  
                                                           ) in fun e
                                                           ?loc ~atts ()
                                                           -> coqpp_body e
                                                           (Attributes.parse raw_attributes atts)), Some 
         (fun e -> 
# 1019 "plugins/ltac2/g_ltac2.mlg"
                                                      Vernacextend.classify_as_sideeff 
         )));
         (Vernacextend.TyML (false, Vernacextend.TyTerminal ("Ltac2", 
                                    Vernacextend.TyTerminal ("Notation", 
                                    Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_ltac2def_syn), 
                                    Vernacextend.TyNil))), (let coqpp_body e
                                                           raw_attributes = 
                                                           (let synterpv = 
                                                           
# 1022 "plugins/ltac2/g_ltac2.mlg"
                                                                                                                             
    let (toks, n, body) = e in
    Tac2entries.register_notation raw_attributes toks n body
  
                                                            in Vernactypes.vtdefault (fun () -> 
                                                           
# 1026 "plugins/ltac2/g_ltac2.mlg"
   
    Tac2entries.register_notation_interpretation synterpv
  
                                                           )) in fun e
                                                           ?loc ~atts ()
                                                           -> coqpp_body e
                                                           (Attributes.parse raw_attributes atts)), Some 
         (fun e -> 
# 1022 "plugins/ltac2/g_ltac2.mlg"
                                                                  Vernacextend.(VtSideff ([], VtNow)) 
         )));
         (Vernacextend.TyML (false, Vernacextend.TyTerminal ("Ltac2", 
                                    Vernacextend.TyTerminal ("Eval", 
                                    Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_ltac2_expr), 
                                    Vernacextend.TyNil))), (let coqpp_body e
                                                           () = Vernactypes.vtreadproofopt (fun ~pstate -> (
                                                                
# 1029 "plugins/ltac2/g_ltac2.mlg"
                                                                                                
  fun ~pstate -> Tac2entries.perform_eval ~pstate e
  
                                                                ) ~pstate) in fun e
                                                           ?loc ~atts ()
                                                           -> coqpp_body e
                                                           (Attributes.unsupported_attributes atts)), Some 
         (fun e -> 
# 1029 "plugins/ltac2/g_ltac2.mlg"
                                                           Vernacextend.classify_as_query 
         )))]


# 1034 "plugins/ltac2/g_ltac2.mlg"
 

let _ = Pvernac.register_proof_mode "Ltac2" tac2mode

open G_ltac
open Vernacextend



let () = Vernacextend.static_vernac_extend ~plugin:(Some "coq-core.plugins.ltac2") ~command:"VernacLtac2"  ?entry:(Some ( tac2mode )) 
         [(Vernacextend.TyML (false, Vernacextend.TyNonTerminal (Extend.TUopt (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_ltac_selector)), 
                                     Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_ltac2_expr), 
                                     Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_ltac_use_default), 
                                     Vernacextend.TyNil))), (let coqpp_body g
                                                            t with_end_tac
                                                            () = Vernactypes.vtmodifyproof (fun ~pstate -> (
                                                                 
# 1045 "plugins/ltac2/g_ltac2.mlg"
                                 fun ~pstate ->
    Tac2entries.call ~pstate g ~with_end_tac t
  
                                                                 ) ~pstate) in fun g
                                                            t with_end_tac
                                                            ?loc ~atts ()
                                                            -> coqpp_body g t
                                                            with_end_tac
                                                            (Attributes.unsupported_attributes atts)), Some 
         (fun g t with_end_tac -> 
# 1045 "plugins/ltac2/g_ltac2.mlg"
    classify_as_proofstep 
         )));
         (Vernacextend.TyML (false, Vernacextend.TyTerminal ("par", Vernacextend.TyTerminal (":", 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_ltac2_expr), 
                                                                    Vernacextend.TyNonTerminal (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_ltac_use_default), 
                                                                    Vernacextend.TyNil)))), 
         (let coqpp_body t with_end_tac
         () = Vernactypes.vtmodifyproof (fun ~pstate -> (
# 1049 "plugins/ltac2/g_ltac2.mlg"
                                 fun ~pstate ->
    Tac2entries.call_par ~pstate ~with_end_tac t
  
              ) ~pstate) in fun t
         with_end_tac ?loc ~atts () -> coqpp_body t with_end_tac
         (Attributes.unsupported_attributes atts)), Some (fun t with_end_tac
                                                         -> 
# 1049 "plugins/ltac2/g_ltac2.mlg"
    classify_as_proofstep 
                                                         )))]

let _ = let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ltac2", "g_ltac2.mlg:116")
        tac2mode
        (Pcoq.Reuse (None, [Pcoq.Production.make
                            (Pcoq.Rule.next (Pcoq.Rule.stop)
                                            ((Pcoq.Symbol.nterm G_vernac.query_command)))
                            (fun tac loc -> 
# 1057 "plugins/ltac2/g_ltac2.mlg"
                                          Vernacexpr.VernacSynPure (tac None) 
                                            )]))
        in ()


# 1060 "plugins/ltac2/g_ltac2.mlg"
 

open Stdarg



let () = Vernacextend.static_vernac_extend ~plugin:(Some "coq-core.plugins.ltac2") ~command:"Ltac2Printers" ~classifier:(fun _ -> Vernacextend.classify_as_query) ?entry:None 
         [(Vernacextend.TyML (false, Vernacextend.TyTerminal ("Print", 
                                     Vernacextend.TyTerminal ("Ltac2", 
                                     Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_reference), 
                                     Vernacextend.TyNil))), (let coqpp_body tac
                                                            () = Vernactypes.vtdefault (fun () -> 
                                                                 
# 1067 "plugins/ltac2/g_ltac2.mlg"
                                          Tac2entries.print_ltac2 tac 
                                                                 ) in fun tac
                                                            ?loc ~atts ()
                                                            -> coqpp_body tac
                                                            (Attributes.unsupported_attributes atts)), None));
         (Vernacextend.TyML (false, Vernacextend.TyTerminal ("Print", 
                                    Vernacextend.TyTerminal ("Ltac2", 
                                    Vernacextend.TyTerminal ("Type", 
                                    Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_reference), 
                                    Vernacextend.TyNil)))), (let coqpp_body tac
                                                            () = Vernactypes.vtdefault (fun () -> 
                                                                 
# 1068 "plugins/ltac2/g_ltac2.mlg"
                                                 Tac2entries.print_ltac2_type tac 
                                                                 ) in fun tac
                                                            ?loc ~atts ()
                                                            -> coqpp_body tac
                                                            (Attributes.unsupported_attributes atts)), None));
         (Vernacextend.TyML (false, Vernacextend.TyTerminal ("Locate", 
                                    Vernacextend.TyTerminal ("Ltac2", 
                                    Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_reference), 
                                    Vernacextend.TyNil))), (let coqpp_body r
                                                           () = Vernactypes.vtdefault (fun () -> 
                                                                
# 1069 "plugins/ltac2/g_ltac2.mlg"
                                         Tac2entries.print_located_tactic r 
                                                                ) in fun r
                                                           ?loc ~atts ()
                                                           -> coqpp_body r
                                                           (Attributes.unsupported_attributes atts)), None));
         (Vernacextend.TyML (false, Vernacextend.TyTerminal ("Print", 
                                    Vernacextend.TyTerminal ("Ltac2", 
                                    Vernacextend.TyTerminal ("Signatures", 
                                    Vernacextend.TyNil))), (let coqpp_body () = 
                                                           Vernactypes.vtdefault (fun () -> 
                                                           
# 1070 "plugins/ltac2/g_ltac2.mlg"
                                        Tac2entries.print_signatures () 
                                                           ) in fun ?loc ~atts ()
                                                           -> coqpp_body (Attributes.unsupported_attributes atts)), None));
         (Vernacextend.TyML (false, Vernacextend.TyTerminal ("Ltac2", 
                                    Vernacextend.TyTerminal ("Check", 
                                    Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_ltac2_expr), 
                                    Vernacextend.TyNil))), (let coqpp_body e
                                                           () = Vernactypes.vtdefault (fun () -> 
                                                                
# 1071 "plugins/ltac2/g_ltac2.mlg"
                                         Tac2entries.typecheck_expr e 
                                                                ) in fun e
                                                           ?loc ~atts ()
                                                           -> coqpp_body e
                                                           (Attributes.unsupported_attributes atts)), None));
         (Vernacextend.TyML (false, Vernacextend.TyTerminal ("Ltac2", 
                                    Vernacextend.TyTerminal ("Globalize", 
                                    Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_ltac2_expr), 
                                    Vernacextend.TyNil))), (let coqpp_body e
                                                           () = Vernactypes.vtdefault (fun () -> 
                                                                
# 1072 "plugins/ltac2/g_ltac2.mlg"
                                             Tac2entries.globalize_expr e 
                                                                ) in fun e
                                                           ?loc ~atts ()
                                                           -> coqpp_body e
                                                           (Attributes.unsupported_attributes atts)), None))]

