# crictl fish shell completion

function __fish_crictl_no_subcommand --description 'Test if there has been any subcommand yet'
    for i in (commandline -opc)
        if contains -- $i attach create exec version images image img inspect inspecti imagefsinfo inspectp logs port-forward ps pull run runp rm rmi rmp pods start info stop stopp update config stats statsp metricsp completion help h checkpoint runtime-config events event help h
            return 1
        end
    end
    return 0
end

complete -c crictl -n '__fish_crictl_no_subcommand' -f -l config -s c -r -d 'Location of the client config file. If not specified and the default does not exist, the program\'s directory is searched as well'
complete -c crictl -n '__fish_crictl_no_subcommand' -f -l debug -s D -d 'Enable debug mode'
complete -c crictl -n '__fish_crictl_no_subcommand' -f -l enable-tracing -d 'Enable OpenTelemetry tracing.'
complete -c crictl -n '__fish_crictl_no_subcommand' -f -l image-endpoint -s i -r -d 'Endpoint of CRI image manager service (default: uses \'runtime-endpoint\' setting)'
complete -c crictl -n '__fish_crictl_no_subcommand' -f -l runtime-endpoint -s r -r -d 'Endpoint of CRI container runtime service (default: uses in order the first successful one of [unix:///run/containerd/containerd.sock unix:///run/crio/crio.sock unix:///var/run/cri-dockerd.sock]). Default is now deprecated and the endpoint should be set instead.'
complete -c crictl -n '__fish_crictl_no_subcommand' -f -l timeout -s t -r -d 'Timeout of connecting to the server in seconds (e.g. 2s, 20s.). 0 or less is set to default'
complete -c crictl -n '__fish_crictl_no_subcommand' -f -l tracing-endpoint -r -d 'Address to which the gRPC tracing collector will send spans to.'
complete -c crictl -n '__fish_crictl_no_subcommand' -f -l tracing-sampling-rate-per-million -r -d 'Number of samples to collect per million OpenTelemetry spans. Set to 1000000 or -1 to always sample.'
complete -c crictl -n '__fish_crictl_no_subcommand' -f -l help -s h -d 'show help'
complete -c crictl -n '__fish_crictl_no_subcommand' -f -l version -s v -d 'print the version'
complete -c crictl -n '__fish_crictl_no_subcommand' -f -l help -s h -d 'show help'
complete -c crictl -n '__fish_crictl_no_subcommand' -f -l version -s v -d 'print the version'
complete -c crictl -n '__fish_seen_subcommand_from attach' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'attach' -d 'Attach to a running container'
complete -c crictl -n '__fish_seen_subcommand_from attach' -f -l stdin -s i -d 'Keep STDIN open'
complete -c crictl -n '__fish_seen_subcommand_from attach' -f -l transport -s r -r -d 'Transport protocol to use, one of: spdy|websocket'
complete -c crictl -n '__fish_seen_subcommand_from attach' -f -l tty -s t -d 'Allocate a pseudo-TTY'
complete -c crictl -n '__fish_seen_subcommand_from create' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'create' -d 'Create a new container'
complete -c crictl -n '__fish_seen_subcommand_from create' -f -l auth -r -d 'Use `AUTH_STRING` for accessing the registry. AUTH_STRING is a base64 encoded \'USERNAME[:PASSWORD]\''
complete -c crictl -n '__fish_seen_subcommand_from create' -f -l cancel-timeout -s T -r -d 'Seconds to wait for a container create request to complete before cancelling the request'
complete -c crictl -n '__fish_seen_subcommand_from create' -f -l creds -r -d 'Use `USERNAME[:PASSWORD]` for accessing the registry'
complete -c crictl -n '__fish_seen_subcommand_from create' -f -l no-pull -d 'Do not pull the image on container creation (overrides pull-image-on-create=true in config)'
complete -c crictl -n '__fish_seen_subcommand_from create' -f -l username -r -d 'Use `USERNAME` for accessing the registry. The password will be requested on the command line'
complete -c crictl -n '__fish_seen_subcommand_from create' -f -l with-pull -d 'Pull the image on container creation (overrides pull-image-on-create=false in config)'
complete -c crictl -n '__fish_seen_subcommand_from exec' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'exec' -d 'Run a command in a running container'
complete -c crictl -n '__fish_seen_subcommand_from exec' -f -l interactive -s i -d 'Keep STDIN open'
complete -c crictl -n '__fish_seen_subcommand_from exec' -f -l sync -s s -d 'Run the command synchronously'
complete -c crictl -n '__fish_seen_subcommand_from exec' -f -l timeout -r -d 'Timeout in seconds'
complete -c crictl -n '__fish_seen_subcommand_from exec' -f -l transport -s r -r -d 'Transport protocol to use, one of: spdy|websocket'
complete -c crictl -n '__fish_seen_subcommand_from exec' -f -l tty -s t -d 'Allocate a pseudo-TTY'
complete -c crictl -n '__fish_seen_subcommand_from version' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'version' -d 'Display runtime version information'
complete -c crictl -n '__fish_seen_subcommand_from images image img' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'images image img' -d 'List images'
complete -c crictl -n '__fish_seen_subcommand_from images image img' -f -l digests -d 'Show digests'
complete -c crictl -n '__fish_seen_subcommand_from images image img' -f -l filter -s f -r -d 'Filter output based on provided conditions.
Available filters: 
* dangling=(boolean - true or false)
* reference=/regular expression/
* before=<image-name>[:<tag>]|<image id>|<image@digest>
* since=<image-name>[:<tag>]|<image id>|<image@digest>
Multiple filters can be combined together.'
complete -c crictl -n '__fish_seen_subcommand_from images image img' -f -l no-trunc -d 'Show output without truncating the ID'
complete -c crictl -n '__fish_seen_subcommand_from images image img' -f -l output -s o -r -d 'Output format, One of: json|yaml|table'
complete -c crictl -n '__fish_seen_subcommand_from images image img' -f -l pinned -d 'Show whether the image is pinned or not'
complete -c crictl -n '__fish_seen_subcommand_from images image img' -f -l quiet -s q -d 'Only show image IDs'
complete -c crictl -n '__fish_seen_subcommand_from images image img' -f -l verbose -s v -d 'Show verbose info for images'
complete -c crictl -n '__fish_seen_subcommand_from inspect' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'inspect' -d 'Display the status of one or more containers'
complete -c crictl -n '__fish_seen_subcommand_from inspect' -f -l output -s o -r -d 'Output format, One of: json|yaml|go-template|table'
complete -c crictl -n '__fish_seen_subcommand_from inspect' -f -l quiet -s q -d 'Do not show verbose information'
complete -c crictl -n '__fish_seen_subcommand_from inspect' -f -l template -r -d 'The template string is only used when output is go-template; The Template format is golang template'
complete -c crictl -n '__fish_seen_subcommand_from inspecti' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'inspecti' -d 'Return the status of one or more images'
complete -c crictl -n '__fish_seen_subcommand_from inspecti' -f -l output -s o -r -d 'Output format, One of: json|yaml|go-template|table'
complete -c crictl -n '__fish_seen_subcommand_from inspecti' -f -l quiet -s q -d 'Do not show verbose information'
complete -c crictl -n '__fish_seen_subcommand_from inspecti' -f -l template -r -d 'The template string is only used when output is go-template; The Template format is golang template'
complete -c crictl -n '__fish_seen_subcommand_from imagefsinfo' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'imagefsinfo' -d 'Return image filesystem info'
complete -c crictl -n '__fish_seen_subcommand_from imagefsinfo' -f -l output -s o -r -d 'Output format, One of: json|yaml|go-template|table'
complete -c crictl -n '__fish_seen_subcommand_from imagefsinfo' -f -l template -r -d 'The template string is only used when output is go-template; The Template format is golang template'
complete -c crictl -n '__fish_seen_subcommand_from inspectp' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'inspectp' -d 'Display the status of one or more pods'
complete -c crictl -n '__fish_seen_subcommand_from inspectp' -f -l output -s o -r -d 'Output format, One of: json|yaml|go-template|table'
complete -c crictl -n '__fish_seen_subcommand_from inspectp' -f -l quiet -s q -d 'Do not show verbose information'
complete -c crictl -n '__fish_seen_subcommand_from inspectp' -f -l template -r -d 'The template string is only used when output is go-template; The Template format is golang template'
complete -c crictl -n '__fish_seen_subcommand_from logs' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'logs' -d 'Fetch the logs of a container'
complete -c crictl -n '__fish_seen_subcommand_from logs' -f -l follow -s f -d 'Follow log output'
complete -c crictl -n '__fish_seen_subcommand_from logs' -f -l limit-bytes -r -d 'Maximum bytes of logs to return. Defaults to no limit'
complete -c crictl -n '__fish_seen_subcommand_from logs' -f -l previous -s p -d 'Print the logs for the previous instance of the container in a pod if it exists'
complete -c crictl -n '__fish_seen_subcommand_from logs' -f -l since -r -d 'Show logs since timestamp (e.g. 2013-01-02T13:23:37) or relative (e.g. 42m for 42 minutes)'
complete -c crictl -n '__fish_seen_subcommand_from logs' -f -l tail -r -d 'Number of lines to show from the end of the logs. Defaults to all'
complete -c crictl -n '__fish_seen_subcommand_from logs' -f -l timestamps -s t -d 'Show timestamps'
complete -c crictl -n '__fish_seen_subcommand_from port-forward' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'port-forward' -d 'Forward local port to a pod'
complete -c crictl -n '__fish_seen_subcommand_from port-forward' -f -l transport -s r -r -d 'Transport protocol to use, one of: spdy|websocket'
complete -c crictl -n '__fish_seen_subcommand_from ps' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'ps' -d 'List containers'
complete -c crictl -n '__fish_seen_subcommand_from ps' -f -l all -s a -d 'Show all containers'
complete -c crictl -n '__fish_seen_subcommand_from ps' -f -l id -r -d 'Filter by container id'
complete -c crictl -n '__fish_seen_subcommand_from ps' -f -l image -r -d 'Filter by container image'
complete -c crictl -n '__fish_seen_subcommand_from ps' -f -l label -r -d 'Filter by key=value label'
complete -c crictl -n '__fish_seen_subcommand_from ps' -f -l last -s n -r -d 'Show last n recently created containers (includes all states). Set 0 for unlimited.'
complete -c crictl -n '__fish_seen_subcommand_from ps' -f -l latest -s l -d 'Show the most recently created container (includes all states)'
complete -c crictl -n '__fish_seen_subcommand_from ps' -f -l name -r -d 'filter by container name regular expression pattern'
complete -c crictl -n '__fish_seen_subcommand_from ps' -f -l no-trunc -d 'Show output without truncating the ID'
complete -c crictl -n '__fish_seen_subcommand_from ps' -f -l output -s o -r -d 'Output format, One of: json|yaml|table'
complete -c crictl -n '__fish_seen_subcommand_from ps' -f -l pod -s p -r -d 'Filter by pod id'
complete -c crictl -n '__fish_seen_subcommand_from ps' -f -l quiet -s q -d 'Only display container IDs'
complete -c crictl -n '__fish_seen_subcommand_from ps' -f -l resolve-image-path -s r -d 'Show image path instead of image id'
complete -c crictl -n '__fish_seen_subcommand_from ps' -f -l state -s s -r -d 'Filter by container state'
complete -c crictl -n '__fish_seen_subcommand_from ps' -f -l verbose -s v -d 'Show verbose information for containers'
complete -c crictl -n '__fish_seen_subcommand_from pull' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'pull' -d 'Pull an image from a registry'
complete -c crictl -n '__fish_seen_subcommand_from pull' -f -l annotation -s a -r -d 'Annotation to be set on the pulled image'
complete -c crictl -n '__fish_seen_subcommand_from pull' -f -l auth -r -d 'Use `AUTH_STRING` for accessing the registry. AUTH_STRING is a base64 encoded \'USERNAME[:PASSWORD]\''
complete -c crictl -n '__fish_seen_subcommand_from pull' -f -l creds -r -d 'Use `USERNAME[:PASSWORD]` for accessing the registry'
complete -c crictl -n '__fish_seen_subcommand_from pull' -l pod-config -r -d 'Use `pod-config.[json|yaml]` to override the pull c'
complete -c crictl -n '__fish_seen_subcommand_from pull' -f -l username -s u -r -d 'Use `USERNAME` for accessing the registry. The password will be requested on the command line'
complete -c crictl -n '__fish_seen_subcommand_from run' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'run' -d 'Run a new container inside a sandbox'
complete -c crictl -n '__fish_seen_subcommand_from run' -f -l auth -r -d 'Use `AUTH_STRING` for accessing the registry. AUTH_STRING is a base64 encoded \'USERNAME[:PASSWORD]\''
complete -c crictl -n '__fish_seen_subcommand_from run' -f -l creds -r -d 'Use `USERNAME[:PASSWORD]` for accessing the registry'
complete -c crictl -n '__fish_seen_subcommand_from run' -f -l no-pull -d 'Do not pull the image (overrides disable-pull-on-run=false in config)'
complete -c crictl -n '__fish_seen_subcommand_from run' -f -l runtime -s r -r -d 'Runtime handler to use. Available options are defined by the container runtime.'
complete -c crictl -n '__fish_seen_subcommand_from run' -f -l timeout -s t -r -d 'Seconds to wait for a container create request before cancelling the request'
complete -c crictl -n '__fish_seen_subcommand_from run' -f -l username -r -d 'Use `USERNAME` for accessing the registry. password will be requested'
complete -c crictl -n '__fish_seen_subcommand_from run' -f -l with-pull -d 'Pull the image (overrides disable-pull-on-run=true in config)'
complete -c crictl -n '__fish_seen_subcommand_from runp' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'runp' -d 'Run a new pod'
complete -c crictl -n '__fish_seen_subcommand_from runp' -f -l cancel-timeout -s T -r -d 'Seconds to wait for a run pod sandbox request to complete before cancelling the request'
complete -c crictl -n '__fish_seen_subcommand_from runp' -f -l runtime -s r -r -d 'Runtime handler to use. Available options are defined by the container runtime.'
complete -c crictl -n '__fish_seen_subcommand_from rm' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'rm' -d 'Remove one or more containers'
complete -c crictl -n '__fish_seen_subcommand_from rm' -f -l all -s a -d 'Remove all containers'
complete -c crictl -n '__fish_seen_subcommand_from rm' -f -l force -s f -d 'Force removal of the container, disregarding if running'
complete -c crictl -n '__fish_seen_subcommand_from rm' -f -l keep-logs -s k -d 'Preserve the container log file and its rotations'
complete -c crictl -n '__fish_seen_subcommand_from rmi' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'rmi' -d 'Remove one or more images'
complete -c crictl -n '__fish_seen_subcommand_from rmi' -f -l all -s a -d 'Remove all images'
complete -c crictl -n '__fish_seen_subcommand_from rmi' -f -l prune -s q -d 'Remove all unused images'
complete -c crictl -n '__fish_seen_subcommand_from rmp' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'rmp' -d 'Remove one or more pods'
complete -c crictl -n '__fish_seen_subcommand_from rmp' -f -l all -s a -d 'Remove all pods'
complete -c crictl -n '__fish_seen_subcommand_from rmp' -f -l force -s f -d 'Force removal of the pod sandbox, disregarding if running'
complete -c crictl -n '__fish_seen_subcommand_from pods' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'pods' -d 'List pods'
complete -c crictl -n '__fish_seen_subcommand_from pods' -f -l id -r -d 'filter by pod id'
complete -c crictl -n '__fish_seen_subcommand_from pods' -f -l label -r -d 'filter by key=value label'
complete -c crictl -n '__fish_seen_subcommand_from pods' -f -l last -s n -r -d 'Show last n recently created pods. Set 0 for unlimited'
complete -c crictl -n '__fish_seen_subcommand_from pods' -f -l latest -s l -d 'Show the most recently created pod'
complete -c crictl -n '__fish_seen_subcommand_from pods' -f -l name -r -d 'filter by pod name regular expression pattern'
complete -c crictl -n '__fish_seen_subcommand_from pods' -f -l namespace -r -d 'filter by pod namespace regular expression pattern'
complete -c crictl -n '__fish_seen_subcommand_from pods' -f -l no-trunc -d 'Show output without truncating the ID'
complete -c crictl -n '__fish_seen_subcommand_from pods' -f -l output -s o -r -d 'Output format, One of: json|yaml|table'
complete -c crictl -n '__fish_seen_subcommand_from pods' -f -l quiet -s q -d 'list only pod IDs'
complete -c crictl -n '__fish_seen_subcommand_from pods' -f -l state -s s -r -d 'filter by pod state'
complete -c crictl -n '__fish_seen_subcommand_from pods' -f -l verbose -s v -d 'show verbose info for pods'
complete -c crictl -n '__fish_seen_subcommand_from start' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'start' -d 'Start one or more created containers'
complete -c crictl -n '__fish_seen_subcommand_from info' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'info' -d 'Display information of the container runtime'
complete -c crictl -n '__fish_seen_subcommand_from info' -f -l output -s o -r -d 'Output format, One of: json|yaml|go-template'
complete -c crictl -n '__fish_seen_subcommand_from info' -f -l quiet -s q -d 'Do not show verbose information'
complete -c crictl -n '__fish_seen_subcommand_from info' -f -l template -r -d 'The template string is only used when output is go-template; The Template format is golang template'
complete -c crictl -n '__fish_seen_subcommand_from stop' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'stop' -d 'Stop one or more running containers'
complete -c crictl -n '__fish_seen_subcommand_from stop' -f -l timeout -s t -r -d 'Seconds to wait to kill the container after a graceful stop is requested'
complete -c crictl -n '__fish_seen_subcommand_from stopp' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'stopp' -d 'Stop one or more running pods'
complete -c crictl -n '__fish_seen_subcommand_from update' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'update' -d 'Update one or more running containers'
complete -c crictl -n '__fish_seen_subcommand_from update' -f -l cpu-count -r -d '(Windows only) Number of CPUs available to the container'
complete -c crictl -n '__fish_seen_subcommand_from update' -f -l cpu-maximum -r -d '(Windows only) Portion of CPU cycles specified as a percentage * 100'
complete -c crictl -n '__fish_seen_subcommand_from update' -f -l cpu-period -r -d 'CPU CFS period to be used for hardcapping (in usecs). 0 to use system default'
complete -c crictl -n '__fish_seen_subcommand_from update' -f -l cpu-quota -r -d 'CPU CFS hardcap limit (in usecs). Allowed cpu time in a given period'
complete -c crictl -n '__fish_seen_subcommand_from update' -f -l cpu-share -r -d 'CPU shares (relative weight vs. other containers)'
complete -c crictl -n '__fish_seen_subcommand_from update' -f -l cpuset-cpus -r -d 'CPU(s) to use'
complete -c crictl -n '__fish_seen_subcommand_from update' -f -l cpuset-mems -r -d 'Memory node(s) to use'
complete -c crictl -n '__fish_seen_subcommand_from update' -f -l memory -r -d 'Memory limit (in bytes)'
complete -c crictl -n '__fish_seen_subcommand_from config' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'config' -d 'Get and set crictl client configuration options'
complete -c crictl -n '__fish_seen_subcommand_from config' -f -l get -r -d 'show the option value'
complete -c crictl -n '__fish_seen_subcommand_from config' -f -l list -d 'show all option value'
complete -c crictl -n '__fish_seen_subcommand_from config' -f -l set -r -d 'set option (can specify multiple or separate values with commas: opt1=val1,opt2=val2)'
complete -c crictl -n '__fish_seen_subcommand_from stats' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'stats' -d 'List container(s) resource usage statistics'
complete -c crictl -n '__fish_seen_subcommand_from stats' -f -l all -s a -d 'Show all containers (default shows just running)'
complete -c crictl -n '__fish_seen_subcommand_from stats' -f -l id -r -d 'Filter by container id'
complete -c crictl -n '__fish_seen_subcommand_from stats' -f -l label -r -d 'Filter by key=value label'
complete -c crictl -n '__fish_seen_subcommand_from stats' -f -l output -s o -r -d 'Output format, One of: json|yaml|table'
complete -c crictl -n '__fish_seen_subcommand_from stats' -f -l pod -s p -r -d 'Filter by pod id'
complete -c crictl -n '__fish_seen_subcommand_from stats' -f -l seconds -s s -r -d 'Sample duration for CPU usage in seconds'
complete -c crictl -n '__fish_seen_subcommand_from stats' -f -l watch -s w -d 'Watch pod resources'
complete -c crictl -n '__fish_seen_subcommand_from statsp' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'statsp' -d 'List pod statistics. Stats represent a structured API that will fulfill the Kubelet\'s /stats/summary endpoint.'
complete -c crictl -n '__fish_seen_subcommand_from statsp' -f -l id -r -d 'Filter by pod id'
complete -c crictl -n '__fish_seen_subcommand_from statsp' -f -l label -r -d 'Filter by key=value label'
complete -c crictl -n '__fish_seen_subcommand_from statsp' -f -l output -s o -r -d 'Output format, One of: json|yaml|table'
complete -c crictl -n '__fish_seen_subcommand_from statsp' -f -l seconds -s s -r -d 'Sample duration for CPU usage in seconds'
complete -c crictl -n '__fish_seen_subcommand_from statsp' -f -l watch -s w -d 'Watch pod resources'
complete -c crictl -n '__fish_seen_subcommand_from metricsp' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'metricsp' -d 'List pod metrics. Metrics are unstructured key/value pairs gathered by CRI meant to replace cAdvisor\'s /metrics/cadvisor endpoint.'
complete -c crictl -n '__fish_seen_subcommand_from metricsp' -f -l output -s o -r -d 'Output format, One of: json|yaml'
complete -c crictl -n '__fish_seen_subcommand_from metricsp' -f -l watch -s w -d 'Watch pod metrics'
complete -c crictl -n '__fish_seen_subcommand_from completion' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'completion' -d 'Output shell completion code'
complete -c crictl -n '__fish_seen_subcommand_from completion' -f -l help -s h -d 'show help'
complete -c crictl -n '__fish_seen_subcommand_from help h' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_seen_subcommand_from completion' -a 'help h' -d 'Shows a list of commands or help for one command'
complete -c crictl -n '__fish_seen_subcommand_from checkpoint' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'checkpoint' -d 'Checkpoint one or more running containers'
complete -c crictl -n '__fish_seen_subcommand_from checkpoint' -f -l export -s e -r -d 'Specify the name of the tar archive (/path/to/checkpoint.tar) used to export the checkpoint image.'
complete -c crictl -n '__fish_seen_subcommand_from runtime-config' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'runtime-config' -d 'Retrieve the container runtime configuration'
complete -c crictl -n '__fish_seen_subcommand_from events event' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'events event' -d 'Stream the events of containers'
complete -c crictl -n '__fish_seen_subcommand_from events event' -f -l output -s o -r -d 'Output format, One of: json|yaml|go-template'
complete -c crictl -n '__fish_seen_subcommand_from events event' -f -l template -r -d 'The template string is only used when output is go-template; The Template format is golang template'
complete -c crictl -n '__fish_seen_subcommand_from help h' -f -l help -s h -d 'show help'
complete -r -c crictl -n '__fish_crictl_no_subcommand' -a 'help h' -d 'Shows a list of commands or help for one command'

