/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.semantics;

import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.antlr.v4.runtime.misc.Interval;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.semantics.SQLDocumentScriptItemSyntaxContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLDocumentSyntaxContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLDocumentSyntaxContextListener;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionProblemInfo;
import org.jkiss.dbeaver.model.sql.semantics.SQLScriptItemAtOffset;
import org.jkiss.dbeaver.ui.AbstractUIJob;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLSemanticErrorAnnotation;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class SQLEditorSemanticMarkersManager {
    private static final Log log = Log.getLog(SQLEditorSemanticMarkersManager.class);
    @NotNull
    private final ITextInputListener textInputListener = new ITextInputListener(){

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            SQLEditorSemanticMarkersManager.this.refresh();
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        }
    };
    private final SQLDocumentSyntaxContextListener syntaxContextListener = new SQLDocumentSyntaxContextListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onScriptItemIntroduced(@NotNull SQLDocumentScriptItemSyntaxContext item) {
            Object object = SQLEditorSemanticMarkersManager.this.syncRoot;
            synchronized (object) {
                SQLEditorSemanticMarkersManager.this.queuedOperations.put(item, true);
                SQLEditorSemanticMarkersManager.this.scheduleRefreshJob();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onScriptItemInvalidated(@NotNull SQLDocumentScriptItemSyntaxContext item) {
            Object object = SQLEditorSemanticMarkersManager.this.syncRoot;
            synchronized (object) {
                SQLEditorSemanticMarkersManager.this.queuedOperations.put(item, false);
                SQLEditorSemanticMarkersManager.this.scheduleRefreshJob();
            }
        }

        public void onAllScriptItemsInvalidated() {
            SQLEditorSemanticMarkersManager.this.scheduleClearAllProblems();
        }
    };
    @NotNull
    private final AbstractUIJob refreshJob = new AbstractUIJob("SQL editor error markers refresh"){

        @NotNull
        protected IStatus runInUIThread(@NotNull DBRProgressMonitor monitor) {
            SQLEditorSemanticMarkersManager.this.updateMarkers();
            return Status.OK_STATUS;
        }
    };
    @NotNull
    private final SQLEditorBase editor;
    @Nullable
    private volatile SQLDocumentSyntaxContext syntaxContext;
    @NotNull
    private final Object syncRoot = new Object();
    @NotNull
    private final Map<SQLDocumentScriptItemSyntaxContext, Boolean> queuedOperations = new HashMap<SQLDocumentScriptItemSyntaxContext, Boolean>();
    @NotNull
    private final Map<SQLDocumentScriptItemSyntaxContext, Deque<SQLSemanticErrorAnnotation>> annotations = new HashMap<SQLDocumentScriptItemSyntaxContext, Deque<SQLSemanticErrorAnnotation>>();
    private volatile boolean resetAnnotations = false;

    public SQLEditorSemanticMarkersManager(@NotNull SQLEditorBase editor) {
        this.editor = editor;
        this.setup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMarkers() {
        Map.Entry[] entries;
        IResource resource = (IResource)GeneralUtils.adapt((Object)this.editor.getEditorInput(), IResource.class);
        IAnnotationModel annotationModel = this.editor.getAnnotationModel();
        if (resource == null || annotationModel == null) {
            return;
        }
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.resetAnnotations) {
                try {
                    resource.deleteMarkers("org.jkiss.dbeaver.ui.editors.sql.semanticProblemMarker", false, 1);
                }
                catch (CoreException e) {
                    log.error((Object)"Error deleting problem markers", (Throwable)e);
                }
                this.resetAnnotations = false;
            }
            entries = this.queuedOperations.entrySet().toArray(new Map.Entry[0]);
            this.queuedOperations.clear();
        }
        Map.Entry[] entryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            Map.Entry entry = entryArray[n2];
            SQLDocumentScriptItemSyntaxContext scriptItem = (SQLDocumentScriptItemSyntaxContext)entry.getKey();
            if (((Boolean)entry.getValue()).booleanValue() && scriptItem.getProblems() != null) {
                itemAnnotations = this.annotations.computeIfAbsent(scriptItem, c -> new LinkedList());
                int scriptItemPosition = scriptItem.getInitialPosition();
                for (SQLQueryRecognitionProblemInfo problemInfo : scriptItem.getProblems()) {
                    try {
                        Interval problemInterval = problemInfo.getInterval();
                        IMarker marker = resource.createMarker("org.jkiss.dbeaver.ui.editors.sql.semanticProblemMarker", Map.of("severity", problemInfo.getSeverity().markerSeverity, "message", problemInfo.getMessage(), "transient", true));
                        SQLSemanticErrorAnnotation annotation = new SQLSemanticErrorAnnotation(marker, problemInfo);
                        marker.setAttribute("org.jkiss.dbeaver.ui.editors.sql.semantics.semanticProblemAnnotation", (Object)annotation);
                        Position position = new Position(scriptItemPosition + problemInterval.a, problemInterval.length());
                        annotationModel.addAnnotation((Annotation)annotation, position);
                        itemAnnotations.addLast(annotation);
                    }
                    catch (CoreException e) {
                        log.error((Object)"Error creating problem marker", (Throwable)e);
                    }
                }
            } else {
                itemAnnotations = this.annotations.remove(scriptItem);
                if (itemAnnotations != null) {
                    for (SQLSemanticErrorAnnotation annotation : itemAnnotations) {
                        IMarker marker = annotation.getMarker();
                        try {
                            marker.setAttribute("org.jkiss.dbeaver.ui.editors.sql.semantics.semanticProblemAnnotation", null);
                        }
                        catch (CoreException e) {
                            log.error((Object)"Error dissociating problem marker", (Throwable)e);
                        }
                        annotationModel.removeAnnotation((Annotation)annotation);
                        try {
                            marker.delete();
                        }
                        catch (CoreException e) {
                            log.error((Object)"Error deleting problem marker", (Throwable)e);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        SQLDocumentSyntaxContext actualContext = this.editor.getSyntaxContext();
        Object object = this.syncRoot;
        synchronized (object) {
            SQLDocumentSyntaxContext context;
            SQLDocumentSyntaxContext currentContext = this.syntaxContext;
            if (actualContext != currentContext) {
                if (currentContext != null) {
                    this.cleanup();
                }
                if (actualContext != null) {
                    this.setup();
                }
            }
            if ((context = this.syntaxContext) != null) {
                for (SQLScriptItemAtOffset itemAtOffset : context.getScriptItems()) {
                    this.queuedOperations.put(itemAtOffset.item, true);
                }
                this.scheduleClearAllProblems();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleClearAllProblems() {
        Object object = this.syncRoot;
        synchronized (object) {
            this.queuedOperations.clear();
            this.resetAnnotations = true;
            this.scheduleRefreshJob();
        }
    }

    private void scheduleRefreshJob() {
        this.refreshJob.schedule(500L);
    }

    private void setup() {
        TextViewer textViewer;
        SQLDocumentSyntaxContext context = this.editor.getSyntaxContext();
        if (context != null) {
            this.syntaxContext = context;
            context.addListener(this.syntaxContextListener);
            this.scheduleRefreshJob();
        }
        if ((textViewer = this.editor.getTextViewer()) != null) {
            textViewer.addTextInputListener(this.textInputListener);
        }
    }

    private void cleanup() {
        SQLDocumentSyntaxContext context;
        TextViewer textViewer = this.editor.getTextViewer();
        if (textViewer != null) {
            textViewer.removeTextInputListener(this.textInputListener);
        }
        if ((context = this.syntaxContext) != null) {
            context.removeListener(this.syntaxContextListener);
            this.syntaxContext = null;
        }
        this.scheduleClearAllProblems();
    }

    public void dispose() {
        this.cleanup();
    }
}

