/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.semantics;

import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionProblemInfo;
import org.jkiss.dbeaver.ui.DBeaverIcons;

public class SQLSemanticErrorAnnotation
extends MarkerAnnotation
implements IAnnotationPresentation {
    public static final String MARKER_TYPE = "org.jkiss.dbeaver.ui.editors.sql.semanticProblemMarker";
    public static final String MARKER_ATTRIBUTE_NAME = "org.jkiss.dbeaver.ui.editors.sql.semantics.semanticProblemAnnotation";
    private static final Map<SQLQueryRecognitionProblemInfo.Severity, Image> imageByProblemSeverity = Map.of(SQLQueryRecognitionProblemInfo.Severity.ERROR, DBeaverIcons.getImage((DBPImage)DBIcon.TINY_ERROR), SQLQueryRecognitionProblemInfo.Severity.WARNING, DBeaverIcons.getImage((DBPImage)DBIcon.TINY_WARNING));
    private final SQLQueryRecognitionProblemInfo problemInfo;
    private final Image image;

    public SQLSemanticErrorAnnotation(@NotNull IMarker marker, SQLQueryRecognitionProblemInfo problemInfo) {
        super("org.eclipse.ui.workbench.texteditor.error", marker);
        this.problemInfo = problemInfo;
        this.image = imageByProblemSeverity.get(problemInfo.getSeverity());
    }

    public void paint(GC gc, Canvas canvas, Rectangle r) {
        ImageUtilities.drawImage((Image)this.image, (GC)gc, (Canvas)canvas, (Rectangle)r, (int)0x1000000, (int)128);
    }
}

