/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionListenerExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.viewers.ISelection;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableParametrized;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionAnalyzer;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionRequest;
import org.jkiss.dbeaver.model.sql.parser.SQLWordPartDetector;
import org.jkiss.dbeaver.model.sql.registry.SQLCommandHandlerDescriptor;
import org.jkiss.dbeaver.model.sql.registry.SQLCommandsRegistry;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLPreferenceConstants;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQueryCompletionAnalyzer;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLCommandCompletionProposal;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLContentAssistant;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLContext;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLTemplateCompletionProposal;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLTemplatesRegistry;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class SQLCompletionProcessor
implements IContentAssistProcessor {
    private static final Log log = Log.getLog(SQLCompletionProcessor.class);
    private static IContextInformationValidator VALIDATOR = new Validator();
    private static boolean lookupTemplates = false;
    private static boolean simpleMode = false;
    private final SQLEditorBase editor;

    public static boolean isLookupTemplates() {
        return lookupTemplates;
    }

    public static void setLookupTemplates(boolean lookupTemplates) {
        SQLCompletionProcessor.lookupTemplates = lookupTemplates;
    }

    static void setSimpleMode(boolean simpleMode) {
        SQLCompletionProcessor.simpleMode = simpleMode;
    }

    public SQLCompletionProcessor(SQLEditorBase editor) {
        this.editor = editor;
    }

    public void initAssistant(SQLContentAssistant contentAssistant) {
        contentAssistant.addCompletionListener(new CompletionListener());
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        List<Object> proposals;
        String contentType;
        IDocument document = this.editor.getDocument();
        if (document == null) {
            return new ICompletionProposal[0];
        }
        try {
            String typeAtLine;
            IRegion line = document.getLineInformationOfOffset(documentOffset);
            if (documentOffset <= line.getLength() + line.getOffset() && line.getLength() > 0 && "sql_comment".equals(typeAtLine = TextUtilities.getContentType((IDocument)document, (String)"___sql_partitioning", (int)(documentOffset - 1), (boolean)true))) {
                return new ICompletionProposal[0];
            }
        }
        catch (BadLocationException e) {
            log.debug((Object)e);
            return new ICompletionProposal[0];
        }
        SQLCompletionRequest request = new SQLCompletionRequest(this.editor.getCompletionContext(), document, documentOffset, this.editor.extractQueryAtPos(documentOffset), simpleMode);
        SQLWordPartDetector wordDetector = request.getWordDetector();
        try {
            contentType = TextUtilities.getContentType((IDocument)document, (String)"___sql_partitioning", (int)documentOffset, (boolean)true);
        }
        catch (BadLocationException e) {
            log.debug((Object)e);
            return new ICompletionProposal[0];
        }
        if (contentType == null) {
            return new ICompletionProposal[0];
        }
        request.setContentType(contentType);
        switch (contentType) {
            case "__dftl_partition_content_type": 
            case "sql_character": 
            case "sql_quoted": {
                if (lookupTemplates) {
                    return this.makeTemplateProposals(viewer, request);
                }
                try {
                    String commandPrefix = this.editor.getSyntaxManager().getControlCommandPrefix();
                    if (commandPrefix != null && wordDetector.getStartOffset() >= commandPrefix.length() && viewer.getDocument().get(wordDetector.getStartOffset() - commandPrefix.length(), commandPrefix.length()).equals(commandPrefix)) {
                        return this.makeCommandProposals(request, request.getWordPart());
                    }
                }
                catch (BadLocationException e) {
                    log.debug((Object)e);
                }
                DBPDataSource dataSource = this.editor.getDataSource();
                SQLPreferenceConstants.SQLExperimentalAutocompletionMode mode = SQLPreferenceConstants.SQLExperimentalAutocompletionMode.fromPreferences(this.editor.getActivePreferenceStore());
                ArrayList<AbstractJob> completionJobs = new ArrayList<AbstractJob>();
                ArrayList<Supplier<List>> completionSuppliers = new ArrayList<Supplier<List>>();
                if (request.getWordPart() != null && mode.useOldAnalyzer && dataSource != null) {
                    SQLCompletionAnalyzer analyzer = new SQLCompletionAnalyzer(request);
                    ProposalSearchJob searchJob = new ProposalSearchJob((DBRRunnableParametrized<DBRProgressMonitor>)analyzer);
                    searchJob.schedule();
                    completionJobs.add(searchJob);
                    completionSuppliers.add(() -> ((SQLCompletionAnalyzer)analyzer).getProposals());
                    UIUtils.waitJobCompletion((AbstractJob)searchJob);
                }
                if (mode.useNewAnalyzer) {
                    final SQLQueryCompletionAnalyzer newAnalyzer = new SQLQueryCompletionAnalyzer(this.editor, request);
                    AbstractJob newJob = new AbstractJob("Analyzing query for proposals..."){
                        {
                            super($anonymous0);
                            this.setSystem(true);
                            this.setUser(false);
                            this.schedule();
                        }

                        protected IStatus run(DBRProgressMonitor monitor) {
                            try {
                                monitor.beginTask("Seeking for SQL completion proposals", 1);
                                try {
                                    monitor.subTask("Find proposals");
                                    if (SQLCompletionProcessor.this.editor.getDataSource() != null) {
                                        DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)SQLCompletionProcessor.this.editor.getDataSource(), (DBRRunnableParametrized)newAnalyzer);
                                    } else {
                                        newAnalyzer.run(monitor);
                                    }
                                }
                                finally {
                                    monitor.done();
                                }
                                return Status.OK_STATUS;
                            }
                            catch (Throwable e) {
                                log.error((Object)e);
                                return Status.CANCEL_STATUS;
                            }
                        }
                    };
                    newJob.schedule();
                    completionJobs.add(newJob);
                    completionSuppliers.add(newAnalyzer::getProposals);
                }
                completionJobs.forEach(UIUtils::waitJobCompletion);
                proposals = completionSuppliers.stream().flatMap(s -> ((List)s.get()).stream()).toList();
                break;
            }
            default: {
                proposals = Collections.emptyList();
            }
        }
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        for (Object cp : proposals) {
            if (!(cp instanceof ICompletionProposal)) continue;
            result.add((ICompletionProposal)cp);
        }
        return (ICompletionProposal[])ArrayUtils.toArray(ICompletionProposal.class, result);
    }

    private ICompletionProposal[] makeCommandProposals(SQLCompletionRequest request, String prefix) {
        String controlCommandPrefix = this.editor.getSyntaxManager().getControlCommandPrefix();
        if (prefix.startsWith(controlCommandPrefix)) {
            prefix = prefix.substring(controlCommandPrefix.length());
        }
        ArrayList<SQLCommandCompletionProposal> commandProposals = new ArrayList<SQLCommandCompletionProposal>();
        for (SQLCommandHandlerDescriptor command : SQLCommandsRegistry.getInstance().getCommandHandlers()) {
            if (!command.getId().startsWith(prefix)) continue;
            commandProposals.add(new SQLCommandCompletionProposal(request, command));
        }
        return commandProposals.toArray(new ICompletionProposal[0]);
    }

    @NotNull
    private ICompletionProposal[] makeTemplateProposals(ITextViewer viewer, SQLCompletionRequest request) {
        String wordPart = request.getWordPart().toLowerCase();
        ArrayList<SQLTemplateCompletionProposal> templateProposals = new ArrayList<SQLTemplateCompletionProposal>();
        Template[] templateArray = this.editor.getTemplatesPage().getTemplateStore().getTemplates();
        int n = templateArray.length;
        int n2 = 0;
        while (n2 < n) {
            Template template = templateArray[n2];
            if (template.getName().toLowerCase().startsWith(wordPart) && SQLEditorUtils.isTemplateContextFitsEditorContext(template.getContextTypeId(), this.editor)) {
                SQLContext templateContext = new SQLContext(SQLTemplatesRegistry.getInstance().getTemplateContextRegistry().getContextType(template.getContextTypeId()), viewer.getDocument(), new Position(request.getWordDetector().getStartOffset(), request.getWordDetector().getLength()), this.editor);
                ISelection selection = viewer.getSelectionProvider().getSelection();
                if (selection instanceof TextSelection) {
                    templateContext.setVariable("selection", ((TextSelection)selection).getText());
                }
                templateProposals.add(new SQLTemplateCompletionProposal(template, (TemplateContext)templateContext, (IRegion)new Region(request.getDocumentOffset(), 0), null));
            }
            ++n2;
        }
        templateProposals.sort(Comparator.comparing(TemplateProposal::getDisplayString));
        return templateProposals.toArray(new ICompletionProposal[0]);
    }

    @Nullable
    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        SQLScriptElement statementInfo = this.editor.extractQueryAtPos(documentOffset);
        if (statementInfo == null || CommonUtils.isEmpty((String)statementInfo.getText())) {
            return null;
        }
        IContextInformation[] result = new IContextInformation[]{new ContextInformation(statementInfo.getText(), statementInfo.getText())};
        return result;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        char[] cArray;
        boolean useKeystrokes = this.editor.getActivePreferenceStore().getBoolean("SQLEditor.ContentAssistant.auto.keystrokes.activation");
        if (useKeystrokes) {
            cArray = ".abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_$".toCharArray();
        } else {
            char[] cArray2 = new char[1];
            cArray = cArray2;
            cArray2[0] = 46;
        }
        return cArray;
    }

    @Nullable
    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    @Nullable
    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return VALIDATOR;
    }

    private static class CompletionListener
    implements ICompletionListener,
    ICompletionListenerExtension {
        private CompletionListener() {
        }

        public void assistSessionStarted(ContentAssistEvent event) {
            SQLCompletionProcessor.setSimpleMode(event.isAutoActivated);
        }

        public void assistSessionEnded(ContentAssistEvent event) {
            simpleMode = false;
        }

        public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
        }

        public void assistSessionRestarted(ContentAssistEvent event) {
            simpleMode = true;
        }
    }

    private class ProposalSearchJob
    extends AbstractJob {
        private final DBRRunnableParametrized<DBRProgressMonitor> analyzer;

        ProposalSearchJob(DBRRunnableParametrized<DBRProgressMonitor> analyzer) {
            super("Search proposals...");
            this.analyzer = analyzer;
            this.setSystem(true);
            this.setUser(false);
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            try {
                monitor.beginTask("Seeking for SQL completion proposals", 1);
                try {
                    monitor.subTask("Find proposals");
                    DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)SQLCompletionProcessor.this.editor.getDataSource(), this.analyzer);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
            catch (Throwable e) {
                log.error((Object)e);
                return Status.CANCEL_STATUS;
            }
        }
    }

    protected static class Validator
    implements IContextInformationValidator,
    IContextInformationPresenter {
        int fInstallOffset;

        protected Validator() {
        }

        public boolean isContextInformationValid(int offset) {
            return Math.abs(this.fInstallOffset - offset) < 5;
        }

        public void install(IContextInformation info, ITextViewer viewer, int offset) {
            this.fInstallOffset = offset;
        }

        public boolean updatePresentation(int documentPosition, TextPresentation presentation) {
            return false;
        }
    }
}

