/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreJobClass;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreJobSchedule;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreJobStep;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBPStatefulObject;
import org.jkiss.dbeaver.model.DBPSystemInfoObject;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookupCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;

public class PostgreJob
implements PostgreObject,
DBPStatefulObject,
DBPRefreshableObject,
DBPSaveableObject,
DBPSystemInfoObject {
    private static final Log log = Log.getLog(PostgreJob.class);
    private final PostgreDatabase database;
    private long id;
    private String name;
    private String description;
    private String hostAgent;
    private PostgreJobClass jobClass;
    private boolean enabled;
    private boolean persisted;
    private final StepCache stepCache = new StepCache();
    private final ScheduleCache scheduleCache = new ScheduleCache();

    public PostgreJob(@NotNull DBRProgressMonitor monitor, @NotNull PostgreDatabase database, @NotNull ResultSet dbResult) throws DBException {
        this.database = database;
        this.id = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"jobid");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"jobname");
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"jobdesc");
        this.hostAgent = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"jobhostagent");
        this.jobClass = database.getJobClass(monitor, JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"jobjclid"));
        this.enabled = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"jobenabled");
        this.persisted = true;
    }

    public PostgreJob(@NotNull DBRProgressMonitor monitor, @NotNull PostgreDatabase database, @NotNull String name) throws DBException {
        this.database = database;
        this.id = 0L;
        this.name = name;
        this.description = "";
        this.hostAgent = "";
        this.jobClass = database.getJobClass(monitor, 1L);
        this.enabled = true;
        this.persisted = false;
    }

    public long getObjectId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Property(viewable=true, editable=true, updatable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    @Property(viewable=true, editable=true, updatable=true, order=2)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@NotNull String description) {
        this.description = description;
    }

    @Property(viewable=true, editable=true, updatable=true, order=3)
    @NotNull
    public String getHostAgent() {
        return this.hostAgent;
    }

    public void setHostAgent(@NotNull String hostAgent) {
        this.hostAgent = hostAgent;
    }

    @Property(viewable=true, editable=true, updatable=true, listProvider=JobClassListProvider.class, order=4)
    @NotNull
    public PostgreJobClass getJobClass() {
        return this.jobClass;
    }

    public void setJobClass(@NotNull PostgreJobClass jobClass) {
        this.jobClass = jobClass;
    }

    @Property(viewable=true, editable=true, updatable=true, order=5)
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Association
    @NotNull
    public List<PostgreJobStep> getSteps(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.stepCache.getAllObjects(monitor, this);
    }

    @Nullable
    public PostgreJobStep getStep(@NotNull DBRProgressMonitor monitor, @NotNull String name) throws DBException {
        return (PostgreJobStep)this.stepCache.getObject(monitor, this, name);
    }

    @NotNull
    public StepCache getStepCache() {
        return this.stepCache;
    }

    @Association
    @NotNull
    public List<PostgreJobSchedule> getSchedules(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.scheduleCache.getAllObjects(monitor, this);
    }

    @Nullable
    public PostgreJobSchedule getSchedule(@NotNull DBRProgressMonitor monitor, @NotNull String name) throws DBException {
        return (PostgreJobSchedule)this.scheduleCache.getObject(monitor, this, name);
    }

    @NotNull
    public ScheduleCache getScheduleCache() {
        return this.scheduleCache;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.database;
    }

    @Override
    @NotNull
    public PostgreDataSource getDataSource() {
        return this.database.getDataSource();
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return this.database;
    }

    @NotNull
    public DBSObjectState getObjectState() {
        return this.enabled ? DBSObjectState.ACTIVE : DBSObjectState.NORMAL;
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) {
    }

    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        PostgreDatabase database = this.getDatabase();
        this.stepCache.clearCache();
        this.scheduleCache.clearCache();
        return database.jobCache.refreshObject(monitor, database, this);
    }

    public static class JobClassListProvider
    implements IPropertyValueListProvider<PostgreJob> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(@NotNull PostgreJob object) {
            try {
                return object.getDatabase().getJobClasses((DBRProgressMonitor)new VoidProgressMonitor()).toArray();
            }
            catch (DBException e) {
                log.error((Object)"Error loading job classes", (Throwable)e);
                return null;
            }
        }
    }

    public static class ScheduleCache
    extends JDBCObjectLookupCache<PostgreJob, PostgreJobSchedule> {
        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull PostgreJob job, @Nullable PostgreJobSchedule schedule, @Nullable String objectName) throws SQLException {
            StringBuilder sql = new StringBuilder("SELECT * FROM pgagent.pga_schedule WHERE jscjobid=?");
            if (schedule != null) {
                sql.append(" AND jscid=?");
            }
            JDBCPreparedStatement stmt = session.prepareStatement(sql.toString());
            stmt.setLong(1, job.getObjectId());
            if (schedule != null) {
                stmt.setLong(2, schedule.getObjectId());
            }
            return stmt;
        }

        @Nullable
        protected PostgreJobSchedule fetchObject(@NotNull JDBCSession session, @NotNull PostgreJob job, @NotNull JDBCResultSet dbResult) {
            return new PostgreJobSchedule(job, (ResultSet)dbResult);
        }
    }

    public static class StepCache
    extends JDBCObjectLookupCache<PostgreJob, PostgreJobStep> {
        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull PostgreJob job, @Nullable PostgreJobStep step, @Nullable String objectName) throws SQLException {
            StringBuilder sql = new StringBuilder("SELECT * FROM pgagent.pga_jobstep WHERE jstjobid=?");
            if (step != null) {
                sql.append(" AND jstid=?");
            }
            JDBCPreparedStatement stmt = session.prepareStatement(sql.toString());
            stmt.setLong(1, job.getObjectId());
            if (step != null) {
                stmt.setLong(2, step.getObjectId());
            }
            return stmt;
        }

        @Nullable
        protected PostgreJobStep fetchObject(@NotNull JDBCSession session, @NotNull PostgreJob job, @NotNull JDBCResultSet dbResult) {
            return new PostgreJobStep(job, (ResultSet)dbResult);
        }
    }
}

