/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAttribute;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreClass;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDialect;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSequence;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreViewBase;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.dpi.DPIElement;
import org.jkiss.dbeaver.model.dpi.DPIObject;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookupCache;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

@DPIObject
@DPIElement
public interface PostgreServerExtension {
    public String getServerTypeName();

    public boolean supportsTransactions();

    public boolean supportsOids();

    public boolean supportsIndexes();

    public boolean supportsForeignKeys();

    public boolean supportsMaterializedViews();

    public boolean supportsPartitions();

    public boolean supportsInheritance();

    public boolean supportsTriggers();

    public boolean supportsEventTriggers();

    public boolean supportsDependencies();

    public boolean supportsFunctionDefRead();

    public boolean supportsFunctionCreate();

    public boolean supportsRules();

    public boolean supportsRowLevelSecurity();

    public boolean supportsExtensions();

    public boolean supportsEncodings();

    public boolean supportsCollations();

    public boolean supportsLanguages();

    public boolean supportsTablespaces();

    public boolean supportsSequences();

    public PostgreSequence createSequence(@NotNull PostgreSchema var1);

    public boolean supportsRoles();

    public boolean supportsSessionActivity();

    public boolean supportsLocks();

    public boolean supportsForeignServers();

    public boolean supportsAggregates();

    public boolean supportsResultSetLimits();

    public boolean supportsClientInfo();

    public boolean supportsRelationSizeCalc();

    public boolean supportsExplainPlan();

    public boolean supportsExplainPlanXML();

    public boolean supportsExplainPlanVerbose();

    public boolean supportsDatabaseDescription();

    public boolean supportsTemporalAccessor();

    public boolean supportsTablespaceLocation();

    public boolean supportsTemplates();

    public boolean supportsStoredProcedures();

    public String getProceduresSystemTable();

    public String getProceduresOidColumn();

    public String readTableDDL(DBRProgressMonitor var1, PostgreTableBase var2) throws DBException;

    public String readViewDDL(DBRProgressMonitor var1, PostgreViewBase var2) throws DBException;

    public JDBCObjectLookupCache<PostgreDatabase, PostgreSchema> createSchemaCache(PostgreDatabase var1);

    public PostgreTableBase createRelationOfClass(PostgreSchema var1, PostgreClass.RelKind var2, JDBCResultSet var3);

    public PostgreTableBase createNewRelation(DBRProgressMonitor var1, PostgreSchema var2, PostgreClass.RelKind var3, Object var4) throws DBException;

    public void configureDialect(PostgreDialect var1);

    public String getTableModifiers(DBRProgressMonitor var1, PostgreTableBase var2, boolean var3);

    public void initDefaultSSLConfig(DBPConnectionConfiguration var1, Map<String, String> var2);

    public List<PostgrePrivilege> readObjectPermissions(DBRProgressMonitor var1, PostgreTableBase var2, boolean var3) throws DBException;

    public Map<String, String> getDataTypeAliases();

    public boolean supportsTableStatistics();

    public boolean supportsEntityMetadataInResults();

    public boolean supportsPGConstraintExpressionColumn();

    public boolean supportsHasOidsColumn();

    public boolean supportsColumnsRequiring();

    public boolean supportsDatabaseSize();

    public boolean isAlterTableAtomic();

    public boolean supportsSuperusers();

    public boolean supportsRolesWithCreateDBAbility();

    public boolean supportsRoleReplication();

    public boolean supportsRoleBypassRLS();

    public boolean supportsCommentsOnRole();

    public boolean supportsDefaultPrivileges();

    public boolean supportSerialTypes();

    public boolean supportsExternalTypes();

    public boolean supportsBackslashStringEscape();

    public boolean supportsDisablingAllTriggers();

    public boolean supportsGeneratedColumns();

    public boolean isHiddenRowidColumn(@NotNull PostgreAttribute var1);

    public boolean supportsShowingOfExtraComments();

    public boolean supportsKeyAndIndexRename();

    public boolean supportsAlterUserChangePassword();

    public boolean supportsCopyFromStdIn();

    public int getParameterBindType(DBSTypedObject var1, Object var2);

    public int getTruncateToolModes();

    public boolean supportsAcl();

    public boolean supportsCustomDataTypes();

    public boolean supportsDistinctForStatementsWithAcl();

    public boolean supportsOpFamily();

    public boolean supportsAlterTableColumnWithUSING();

    public boolean supportsAlterTableForViewRename();

    public boolean supportsNativeClient();
}

