/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.connection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.DBPDataSourcePermissionOwner;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class DBPConnectionType
implements DBPDataSourcePermissionOwner {
    public static final DBPConnectionType DEV = new DBPConnectionType("dev", ModelMessages.dbp_connection_type_table_development, "255,255,255", ModelMessages.dbp_connection_type_table_regular_development_database, true, false, false, false, true, true, 1800, true, 14400, true, null);
    public static final DBPConnectionType TEST = new DBPConnectionType("test", ModelMessages.dbp_connection_type_table_test, "org.jkiss.dbeaver.color.connectionType.qa.background", ModelMessages.dbp_connection_type_table_test_database, true, false, true, false, true, true, 900, true, 7200, true, null);
    public static final DBPConnectionType PROD = new DBPConnectionType("prod", ModelMessages.dbp_connection_type_table_production, "org.jkiss.dbeaver.color.connectionType.prod.background", ModelMessages.dbp_connection_type_table_production_database, false, true, true, false, false, true, 600, true, 3600, true, null);
    public static final DBPConnectionType[] SYSTEM_TYPES = new DBPConnectionType[]{DEV, TEST, PROD};
    public static final DBPConnectionType DEFAULT_TYPE = DEV;
    private String id;
    private String name;
    private String color;
    private String description;
    private boolean autocommit;
    private boolean confirmExecute;
    private boolean confirmDataChange;
    private boolean smartCommit;
    private boolean smartCommitRecover;
    private boolean autoCloseTransactions;
    private int closeIdleTransactionPeriod;
    private boolean autoCloseConnections;
    private int closeIdleConnectionPeriod;
    private final boolean predefined;
    private List<DBPDataSourcePermission> connectionModifyRestrictions;
    private static final String DEFAULT_CONNECTION_TYPE_PREF = "default.connection.type";

    public DBPConnectionType(DBPConnectionType source) {
        this(source.id, source.name, source.color, source.description, source.autocommit, source.confirmExecute, source.confirmDataChange, source.smartCommit, source.smartCommitRecover, source.autoCloseTransactions, source.closeIdleTransactionPeriod, source.autoCloseConnections, source.closeIdleConnectionPeriod, source.predefined, source.connectionModifyRestrictions);
    }

    public DBPConnectionType(String id, String name, String color, String description, boolean autocommit, boolean confirmExecute, boolean confirmDataChange, boolean smartCommit, boolean smartCommitRecover, boolean autoCloseTransactions, int closeIdleTransactionPeriod, boolean autoCloseConnections, int closeIdleConnectionPeriod) {
        this(id, name, color, description, autocommit, confirmExecute, confirmDataChange, smartCommit, smartCommitRecover, autoCloseTransactions, closeIdleTransactionPeriod, autoCloseConnections, closeIdleConnectionPeriod, false, null);
    }

    private DBPConnectionType(String id, String name, String color, String description, boolean autocommit, boolean confirmExecute, boolean confirmDataChange, boolean smartCommit, boolean smartCommitRecover, boolean autoCloseTransactions, int closeIdleTransactionPeriod, boolean autoCloseConnections, int closeIdleConnectionPeriod, boolean predefined, List<DBPDataSourcePermission> connectionModifyRestrictions) {
        this.id = id;
        this.name = name;
        this.color = this.getColorValueFixed(color);
        this.description = description;
        this.autocommit = autocommit;
        this.confirmExecute = confirmExecute;
        this.confirmDataChange = confirmDataChange;
        this.smartCommit = smartCommit;
        this.smartCommitRecover = smartCommitRecover;
        this.autoCloseTransactions = autoCloseTransactions;
        this.closeIdleTransactionPeriod = closeIdleTransactionPeriod;
        this.autoCloseConnections = autoCloseConnections;
        this.closeIdleConnectionPeriod = closeIdleConnectionPeriod;
        this.predefined = predefined;
        if (connectionModifyRestrictions != null) {
            this.connectionModifyRestrictions = new ArrayList<DBPDataSourcePermission>(connectionModifyRestrictions);
        }
    }

    public boolean isPredefined() {
        return this.predefined;
    }

    public String getId() {
        return this.id;
    }

    public String setId(String id) {
        this.id = id;
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = this.getColorValueFixed(color);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isAutocommit() {
        return this.autocommit;
    }

    public void setAutocommit(boolean autocommit) {
        this.autocommit = autocommit;
    }

    public boolean isConfirmExecute() {
        return this.confirmExecute;
    }

    public void setConfirmExecute(boolean confirmExecute) {
        this.confirmExecute = confirmExecute;
    }

    public boolean isConfirmDataChange() {
        return this.confirmDataChange;
    }

    public void setConfirmDataChange(boolean confirmDataChange) {
        this.confirmDataChange = confirmDataChange;
    }

    public boolean isSmartCommit() {
        return this.smartCommit;
    }

    public void setSmartCommit(boolean smartCommit) {
        this.smartCommit = smartCommit;
    }

    public boolean isSmartCommitRecover() {
        return this.smartCommitRecover;
    }

    public void setSmartCommitRecover(boolean smartCommitRecover) {
        this.smartCommitRecover = smartCommitRecover;
    }

    public boolean isAutoCloseTransactions() {
        return this.autoCloseTransactions;
    }

    public void setAutoCloseTransactions(boolean autoCloseTransactions) {
        this.autoCloseTransactions = autoCloseTransactions;
    }

    public int getCloseIdleTransactionPeriod() {
        return this.closeIdleTransactionPeriod;
    }

    public void setCloseIdleTransactionPeriod(int closeIdleTransactionPeriod) {
        this.closeIdleTransactionPeriod = closeIdleTransactionPeriod;
    }

    public boolean isAutoCloseConnections() {
        return this.autoCloseConnections;
    }

    public void setAutoCloseConnections(boolean autoCloseConnections) {
        this.autoCloseConnections = autoCloseConnections;
    }

    public int getCloseIdleConnectionPeriod() {
        return this.closeIdleConnectionPeriod;
    }

    public void setCloseIdleConnectionPeriod(int closeIdleConnectionPeriod) {
        this.closeIdleConnectionPeriod = closeIdleConnectionPeriod;
    }

    @Override
    public boolean hasModifyPermission(DBPDataSourcePermission permission) {
        return this.connectionModifyRestrictions == null || !this.connectionModifyRestrictions.contains((Object)permission);
    }

    @Override
    public List<DBPDataSourcePermission> getModifyPermission() {
        if (CommonUtils.isEmpty(this.connectionModifyRestrictions)) {
            return Collections.emptyList();
        }
        return new ArrayList<DBPDataSourcePermission>(this.connectionModifyRestrictions);
    }

    @Override
    public void setModifyPermissions(@Nullable Collection<DBPDataSourcePermission> permissions) {
        this.connectionModifyRestrictions = CommonUtils.isEmpty(permissions) ? null : new ArrayList<DBPDataSourcePermission>(permissions);
    }

    private String getColorValueFixed(String color) {
        if (PROD != null && this.id.equals(DBPConnectionType.PROD.id) && color.equals("247,159,129")) {
            return DBPConnectionType.PROD.color;
        }
        if (TEST != null && this.id.equals(DBPConnectionType.TEST.id) && color.equals("196,255,181")) {
            return DBPConnectionType.TEST.color;
        }
        return color;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DBPConnectionType) {
            DBPConnectionType ct = (DBPConnectionType)obj;
            return CommonUtils.equalObjects((Object)this.id, (Object)ct.id) && CommonUtils.equalObjects((Object)this.name, (Object)ct.name) && CommonUtils.equalObjects((Object)this.color, (Object)ct.color) && CommonUtils.equalObjects((Object)this.description, (Object)ct.description) && this.autocommit == ct.autocommit && this.confirmExecute == ct.confirmExecute && this.confirmDataChange == ct.confirmDataChange && this.smartCommit == ct.smartCommit && this.smartCommitRecover == ct.smartCommitRecover && this.autoCloseTransactions == ct.autoCloseTransactions && CommonUtils.equalObjects((Object)this.closeIdleTransactionPeriod, (Object)ct.closeIdleTransactionPeriod) && this.autoCloseConnections == ct.autoCloseConnections && CommonUtils.equalObjects((Object)this.closeIdleConnectionPeriod, (Object)ct.closeIdleConnectionPeriod) && this.predefined == ct.predefined && CommonUtils.equalObjects(this.connectionModifyRestrictions, ct.connectionModifyRestrictions);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static DBPConnectionType getDefaultConnectionType() {
        String defTypeName = DBWorkbench.getPlatform().getPreferenceStore().getString(DEFAULT_CONNECTION_TYPE_PREF);
        if (CommonUtils.isEmpty((String)defTypeName)) {
            defTypeName = DEV.getId();
        }
        return DBWorkbench.getPlatform().getDataSourceProviderRegistry().getConnectionType(defTypeName, DEV);
    }

    public static void setDefaultConnectionType(DBPConnectionType connectionType) {
        DBWorkbench.getPlatform().getPreferenceStore().setValue(DEFAULT_CONNECTION_TYPE_PREF, connectionType.getId());
    }
}

