/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data.transformers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingType;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformer;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public class MapAttributeTransformer
implements DBDAttributeTransformer {
    private static final boolean FILTER_SIMPLE_COLLECTIONS = false;

    @Override
    public void transformAttribute(@NotNull DBCSession session, @NotNull DBDAttributeBinding attribute, @NotNull List<Object[]> rows, @NotNull Map<String, Object> options) throws DBException {
        if (!session.getDataSource().getContainer().getPreferenceStore().getBoolean("resultset.transform.complex.type")) {
            return;
        }
        if (attribute.getDataKind() == DBPDataKind.STRUCT && !CommonUtils.isEmpty(attribute.getNestedBindings()) && !session.getDataSource().getInfo().isDynamicMetadata()) {
            return;
        }
        if (rows.isEmpty()) {
            int attrIndex = attribute.getOrdinalPosition();
            Object[] fakeRow = new Object[attrIndex + 1];
            fakeRow[attrIndex] = attribute.getValueHandler().createNewValueObject(session, attribute);
            MapAttributeTransformer.resolveMapsFromData(session, attribute, Collections.singletonList(fakeRow));
        } else {
            MapAttributeTransformer.resolveMapsFromData(session, attribute, rows);
        }
    }

    static void resolveMapsFromData(DBCSession session, DBDAttributeBinding attribute, List<Object[]> rows) throws DBException {
        ArrayList<Pair> valueAttributes = null;
        int i = 0;
        while (i < rows.size()) {
            block13: {
                Object value;
                block12: {
                    value = rows.get(i)[attribute.getOrdinalPosition()];
                    if (!(value instanceof DBDCollection)) break block12;
                    DBDCollection collection = (DBDCollection)value;
                    if (collection.getItemCount() <= 0) break block13;
                    value = collection.getItem(0);
                }
                if (value instanceof DBDComposite) {
                    DBSAttributeBase[] attributes;
                    DBSAttributeBase[] dBSAttributeBaseArray = attributes = ((DBDComposite)value).getAttributes();
                    int n = attributes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DBSAttributeBase attr = dBSAttributeBaseArray[n2];
                        Pair<DBSAttributeBase, Object[]> attrValue = MapAttributeTransformer.findAttributeValue(attr, (List<Pair<DBSAttributeBase, Object[]>>)valueAttributes);
                        if (attrValue != null) {
                            ((Object[])attrValue.getSecond())[i] = ((DBDComposite)value).getAttributeValue(attr);
                        } else {
                            Object[] valueList = new Object[rows.size()];
                            valueList[i] = ((DBDComposite)value).getAttributeValue(attr);
                            if (valueAttributes == null) {
                                valueAttributes = new ArrayList<Pair>();
                            }
                            Pair attributePair = new Pair((Object)attr, (Object)valueList);
                            if (valueAttributes.size() >= attr.getOrdinalPosition()) {
                                valueAttributes.add(attr.getOrdinalPosition(), attributePair);
                            } else {
                                valueAttributes.add(attributePair);
                            }
                        }
                        ++n2;
                    }
                }
            }
            ++i;
        }
        if (valueAttributes != null && !valueAttributes.isEmpty()) {
            MapAttributeTransformer.createNestedMapBindings(session, attribute, (List<Pair<DBSAttributeBase, Object[]>>)valueAttributes, rows);
        }
    }

    private static Pair<DBSAttributeBase, Object[]> findAttributeValue(@NotNull DBSAttributeBase attr, @Nullable List<Pair<DBSAttributeBase, Object[]>> valueAttributes) {
        if (valueAttributes == null) {
            return null;
        }
        for (Pair<DBSAttributeBase, Object[]> pair : valueAttributes) {
            if (!((DBSAttributeBase)pair.getFirst()).getName().equals(attr.getName())) continue;
            pair.setFirst((Object)DBUtils.getMoreCommonType((DBSAttributeBase)pair.getFirst(), attr));
            return pair;
        }
        return null;
    }

    private static void createNestedMapBindings(DBCSession session, DBDAttributeBinding topAttribute, List<Pair<DBSAttributeBase, Object[]>> nestedAttributes, List<Object[]> rows) throws DBException {
        int maxPosition = 0;
        List<DBDAttributeBinding> nestedBindings = topAttribute.getNestedBindings();
        if (nestedBindings == null) {
            nestedBindings = new ArrayList<DBDAttributeBinding>();
        }
        for (Pair<DBSAttributeBase, Object[]> nestedAttr : nestedAttributes) {
            DBSAttributeBase attribute = (DBSAttributeBase)nestedAttr.getFirst();
            maxPosition = Math.max(maxPosition, attribute.getOrdinalPosition());
            DBDAttributeBinding nestedBinding = DBUtils.findObject(nestedBindings, attribute.getName());
            if (nestedBinding == null) {
                nestedBinding = new DBDAttributeBindingType(topAttribute, attribute, nestedBindings.size());
                nestedBindings.add(nestedBinding);
            }
            maxPosition = Math.max(maxPosition, nestedBinding.getOrdinalPosition());
        }
        Object[] fakeRow = new Object[maxPosition + 1];
        List<Object[]> fakeRows = Collections.singletonList(fakeRow);
        for (Pair<DBSAttributeBase, Object[]> nestedAttr : nestedAttributes) {
            DBSAttributeBase attribute = (DBSAttributeBase)nestedAttr.getFirst();
            Object[] values = (Object[])nestedAttr.getSecond();
            DBDAttributeBinding nestedBinding = DBUtils.findObject(nestedBindings, attribute.getName());
            if (nestedBinding == null) {
                nestedBinding = new DBDAttributeBindingType(topAttribute, attribute, nestedBindings.size());
                nestedBindings.add(nestedBinding);
            }
            if (attribute.getDataKind().isComplex()) {
                int i = 0;
                while (i < values.length) {
                    if (!DBUtils.isNullValue(values[i])) {
                        fakeRow[nestedBinding.getOrdinalPosition()] = values[i];
                        nestedBinding.lateBinding(session, fakeRows);
                    }
                    ++i;
                }
                continue;
            }
            nestedBinding.lateBinding(session, fakeRows);
        }
        if (!nestedBindings.isEmpty()) {
            topAttribute.setNestedBindings(nestedBindings);
        }
    }
}

