/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.net;

import java.io.IOException;
import java.net.ProxySelector;
import org.eclipse.core.net.proxy.IProxyService;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCInvalidatePhase;
import org.jkiss.dbeaver.model.net.DBWForwarder;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWNetworkHandler;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.net.GlobalProxySelector;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class SocksProxyImpl
implements DBWNetworkHandler,
DBWForwarder {
    private static final Log log = Log.getLog(SocksProxyImpl.class);
    private DBWHandlerConfiguration configuration;

    @Override
    public DBPConnectionConfiguration initializeHandler(DBRProgressMonitor monitor, DBWHandlerConfiguration configuration, DBPConnectionConfiguration connectionInfo) throws DBException, IOException {
        this.configuration = configuration;
        SocksProxyImpl.setupProxyHandler();
        return null;
    }

    @Override
    public void invalidateHandler(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull DBCInvalidatePhase phase) throws DBException {
    }

    @Override
    public boolean matchesParameters(String host, int port) {
        if (host.equals(this.configuration.getStringProperty("socks-host"))) {
            int socksPort = this.configuration.getIntProperty("socks-port");
            return socksPort == port;
        }
        return false;
    }

    private static void activateProxyService() {
        try {
            log.debug("Proxy service '" + IProxyService.class.getName() + "' loaded");
        }
        catch (Throwable throwable) {
            log.debug("Proxy service not found");
        }
    }

    private static void setupProxyHandler() {
        if (ProxySelector.getDefault() instanceof GlobalProxySelector) {
            return;
        }
        SocksProxyImpl.activateProxyService();
        ProxySelector defProxySelector = GeneralUtils.adapt(DBWorkbench.getPlatform(), ProxySelector.class);
        if (defProxySelector == null) {
            defProxySelector = new GlobalProxySelector(ProxySelector.getDefault());
        }
        ProxySelector.setDefault(defProxySelector);
    }
}

