/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDBinaryFormatter;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.impl.data.formatters.BinaryFormatterHexNative;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.impl.sql.SQLDialectQueryGenerator;
import org.jkiss.dbeaver.model.impl.sql.StandardSQLDialectQueryGenerator;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLBlockCompletions;
import org.jkiss.dbeaver.model.sql.SQLBlockCompletionsCollection;
import org.jkiss.dbeaver.model.sql.SQLConstants;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLExpressionFormatter;
import org.jkiss.dbeaver.model.sql.SQLStateType;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.parser.EmptyTokenPredicateSet;
import org.jkiss.dbeaver.model.sql.parser.SQLTokenPredicateSet;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameter;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameterKind;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public abstract class AbstractSQLDialect
implements SQLDialect {
    public static final String ID = "basic";
    private static final String[] DEFAULT_LINE_COMMENTS = new String[]{"//"};
    private static final String[] QUERY_KEYWORDS = new String[]{"SELECT"};
    private static final String[] EXEC_KEYWORDS = new String[0];
    private static final String[] DDL_KEYWORDS = new String[0];
    private static final Collection<String> TRANSACTION_NON_MODIFYING_KEYWORDS = Set.of("SELECT", "SHOW", "USE", "SET", "EXPLAIN");
    public static final String[][] DEFAULT_IDENTIFIER_QUOTES = new String[][]{{"\"", "\""}};
    public static final String[][] DEFAULT_STRING_QUOTES = new String[][]{{"'", "'"}};
    private static final String[][] DEFAULT_BEGIN_END_BLOCK = new String[0][];
    private static final String[] CORE_NON_TRANSACTIONAL_KEYWORDS = new String[0];
    public static final String[] DML_KEYWORDS = new String[0];
    public static final Pair<String, String> IN_CLAUSE_PARENTHESES = new Pair((Object)"(", (Object)")");
    protected static final SQLBlockCompletions DEFAULT_SQL_BLOCK_COMPLETIONS = new SQLBlockCompletionsCollection(){
        {
            this.registerCompletionPair("BEGIN", "END");
            this.registerCompletionPair("CASE", "END");
            this.registerCompletionPair("LOOP", "END", "LOOP");
            this.registerCompletionInfo("IF", new String[]{" THEN", SQLBlockCompletions.NEW_LINE_COMPLETION_PART, "\t", SQLBlockCompletions.NEW_LINE_COMPLETION_PART, "END IF", SQLBlockCompletions.NEW_LINE_COMPLETION_PART}, "END", "IF");
        }
    };
    public static final Locale DEF_LOCALE = Locale.ENGLISH;
    private final TreeMap<String, KeywordHolder> allKeywords = new TreeMap();
    private final TreeMap<String, String> reservedWords = new TreeMap();
    private final TreeMap<String, String> functions = new TreeMap();
    private final TreeMap<String, String> types = new TreeMap();
    private final TreeMap<String, String> tableQueryWords = new TreeMap();
    private final TreeMap<String, String> columnQueryWords = new TreeMap();
    private final Pair<String, String> multiLineComments = new Pair((Object)"/*", (Object)"*/");
    private final Map<String, Integer> keywordsIndent = new HashMap<String, Integer>();

    protected AbstractSQLDialect() {
    }

    @Override
    @NotNull
    public SQLDialectQueryGenerator getQueryGenerator() {
        return StandardSQLDialectQueryGenerator.INSTANCE;
    }

    @Override
    @Nullable
    public String[][] getIdentifierQuoteStrings() {
        return DEFAULT_IDENTIFIER_QUOTES;
    }

    @Override
    @NotNull
    public String[][] getStringQuoteStrings() {
        return DEFAULT_STRING_QUOTES;
    }

    @Override
    @NotNull
    public String[] getQueryKeywords() {
        return QUERY_KEYWORDS;
    }

    @Override
    @NotNull
    public String[] getExecuteKeywords() {
        return EXEC_KEYWORDS;
    }

    @Override
    @NotNull
    public String[] getDDLKeywords() {
        return DDL_KEYWORDS;
    }

    protected void addSQLKeyword(String keyword) {
        String ciWord = keyword.toUpperCase(DEF_LOCALE);
        this.reservedWords.put(ciWord, keyword);
        this.allKeywords.put(ciWord, new KeywordHolder(DBPKeywordType.KEYWORD, keyword));
    }

    protected void removeSQLKeyword(String keyword) {
        String ciWord = keyword.toUpperCase(DEF_LOCALE);
        this.reservedWords.remove(ciWord);
        this.allKeywords.remove(ciWord);
    }

    protected void addSQLKeywords(Collection<String> allKeywords) {
        for (String kw : allKeywords) {
            this.addSQLKeyword(kw);
        }
    }

    @Override
    @NotNull
    public Pair<String, String> getInClauseParentheses() {
        return IN_CLAUSE_PARENTHESES;
    }

    protected void setKeywordIndent(String ketyword, int indent) {
        this.keywordsIndent.put(ketyword, indent);
    }

    protected void addFunctions(Collection<String> allFunctions) {
        for (String function : allFunctions) {
            this.functions.put(function.toUpperCase(DEF_LOCALE), function);
        }
        this.addKeywords(allFunctions, DBPKeywordType.FUNCTION);
    }

    protected void turnFunctionIntoKeyword(String function) {
        this.functions.remove(function);
        this.addKeywords(Collections.singletonList(function), DBPKeywordType.KEYWORD);
    }

    protected void addDataTypes(Collection<String> allTypes) {
        for (String type : allTypes) {
            this.types.put(type.toUpperCase(DEF_LOCALE), type);
        }
        this.addKeywords(allTypes, DBPKeywordType.TYPE);
    }

    protected Collection<String> getTableQueryWords() {
        return this.tableQueryWords.values();
    }

    protected void addTableQueryKeywords(String ... keywords) {
        String[] stringArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            this.tableQueryWords.put(keyword.toUpperCase(DEF_LOCALE), keyword);
            ++n2;
        }
    }

    public Collection<String> getColumnQueryWords() {
        return this.columnQueryWords.values();
    }

    protected void addColumnQueryKeywords(String ... keywords) {
        String[] stringArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            this.columnQueryWords.put(keyword.toUpperCase(DEF_LOCALE), keyword);
            ++n2;
        }
    }

    protected void addKeywords(Collection<String> set, DBPKeywordType type) {
        if (set != null) {
            for (String keyword : set) {
                String ciKeyword = keyword.toUpperCase(DEF_LOCALE);
                this.reservedWords.put(ciKeyword, keyword);
                KeywordHolder oldType = this.allKeywords.get(ciKeyword);
                if (oldType != null && oldType.type == DBPKeywordType.KEYWORD) continue;
                this.allKeywords.put(ciKeyword, new KeywordHolder(type, keyword));
            }
        }
    }

    @Override
    @NotNull
    public Collection<String> getReservedWords() {
        return this.reservedWords.values();
    }

    @Override
    @NotNull
    public Collection<String> getFunctions() {
        return this.functions.values();
    }

    @Override
    @NotNull
    public Collection<String> getDataTypes(@Nullable DBPDataSource dataSource) {
        return this.types.values();
    }

    protected void clearDataTypes() {
        this.types.clear();
    }

    @Override
    public DBPKeywordType getKeywordType(@NotNull String word) {
        KeywordHolder keywordHolder = this.allKeywords.get(word.toUpperCase(DEF_LOCALE));
        return keywordHolder == null ? null : keywordHolder.type;
    }

    @Override
    @NotNull
    public List<String> getMatchedKeywords(@NotNull String word) {
        word = word.toUpperCase(DEF_LOCALE);
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, KeywordHolder> keyword : this.allKeywords.tailMap(word).entrySet()) {
            if (!keyword.getKey().startsWith(word)) break;
            result.add(keyword.getValue().original);
        }
        return result;
    }

    @Override
    public boolean isKeywordStart(@NotNull String word) {
        SortedMap<String, KeywordHolder> map = this.allKeywords.tailMap(word.toUpperCase(DEF_LOCALE));
        return !map.isEmpty() && map.firstKey().startsWith(word);
    }

    @Override
    public boolean isEntityQueryWord(@NotNull String word) {
        return this.tableQueryWords.containsKey(word.toUpperCase(DEF_LOCALE));
    }

    @Override
    public boolean isAttributeQueryWord(@NotNull String word) {
        return this.columnQueryWords.containsKey(word.toUpperCase(DEF_LOCALE));
    }

    @Override
    public int getKeywordNextLineIndent(@NotNull String word) {
        Integer indent = this.keywordsIndent.get(word.toUpperCase(DEF_LOCALE));
        return indent == null ? 0 : indent;
    }

    @Override
    @NotNull
    public String getSearchStringEscape() {
        return "";
    }

    @Override
    public char getStringEscapeCharacter() {
        return '\u0000';
    }

    @Override
    public int getCatalogUsage() {
        return 0;
    }

    @Override
    public int getSchemaUsage() {
        return 0;
    }

    @Override
    @NotNull
    public String getCatalogSeparator() {
        return String.valueOf('.');
    }

    @Override
    public char getStructSeparator() {
        return '.';
    }

    @Override
    @NotNull
    public String[] getParametersPrefixes() {
        return new String[0];
    }

    @Override
    public boolean isCatalogAtStart() {
        return true;
    }

    @Override
    @NotNull
    public SQLStateType getSQLStateType() {
        return SQLStateType.SQL99;
    }

    @Override
    @NotNull
    public String[] getScriptDelimiters() {
        return SQLConstants.DEFAULT_SCRIPT_DELIMITER;
    }

    @Override
    @Nullable
    public String getScriptDelimiterRedefiner() {
        return null;
    }

    @Override
    public String[][] getBlockBoundStrings() {
        return DEFAULT_BEGIN_END_BLOCK;
    }

    @Override
    @Nullable
    public String[] getBlockHeaderStrings() {
        return null;
    }

    @Override
    @Nullable
    public String[] getInnerBlockPrefixes() {
        return null;
    }

    @Override
    public boolean isWordStart(int ch) {
        return Character.isUnicodeIdentifierStart(ch) || ch == 95;
    }

    @Override
    public boolean isWordPart(int ch) {
        return Character.isUnicodeIdentifierPart(ch);
    }

    @Override
    public boolean validIdentifierStart(char c) {
        return Character.isLetter(c);
    }

    @Override
    public boolean validIdentifierPart(char c, boolean quoted) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '_';
    }

    @Override
    public boolean useCaseInsensitiveNameLookup() {
        return false;
    }

    @Override
    public boolean supportsUnquotedMixedCase() {
        return true;
    }

    @Override
    public boolean supportsQuotedMixedCase() {
        return true;
    }

    @Override
    @NotNull
    public DBPIdentifierCase storesUnquotedCase() {
        return DBPIdentifierCase.UPPER;
    }

    @Override
    @NotNull
    public DBPIdentifierCase storesQuotedCase() {
        return DBPIdentifierCase.MIXED;
    }

    @Override
    public String getCastedAttributeName(@NotNull DBSAttributeBase attribute, String attributeName) {
        if (attribute instanceof DBSObject && !DBUtils.isPseudoAttribute(attribute)) {
            attributeName = !CommonUtils.equalObjects((Object)attributeName, (Object)attribute.getName()) ? DBUtils.getQuotedIdentifier(((DBSObject)((Object)attribute)).getDataSource(), attributeName) : DBUtils.getObjectFullName(((DBSObject)((Object)attribute)).getDataSource(), attribute, DBPEvaluationContext.DML);
        }
        return attributeName;
    }

    @Override
    @NotNull
    public String getTypeCastClause(@NotNull DBSTypedObject attribute, String expression, boolean isInCondition) {
        return expression;
    }

    @Override
    public boolean isQuotedIdentifier(String identifier) {
        String[][] quoteStrings = this.getIdentifierQuoteStrings();
        if (ArrayUtils.isEmpty((Object[])quoteStrings)) {
            return false;
        }
        String[][] stringArray = quoteStrings;
        int n = quoteStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String[] quoteString = stringArray[n2];
            if (identifier.startsWith(quoteString[0]) && identifier.endsWith(quoteString[1])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public String getQuotedIdentifier(String str, boolean forceCaseSensitive, boolean forceQuotes) {
        if (this.isQuotedIdentifier(str)) {
            return str;
        }
        String[][] quoteStrings = this.getIdentifierQuoteStrings();
        if (ArrayUtils.isEmpty((Object[])quoteStrings)) {
            return str;
        }
        if (this.mustBeQuoted(str, forceCaseSensitive) || forceQuotes) {
            return this.quoteIdentifier(str, quoteStrings);
        }
        return str;
    }

    @Override
    public boolean mustBeQuoted(@NotNull String str, boolean forceCaseSensitive) {
        boolean hasBadChars;
        DBPKeywordType keywordType = this.getKeywordType(str);
        boolean bl = hasBadChars = (keywordType == DBPKeywordType.KEYWORD || keywordType == DBPKeywordType.TYPE || keywordType == DBPKeywordType.OTHER) && this.isQuoteReservedWords();
        if (!hasBadChars && !str.isEmpty()) {
            boolean bl2 = hasBadChars = !this.validIdentifierStart(str.charAt(0));
        }
        if (!hasBadChars && forceCaseSensitive && !this.useCaseInsensitiveNameLookup()) {
            switch (this.storesUnquotedCase()) {
                case UPPER: {
                    hasBadChars = !str.equals(str.toUpperCase());
                    break;
                }
                case LOWER: {
                    boolean bl3 = hasBadChars = !str.equals(str.toLowerCase());
                }
            }
        }
        if (!hasBadChars && !str.isEmpty()) {
            int i = 0;
            while (i < str.length()) {
                if (!this.validIdentifierPart(str.charAt(i), false)) {
                    hasBadChars = true;
                    break;
                }
                ++i;
            }
        }
        return hasBadChars;
    }

    @NotNull
    protected String quoteIdentifier(@NotNull String str, @NotNull String[][] quoteStrings) {
        String[][] stringArray = quoteStrings;
        int n = quoteStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String[] pair = stringArray[n2];
            String q1 = pair[0];
            String q2 = pair[1];
            if (q1.equals(q2) && (q1.equals("\"") || q1.equals("'")) && str.contains(q1)) {
                str = str.replace(q1, q1 + q1);
            }
            ++n2;
        }
        return quoteStrings[0][0] + str + quoteStrings[0][1];
    }

    @Override
    public String getUnquotedIdentifier(String identifier) {
        return this.getUnquotedIdentifier(identifier, false);
    }

    @Override
    public String getUnquotedIdentifier(String identifier, boolean unescapeQuotesInsideIdentifier) {
        String[][] quoteStrings = this.getIdentifierQuoteStrings();
        if (ArrayUtils.isEmpty((Object[])quoteStrings)) {
            quoteStrings = BasicSQLDialect.DEFAULT_IDENTIFIER_QUOTES;
        }
        int i = 0;
        while (i < quoteStrings.length) {
            identifier = DBUtils.getUnQuotedIdentifier(identifier, quoteStrings[i][0], quoteStrings[i][1]);
            if (unescapeQuotesInsideIdentifier) {
                identifier = identifier.replace(quoteStrings[i][0] + quoteStrings[i][0], quoteStrings[i][0]);
            }
            ++i;
        }
        return identifier;
    }

    @Override
    public boolean isQuotedString(String string) {
        return string.length() >= 2 && string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'';
    }

    @Override
    public String getQuotedString(String string) {
        return "'" + this.escapeString(string) + "'";
    }

    @Override
    public String getUnquotedString(String string) {
        return this.isQuotedString(string) ? this.unEscapeString(string.substring(1, string.length() - 1)) : string;
    }

    @Override
    @NotNull
    public String escapeString(String string) {
        return string.replace("'", "''");
    }

    @Override
    @NotNull
    public String unEscapeString(String string) {
        return CommonUtils.notEmpty((String)string).replace("''", "'");
    }

    @Override
    @NotNull
    public String escapeScriptValue(DBSTypedObject attribute, @NotNull Object value, @NotNull String strValue) {
        if (value instanceof UUID) {
            return "'" + this.escapeString(strValue) + "'";
        }
        return strValue;
    }

    @Override
    @NotNull
    public SQLDialect.MultiValueInsertMode getDefaultMultiValueInsertMode() {
        return SQLDialect.MultiValueInsertMode.NOT_SUPPORTED;
    }

    @Override
    public String addFiltersToQuery(DBRProgressMonitor monitor, DBPDataSource dataSource, String query, DBDDataFilter filter) {
        return this.getQueryGenerator().getQueryWithAppliedFilters(monitor, dataSource, query, filter);
    }

    @Override
    public boolean supportsSubqueries() {
        return true;
    }

    @Override
    public boolean supportsAliasInSelect() {
        return false;
    }

    @Override
    public boolean supportsAliasInUpdate() {
        return false;
    }

    @Override
    @Nullable
    public String getAllAttributesAlias() {
        return "*";
    }

    @Override
    @Nullable
    public String getDefaultGroupAttribute() {
        return this.getAllAttributesAlias();
    }

    @Override
    public boolean supportsAliasInConditions() {
        return true;
    }

    @Override
    public String getOffsetLimitQueryPart(int offset, int limit) {
        return String.format("LIMIT %d OFFSET %d", limit, offset);
    }

    @Override
    public String getClobComparingPart(@NotNull String columnName) {
        return "%s=?".formatted(columnName);
    }

    @Override
    public boolean supportsAliasInHaving() {
        return true;
    }

    @Override
    public boolean supportsTableDropCascade() {
        return false;
    }

    @Override
    public boolean supportsOrderByIndex() {
        return true;
    }

    @Override
    public boolean supportsNestedComments() {
        return false;
    }

    @Override
    public boolean supportsCommentQuery() {
        return false;
    }

    @Override
    public boolean supportsNullability() {
        return true;
    }

    @Override
    public boolean supportsColumnAutoIncrement() {
        return true;
    }

    @Override
    @Nullable
    public SQLExpressionFormatter getCaseInsensitiveExpressionFormatter(@NotNull DBCLogicalOperator operator) {
        return null;
    }

    @Override
    public Pair<String, String> getMultiLineComments() {
        return this.multiLineComments;
    }

    @Override
    public String[] getSingleLineComments() {
        return DEFAULT_LINE_COMMENTS;
    }

    @Override
    public boolean isDelimiterAfterQuery() {
        return false;
    }

    @Override
    public boolean isDelimiterAfterBlock() {
        return false;
    }

    @Override
    public boolean needsDelimiterFor(String firstKeyword, String lastKeyword) {
        return false;
    }

    @Override
    @NotNull
    public DBDBinaryFormatter getNativeBinaryFormatter() {
        return BinaryFormatterHexNative.INSTANCE;
    }

    @Override
    public String getTestSQL() {
        return null;
    }

    @Override
    @Nullable
    public String getDualTableName() {
        return null;
    }

    @Override
    public boolean isTransactionModifyingQuery(String queryString) {
        if ((queryString = SQLUtils.stripComments(this, queryString)).isEmpty()) {
            return false;
        }
        String firstKeyword = SQLUtils.getFirstKeyword(this, queryString);
        if (firstKeyword.isEmpty()) {
            return false;
        }
        firstKeyword = firstKeyword.toUpperCase(DEF_LOCALE);
        return this.isTransactionModifyingKeyword(firstKeyword);
    }

    @Override
    @Nullable
    public String[] getTransactionCommitKeywords() {
        return null;
    }

    @Override
    @Nullable
    public String[] getTransactionRollbackKeywords() {
        return null;
    }

    protected boolean isTransactionModifyingKeyword(String firstKeyword) {
        if (this.getKeywordType(firstKeyword) != DBPKeywordType.KEYWORD) {
            return false;
        }
        return !TRANSACTION_NON_MODIFYING_KEYWORDS.contains(firstKeyword);
    }

    private static boolean containsKeyword(String[] keywords, String keyword) {
        if (keywords == null) {
            return false;
        }
        int i = 0;
        while (i < keywords.length) {
            if (keyword.equals(keywords[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    @NotNull
    public String[] getDMLKeywords() {
        return DML_KEYWORDS;
    }

    @NotNull
    public String[] getNonTransactionKeywords() {
        return CORE_NON_TRANSACTIONAL_KEYWORDS;
    }

    public boolean isQuoteReservedWords() {
        return true;
    }

    @Override
    public boolean isCRLFBroken() {
        return false;
    }

    @Override
    public String getColumnTypeModifiers(@NotNull DBPDataSource dataSource, @NotNull DBSTypedObject column, @NotNull String typeName, @NotNull DBPDataKind dataKind) {
        DBSDataType dataType;
        typeName = CommonUtils.notEmpty((String)typeName).toUpperCase(DEF_LOCALE);
        if (column instanceof DBSObject && (dataType = column instanceof DBSTypedObjectEx ? ((DBSTypedObjectEx)((Object)column)).getDataType() : DBUtils.getLocalDataType(((DBSObject)((Object)column)).getDataSource(), column.getTypeName())) != null && CommonUtils.equalObjects((Object)dataType.getScale(), (Object)column.getScale()) && (CommonUtils.toInt((Object)dataType.getPrecision()) > 0 && CommonUtils.equalObjects((Object)dataType.getPrecision(), (Object)column.getPrecision()) || dataType.getMaxLength() > 0L && dataType.getMaxLength() == column.getMaxLength())) {
            return null;
        }
        if (dataKind == DBPDataKind.STRING) {
            long maxLength;
            if (typeName.indexOf(40) == -1 && (maxLength = column.getMaxLength()) > 0L) {
                boolean badValue = maxLength == Integer.MAX_VALUE || maxLength == Long.MAX_VALUE;
                Object maxStringLength = dataSource.getDataSourceFeature("datasource.max-string-type-length");
                if (maxStringLength instanceof Number) {
                    int lengthLimit = ((Number)maxStringLength).intValue();
                    if (lengthLimit < 0) {
                        return null;
                    }
                    if ((long)lengthLimit < maxLength) {
                        maxLength = lengthLimit;
                    }
                } else if (badValue) {
                    return null;
                }
                return "(" + maxLength + ")";
            }
        } else if (!(dataKind != DBPDataKind.CONTENT && dataKind != DBPDataKind.BINARY || typeName.contains("LOB"))) {
            long maxLength = column.getMaxLength();
            if (maxLength > 0L && maxLength < Integer.MAX_VALUE) {
                return "(" + maxLength + ")";
            }
        } else if (dataKind == DBPDataKind.NUMERIC) {
            int precision;
            if (typeName.equals("DECIMAL") || typeName.equals("NUMERIC") || typeName.equals("NUMBER")) {
                Integer scale = column.getScale();
                int precision2 = CommonUtils.toInt((Object)column.getPrecision());
                if (precision2 == 0) {
                    precision2 = (int)column.getMaxLength();
                }
                if (scale != null && scale >= 0 && precision2 >= 0 && (scale != 0 || precision2 != 0)) {
                    return "(" + precision2 + "," + String.valueOf(scale) + ")";
                }
            } else if (typeName.equals("BIT") && (precision = CommonUtils.toInt((Object)column.getPrecision())) > 1) {
                return "(" + precision + ")";
            }
        }
        return null;
    }

    @Override
    public String formatStoredProcedureCall(DBPDataSource dataSource, String sqlText) {
        return sqlText;
    }

    protected int getMaxParameterLength(Collection<? extends DBSProcedureParameter> parameters, List<DBSProcedureParameter> inParameters) {
        int maxParamLength = 0;
        for (DBSProcedureParameter dBSProcedureParameter : parameters) {
            if (dBSProcedureParameter.getParameterKind() != DBSProcedureParameterKind.IN) continue;
            inParameters.add(dBSProcedureParameter);
            if (dBSProcedureParameter.getName().length() <= maxParamLength) continue;
            maxParamLength = dBSProcedureParameter.getName().length();
        }
        return maxParamLength;
    }

    protected boolean useBracketsForExec(DBSProcedure procedure) {
        return false;
    }

    protected String getStoredProcedureCallInitialClause(DBSProcedure proc) {
        Object[] executeKeywords = this.getExecuteKeywords();
        if (proc.getProcedureType() == DBSProcedureType.FUNCTION || ArrayUtils.isEmpty((Object[])executeKeywords)) {
            return "SELECT " + proc.getFullyQualifiedName(DBPEvaluationContext.DML);
        }
        return (String)executeKeywords[0] + " " + proc.getFullyQualifiedName(DBPEvaluationContext.DML);
    }

    @NotNull
    protected String getProcedureCallEndClause(DBSProcedure procedure) {
        return "";
    }

    @Override
    public void generateStoredProcedureCall(StringBuilder sql, DBSProcedure proc, Collection<? extends DBSProcedureParameter> parameters, boolean castParams) {
        DBPDataSource dataSource;
        ArrayList<? extends DBSProcedureParameter> inParameters = new ArrayList<DBSProcedureParameter>();
        if (parameters != null) {
            inParameters.addAll(parameters);
        }
        DBPPreferenceStore prefStore = (dataSource = proc.getDataSource()) != null ? dataSource.getContainer().getPreferenceStore() : DBWorkbench.getPlatform().getPreferenceStore();
        String namedParameterPrefix = prefStore.getString("sql.parameter.prefix");
        boolean useBrackets = this.useBracketsForExec(proc);
        if (useBrackets) {
            sql.append("{ ");
        }
        sql.append(this.getStoredProcedureCallInitialClause(proc)).append("(");
        if (!inParameters.isEmpty()) {
            boolean first = true;
            block4: for (DBSProcedureParameter dBSProcedureParameter : inParameters) {
                String typeName = dBSProcedureParameter.getParameterType().getFullTypeName();
                switch (dBSProcedureParameter.getParameterKind()) {
                    case IN: {
                        if (!first) {
                            sql.append(", ");
                        }
                        if (castParams) {
                            sql.append("cast(").append(namedParameterPrefix).append(CommonUtils.escapeIdentifier((String)dBSProcedureParameter.getName())).append(" as ").append(typeName).append(")");
                            break;
                        }
                        sql.append(namedParameterPrefix).append(CommonUtils.escapeIdentifier((String)dBSProcedureParameter.getName()));
                        break;
                    }
                    case RETURN: {
                        continue block4;
                    }
                    default: {
                        if (!this.isStoredProcedureCallIncludesOutParameters()) break;
                        if (!first) {
                            sql.append(", ");
                        }
                        if (castParams) {
                            sql.append("cast(?").append(" as ").append(typeName).append(")");
                            break;
                        }
                        sql.append("?");
                    }
                }
                first = false;
            }
        }
        sql.append(")");
        String callEndClause = this.getProcedureCallEndClause(proc);
        if (!CommonUtils.isEmpty((String)callEndClause)) {
            sql.append(" ").append(callEndClause);
        }
        if (!useBrackets) {
            sql.append(";");
        } else {
            sql.append(" }");
        }
        sql.append("\n\n");
    }

    protected boolean isStoredProcedureCallIncludesOutParameters() {
        return true;
    }

    @Override
    public boolean isDisableScriptEscapeProcessing() {
        return false;
    }

    @Override
    public boolean supportsAlterTableStatement() {
        return true;
    }

    @Override
    public boolean supportsIndexCreateAndDrop() {
        return this.supportsAlterTableStatement();
    }

    @Override
    public boolean supportsInsertAllDefaultValuesStatement() {
        return false;
    }

    @Override
    public boolean supportsUuid() {
        return true;
    }

    @Override
    @NotNull
    public SQLTokenPredicateSet getSkipTokenPredicates() {
        return EmptyTokenPredicateSet.INSTANCE;
    }

    @Override
    public boolean isStripCommentsBeforeBlocks() {
        return false;
    }

    @Override
    public boolean hasCaseSensitiveFiltration() {
        return false;
    }

    @Override
    public SQLBlockCompletions getBlockCompletions() {
        return DEFAULT_SQL_BLOCK_COMPLETIONS;
    }

    private static class KeywordHolder {
        DBPKeywordType type;
        String original;

        public KeywordHolder(DBPKeywordType type, String original) {
            this.type = type;
            this.original = original;
        }
    }
}

