/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.jobs;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableParametrized;
import org.jkiss.dbeaver.runtime.jobs.ConnectJob;
import org.jkiss.dbeaver.runtime.jobs.DisconnectJob;
import org.jkiss.utils.CommonUtils;

public class ConnectionTestJob
extends ConnectJob {
    private static final Log log = Log.getLog(ConnectionTestJob.class);
    private DBRRunnableParametrized<DBCSession> onTest;
    private String productName;
    private String productVersion;
    private String driverName;
    private String driverVersion;
    private String serverVersion = "?";
    private String clientVersion = "?";
    private long connectTime = -1L;
    private DBRProgressMonitor ownerMonitor;

    public ConnectionTestJob(DBPDataSourceContainer testDataSource, DBRRunnableParametrized<DBCSession> onTest) {
        super(testDataSource);
        this.setSystem(true);
        this.setUser(false);
        this.initialize = true;
        this.onTest = onTest;
        this.productName = null;
        this.productVersion = null;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public long getConnectTime() {
        return this.connectTime;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public void setOwnerMonitor(DBRProgressMonitor ownerMonitor) {
        this.ownerMonitor = ownerMonitor;
    }

    @Override
    public IStatus run(DBRProgressMonitor monitor) {
        if (this.ownerMonitor != null) {
            monitor = this.ownerMonitor;
        }
        Thread.currentThread().setName(ModelMessages.dialog_connection_wizard_start_connection_monitor_thread);
        try {
            Object session;
            Object var7_12;
            Throwable e2;
            this.container.setName(this.container.getConnectionConfiguration().getUrl());
            long startTime = System.currentTimeMillis();
            super.run(monitor);
            this.connectTime = System.currentTimeMillis() - startTime;
            if (this.connectError != null || monitor.isCanceled()) {
                return Status.OK_STATUS;
            }
            if (this.connectStatus == Status.CANCEL_STATUS) {
                return Status.CANCEL_STATUS;
            }
            monitor.beginTask(ModelMessages.dialog_connection_wizard_start_connection_monitor_start, 3);
            DBPDataSource dataSource = this.container.getDataSource();
            if (dataSource == null) {
                throw new DBException(ModelMessages.error_not_connected_to_database);
            }
            monitor.subTask(ModelMessages.dialog_connection_wizard_start_connection_monitor_subtask_test);
            DBPDataSourceInfo info = dataSource.getInfo();
            if (info != null) {
                try {
                    this.productName = info.getDatabaseProductName();
                    this.productVersion = info.getDatabaseProductVersion();
                    this.driverName = info.getDriverName();
                    this.driverVersion = info.getDriverVersion();
                }
                catch (Exception e2) {
                    log.error("Can't obtain connection metadata", e2);
                }
            } else {
                e2 = null;
                var7_12 = null;
                try {
                    session = DBUtils.openUtilSession(monitor, dataSource, "Test connection");
                    try {
                        if (session instanceof Connection) {
                            try {
                                Connection connection = (Connection)session;
                                DatabaseMetaData metaData = connection.getMetaData();
                                this.productName = metaData.getDatabaseProductName();
                                this.productVersion = metaData.getDatabaseProductVersion();
                                this.driverName = metaData.getDriverName();
                                this.driverVersion = metaData.getDriverVersion();
                            }
                            catch (Exception e3) {
                                log.error("Can't obtain connection metadata", e3);
                            }
                        }
                    }
                    finally {
                        if (session != null) {
                            session.close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (e2 == null) {
                        e2 = throwable;
                    } else if (e2 != throwable) {
                        e2.addSuppressed(throwable);
                    }
                    throw e2;
                }
            }
            if (this.driverName == null || this.driverVersion == null) {
                try {
                    Object driverInstance;
                    if (this.driverName == null) {
                        this.driverName = this.container.getDriver().getDriverClassName();
                    }
                    if (this.driverVersion == null && (driverInstance = this.container.getDriver().getDriverInstance(monitor)) instanceof Driver) {
                        this.driverVersion = ((Driver)driverInstance).getMajorVersion() + "." + ((Driver)driverInstance).getMinorVersion();
                    }
                }
                catch (DBException e4) {
                    log.debug(e4);
                }
            }
            monitor.worked(1);
            monitor.subTask("Load connection info");
            try {
                e2 = null;
                var7_12 = null;
                try {
                    session = DBUtils.openUtilSession(monitor, dataSource, "Call connection testers");
                    try {
                        this.onTest.run((DBCSession)session);
                    }
                    finally {
                        if (session != null) {
                            session.close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (e2 == null) {
                        e2 = throwable;
                    } else if (e2 != throwable) {
                        e2.addSuppressed(throwable);
                    }
                    throw e2;
                }
            }
            catch (InvocationTargetException e5) {
                log.error(e5.getTargetException());
            }
            catch (InterruptedException interruptedException) {}
            monitor.worked(1);
            new DisconnectJob(this.container).schedule();
            monitor.worked(1);
            monitor.subTask(ModelMessages.dialog_connection_wizard_start_connection_monitor_success);
            if (!CommonUtils.isEmpty((String)this.productName)) {
                this.serverVersion = this.productName + " " + this.productVersion;
            }
            if (!CommonUtils.isEmpty((String)this.driverName)) {
                this.clientVersion = this.driverName + " " + this.driverVersion;
            }
        }
        catch (DBException ex) {
            this.connectError = ex;
        }
        monitor.done();
        return Status.OK_STATUS;
    }
}

