/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.cache;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.AbstractObjectCache;
import org.jkiss.utils.CommonUtils;

public abstract class JDBCObjectCache<OWNER extends DBSObject, OBJECT extends DBSObject>
extends AbstractObjectCache<OWNER, OBJECT> {
    private static final int DEFAULT_MAX_CACHE_SIZE = 1000000;
    private static final Log log = Log.getLog(JDBCObjectCache.class);
    private int maximumCacheSize = 1000000;

    protected JDBCObjectCache() {
    }

    public void setMaximumCacheSize(int maximumCacheSize) {
        this.maximumCacheSize = maximumCacheSize;
    }

    @NotNull
    protected abstract JDBCStatement prepareObjectsStatement(@NotNull JDBCSession var1, @NotNull OWNER var2) throws SQLException;

    @Nullable
    protected abstract OBJECT fetchObject(@NotNull JDBCSession var1, @NotNull OWNER var2, @NotNull JDBCResultSet var3) throws SQLException, DBException;

    @NotNull
    public List<OBJECT> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable OWNER owner) throws DBException {
        if (!this.isFullyCached() && !monitor.isForceCacheUsage()) {
            this.loadObjects(monitor, owner);
        }
        return this.getCachedObjects();
    }

    public OBJECT getObject(@NotNull DBRProgressMonitor monitor, @NotNull OWNER owner, @NotNull String name) throws DBException {
        if (!this.isFullyCached() && !monitor.isForceCacheUsage()) {
            this.loadObjects(monitor, owner);
        }
        return (OBJECT)this.getCachedObject(name);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void loadObjects(DBRProgressMonitor monitor, OWNER owner) throws DBException {
        block36: {
            if (this.isFullyCached() != false) return;
            if (monitor.isForceCacheUsage() != false) return;
            if (monitor.isCanceled()) {
                return;
            }
            tmpObjectList = new ArrayList<OBJECT>();
            dataSource = owner.getDataSource();
            if (dataSource == null) {
                throw new DBException(ModelMessages.error_not_connected_to_database);
            }
            if (owner.isPersisted()) {
                try {
                    try {
                        var5_5 = null;
                        var6_11 = null;
                        try {
                            session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, owner, (String)("Load objects from " + owner.getName()));
                            try {
                                this.beforeCacheLoading(session, owner);
                                try {
                                    var8_14 = null;
                                    var9_16 = null;
                                    try {
                                        dbStat = this.prepareObjectsStatement(session, owner);
                                        try {
                                            monitor.subTask("Load " + this.getCacheName());
                                            dbStat.setFetchSize(1000);
                                            dbStat.executeStatement();
                                            dbResult = dbStat.getResultSet();
                                            if (dbResult == null) break block36;
                                            ** try [egrp 7[TRYBLOCK] [0 : 163->175)] { 
lbl-1000:
                                            // 1 sources

                                            {
                                                if (dbResult.next()) {
                                                }
                                                break block36;
                                            }
lbl34:
                                            // 1 sources

                                            finally {
                                                dbResult.close();
                                            }
                                        }
                                        finally {
                                            if (dbStat != null) {
                                                dbStat.close();
                                            }
                                        }
                                    }
                                    catch (Throwable var9_17) {
                                        if (var8_14 == null) {
                                            var8_14 = var9_17;
                                            throw var8_14;
                                        }
                                        if (var8_14 == var9_17) throw var8_14;
                                        var8_14.addSuppressed(var9_17);
                                        throw var8_14;
                                    }
                                }
                                finally {
                                    this.afterCacheLoading(session, owner);
                                }
                            }
                            finally {
                                if (session != null) {
                                    session.close();
                                }
                            }
                        }
                        catch (Throwable var6_12) {
                            if (var5_5 == null) {
                                var5_5 = var6_12;
                                throw var5_5;
                            }
                            if (var5_5 == var6_12) throw var5_5;
                            var5_5.addSuppressed(var6_12);
                            throw var5_5;
                        }
                    }
                    catch (SQLException ex) {
                        throw new DBDatabaseException((Throwable)ex, dataSource);
                    }
                    catch (DBException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        throw new DBException("Internal driver error", (Throwable)ex);
                    }
                }
                catch (Exception e) {
                    if (this.handleCacheReadError(e)) break block36;
                    throw e;
                }
            }
        }
        this.addCustomObjects(monitor, (DBSObject)owner, tmpObjectList);
        comparator = this.getListOrderComparator();
        if (comparator != null && !CommonUtils.isEmpty(tmpObjectList)) {
            tmpObjectList.sort(comparator);
        }
        this.detectCaseSensitivity((DBSObject)owner);
        this.mergeCache(tmpObjectList);
        this.invalidateObjects(monitor, (DBSObject)owner, (Iterator)new AbstractObjectCache.CacheIterator((AbstractObjectCache)this));
    }

    public void beforeCacheLoading(JDBCSession session, OWNER owner) throws DBException {
    }

    public void afterCacheLoading(JDBCSession session, OWNER owner) throws DBException {
    }

    protected String getCacheName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected boolean handleCacheReadError(Exception error) {
        return false;
    }
}

