/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.application.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.jface.widgets.LabelFactory;
import org.eclipse.jface.widgets.TableColumnFactory;
import org.eclipse.jface.widgets.TableFactory;
import org.eclipse.jface.widgets.TextFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.urischeme.IOperatingSystemRegistration;
import org.eclipse.urischeme.IScheme;
import org.eclipse.urischeme.ISchemeInformation;
import org.eclipse.urischeme.IUriSchemeExtensionReader;

public class UriSchemeHandlerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    Text handlerLocation;
    CheckboxTableViewer tableViewer;
    private String currentLocation = null;
    IStatusManagerWrapper statusManagerWrapper = new IStatusManagerWrapper(){};
    IMessageDialogWrapper messageDialogWrapper = new IMessageDialogWrapper(){};
    OsRegistrationReadingJob osRegistrationReadingJob = new OsRegistrationReadingJob();
    IOperatingSystemRegistration operatingSystemRegistration = null;
    IUriSchemeExtensionReader extensionReader = null;
    private Composite handlerComposite;
    private volatile boolean isLoading = false;

    public UriSchemeHandlerPreferencePage() {
        super.setDescription(IDEWorkbenchMessages.UrlHandlerPreferencePage_Page_Description);
    }

    public void init(IWorkbench workbench) {
        if (this.operatingSystemRegistration == null) {
            this.operatingSystemRegistration = IOperatingSystemRegistration.getInstance();
        }
        if (this.extensionReader == null) {
            this.extensionReader = IUriSchemeExtensionReader.newInstance();
        }
        if (this.operatingSystemRegistration != null) {
            this.currentLocation = this.operatingSystemRegistration.getEclipseLauncher();
        }
    }

    protected Control createContents(Composite parent) {
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.link_handlers_page_context");
        }
        this.noDefaultAndApplyButton();
        this.addFiller(parent);
        this.createTableViewerForSchemes(parent);
        this.createHandlerLocationControls(parent);
        if (this.operatingSystemRegistration == null) {
            this.setErrorMessage(NLS.bind((String)IDEWorkbenchMessages.UrlHandlerPreferencePage_UnsupportedOperatingSystem, (Object)(Platform.isRunning() ? Platform.getOS() : null)));
            this.setDataOnTableViewer(Collections.emptyList());
        } else if (this.currentLocation == null) {
            this.setErrorMessage(IDEWorkbenchMessages.UrlHandlerPreferencePage_LauncherCannotBeDetermined);
            this.setDataOnTableViewer(Collections.emptyList());
        } else {
            this.setDataOnTableViewer(this.getLoadingSchemeInformationList());
            this.startRegistrationReadingJob();
        }
        this.tableViewer.getControl().setEnabled(false);
        return parent;
    }

    private void startRegistrationReadingJob() {
        this.isLoading = true;
        this.osRegistrationReadingJob.setSystem(true);
        this.osRegistrationReadingJob.schedule();
    }

    private void addFiller(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        ((LabelFactory)WidgetFactory.label((int)16384).layoutData((Object)gd)).create((Widget)composite);
    }

    private void createTableViewerForSchemes(Composite parent) {
        GridDataFactory gridDataFactory = GridDataFactory.fillDefaults().grab(true, true);
        gridDataFactory.span(2, 1).indent(0, -1);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        Composite tableComposite = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layoutData((Object)gridDataFactory.create())).layout((Layout)tableColumnLayout)).create((Widget)parent);
        Table schemeTable = (Table)((TableFactory)WidgetFactory.table((int)68388).headerVisible(true).linesVisible(true).font(parent.getFont())).create((Widget)tableComposite);
        TableColumnFactory columnFactory = WidgetFactory.tableColumn((int)0);
        TableColumn nameColumn = (TableColumn)((TableColumnFactory)columnFactory.text(IDEWorkbenchMessages.UrlHandlerPreferencePage_ColumnName_SchemeName)).create((Widget)schemeTable);
        TableColumn descriptionColumn = (TableColumn)((TableColumnFactory)columnFactory.text(IDEWorkbenchMessages.UrlHandlerPreferencePage_ColumnName_SchemeDescription)).create((Widget)schemeTable);
        TableColumn appColumn = (TableColumn)((TableColumnFactory)columnFactory.text(IDEWorkbenchMessages.UrlHandlerPreferencePage_ColumnName_Handler)).create((Widget)schemeTable);
        tableColumnLayout.setColumnData((Widget)nameColumn, (ColumnLayoutData)new ColumnWeightData(20));
        tableColumnLayout.setColumnData((Widget)descriptionColumn, (ColumnLayoutData)new ColumnWeightData(60));
        tableColumnLayout.setColumnData((Widget)appColumn, (ColumnLayoutData)new ColumnWeightData(20));
        this.tableViewer = new CheckboxTableViewer(schemeTable);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ItemLabelProvider());
        TableSchemeSelectionListener listener = new TableSchemeSelectionListener();
        this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)listener);
        this.tableViewer.addCheckStateListener((ICheckStateListener)listener);
    }

    private void setDataOnTableViewer(Collection<UiSchemeInformation> schemeInformationList) {
        this.tableViewer.setInput(schemeInformationList);
        for (UiSchemeInformation schemeInformation : schemeInformationList) {
            this.tableViewer.setChecked((Object)schemeInformation, schemeInformation.checked);
        }
    }

    private void createHandlerLocationControls(Composite parent) {
        this.handlerComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.handlerComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.handlerComposite);
        WidgetFactory.label((int)0).text(IDEWorkbenchMessages.UrlHandlerPreferencePage_Handler_Label).create((Widget)this.handlerComposite);
        this.handlerLocation = (Text)((TextFactory)WidgetFactory.text((int)2056).layoutData((Object)new GridData(4, 0x1000000, true, false))).create((Widget)this.handlerComposite);
        this.handlerComposite.setVisible(false);
    }

    private Collection<UiSchemeInformation> getLoadingSchemeInformationList() {
        ArrayList<UiSchemeInformation> returnList = new ArrayList<UiSchemeInformation>();
        Collection schemes = this.extensionReader.getSchemes();
        for (IScheme scheme : schemes) {
            returnList.add(new LoadingSchemeInformation(scheme));
        }
        return returnList;
    }

    public boolean performOk() {
        if (this.operatingSystemRegistration == null || this.currentLocation == null || this.isLoading) {
            return true;
        }
        ArrayList<ISchemeInformation> toAdd = new ArrayList<ISchemeInformation>();
        ArrayList<ISchemeInformation> toRemove = new ArrayList<ISchemeInformation>();
        for (UiSchemeInformation info : (Collection)this.tableViewer.getInput()) {
            if (info.checked && !info.information.isHandled()) {
                toAdd.add(info.information);
            }
            if (info.checked || !info.information.isHandled()) continue;
            toRemove.add(info.information);
        }
        try {
            this.operatingSystemRegistration.handleSchemes(toAdd, toRemove);
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.UrlHandlerPreferencePage_Error_Writing_Scheme, (Throwable)e);
            this.statusManagerWrapper.handle((IStatus)status, 5);
        }
        return true;
    }

    static interface IMessageDialogWrapper {
        default public void openWarning(Shell shell, String title, String message) {
            MessageDialog.openWarning((Shell)shell, (String)title, (String)message);
        }

        default public boolean openQuestion(Shell parent, String title, String message) {
            MessageDialog dlg = new MessageDialog(parent, title, null, message, 5, 0, new String[]{IDEWorkbenchMessages.UriHandlerPreferencePage_Confirm_Handle, IDialogConstants.CANCEL_LABEL});
            dlg.open();
            return dlg.getReturnCode() == 0;
        }
    }

    static interface IStatusManagerWrapper {
        default public void handle(IStatus status, int style) {
            StatusManager.getManager().handle(status, style);
        }
    }

    private static final class ItemLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ItemLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof UiSchemeInformation) {
                UiSchemeInformation schemeInfo = (UiSchemeInformation)element;
                switch (columnIndex) {
                    case 0: {
                        return schemeInfo.getName();
                    }
                    case 1: {
                        return schemeInfo.getDescription();
                    }
                    case 2: {
                        String text = "";
                        if (IDEWorkbenchMessages.UrlHandlerPreferencePage_LoadingText.equals(schemeInfo.getHandlerInstanceLocation())) {
                            text = schemeInfo.getHandlerInstanceLocation();
                        } else if (schemeInfo.isChecked()) {
                            text = IDEWorkbenchMessages.UrlHandlerPreferencePage_Column_Handler_Text_Current_Application;
                        } else if (schemeInfo.information.schemeIsHandledByOther()) {
                            text = IDEWorkbenchMessages.UrlHandlerPreferencePage_Column_Handler_Text_Other_Application;
                        }
                        return text;
                    }
                }
                throw new IllegalArgumentException("Unknown column");
            }
            return null;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }
    }

    static final class LoadingSchemeInformation
    extends UiSchemeInformation {
        private IScheme scheme;

        public LoadingSchemeInformation(IScheme scheme) {
            super(false, null);
            this.scheme = scheme;
        }

        @Override
        public String getName() {
            return this.scheme.getName();
        }

        @Override
        public String getDescription() {
            return this.scheme.getDescription();
        }

        @Override
        public String getHandlerInstanceLocation() {
            return IDEWorkbenchMessages.UrlHandlerPreferencePage_LoadingText;
        }

        @Override
        public boolean isChecked() {
            return false;
        }
    }

    class OsRegistrationReadingJob
    extends Job {
        private OsRegistrationReadingJob() {
            super("Retrieving Link Handlers registration status from Operating System");
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                Collection<UiSchemeInformation> schemeInformationList = this.retrieveSchemeInformationList();
                if (!schemeInformationList.isEmpty()) {
                    Display.getDefault().asyncExec(() -> {
                        if (!UriSchemeHandlerPreferencePage.this.tableViewer.getControl().isDisposed()) {
                            UriSchemeHandlerPreferencePage.this.setDataOnTableViewer(schemeInformationList);
                            UriSchemeHandlerPreferencePage.this.tableViewer.getControl().setEnabled(true);
                        }
                    });
                }
            }
            finally {
                UriSchemeHandlerPreferencePage.this.isLoading = false;
            }
            return Status.OK_STATUS;
        }

        private Collection<UiSchemeInformation> retrieveSchemeInformationList() {
            ArrayList<UiSchemeInformation> returnList = new ArrayList<UiSchemeInformation>();
            Collection schemes = UriSchemeHandlerPreferencePage.this.extensionReader.getSchemes();
            try {
                for (ISchemeInformation info : UriSchemeHandlerPreferencePage.this.operatingSystemRegistration.getSchemesInformation(schemes)) {
                    returnList.add(new UiSchemeInformation(info.isHandled(), info));
                }
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.UrlHandlerPreferencePage_Error_Reading_Scheme, (Throwable)e);
                UriSchemeHandlerPreferencePage.this.statusManagerWrapper.handle((IStatus)status, 5);
            }
            return returnList;
        }
    }

    private class TableSchemeSelectionListener
    implements ICheckStateListener,
    ISelectionChangedListener {
        private TableSchemeSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.handleSelection();
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            this.handleCheckbox(event);
        }

        private void handleSelection() {
            Object firstElement;
            IStructuredSelection selection = UriSchemeHandlerPreferencePage.this.tableViewer.getStructuredSelection();
            Object object = firstElement = selection != null ? selection.getFirstElement() : null;
            if (firstElement instanceof UiSchemeInformation) {
                this.setSchemeDetails((UiSchemeInformation)firstElement);
                UriSchemeHandlerPreferencePage.this.handlerComposite.setVisible(true);
            }
        }

        private void setSchemeDetails(UiSchemeInformation schemeInfo) {
            if (schemeInfo.checked) {
                UriSchemeHandlerPreferencePage.this.handlerLocation.setText(UriSchemeHandlerPreferencePage.this.currentLocation);
            } else if (schemeInfo.information.schemeIsHandledByOther()) {
                UriSchemeHandlerPreferencePage.this.handlerLocation.setText(schemeInfo.information.getHandlerInstanceLocation());
            } else {
                UriSchemeHandlerPreferencePage.this.handlerLocation.setText(IDEWorkbenchMessages.UrlHandlerPreferencePage_Handler_Text_No_Application);
            }
        }

        private void handleCheckbox(CheckStateChangedEvent event) {
            UiSchemeInformation schemeInformation = (UiSchemeInformation)event.getElement();
            if (event.getChecked() && schemeInformation.information.schemeIsHandledByOther()) {
                if (UriSchemeHandlerPreferencePage.this.operatingSystemRegistration.canOverwriteOtherApplicationsRegistration()) {
                    boolean answer = UriSchemeHandlerPreferencePage.this.messageDialogWrapper.openQuestion(UriSchemeHandlerPreferencePage.this.getShell(), IDEWorkbenchMessages.UriHandlerPreferencePage_Warning_OtherApp_Confirmation, NLS.bind((String)IDEWorkbenchMessages.UriHandlerPreferencePage_Warning_OtherApp_Confirmation_Description, (Object)schemeInformation.information.getHandlerInstanceLocation(), (Object)schemeInformation.information.getName()));
                    if (!answer) {
                        schemeInformation.checked = false;
                        UriSchemeHandlerPreferencePage.this.tableViewer.setChecked((Object)schemeInformation, schemeInformation.checked);
                        return;
                    }
                } else {
                    schemeInformation.checked = false;
                    UriSchemeHandlerPreferencePage.this.tableViewer.setChecked((Object)schemeInformation, schemeInformation.checked);
                    UriSchemeHandlerPreferencePage.this.messageDialogWrapper.openWarning(UriSchemeHandlerPreferencePage.this.getShell(), IDEWorkbenchMessages.UriHandlerPreferencePage_Warning_OtherApp, NLS.bind((String)IDEWorkbenchMessages.UriHandlerPreferencePage_Warning_OtherApp_Description, (Object)schemeInformation.information.getHandlerInstanceLocation(), (Object)schemeInformation.information.getName()));
                    return;
                }
            }
            schemeInformation.checked = event.getChecked();
            this.setSchemeDetails(schemeInformation);
            UriSchemeHandlerPreferencePage.this.tableViewer.update((Object)schemeInformation, null);
        }
    }

    static class UiSchemeInformation {
        private boolean checked;
        private ISchemeInformation information;

        public UiSchemeInformation(boolean checked, ISchemeInformation information) {
            this.checked = checked;
            this.information = information;
        }

        public String getHandlerInstanceLocation() {
            return this.information.getHandlerInstanceLocation();
        }

        public String getName() {
            return this.information.getName();
        }

        public String getDescription() {
            return this.information.getDescription();
        }

        public boolean isChecked() {
            return this.checked;
        }
    }
}

