/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.internal.localstore.Bucket;
import org.eclipse.core.internal.localstore.BucketTree;
import org.eclipse.core.internal.properties.PropertyBucket;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.app.DBPWorkspaceEclipse;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.registry.BaseProjectImpl;
import org.jkiss.dbeaver.registry.BaseWorkspaceImpl;
import org.jkiss.dbeaver.registry.DesktopApplicationImpl;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.IOUtils;

public class LocalProjectImpl
extends BaseProjectImpl {
    private static final Log log = Log.getLog(LocalProjectImpl.class);
    private static final String SETTINGS_FOLDER = ".settings";
    private static final String PROJECT_FILE = ".project";
    private static final String EMPTY_PROJECT_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n<name>${project-name}</name>\n<comment></comment>\n<projects>\n</projects>\n<buildSpec>\n</buildSpec>\n<natures>\n</natures>\n</projectDescription>";
    @NotNull
    private final IProject project;
    private volatile boolean projectInvalidated;

    public LocalProjectImpl(@NotNull BaseWorkspaceImpl workspace, @NotNull IProject project, @Nullable SMSessionContext sessionContext) {
        super((DBPWorkspace)workspace, sessionContext);
        this.project = project;
    }

    public boolean isVirtual() {
        return false;
    }

    @NotNull
    public String getName() {
        return this.project.getName();
    }

    @NotNull
    public Path getAbsolutePath() {
        if (this.project.getLocation() == null) {
            throw new IllegalStateException("Can't determine the workspace path for project " + this.project.getName());
        }
        return this.project.getLocation().toFile().toPath();
    }

    @Nullable
    public IProject getEclipseProject() {
        return this.project;
    }

    public boolean isOpen() {
        return this.project.isOpen();
    }

    public void ensureOpen() throws IllegalStateException {
        block15: {
            if (!this.project.isOpen()) {
                NullProgressMonitor monitor = new NullProgressMonitor();
                try {
                    this.project.open((IProgressMonitor)monitor);
                    if (!DBWorkbench.isDistributed()) {
                        this.project.refreshLocal(1, (IProgressMonitor)monitor);
                    }
                }
                catch (CoreException e) {
                    if (!this.getWorkspace().getPlatform().getApplication().isStandalone() || !e.getMessage().contains(PROJECT_FILE)) break block15;
                    try {
                        this.recoverProjectDescription();
                        this.project.open((IProgressMonitor)monitor);
                        this.hideConfigurationFiles();
                        this.project.refreshLocal(1, (IProgressMonitor)monitor);
                    }
                    catch (Exception e2) {
                        log.error((Object)"Error opening project", (Throwable)e2);
                        return;
                    }
                }
            }
        }
        if (!this.projectInvalidated) {
            try {
                if (this.isInMemory()) {
                    this.setFormat(BaseProjectImpl.ProjectFormat.MODERN);
                    return;
                }
                if (DBWorkbench.getPlatform().getApplication() instanceof DesktopApplicationImpl && !DBWorkbench.isDistributed()) {
                    Path mdFolder = this.getMetadataFolder(false);
                    Path dsConfig = this.getAbsolutePath().resolve(".dbeaver-data-sources.xml");
                    if (!Files.exists(mdFolder, new LinkOption[0]) && Files.exists(dsConfig, new LinkOption[0])) {
                        this.setFormat(BaseProjectImpl.ProjectFormat.LEGACY);
                    } else {
                        this.setFormat(BaseProjectImpl.ProjectFormat.MODERN);
                    }
                    this.checkAndUpdateProjectStructure();
                }
                this.setFormat(BaseProjectImpl.ProjectFormat.MODERN);
            }
            finally {
                this.projectInvalidated = true;
            }
        }
    }

    public boolean isUseSecretStorage() {
        return false;
    }

    @Override
    @Nullable
    public DBNModel getNavigatorModel() {
        return this.getWorkspace().getPlatform().getNavigatorModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndUpdateProjectStructure() {
        if (this.getFormat() == BaseProjectImpl.ProjectFormat.UNKNOWN || this.getFormat() == BaseProjectImpl.ProjectFormat.MODERN) {
            return;
        }
        Path mdConfig = this.getMetadataPath().resolve("project-metadata.json");
        if (!Files.exists(mdConfig, new LinkOption[0])) {
            Map<String, Map<String, Object>> projectResourceProperties = this.extractProjectResourceProperties();
            Object object = this.metadataSync;
            synchronized (object) {
                this.setResourceProperties(projectResourceProperties);
            }
            this.flushMetadata();
        }
    }

    private Map<String, Map<String, Object>> extractProjectResourceProperties() {
        final LinkedHashMap<String, Map<String, Object>> result = new LinkedHashMap<String, Map<String, Object>>();
        if (!(this.getWorkspace() instanceof DBPWorkspaceEclipse)) {
            return result;
        }
        DBPWorkspaceEclipse workspaceEclipse = (DBPWorkspaceEclipse)this.getWorkspace();
        try {
            BucketTree bucketTree = new BucketTree((Workspace)workspaceEclipse.getEclipseWorkspace(), (Bucket)new PropertyBucket());
            try {
                final IPath projectPath = this.project.getFullPath();
                bucketTree.accept(new Bucket.Visitor(){

                    public int visit(Bucket.Entry entry) {
                        Object value = entry.getValue();
                        if (value instanceof String[][]) {
                            String[][] bucketProps;
                            String[][] stringArray = bucketProps = (String[][])value;
                            int n = bucketProps.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String[] resProps = stringArray[n2];
                                if (resProps.length == 3 && "org.jkiss.dbeaver".equals(resProps[0]) && !"sql-editor-project-id".equals(resProps[1])) {
                                    Map propsMap = result.computeIfAbsent(entry.getPath().makeRelativeTo(projectPath).toString(), s -> new LinkedHashMap());
                                    propsMap.put(resProps[1], resProps[2]);
                                }
                                ++n2;
                            }
                        }
                        return 0;
                    }
                }, projectPath, Integer.MAX_VALUE);
            }
            catch (CoreException e) {
                log.error((Object)e);
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error extracting project metadata", e);
        }
        return result;
    }

    public void hideConfigurationFiles() {
        if (this.project.isOpen() && DBWorkbench.getPlatform().getApplication().isStandalone()) {
            IFolder metadataFolder = this.project.getFolder(".dbeaver");
            this.hideResource((IResource)metadataFolder);
            IFolder settingsFolder = this.project.getFolder(SETTINGS_FOLDER);
            this.hideResource((IResource)settingsFolder);
            IFile file = this.project.getFile(PROJECT_FILE);
            this.hideResource((IResource)file);
        }
    }

    private void hideResource(IResource file) {
        if (file.exists() && !file.isHidden()) {
            try {
                file.setHidden(true);
            }
            catch (CoreException e) {
                log.error((Object)"Error hiding metadata folder", (Throwable)e);
            }
        }
    }

    public void recoverProjectDescription() throws IOException {
        Path mdFile = this.getAbsolutePath().resolve(PROJECT_FILE);
        log.debug((Object)("Recovering project '" + this.project.getName() + "' metadata " + String.valueOf(mdFile.toAbsolutePath())));
        IOUtils.writeFileFromString((File)mdFile.toFile(), (String)EMPTY_PROJECT_TEMPLATE.replace("${project-name}", this.project.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Map<String, Map<String, Object>> getAllResourceProperties() {
        this.loadMetadata();
        Object object = this.resourcesSync;
        synchronized (object) {
            return new TreeMap<String, Map<String, Object>>(this.resourceProperties);
        }
    }
}

