/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.app.DBPResourceHandlerDescriptor;
import org.jkiss.dbeaver.model.app.DBPResourceTypeDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.registry.ResourceTypeRegistry;

public class ResourceHandlerDescriptor
extends AbstractDescriptor
implements DBPResourceHandlerDescriptor {
    private static final Log log = Log.getLog(ResourceHandlerDescriptor.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.resourceHandler";
    private final String typeId;
    private AbstractDescriptor.ObjectType handlerType;
    private DBPResourceHandler handler;

    public ResourceHandlerDescriptor(IConfigurationElement config) {
        super(config);
        this.typeId = config.getAttribute("type");
        this.handlerType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
    }

    void dispose() {
        this.handler = null;
        this.handlerType = null;
    }

    public String getTypeId() {
        return this.typeId;
    }

    @NotNull
    public DBPResourceTypeDescriptor getResourceType() {
        return ResourceTypeRegistry.getInstance().getResourceType(this.typeId);
    }

    @Nullable
    public synchronized DBPResourceHandler getHandler() {
        if (this.handler == null) {
            Class clazz = this.handlerType.getObjectClass(DBPResourceHandler.class);
            if (clazz == null) {
                return null;
            }
            try {
                this.handler = (DBPResourceHandler)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                log.error((Object)"Can't instantiate resource handler", (Throwable)e);
            }
        }
        return this.handler;
    }

    public boolean isDefault() {
        return "default".equals(this.typeId);
    }

    public boolean canHandle(IResource resource) {
        return this.canHandle(resource, false);
    }

    public boolean canHandle(IResource resource, boolean testContent) {
        if (this.isDefault()) {
            return false;
        }
        DBPResourceTypeDescriptor resourceType = this.getResourceType();
        return resourceType != null && resourceType.isApplicableTo(resource, testContent);
    }

    public String toString() {
        return this.typeId;
    }
}

