/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.views.properties.IPropertySource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNNodeWithResource;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSStructContainer;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.runtime.properties.PropertyCollector;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.properties.PropertySourceDelegate;

public class NavigatorAdapterFactory
implements IAdapterFactory {
    private static final Class<?>[] ADAPTER_LIST = new Class[]{DBPNamedObject.class, DBPQualifiedObject.class, DBPObject.class, DBSObject.class, DBSEntity.class, DBSDataContainer.class, DBSDataManipulator.class, DBSObjectContainer.class, DBSStructContainer.class, DBPDataSourceContainer.class, IPropertySource.class, IProject.class, IFolder.class, IFile.class, IResource.class, IWorkbenchAdapter.class};

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adapterType == DBPDataSourceContainer.class) {
            if (adaptableObject instanceof DBNDataSource) {
                return adapterType.cast(((DBNDataSource)adaptableObject).getDataSourceContainer());
            }
            DBSObject object = DBUtils.getFromObject((Object)adaptableObject);
            if (object == null) {
                return null;
            }
            if (object instanceof DBPDataSourceContainer) {
                return adapterType.cast(object);
            }
            DBPDataSource dataSource = object.getDataSource();
            return dataSource == null ? null : (T)adapterType.cast(dataSource.getContainer());
        }
        if (DBPObject.class.isAssignableFrom(adapterType)) {
            if (adaptableObject instanceof DBNDatabaseFolder) {
                adaptableObject = ((DBNDatabaseFolder)adaptableObject).getParentObject();
            }
            DBSObject object = null;
            if (adaptableObject instanceof DBSWrapper) {
                object = ((DBSWrapper)adaptableObject).getObject();
            } else if (adaptableObject instanceof DBPObject) {
                object = (DBPObject)adaptableObject;
            }
            if (object instanceof DBSObject) {
                object = DBUtils.getPublicObject((DBSObject)object);
            }
            if (object != null && adapterType.isAssignableFrom(object.getClass())) {
                return adapterType.cast(object);
            }
        } else if (IResource.class.isAssignableFrom(adapterType)) {
            IResource resource;
            if (adaptableObject instanceof DBNResource) {
                return (T)((DBNResource)adaptableObject).getAdapter(adapterType);
            }
            if (adaptableObject instanceof DBNNodeWithResource && adapterType.isInstance(resource = ((DBNNodeWithResource)adaptableObject).getResource())) {
                return adapterType.cast(resource);
            }
        } else if (adapterType == IPropertySource.class) {
            DBSObject dbObject = null;
            if (adaptableObject instanceof DBSWrapper) {
                dbObject = ((DBSWrapper)adaptableObject).getObject();
            } else if (adaptableObject instanceof DBPObject) {
                dbObject = (DBPObject)adaptableObject;
            }
            if (dbObject instanceof IPropertySource) {
                return adapterType.cast(dbObject);
            }
            if (dbObject instanceof DBPPropertySource) {
                return adapterType.cast(new PropertySourceDelegate((DBPPropertySource)dbObject));
            }
            if (dbObject instanceof IAdaptable) {
                Object adapter = ((IAdaptable)dbObject).getAdapter(IPropertySource.class);
                if (adapter != null) {
                    return adapterType.cast(adapter);
                }
                adapter = ((IAdaptable)dbObject).getAdapter(DBPPropertySource.class);
                if (adapter != null) {
                    return adapterType.cast(new PropertySourceDelegate((DBPPropertySource)adapter));
                }
            }
            if (dbObject != null) {
                PropertyCollector props = new PropertyCollector(adaptableObject, (Object)dbObject, true);
                props.collectProperties();
                if (props.isEmpty() && adaptableObject instanceof DBSObject) {
                    DBSObject meta = (DBSObject)adaptableObject;
                    props.addProperty(null, "name", ModelMessages.model_navigator_Name, (Object)meta.getName());
                    props.addProperty(null, "desc", ModelMessages.model_navigator_Description, (Object)meta.getDescription());
                }
                return adapterType.cast(new PropertySourceDelegate((DBPPropertySource)props));
            }
        } else if (adapterType == IWorkbenchAdapter.class) {
            if (adaptableObject instanceof DBNNode) {
                final DBNNode node = (DBNNode)adaptableObject;
                WorkbenchAdapter workbenchAdapter = new WorkbenchAdapter(){

                    public ImageDescriptor getImageDescriptor(Object object) {
                        return DBeaverIcons.getImageDescriptor((DBPImage)node.getNodeIconDefault());
                    }

                    public String getLabel(Object o) {
                        return node.getNodeDisplayName();
                    }

                    public Object getParent(Object o) {
                        return node.getParentNode();
                    }
                };
                return adapterType.cast(workbenchAdapter);
            }
            return null;
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return ADAPTER_LIST;
    }
}

