/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericSynonym;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class CubridSynonym
extends GenericSynonym {
    private String owner;
    private String targetName;
    private String targetOwner;

    public CubridSynonym(@NotNull GenericStructContainer container, @NotNull String name, @Nullable String description, @NotNull JDBCResultSet dbResult) {
        super(container, name, description);
        this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"synonym_owner_name");
        this.targetName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"target_name");
        this.targetOwner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"target_owner_name");
    }

    @Property(viewable=true, order=2)
    @NotNull
    public String getOwner() {
        return this.owner;
    }

    @Property(viewable=true, editable=false, order=3)
    @Nullable
    public DBSObject getTargetObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getDataSource().findTable(monitor, null, this.targetOwner, this.targetName);
    }
}

