/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.model.plan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNodeKind;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlanNode;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.utils.CommonUtils;

public class CubridPlanNode
extends AbstractExecutionPlanNode {
    private static final String OPTIONS_SEPARATOR = ":";
    private static final String COST = "cost";
    private static final String CLASS = "class";
    private static Map<String, String> classNode = new HashMap<String, String>();
    private static Map<String, String> terms = new HashMap<String, String>();
    private String fullText;
    private String nodeName;
    private String name;
    private String index;
    private String term;
    private long cost;
    private long row;
    private Map<String, String> nodeProps = new HashMap<String, String>();
    private CubridPlanNode parent;
    private List<CubridPlanNode> nested;

    public CubridPlanNode(@NotNull String queryPlan) {
        this(null, null, null, queryPlan);
    }

    private CubridPlanNode(@Nullable CubridPlanNode parent, @Nullable String name, @Nullable List<String> segments, @NotNull String fullText) {
        this.parent = parent;
        this.name = name;
        this.fullText = fullText;
        this.parseObject(parent == null ? this.getSegments() : segments);
        this.parseNode();
    }

    @Property(order=0, viewable=true)
    @NotNull
    public String getNodeType() {
        return this.getMethodTitle(this.name);
    }

    @Property(order=1, viewable=true)
    @NotNull
    public String getNodeName() {
        return this.getNameOrTotal(true);
    }

    @Property(order=2, viewable=true)
    @NotNull
    public String getIndex() {
        return this.index;
    }

    @Property(order=3, viewable=true)
    @NotNull
    public String getTerms() {
        return this.getTermExtra(true);
    }

    @Property(order=4, viewable=true)
    public long getCost() {
        return this.cost;
    }

    @Property(order=5, viewable=true)
    public long getCardinality() {
        return this.row;
    }

    @Property(order=6, viewable=true)
    @NotNull
    public String getTotal() {
        return this.getNameOrTotal(false);
    }

    @Property(order=7, viewable=true)
    @NotNull
    public String getExtra() {
        return this.getTermExtra(false);
    }

    @Property(order=8, length=PropertyLength.MULTILINE)
    @NotNull
    public String getFullText() {
        return this.fullText;
    }

    @Nullable
    public CubridPlanNode getParent() {
        return this.parent;
    }

    @Nullable
    public Collection<CubridPlanNode> getNested() {
        return this.nested;
    }

    public DBCPlanNodeKind getNodeKind() {
        if ("sscan".equals(this.name)) {
            return DBCPlanNodeKind.TABLE_SCAN;
        }
        if ("iscan".equals(this.name)) {
            return DBCPlanNodeKind.INDEX_SCAN;
        }
        return super.getNodeKind();
    }

    @Nullable
    private String getMethodTitle(@NotNull String method) {
        return switch (method) {
            case "iscan" -> "Index Scan";
            case "sscan" -> "Full Scan";
            case "temp(group by)" -> "Group by Temp";
            case "temp(order by)" -> "Order by Temp";
            case "nl-join (inner join)" -> "Nested Loop - Inner Join";
            case "nl-join (cross join)" -> "Nested Loop - Cross Join";
            case "idx-join (inner join)" -> "Index Join - Inner Join";
            case "m-join (inner join)" -> "Merged - Inner Join";
            case "temp" -> "Temp";
            case "follow" -> "Follow";
            default -> method;
        };
    }

    private void addNested(@NotNull String name, @NotNull List<String> value) {
        if (this.nested == null) {
            this.nested = new ArrayList<CubridPlanNode>();
        }
        this.nested.add(new CubridPlanNode(this, name, value, this.fullText));
    }

    private void parseNode() {
        for (String key : this.nodeProps.keySet()) {
            if (key.contains(CLASS)) {
                this.nodeName = this.nodeProps.get(CLASS).split(" ")[1];
                continue;
            }
            if (key.equals("index")) {
                this.index = this.nodeProps.get(key).split(" ")[0];
                this.term = this.nodeProps.get(key).split(" ")[1];
                continue;
            }
            if (key.equals("sargs")) {
                this.term = this.nodeProps.get(key);
                continue;
            }
            if (!key.equals(COST)) continue;
            String[] values = this.nodeProps.get(key).split(" card ");
            this.cost = Long.parseLong(values[0]);
            this.row = Long.parseLong(values[1]);
        }
    }

    private void parseObject(@NotNull List<String> segments) {
        if (!segments.isEmpty()) {
            String[] removes = segments.remove(0).split(OPTIONS_SEPARATOR);
            this.nodeProps.put(removes[0], removes[1].trim());
            if (removes[0].equals(COST) || segments.isEmpty()) {
                return;
            }
            String key = segments.get(0).split(OPTIONS_SEPARATOR)[0];
            if (this.nodeProps.containsKey(key) || removes[0].equals("subplan")) {
                this.addNested(removes[1].trim(), segments);
                this.parseObject(segments);
            } else if (key.equals(CLASS)) {
                if (!removes[0].equals("Query plan")) {
                    this.addNested(removes[1].trim(), segments);
                }
                this.parseObject(segments);
            } else {
                this.parseObject(segments);
            }
        }
    }

    @Nullable
    private String getTermExtra(boolean isTerm) {
        String termValue = terms.get(this.term);
        if (CommonUtils.isNotEmpty((String)termValue)) {
            String[] values = termValue.split(" \\(sel");
            if (isTerm) {
                return values[0].trim();
            }
            return "(sel" + values[1].trim();
        }
        return null;
    }

    @Nullable
    private String getNameOrTotal(boolean isName) {
        Pattern p;
        Matcher m;
        String classNodeValue = classNode.get(this.nodeName);
        if (CommonUtils.isNotEmpty((String)classNodeValue) && (m = (p = isName ? Pattern.compile("\\w+ \\w+") : Pattern.compile("\\w+\\/\\w+")).matcher(classNodeValue)).find()) {
            return m.group(0);
        }
        return null;
    }

    @NotNull
    private List<String> getSegments() {
        Pattern pattern = Pattern.compile("(inner|outer|class|cost|index|sargs|Query plan|term\\[..|node\\[..):\\s*([^\\n\\r]*)");
        Matcher matcher = pattern.matcher(this.fullText);
        ArrayList<String> segments = new ArrayList<String>();
        while (matcher.find()) {
            String[] values;
            String segment = matcher.group().trim();
            if (segment.startsWith("node")) {
                values = segment.split(OPTIONS_SEPARATOR);
                classNode.put(values[0], values[1]);
                continue;
            }
            if (segment.startsWith("term")) {
                values = segment.split(OPTIONS_SEPARATOR);
                terms.put(values[0], values[1]);
                continue;
            }
            segments.add(segment);
        }
        this.name = ((String)segments.get(0)).split(OPTIONS_SEPARATOR)[1].trim();
        return segments;
    }
}

