/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.model.plan;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.cubrid.model.CubridDataSource;
import org.jkiss.dbeaver.ext.cubrid.model.plan.CubridPlanAnalyser;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanStyle;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerConfiguration;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;

public class CubridQueryPlanner
implements DBCQueryPlanner {
    private CubridDataSource dataSource;

    public CubridQueryPlanner(@NotNull CubridDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public CubridPlanAnalyser explain(@NotNull JDBCSession session, @NotNull String query) throws DBCException {
        String plainQuery;
        SQLDialect dialect = SQLUtils.getDialectFromObject((DBPObject)this.dataSource);
        String firstKeyword = SQLUtils.getFirstKeyword((SQLDialect)dialect, (String)(plainQuery = SQLUtils.stripComments((SQLDialect)dialect, (String)query).toUpperCase()));
        if (!"SELECT".equalsIgnoreCase(firstKeyword) && !"WITH".equalsIgnoreCase(firstKeyword)) {
            throw new DBCException("Only SELECT statements could produce execution plan");
        }
        return new CubridPlanAnalyser(session, query);
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public DBCPlan planQueryExecution(@NotNull DBCSession session, @NotNull String query, @NotNull DBCQueryPlannerConfiguration configuration) throws DBCException {
        return this.explain((JDBCSession)session, query);
    }

    @NotNull
    public DBCPlanStyle getPlanStyle() {
        return DBCPlanStyle.PLAN;
    }
}

