/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model.session;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.session.SQLServerSession;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManagerSQL;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.utils.CommonUtils;

public class SQLServerSessionManager
implements DBAServerSessionManager<SQLServerSession>,
DBAServerSessionManagerSQL {
    public static final String OPTION_SHOW_ONLY_CONNECTIONS = "showOnlyConnections";
    private final SQLServerDataSource dataSource;

    public SQLServerSessionManager(SQLServerDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    /*
     * Loose catch block
     */
    @NotNull
    public Collection<SQLServerSession> getSessions(@NotNull DBCSession session, @NotNull Map<String, Object> options) throws DBException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement(this.generateSessionReadQuery(options));){
                ArrayList<SQLServerSession> arrayList;
                JDBCResultSet dbResult;
                Throwable throwable2;
                block22: {
                    throwable2 = null;
                    Object var7_11 = null;
                    dbResult = dbStat.executeQuery();
                    ArrayList<SQLServerSession> sessions = new ArrayList<SQLServerSession>();
                    while (dbResult.next()) {
                        sessions.add(new SQLServerSession((ResultSet)dbResult));
                    }
                    arrayList = sessions;
                    if (dbResult == null) break block22;
                    dbResult.close();
                }
                return arrayList;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (dbResult != null) {
                                dbResult.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBDatabaseException((Throwable)e, session.getDataSource());
        }
    }

    public void alterSession(@NotNull DBCSession session, @NotNull SQLServerSession sessionType, @NotNull Map<String, Object> options) throws DBException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCStatement dbStat = ((JDBCSession)session).createStatement();){
                dbStat.execute("KILL " + sessionType.getId());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBDatabaseException((Throwable)e, session.getDataSource());
        }
    }

    public boolean canGenerateSessionReadQuery() {
        return true;
    }

    @NotNull
    public String generateSessionReadQuery(@NotNull Map<String, Object> options) {
        boolean onlyConnections = CommonUtils.getOption(options, (String)OPTION_SHOW_ONLY_CONNECTIONS);
        boolean supportsDatabaseInfo = this.dataSource.isServerVersionAtLeast(11, 0);
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT s.*,");
        if (supportsDatabaseInfo) {
            sql.append("db.name as database_name,");
        } else {
            sql.append("NULL as database_name,");
        }
        sql.append("c.connection_id,(select text from sys.dm_exec_sql_text(c.most_recent_sql_handle)) as sql_text\n").append("FROM sys.dm_exec_sessions s\n");
        if (onlyConnections) {
            sql.append("LEFT OUTER ");
        }
        sql.append("JOIN sys.dm_exec_connections c ON c.session_id=s.session_id\n");
        if (supportsDatabaseInfo) {
            sql.append("LEFT OUTER JOIN sys.sysdatabases db on db.dbid=s.database_id\n");
        }
        sql.append("ORDER BY s.session_id DESC");
        return sql.toString();
    }
}

