/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.object.struct;

import java.util.Collection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstrainable;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintInfo;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraint;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.object.internal.ObjectEditorMessages;
import org.jkiss.dbeaver.ui.editors.object.struct.AttributesSelectorPage;
import org.jkiss.dbeaver.ui.editors.object.struct.ConstraintNameGenerator;
import org.jkiss.utils.CommonUtils;

public class EditConstraintPage
extends AttributesSelectorPage {
    private static final Log log = Log.getLog(EditConstraintPage.class);
    private DBSEntityConstraintType[] constraintTypes;
    private DBSEntityConstraintType selectedConstraintType;
    private String constraintExpression;
    private DBSEntityReferrer constraint;
    private Collection<? extends DBSEntityAttributeRef> attributes;
    private final ConstraintNameGenerator nameGenerator;
    private Group expressionGroup;
    private Text expressionText;
    private boolean enableConstraint = true;
    private boolean showEnable = false;
    private boolean useAllColumns = false;

    public EditConstraintPage(String title, DBSEntityReferrer constraint) {
        super(title, constraint.getParentObject());
        this.constraint = constraint;
        DBSEntity dBSEntity = this.entity;
        if (dBSEntity instanceof DBSEntityConstrainable) {
            DBSEntityConstrainable entityConstrainable = (DBSEntityConstrainable)dBSEntity;
            this.constraintTypes = (DBSEntityConstraintType[])entityConstrainable.getSupportedConstraints().stream().map(DBSEntityConstraintInfo::getType).filter(type -> type != DBSEntityConstraintType.INDEX).toArray(DBSEntityConstraintType[]::new);
        } else {
            this.constraintTypes = new DBSEntityConstraintType[]{constraint.getConstraintType()};
        }
        this.selectedConstraintType = constraint.getConstraintType();
        this.constraint = constraint;
        try {
            this.attributes = constraint.getAttributeReferences((DBRProgressMonitor)new VoidProgressMonitor());
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError(ObjectEditorMessages.edit_constraints_error_title, ObjectEditorMessages.edit_constraints_error_message, (Throwable)e);
        }
        this.nameGenerator = new ConstraintNameGenerator(constraint.getParentObject(), this.constraint.isPersisted() ? this.constraint.getName() : null, constraint.getConstraintType());
        if (constraint instanceof DBVEntityConstraint) {
            this.useAllColumns = ((DBVEntityConstraint)constraint).isUseAllColumns();
        }
    }

    private boolean isUniqueVirtualKeyEdit() {
        return this.constraintTypes.length == 1 && this.constraintTypes[0] == DBSEntityConstraintType.VIRTUAL_KEY;
    }

    public void setConstraintTypes(DBSEntityConstraintType[] constraintTypes) {
        this.constraintTypes = constraintTypes;
    }

    @Override
    protected Composite createPageContents(Composite parent) {
        Composite pageContents = super.createPageContents(parent);
        this.toggleEditAreas();
        return pageContents;
    }

    private void toggleEditAreas() {
        boolean custom = this.selectedConstraintType.isCustom();
        this.columnsGroup.setVisible(!custom);
        ((GridData)this.columnsGroup.getLayoutData()).exclude = custom;
        this.expressionGroup.setVisible(custom);
        ((GridData)this.expressionGroup.getLayoutData()).exclude = !custom;
        this.columnsGroup.getParent().layout();
    }

    @Override
    protected void createContentsBeforeColumns(Composite panel) {
        Text nameText;
        Text text = nameText = this.entity != null ? UIUtils.createLabelText((Composite)panel, (String)ObjectEditorMessages.dialog_struct_edit_constrain_label_name, (String)this.nameGenerator.getConstraintName()) : null;
        if (nameText != null) {
            nameText.selectAll();
            nameText.setFocus();
            nameText.addModifyListener(e -> {
                this.nameGenerator.setConstraintName(nameText.getText().trim());
                this.validateProperties();
            });
        }
        UIUtils.createControlLabel((Composite)panel, (String)ObjectEditorMessages.dialog_struct_edit_constrain_label_type);
        final Combo typeCombo = new Combo(panel, 12);
        typeCombo.setLayoutData((Object)new GridData(768));
        DBSEntityConstraintType[] dBSEntityConstraintTypeArray = this.constraintTypes;
        int n = this.constraintTypes.length;
        int n2 = 0;
        while (n2 < n) {
            DBSEntityConstraintType constraintType = dBSEntityConstraintTypeArray[n2];
            typeCombo.add(constraintType.getName());
            if (this.selectedConstraintType == null || constraintType == this.selectedConstraintType) {
                this.selectedConstraintType = constraintType;
                typeCombo.select(typeCombo.getItemCount() - 1);
            }
            ++n2;
        }
        if (this.selectedConstraintType == null) {
            typeCombo.select(0);
            this.selectedConstraintType = this.constraintTypes[0];
        }
        typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditConstraintPage.this.selectedConstraintType = EditConstraintPage.this.constraintTypes[typeCombo.getSelectionIndex()];
                EditConstraintPage.this.nameGenerator.setConstraintType(EditConstraintPage.this.selectedConstraintType);
                if (nameText != null) {
                    nameText.setText(EditConstraintPage.this.nameGenerator.getConstraintName());
                }
                EditConstraintPage.this.validateProperties();
                EditConstraintPage.this.toggleEditAreas();
            }
        });
        if (this.showEnable) {
            final Button enableConstraintButton = UIUtils.createCheckbox((Composite)panel, (String)ObjectEditorMessages.edit_constraints_enable_constraint_text, (String)ObjectEditorMessages.edit_constraints_enable_constraint_tip, (boolean)true, (int)2);
            enableConstraintButton.setVisible(this.showEnable);
            enableConstraintButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditConstraintPage.this.enableConstraint = enableConstraintButton.getSelection();
                }
            });
        }
        if (this.isUniqueVirtualKeyEdit()) {
            final Button useAllColumnsCheck = UIUtils.createCheckbox((Composite)panel, (String)ObjectEditorMessages.edit_constraints_use_all_columns_text, (String)ObjectEditorMessages.edit_constraints_use_all_columns_tip, (boolean)this.useAllColumns, (int)2);
            useAllColumnsCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditConstraintPage.this.useAllColumns = useAllColumnsCheck.getSelection();
                    EditConstraintPage.this.columnsTable.setEnabled(!EditConstraintPage.this.useAllColumns);
                    EditConstraintPage.this.validateProperties();
                    EditConstraintPage.this.updatePageState();
                }
            });
        }
        this.validateProperties();
    }

    @Override
    protected void createContentsAfterColumns(Composite panel) {
        this.expressionGroup = UIUtils.createControlGroup((Composite)panel, (String)ObjectEditorMessages.edit_constraints_expression_text, (int)1, (int)1808, (int)0);
        this.expressionText = new Text((Composite)this.expressionGroup, 2050);
        GridData gd = new GridData(1808);
        gd.heightHint = this.expressionText.getLineHeight() * 3;
        this.expressionText.setLayoutData((Object)gd);
        this.expressionText.addModifyListener(e -> {
            this.constraintExpression = this.expressionText.getText();
            this.updatePageState();
        });
        this.columnsTable.setEnabled(!this.useAllColumns);
    }

    @Override
    protected boolean isColumnsRequired() {
        return !this.selectedConstraintType.isCustom() && !this.useAllColumns;
    }

    public String getConstraintName() {
        return this.nameGenerator.getConstraintName();
    }

    public DBSEntityConstraintType getConstraintType() {
        return this.selectedConstraintType;
    }

    public String getConstraintExpression() {
        return this.constraintExpression;
    }

    @Override
    public DBSObject getObject() {
        return this.constraint;
    }

    @Override
    protected String getEditError() {
        String error = this.nameGenerator.validateAllowedType(this.selectedConstraintType);
        if (error != null) {
            return error;
        }
        return super.getEditError();
    }

    @Override
    public boolean isPageComplete() {
        if (this.selectedConstraintType == null) {
            return false;
        }
        if (this.selectedConstraintType.isCustom()) {
            return !CommonUtils.isEmpty((String)this.constraintExpression);
        }
        return this.useAllColumns || super.isPageComplete();
    }

    @Override
    public boolean isColumnSelected(DBSEntityAttribute attribute) {
        if (!CommonUtils.isEmpty(this.attributes)) {
            for (DBSEntityAttributeRef dBSEntityAttributeRef : this.attributes) {
                if (dBSEntityAttributeRef.getAttribute() != attribute) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEnableConstraint() {
        return this.enableConstraint;
    }

    public boolean isUseAllColumns() {
        return this.useAllColumns;
    }

    @Override
    public void performFinish() {
        DBSEntityReferrer dBSEntityReferrer = this.constraint;
        if (dBSEntityReferrer instanceof AbstractTableConstraint) {
            AbstractTableConstraint atc = (AbstractTableConstraint)dBSEntityReferrer;
            atc.setConstraintType(this.getConstraintType());
            atc.setName(this.getConstraintName());
        }
    }
}

