/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.object.struct;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.object.internal.ObjectEditorMessages;
import org.jkiss.dbeaver.ui.editors.object.struct.AttributesSelectorPage;
import org.jkiss.utils.CommonUtils;

public class EditDictionaryPage
extends AttributesSelectorPage {
    private Text criteriaText;
    private DBVEntity dictionary;
    private Collection<DBSEntityAttribute> descColumns;
    private DBSEntity entity;
    private Text columnDividerText;

    public EditDictionaryPage(DBSEntity entity) {
        super("Edit dictionary", entity);
        this.entity = entity;
        this.dictionary = DBVUtils.getVirtualEntity((DBSEntity)entity, (boolean)true);
        UIUtils.runInUI((IRunnableContext)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), monitor -> {
            try {
                List tablePK;
                if (this.dictionary.getDescriptionColumnNames() == null && (tablePK = DBUtils.getBestTableIdentifier((DBRProgressMonitor)monitor, (DBSEntity)entity)) != null && !tablePK.isEmpty()) {
                    this.dictionary.setDescriptionColumnNames(DBVEntity.getDefaultDescriptionColumn((DBRProgressMonitor)monitor, (DBSEntityAttribute)((DBSEntityAttribute)tablePK.iterator().next())));
                }
                this.descColumns = this.dictionary.getDescriptionColumns(monitor, entity);
            }
            catch (DBException e) {
                throw new InvocationTargetException(e);
            }
        });
    }

    public DBVEntity getDictionary() {
        return this.dictionary;
    }

    @Override
    protected void createContentsBeforeColumns(Composite panel) {
        Link label = UIUtils.createLink((Composite)panel, (String)ObjectEditorMessages.dialog_struct_edit_dictionary_tip, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIUtils.showPreferencesFor(null, null, (String[])new String[]{"org.jkiss.dbeaver.preferences.main.dataviewer"});
            }
        });
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
    }

    @Override
    protected void createContentsAfterColumns(Composite panel) {
        Composite group = UIUtils.createComposite((Composite)panel, (int)1);
        group.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)group, (String)ObjectEditorMessages.dialog_struct_edit_dictionary_custom_criteria);
        this.criteriaText = new Text(group, 2626);
        GridData gd = new GridData(1808);
        gd.heightHint = 50;
        this.criteriaText.setLayoutData((Object)gd);
        this.criteriaText.setToolTipText(ObjectEditorMessages.dialog_struct_edit_dictionary_custom_criteria_tip);
        if (!CommonUtils.isEmpty((String)this.dictionary.getDescriptionColumnNames())) {
            this.criteriaText.setText(this.dictionary.getDescriptionColumnNames());
        }
        Composite settingsPanel = UIUtils.createComposite((Composite)group, (int)2);
        settingsPanel.setLayoutData((Object)new GridData(768));
        this.columnDividerText = UIUtils.createLabelText((Composite)settingsPanel, (String)ObjectEditorMessages.dialog_struct_edit_dictionary_column_delimiter, (String)this.entity.getDataSource().getContainer().getPreferenceStore().getString("resultset.dictionary.columnDivider"));
        this.columnDividerText.setToolTipText(ObjectEditorMessages.dialog_struct_edit_dictionary_column_delimiter_tip);
    }

    @Override
    protected boolean isColumnsRequired() {
        return false;
    }

    @Override
    public boolean isColumnSelected(DBSEntityAttribute attribute) {
        return this.descColumns.contains(attribute);
    }

    @Override
    protected void handleColumnsChange() {
        this.descColumns = this.getSelectedAttributes();
        StringBuilder custom = new StringBuilder();
        for (DBSEntityAttribute column : this.descColumns) {
            if (custom.length() > 0) {
                custom.append(",");
            }
            custom.append(DBUtils.getQuotedIdentifier((DBSObject)column));
        }
        this.criteriaText.setText(custom.toString());
    }

    @Override
    public DBSObject getObject() {
        return this.entity;
    }

    @Override
    public boolean isPageComplete() {
        if (!CommonUtils.isEmpty((String)this.criteriaText.getText())) {
            return true;
        }
        return super.isPageComplete();
    }

    @Override
    public void performFinish() {
        this.saveDictionarySettings();
        this.entity.getDataSource().getContainer().persistConfiguration();
    }

    public void saveDictionarySettings() {
        this.dictionary.setDescriptionColumnNames(this.criteriaText.getText());
        DBWorkbench.getPlatform().getPreferenceStore().setValue("resultset.dictionary.columnDivider", this.columnDividerText.getText());
    }
}

