/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone;

import java.awt.Desktop;
import java.awt.GraphicsEnvironment;
import java.awt.desktop.SystemEventListener;
import java.awt.desktop.SystemSleepEvent;
import java.awt.desktop.SystemSleepListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.SaveableHelper;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.ide.application.DelayedEventsProcessor;
import org.eclipse.ui.internal.ide.application.IDEWorkbenchAdvisor;
import org.eclipse.ui.internal.wizards.AbstractExtensionWizardRegistry;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreFeatures;
import org.jkiss.dbeaver.core.ui.services.ApplicationPolicyService;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.impl.preferences.BundlePreferenceStore;
import org.jkiss.dbeaver.model.task.DBTTaskManager;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.OperationSystemState;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIFonts;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceHandler;
import org.jkiss.dbeaver.ui.app.standalone.ApplicationWorkbenchWindowAdvisor;
import org.jkiss.dbeaver.ui.app.standalone.FontPreferenceOverrides;
import org.jkiss.dbeaver.ui.app.standalone.internal.CoreApplicationActivator;
import org.jkiss.dbeaver.ui.app.standalone.internal.CoreApplicationMessages;
import org.jkiss.dbeaver.ui.app.standalone.update.DBeaverVersionChecker;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.content.ContentEditorInput;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class ApplicationWorkbenchAdvisor
extends IDEWorkbenchAdvisor {
    private static final Log log = Log.getLog(ApplicationWorkbenchAdvisor.class);
    private static final String PERSPECTIVE_ID = "org.jkiss.dbeaver.core.perspective";
    public static final String DBEAVER_SCHEME_NAME = "org.jkiss.dbeaver.defaultKeyScheme";
    protected static final String WORKBENCH_PREF_PAGE_ID = "org.eclipse.ui.preferencePages.Workbench";
    protected static final String APPEARANCE_PREF_PAGE_ID = "org.eclipse.ui.preferencePages.Views";
    private static final String EDITORS_PREF_PAGE_ID = "org.eclipse.ui.preferencePages.Editors";
    private static final String[] EXCLUDE_PREF_PAGES = new String[]{"org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.preferencePages.Globalization", "org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.preferencePages.Perspectives", "org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.preferencePages.Views/org.eclipse.ui.preferencePages.Decorators", "org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.preferencePages.Workspace/org.eclipse.ui.preferencePages.BuildOrder", "org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.preferencePages.General.LinkHandlers", "org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.preferencePages.Startup", "org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.trace.tracingPage", "org.eclipse.ui.preferencePages.Workbench/org.eclipse.epp.mpc.projectnatures", "org.eclipse.ui.internal.console.ansi.preferences.AnsiConsolePreferencePage", "org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.browser.preferencePage", "org.eclipse.jsch.ui.SSHPreferences", "org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.preferencePages.Editors", "org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.preferencePages.Editors/org.eclipse.ui.preferencePages.AutoSave"};
    private static final String[] UI_PREF_PAGES = new String[]{"org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.preferencePages.Views", "org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.preferencePages.Keys", "org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.browser.preferencePage", "org.eclipse.ui.preferencePages.Workbench/org.eclipse.search.preferences.SearchPreferencePage", "org.eclipse.ui.preferencePages.Workbench/org.eclipse.text.quicksearch.PreferencesPage", "org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.preferencePages.Editors/org.eclipse.ui.preferencePages.FileEditors"};
    private static final String[] EDITORS_PREF_PAGES = new String[]{"org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.preferencePages.Editors/org.eclipse.ui.preferencePages.GeneralTextEditor"};
    private static final String[] GENERAL_PREF_PAGES = new String[]{"org.eclipse.equinox.internal.p2.ui.sdk.ProvisioningPreferencePage", "org.eclipse.debug.ui.DebugPreferencePage"};
    private static final String[] NETWORK_PREF_PAGES = new String[]{"org.eclipse.ui.preferencePages.Workbench/org.eclipse.ui.net.NetPreferences"};
    private static final Set<String> fontPrefIdsToHide = Set.of(ApplicationWorkbenchWindowAdvisor.TEXT_EDITOR_BLOCK_SELECTION_FONT, ApplicationWorkbenchWindowAdvisor.TEXT_FONT, ApplicationWorkbenchWindowAdvisor.CONSOLE_FONT, ApplicationWorkbenchWindowAdvisor.DETAIL_PANE_TEXT_FONT, ApplicationWorkbenchWindowAdvisor.MEMORY_VIEW_TABLE_FONT, ApplicationWorkbenchWindowAdvisor.COMPARE_TEXT_FONT, ApplicationWorkbenchWindowAdvisor.DIALOG_FONT, ApplicationWorkbenchWindowAdvisor.VARIABLE_TEXT_FONT, ApplicationWorkbenchWindowAdvisor.PART_TITLE_FONT, ApplicationWorkbenchWindowAdvisor.TREE_AND_TABLE_FONT_FOR_VIEWS);
    private static final Map<String, List<String>> fontOverrides = Map.of(UIFonts.DBEAVER_FONTS_MONOSPACE, List.of(ApplicationWorkbenchWindowAdvisor.TEXT_EDITOR_BLOCK_SELECTION_FONT, ApplicationWorkbenchWindowAdvisor.TEXT_FONT, ApplicationWorkbenchWindowAdvisor.CONSOLE_FONT, ApplicationWorkbenchWindowAdvisor.DETAIL_PANE_TEXT_FONT, ApplicationWorkbenchWindowAdvisor.MEMORY_VIEW_TABLE_FONT, ApplicationWorkbenchWindowAdvisor.COMPARE_TEXT_FONT), UIFonts.DBEAVER_FONTS_MAIN_FONT, List.of(ApplicationWorkbenchWindowAdvisor.DIALOG_FONT, ApplicationWorkbenchWindowAdvisor.VARIABLE_TEXT_FONT, ApplicationWorkbenchWindowAdvisor.PART_TITLE_FONT, ApplicationWorkbenchWindowAdvisor.TREE_AND_TABLE_FONT_FOR_VIEWS));
    protected final DBPApplication application;
    private final DelayedEventsProcessor processor;
    private final SystemEventListener systemSleepListener = new SystemSleepListener(){

        @Override
        public void systemAboutToSleep(SystemSleepEvent e) {
            OperationSystemState.toggleSleepMode((boolean)true);
        }

        @Override
        public void systemAwoke(SystemSleepEvent e) {
            OperationSystemState.toggleSleepMode((boolean)false);
        }
    };

    protected ApplicationWorkbenchAdvisor(DBPApplication application) {
        this.application = application;
        this.processor = new DelayedEventsProcessor(Display.getCurrent());
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new ApplicationWorkbenchWindowAdvisor(this, configurer);
    }

    public String getInitialWindowPerspectiveId() {
        return PERSPECTIVE_ID;
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        if (RuntimeUtils.isMacOS()) {
            try {
                new BundlePreferenceStore("org.eclipse.urischeme").setValue("skipAutoRegistration", true);
            }
            catch (Exception e) {
                log.debug((Object)"Error disabling urischeme auto registration", (Throwable)e);
            }
        }
        super.initialize(configurer);
        DefaultScope.INSTANCE.getNode(CoreApplicationActivator.getDefault().getBundle().getSymbolicName());
        TrayDialog.setDialogHelpAvailable((boolean)false);
        WorkbenchImages.getImageRegistry().remove("IMG_OBJS_ERROR_PATH");
        WorkbenchImages.getImageRegistry().put("IMG_OBJS_ERROR_PATH", DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.SMALL_ERROR));
        WorkbenchImages.getDescriptors().put("IMG_OBJS_ERROR_PATH", DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.SMALL_ERROR));
        FontPreferenceOverrides.overrideFontPrefValues(fontOverrides);
    }

    public void preStartup() {
        super.preStartup();
        LinkedHashMap<String, Long> params = new LinkedHashMap<String, Long>();
        params.put("startTime", DBWorkbench.getPlatform().getApplication().getApplicationStartTime());
        CoreFeatures.APP_OPEN.use(params);
    }

    public void postStartup() {
        Desktop desktop;
        super.postStartup();
        this.filterPreferencePages();
        this.filterWizards();
        this.patchJFaceIcons();
        if (!this.application.isDistributed() && !ApplicationPolicyService.getInstance().isInstallUpdateDisabled()) {
            this.startVersionChecker();
        }
        if (!GraphicsEnvironment.isHeadless() && Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.APP_EVENT_SYSTEM_SLEEP)) {
            desktop.addAppEventListener(this.systemSleepListener);
        }
    }

    public IAdaptable getDefaultPageInput() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected boolean isPropertyChangeRequiresRestart(String property) {
        return property.equals("logs.debug.enabled") || property.equals("logs.debug.location") || property.equals("platform.language");
    }

    private void filterPreferencePages() {
        PreferenceManager pm = PlatformUI.getWorkbench().getPreferenceManager();
        FontPreferenceOverrides.hideFontPrefs(pm, fontPrefIdsToHide);
        this.patchPreferencePages(pm, EDITORS_PREF_PAGES, "org.jkiss.dbeaver.preferences.editors");
        this.patchPreferencePages(pm, UI_PREF_PAGES, "org.jkiss.dbeaver.preferences.main");
        this.patchPreferencePages(pm, GENERAL_PREF_PAGES, WORKBENCH_PREF_PAGE_ID);
        this.patchPreferencePages(pm, NETWORK_PREF_PAGES, "org.jkiss.dbeaver.preferences.main.connections");
        String[] stringArray = this.getExcludedPreferencePageIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String epp = stringArray[n2];
            pm.remove(epp);
            ++n2;
        }
    }

    @NotNull
    protected String[] getExcludedPreferencePageIds() {
        return EXCLUDE_PREF_PAGES;
    }

    protected void patchPreferencePages(PreferenceManager pm, String[] preferencePages, String preferencePageId) {
        String[] stringArray = preferencePages;
        int n = preferencePages.length;
        int n2 = 0;
        while (n2 < n) {
            String pageId = stringArray[n2];
            IPreferenceNode uiPage = pm.remove(pageId);
            if (uiPage != null) {
                pm.addTo(preferencePageId, uiPage);
            }
            ++n2;
        }
    }

    protected boolean isWizardAllowed(String wizardId) {
        return !this.application.isStandalone() || !"org.eclipse.ui.wizards.new.project".equals(wizardId);
    }

    private void filterWizards() {
        AbstractExtensionWizardRegistry wizardRegistry = (AbstractExtensionWizardRegistry)WorkbenchPlugin.getDefault().getNewWizardRegistry();
        IWizardCategory[] categories = WorkbenchPlugin.getDefault().getNewWizardRegistry().getRootCategory().getCategories();
        IWizardDescriptor[] iWizardDescriptorArray = this.getAllWizards(categories);
        int n = iWizardDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardDescriptor wizard = iWizardDescriptorArray[n2];
            WorkbenchWizardElement wizardElement = (WorkbenchWizardElement)wizard;
            if (!this.isWizardAllowed(wizardElement.getId())) {
                wizardRegistry.removeExtension(wizardElement.getConfigurationElement().getDeclaringExtension(), new Object[]{wizardElement});
            }
            ++n2;
        }
    }

    private IWizardDescriptor[] getAllWizards(IWizardCategory ... categories) {
        ArrayList results = new ArrayList();
        IWizardCategory[] iWizardCategoryArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardCategory wizardCategory = iWizardCategoryArray[n2];
            Collections.addAll(results, wizardCategory.getWizards());
            Collections.addAll(results, this.getAllWizards(wizardCategory.getCategories()));
            ++n2;
        }
        return results.toArray(new IWizardDescriptor[0]);
    }

    private void patchJFaceIcons() {
        Map<String, ImageDescriptor> icons = Map.of("dialog_messasge_info_image", DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.SMALL_INFO), "dialog_messasge_warning_image", DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.SMALL_WARNING), "dialog_message_error_image", DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.SMALL_ERROR));
        ImageRegistry registry = JFaceResources.getImageRegistry();
        for (Map.Entry<String, ImageDescriptor> entry : icons.entrySet()) {
            registry.remove(entry.getKey());
            registry.put(entry.getKey(), entry.getValue());
        }
    }

    private void startVersionChecker() {
        DBeaverVersionChecker checker = new DBeaverVersionChecker(false);
        checker.schedule(3000L);
    }

    public boolean preShutdown() {
        if (!this.saveAndCleanup()) {
            return false;
        }
        CoreFeatures.APP_CLOSE.use();
        return super.preShutdown();
    }

    public void postShutdown() {
        Desktop desktop;
        super.postShutdown();
        if (!GraphicsEnvironment.isHeadless() && Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.APP_EVENT_SYSTEM_SLEEP)) {
            desktop.removeAppEventListener(this.systemSleepListener);
        }
    }

    private boolean saveAndCleanup() {
        block4: {
            if (this.getWorkbenchConfigurer().emergencyClosing()) {
                return true;
            }
            try {
                IWorkbenchWindow window = this.getWorkbenchConfigurer().getWorkbench().getActiveWorkbenchWindow();
                if (window == null || ApplicationWorkbenchAdvisor.closeOpenEditors(window, false, true)) break block4;
                return false;
            }
            catch (Throwable e) {
                log.error((Object)e);
                return true;
            }
        }
        return ApplicationWorkbenchAdvisor.cancelRunningTasks(true) && ApplicationWorkbenchAdvisor.closeActiveTransactions(false);
    }

    public static boolean closeOpenEditors(IWorkbenchWindow window, boolean forceRevert, boolean showConfirmation) {
        IEditorPart editorPart;
        IEditorReference editor;
        if (showConfirmation && !forceRevert && !"never".equals(ConfirmationDialog.getSavedPreference((String)"exit")) && ConfirmationDialog.confirmAction((Shell)window.getShell(), (String)"exit", (int)3, (Object[])new Object[0]) != 2) {
            return false;
        }
        IWorkbenchPage workbenchPage = window.getActivePage();
        IEditorReference[] editors = workbenchPage.getEditorReferences();
        ArrayList<IEditorPart> editorsToRevert = new ArrayList<IEditorPart>();
        IEditorReference[] iEditorReferenceArray = editors;
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            editor = iEditorReferenceArray[n2];
            editorPart = editor.getEditor(false);
            if (editorPart != null && editorPart.getEditorInput() instanceof ContentEditorInput) {
                workbenchPage.closeEditor(editorPart, false);
            }
            ++n2;
        }
        iEditorReferenceArray = editors;
        n = editors.length;
        n2 = 0;
        while (n2 < n) {
            editor = iEditorReferenceArray[n2];
            editorPart = editor.getEditor(false);
            if (editorPart instanceof ISaveablePart2) {
                if (!forceRevert && !SaveableHelper.savePart((ISaveablePart)editorPart, (IWorkbenchPart)editorPart, (IWorkbenchWindow)window, (boolean)true)) {
                    return false;
                }
                editorsToRevert.add(editorPart);
            }
            ++n2;
        }
        for (IEditorPart editorPart2 : editorsToRevert) {
            try {
                EditorUtils.revertEditorChanges((IEditorPart)editorPart2);
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
        }
        return true;
    }

    public static boolean closeActiveTransactions(boolean forceRollback) {
        for (DBPDataSourceContainer dataSourceDescriptor : DataSourceRegistry.getAllDataSources()) {
            if (DataSourceHandler.checkAndCloseActiveTransaction((DBPDataSourceContainer)dataSourceDescriptor, (boolean)false, (boolean)forceRollback)) continue;
            return false;
        }
        return true;
    }

    public static boolean cancelRunningTasks(boolean confirmCancel) {
        DBPProject activeProject = DBWorkbench.getPlatform().getWorkspace().getActiveProject();
        if (activeProject == null) {
            return true;
        }
        DBTTaskManager manager = activeProject.getTaskManager();
        if (manager.hasRunningTasks()) {
            boolean cancel;
            boolean bl = cancel = !confirmCancel || DBWorkbench.getPlatformUI().confirmAction(CoreApplicationMessages.confirmation_cancel_database_tasks_title, CoreApplicationMessages.confirmation_cancel_database_tasks_message);
            if (cancel) {
                manager.cancelRunningTasks();
            }
            return cancel;
        }
        return true;
    }

    public void eventLoopException(Throwable exception) {
        super.eventLoopException(exception);
        log.error((Object)"Event loop exception", exception);
    }

    public void eventLoopIdle(Display display) {
        this.processor.catchUp(display);
        super.eventLoopIdle(display);
    }
}

