/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.stm;

import java.util.AbstractList;
import java.util.List;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.Tree;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.stm.STMParserOverrides;
import org.jkiss.dbeaver.model.stm.STMTreeRuleNode;
import org.jkiss.utils.CommonUtils;

public interface STMTreeNode
extends Tree {
    public void fixup(@NotNull STMParserOverrides var1);

    default public int getNodeKindId() {
        return -1;
    }

    public int getAtnState();

    @NotNull
    public String getNodeName();

    @NotNull
    public Interval getRealInterval();

    @NotNull
    default public String getTextContent() {
        String result = null;
        STMTreeNode sTMTreeNode = this;
        if (sTMTreeNode instanceof STMTreeRuleNode) {
            STMTreeRuleNode ruleNode = (STMTreeRuleNode)sTMTreeNode;
            Interval textRange = ruleNode.getRealInterval();
            result = ruleNode.getStart().getInputStream().getText(textRange);
        } else if (this instanceof TerminalNode) {
            Interval textRange = this.getRealInterval();
            result = ((TerminalNode)this).getSymbol().getInputStream().getText(textRange);
        } else if (this instanceof ParseTree) {
            result = ((ParseTree)this).getText();
        } else {
            STMTreeNode first = this;
            STMTreeNode last = this;
            while (!(first instanceof TerminalNode) && first.getChildCount() > 0) {
                first = first.getChild(0);
            }
            while (!(last instanceof TerminalNode) && last.getChildCount() > 0) {
                last = last.getChild(last.getChildCount() - 1);
            }
            if (first instanceof TerminalNode) {
                TerminalNode a = (TerminalNode)first;
                if (last instanceof TerminalNode) {
                    TerminalNode b = (TerminalNode)last;
                    Interval textRange = Interval.of((int)a.getSymbol().getStartIndex(), (int)b.getSymbol().getStopIndex());
                    result = b.getSymbol().getTokenSource().getInputStream().getText(textRange);
                }
            }
        }
        return CommonUtils.notEmpty((String)result);
    }

    @NotNull
    public String getText();

    @Nullable
    default public STMTreeNode getStmParent() {
        STMTreeNode parent;
        Tree tree = this.getParent();
        return tree instanceof STMTreeNode ? (parent = (STMTreeNode)tree) : null;
    }

    default public STMTreeNode getStmChild(int index) {
        throw new UnsupportedOperationException();
    }

    default public STMTreeNode getFirstStmChild() {
        return this.getStmChild(0);
    }

    default public STMTreeNode getLastStmtChild() {
        return this.getStmChild(this.getChildCount() - 1);
    }

    @Nullable
    default public STMTreeNode findChildOfName(@NotNull String nodeName) {
        int i = 0;
        while (i < this.getChildCount()) {
            STMTreeNode cn = this.getStmChild(i);
            if (cn != null && cn.getNodeName().equals(nodeName)) {
                return cn;
            }
            ++i;
        }
        return null;
    }

    default public List<STMTreeNode> getChildren() {
        return new AbstractList<STMTreeNode>(){

            @Override
            public STMTreeNode get(int index) {
                return STMTreeNode.this.getStmChild(index);
            }

            @Override
            public int size() {
                return STMTreeNode.this.getChildCount();
            }
        };
    }
}

