/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.stm;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.stm.STMTreeTermNode;

public class STMUtils {
    @NotNull
    public static List<STMTreeNode> expandSubtree(@NotNull STMTreeNode root, @Nullable Set<String> toExpand, @NotNull Set<String> toCollect) {
        ArrayList<STMTreeNode> result = new ArrayList<STMTreeNode>();
        Stack<STMTreeNode> stack = new Stack<STMTreeNode>();
        stack.add(root);
        while (!stack.isEmpty()) {
            STMTreeNode node = (STMTreeNode)stack.pop();
            String nodeName = node.getNodeName();
            if (toCollect.contains(nodeName)) {
                result.add(node);
                continue;
            }
            if (toExpand != null && !toExpand.contains(nodeName)) continue;
            int i = node.getChildCount() - 1;
            while (i >= 0) {
                stack.push((STMTreeNode)node.getChild(i));
                --i;
            }
        }
        return result;
    }

    @NotNull
    public static List<STMTreeTermNode> expandTerms(@NotNull STMTreeNode root) {
        ArrayList<STMTreeTermNode> result = new ArrayList<STMTreeTermNode>();
        Stack<STMTreeNode> stack = new Stack<STMTreeNode>();
        stack.add(root);
        while (stack.size() > 0) {
            STMTreeNode node = (STMTreeNode)stack.pop();
            if (node instanceof STMTreeTermNode) {
                STMTreeTermNode term = (STMTreeTermNode)node;
                result.add(term);
                continue;
            }
            int i = 0;
            while (i < node.getChildCount()) {
                stack.push((STMTreeNode)node.getChild(i));
                ++i;
            }
        }
        return result;
    }

    @NotNull
    public static List<String> expandTermStrings(@NotNull STMTreeNode root) {
        ArrayList<String> result = new ArrayList<String>();
        Stack<STMTreeNode> stack = new Stack<STMTreeNode>();
        stack.add(root);
        while (stack.size() > 0) {
            STMTreeNode node = (STMTreeNode)stack.pop();
            if (node instanceof STMTreeTermNode) {
                STMTreeTermNode term = (STMTreeTermNode)node;
                result.add(term.getText());
                continue;
            }
            int i = 0;
            while (i < node.getChildCount()) {
                stack.push((STMTreeNode)node.getChild(i));
                ++i;
            }
        }
        return result;
    }

    public static <T, K> int binarySearchByKey(@NotNull List<T> list, @NotNull Function<T, K> keyGetter, @NotNull K key, @NotNull Comparator<K> comparator) {
        int low = 0;
        int high = list.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            K midVal = keyGetter.apply(list.get(mid));
            int cmp = comparator.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static <T, K> List<T> orderedInsert(@Nullable List<T> list, @NotNull Function<T, K> keyGetter, @NotNull T value, @NotNull Comparator<K> comparator) {
        if (list == null) {
            list = new ArrayList<T>();
        }
        if (list.isEmpty()) {
            list.add(value);
        } else {
            K lastKey;
            K key = keyGetter.apply(value);
            if (comparator.compare(key, lastKey = keyGetter.apply(list.get(list.size() - 1))) > 0) {
                list.add(value);
            } else {
                int index = STMUtils.binarySearchByKey(list, keyGetter, key, comparator);
                if (index < 0) {
                    index ^= 0xFFFFFFFF;
                }
                list.add(index, value);
            }
        }
        return list;
    }

    @NotNull
    public static <T> List<T> combineLists(@NotNull List<T> leftColumns, @NotNull List<T> rightColumns) {
        ArrayList<T> symbols = new ArrayList<T>(leftColumns.size() + rightColumns.size());
        symbols.addAll(leftColumns);
        symbols.addAll(rightColumns);
        return symbols;
    }
}

