/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerDescriptor;
import org.jkiss.dbeaver.model.net.DBWNetworkProfile;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorDescriptor;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorRegistry;
import org.jkiss.dbeaver.registry.network.NetworkHandlerDescriptor;
import org.jkiss.dbeaver.registry.network.NetworkHandlerRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public abstract class PrefPageNetworkProfiles
extends AbstractPrefPage {
    private static final Log log = Log.getLog(PrefPageNetworkProfiles.class);
    private Table profilesTable;
    private TabFolder handlersFolder;
    private ToolItem deleteProfileItem;
    private ToolItem copyProfileItem;
    private final List<NetworkHandlerDescriptor> allHandlers = new ArrayList<NetworkHandlerDescriptor>();
    private DBWNetworkProfile selectedProfile;
    private final Map<NetworkHandlerDescriptor, HandlerBlock> configurations = new HashMap<NetworkHandlerDescriptor, HandlerBlock>();

    protected abstract DBSSecretController getSecretController() throws DBException;

    protected abstract List<DBWNetworkProfile> getDefaultNetworkProfiles();

    protected abstract void updateNetworkProfiles(List<DBWNetworkProfile> var1);

    protected abstract DBWNetworkProfile createNewProfile(@Nullable DBWNetworkProfile var1);

    protected abstract boolean deleteProfile(DBWNetworkProfile var1);

    public PrefPageNetworkProfiles() {
        this.noDefaultAndApplyButton();
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        CustomSashForm divider = UIUtils.createPartDivider(null, (Composite)parent, (int)256);
        Composite profilesGroup = UIUtils.createComposite((Composite)divider, (int)1);
        profilesGroup.setLayoutData((Object)new GridData(1808));
        this.createProfilesTable(profilesGroup);
        this.createProfilesToolBar(profilesGroup);
        Composite handlersComp = UIUtils.createComposite((Composite)divider, (int)1);
        this.preCreateHandlerControls(handlersComp);
        this.handlersFolder = new TabFolder(handlersComp, 0x800080);
        this.handlersFolder.setLayoutData((Object)new GridData(1808));
        for (NetworkHandlerDescriptor nhd : NetworkHandlerRegistry.getInstance().getDescriptors()) {
            if (nhd.hasObjectTypes() || !this.isHandlerApplicable((DBWHandlerDescriptor)nhd)) continue;
            this.createHandlerTab(nhd);
        }
        this.handlersFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageNetworkProfiles.this.updateControlsState();
            }
        });
        this.postCreateHandlerControls(handlersComp);
        divider.setWeights(new int[]{300, 700});
        if (this.isInitOnCreate()) {
            this.performDefaults();
        }
        return divider;
    }

    protected boolean isHandlerApplicable(DBWHandlerDescriptor nhd) {
        return true;
    }

    protected boolean isInitOnCreate() {
        return true;
    }

    public DBWNetworkProfile getSelectedProfile() {
        return this.selectedProfile;
    }

    public void loadSettings() {
        this.performDefaults();
    }

    private void createProfilesTable(Composite profilesGroup) {
        this.profilesTable = new Table(profilesGroup, 4);
        GridData gd = new GridData(1808);
        gd.minimumWidth = 150;
        this.profilesTable.setLayoutData((Object)gd);
        this.profilesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageNetworkProfiles.this.saveHandlerSettings();
                Object[] selection = PrefPageNetworkProfiles.this.profilesTable.getSelection();
                PrefPageNetworkProfiles.this.selectedProfile = ArrayUtils.isEmpty((Object[])selection) ? null : (DBWNetworkProfile)selection[0].getData();
                PrefPageNetworkProfiles.this.updateSelectedProfile(PrefPageNetworkProfiles.this.selectedProfile);
                PrefPageNetworkProfiles.this.updateControlsState();
            }
        });
    }

    private void createProfilesToolBar(Composite profilesGroup) {
        ToolBar toolbar = new ToolBar(profilesGroup, 131328);
        UIUtils.createToolItem((ToolBar)toolbar, (String)UIConnectionMessages.pref_page_network_profiles_tool_create_title, (String)UIConnectionMessages.pref_page_network_profiles_tool_create_text, (DBPImage)UIIcon.ROW_ADD, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageNetworkProfiles.this.createAndShowProfile(null);
            }
        });
        this.deleteProfileItem = UIUtils.createToolItem((ToolBar)toolbar, (String)UIConnectionMessages.pref_page_network_profiles_tool_delete_title, (String)UIConnectionMessages.pref_page_network_profiles_tool_delete_text, (DBPImage)UIIcon.ROW_DELETE, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PrefPageNetworkProfiles.this.deleteProfile(PrefPageNetworkProfiles.this.selectedProfile)) {
                    int index = PrefPageNetworkProfiles.this.profilesTable.getSelectionIndex();
                    PrefPageNetworkProfiles.this.profilesTable.remove(index);
                    PrefPageNetworkProfiles.this.profilesTable.select(CommonUtils.clamp((int)index, (int)0, (int)(PrefPageNetworkProfiles.this.profilesTable.getItemCount() - 1)));
                    PrefPageNetworkProfiles.this.profilesTable.notifyListeners(13, new Event());
                    PrefPageNetworkProfiles.this.updateControlsState();
                }
            }
        });
        this.copyProfileItem = UIUtils.createToolItem((ToolBar)toolbar, (String)UIConnectionMessages.pref_page_network_profiles_tool_copy_title, (String)UIConnectionMessages.pref_page_network_profiles_tool_copy_text, (DBPImage)UIIcon.ROW_COPY, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageNetworkProfiles.this.createAndShowProfile(PrefPageNetworkProfiles.this.selectedProfile);
            }
        });
    }

    private void createAndShowProfile(DBWNetworkProfile sourceProfile) {
        DBWNetworkProfile newProfile = this.createNewProfile(sourceProfile);
        if (newProfile == null) {
            return;
        }
        if (sourceProfile != null) {
            newProfile.setProperties(new LinkedHashMap(sourceProfile.getProperties()));
            for (DBWHandlerConfiguration configuration : sourceProfile.getConfigurations()) {
                newProfile.getConfigurations().add(new DBWHandlerConfiguration(configuration));
            }
            for (HandlerBlock handler : this.configurations.values()) {
                DBWHandlerConfiguration configuration = handler.loadedConfigs.get(sourceProfile);
                if (configuration == null) continue;
                handler.loadedConfigs.put(newProfile, new DBWHandlerConfiguration(configuration));
            }
        }
        TableItem item = new TableItem(this.profilesTable, 0);
        item.setText(newProfile.getProfileName());
        item.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TYPE_DOCUMENT));
        item.setData((Object)newProfile);
        this.profilesTable.select(this.profilesTable.getItemCount() - 1);
        this.profilesTable.notifyListeners(13, new Event());
    }

    private void saveHandlerSettings() {
        if (this.selectedProfile == null) {
            return;
        }
        TabItem[] tabItemArray = this.handlersFolder.getItems();
        int n = tabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TabItem handlerTab = tabItemArray[n2];
            NetworkHandlerDescriptor handler = (NetworkHandlerDescriptor)handlerTab.getData();
            HandlerBlock handlerBlock = this.configurations.get(handler);
            DBWHandlerConfiguration handlerConfiguration = handlerBlock.loadedConfigs.get(this.selectedProfile);
            if (handlerBlock.useHandlerCheck.getSelection()) {
                if (handlerConfiguration == null) {
                    handlerConfiguration = new DBWHandlerConfiguration((DBWHandlerDescriptor)handler, null);
                }
                handlerConfiguration.setProperties(Collections.emptyMap());
                handlerBlock.configurator.saveSettings((Object)handlerConfiguration);
            }
            ++n2;
        }
    }

    private void updateControlsState() {
        NetworkHandlerDescriptor descriptor = this.getSelectedHandler();
        this.enableHandlerContent(descriptor);
        if (descriptor != null && this.selectedProfile != null) {
            HandlerBlock handlerBlock = this.configurations.get(descriptor);
            DBWHandlerConfiguration handlerConfiguration = handlerBlock.loadedConfigs.get(this.selectedProfile);
            if (handlerConfiguration == null) {
                handlerBlock.configurator.loadSettings((Object)new DBWHandlerConfiguration((DBWHandlerDescriptor)descriptor, null));
            } else {
                handlerBlock.configurator.loadSettings((Object)handlerConfiguration);
            }
        }
        this.deleteProfileItem.setEnabled(this.selectedProfile != null);
        this.copyProfileItem.setEnabled(this.selectedProfile != null);
    }

    @Nullable
    private NetworkHandlerDescriptor getSelectedHandler() {
        Object[] selection = this.handlersFolder.getSelection();
        return ArrayUtils.isEmpty((Object[])selection) ? null : (NetworkHandlerDescriptor)selection[0].getData();
    }

    private void createHandlerTab(final NetworkHandlerDescriptor descriptor) {
        IObjectPropertyConfigurator configurator;
        try {
            String implName = descriptor.getHandlerType().getImplName();
            UIPropertyConfiguratorDescriptor configDescriptor = UIPropertyConfiguratorRegistry.getInstance().getDescriptor(implName);
            if (configDescriptor == null) {
                return;
            }
            configurator = configDescriptor.createConfigurator();
        }
        catch (DBException e) {
            log.error((Object)("Can't create network configurator '" + descriptor.getId() + "'"), (Throwable)e);
            return;
        }
        this.allHandlers.add(descriptor);
        TabItem tabItem = new TabItem(this.handlersFolder, 0);
        tabItem.setText(descriptor.getLabel());
        tabItem.setToolTipText(descriptor.getDescription());
        tabItem.setData((Object)descriptor);
        Composite composite = new Composite((Composite)this.handlersFolder, 0);
        tabItem.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        final Button useHandlerCheck = UIUtils.createCheckbox((Composite)composite, (String)NLS.bind((String)UIConnectionMessages.dialog_tunnel_checkbox_use_handler, (Object)descriptor.getLabel()), (boolean)false);
        useHandlerCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PrefPageNetworkProfiles.this.selectedProfile == null) {
                    useHandlerCheck.setSelection(false);
                    UIUtils.showMessageBox((Shell)PrefPageNetworkProfiles.this.getShell(), (String)UIConnectionMessages.pref_page_network_profiles_tool_no_profile_error_title, (String)UIConnectionMessages.pref_page_network_profiles_tool_no_profile_error_information, (int)2);
                    return;
                }
                HandlerBlock handlerBlock = PrefPageNetworkProfiles.this.configurations.get(descriptor);
                DBWHandlerConfiguration handlerConfiguration = handlerBlock.loadedConfigs.get(PrefPageNetworkProfiles.this.selectedProfile);
                if (handlerConfiguration == null) {
                    handlerConfiguration = new DBWHandlerConfiguration((DBWHandlerDescriptor)descriptor, null);
                    handlerBlock.loadedConfigs.put(PrefPageNetworkProfiles.this.selectedProfile, handlerConfiguration);
                }
                handlerConfiguration.setEnabled(useHandlerCheck.getSelection());
                PrefPageNetworkProfiles.this.enableHandlerContent(descriptor);
            }
        });
        Composite handlerComposite = UIUtils.createPlaceholder((Composite)composite, (int)1);
        this.configurations.put(descriptor, new HandlerBlock((IObjectPropertyConfigurator<Object, DBWHandlerConfiguration>)configurator, handlerComposite, useHandlerCheck));
        handlerComposite.setLayoutData((Object)new GridData(1808));
        configurator.createControl(handlerComposite, (Object)descriptor, () -> ((PrefPageNetworkProfiles)this).updateApplyButton());
        this.enableHandlerContent(descriptor);
    }

    protected void updateSelectedProfile(DBWNetworkProfile profile) {
    }

    protected void preCreateHandlerControls(Composite composite) {
    }

    protected void postCreateHandlerControls(Composite composite) {
    }

    private void enableHandlerContent(NetworkHandlerDescriptor descriptor) {
        HandlerBlock handlerBlock = this.configurations.get(descriptor);
        DBWHandlerConfiguration handlerConfiguration = handlerBlock.loadedConfigs.get(this.selectedProfile);
        handlerBlock.useHandlerCheck.setSelection(handlerConfiguration != null && handlerConfiguration.isEnabled());
        if (handlerConfiguration != null && handlerConfiguration.isEnabled()) {
            if (handlerBlock.blockEnableState != null) {
                handlerBlock.blockEnableState.restore();
                handlerBlock.blockEnableState = null;
            }
        } else if (handlerBlock.blockEnableState == null) {
            handlerBlock.blockEnableState = ControlEnableState.disable((Control)handlerBlock.blockControl);
        }
    }

    public void saveSettings(DBWNetworkProfile profile) {
        for (HandlerBlock handlerBlock : this.configurations.values()) {
            DBWHandlerConfiguration configuration = handlerBlock.loadedConfigs.get(profile);
            if (configuration == null) continue;
            profile.updateConfiguration(configuration);
        }
    }

    protected void performDefaults() {
        DBSSecretController secretController;
        super.performDefaults();
        this.profilesTable.removeAll();
        try {
            secretController = this.getSecretController();
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("No secret controller", null, (Throwable)e);
            return;
        }
        for (DBWNetworkProfile profile : this.getDefaultNetworkProfiles()) {
            if (secretController != null) {
                try {
                    profile.resolveSecrets(secretController);
                }
                catch (DBException dBException) {
                    log.error((Object)("Error resolving secret configuration for profile " + profile.getProfileId()));
                }
            }
            TableItem item = new TableItem(this.profilesTable, 0);
            item.setText(profile.getProfileName());
            item.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TYPE_DOCUMENT));
            item.setData((Object)profile);
            if (this.selectedProfile == null) {
                this.selectedProfile = profile;
                this.profilesTable.select(0);
                this.updateSelectedProfile(this.selectedProfile);
            }
            for (NetworkHandlerDescriptor nhd : this.allHandlers) {
                HandlerBlock handlerBlock = this.configurations.get(nhd);
                DBWHandlerConfiguration configuration = profile.getConfiguration((DBWHandlerDescriptor)nhd);
                if (configuration == null) continue;
                handlerBlock.loadedConfigs.put(profile, configuration);
            }
        }
        this.updateControlsState();
    }

    public boolean performOk() {
        this.saveHandlerSettings();
        ArrayList<DBWNetworkProfile> allProfiles = new ArrayList<DBWNetworkProfile>();
        TableItem[] tableItemArray = this.profilesTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            DBWNetworkProfile profile = (DBWNetworkProfile)item.getData();
            this.saveSettings(profile);
            allProfiles.add(profile);
            ++n2;
        }
        this.updateNetworkProfiles(allProfiles);
        return super.performOk();
    }

    public void applyData(Object data) {
        String profileId = CommonUtils.toString((Object)data);
        DBWNetworkProfile profile = null;
        for (DBWNetworkProfile p : this.getDefaultNetworkProfiles()) {
            if (!p.getProfileId().equals(profileId)) continue;
            profile = p;
            break;
        }
        if (profile != null) {
            TableItem[] items = this.profilesTable.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].getData() == profile) {
                    this.profilesTable.select(i);
                    this.profilesTable.notifyListeners(13, new Event());
                    break;
                }
                ++i;
            }
        }
    }

    private static class HandlerBlock {
        private final IObjectPropertyConfigurator<Object, DBWHandlerConfiguration> configurator;
        private final Composite blockControl;
        private final Button useHandlerCheck;
        private ControlEnableState blockEnableState;
        private final Map<DBWNetworkProfile, DBWHandlerConfiguration> loadedConfigs = new HashMap<DBWNetworkProfile, DBWHandlerConfiguration>();

        private HandlerBlock(IObjectPropertyConfigurator<Object, DBWHandlerConfiguration> configurator, Composite blockControl, Button useHandlerCheck) {
            this.configurator = configurator;
            this.blockControl = blockControl;
            this.useHandlerCheck = useHandlerCheck;
        }
    }
}

