/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.lightgrid;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridCellRenderer;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridColumnRenderer;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridColumn;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridContentProvider;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridLabelProvider;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridRow;
import org.jkiss.dbeaver.ui.controls.lightgrid.LightGrid;
import org.jkiss.utils.CommonUtils;

public class GridColumn
implements IGridColumn {
    private static final int DEFAULT_WIDTH = 10;
    static final int topMargin = 6;
    static final int bottomMargin = 6;
    private static final int leftMargin = 6;
    private static final int rightMargin = 6;
    private static final int imageSpacing = 3;
    private static final int insideMargin = 3;
    private final LightGrid grid;
    private final Object element;
    private final GridColumn parent;
    private List<GridColumn> children;
    private final int level;
    private int width = 10;
    private int height = -1;
    private int pinIndex = -1;

    public GridColumn(LightGrid grid, Object element) {
        this.grid = grid;
        this.element = element;
        this.parent = null;
        this.level = 0;
        grid.newColumn(this, -1);
    }

    public GridColumn(GridColumn parent, Object element) {
        this.grid = parent.grid;
        this.element = element;
        this.parent = parent;
        this.level = parent.level + 1;
        parent.addChild(this);
        this.grid.newColumn(this, -1);
    }

    @Override
    public Object getElement() {
        return this.element;
    }

    @Override
    public int getIndex() {
        return this.grid.indexOf(this);
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.setWidth(width, true);
    }

    void setWidth(int width, boolean redraw) {
        int delta = width - this.width;
        this.width = width;
        GridColumn pc = this.parent;
        while (pc != null) {
            pc.width += delta;
            pc = pc.parent;
        }
        if (redraw) {
            this.grid.setScrollValuesObsolete();
            this.grid.redraw();
        }
    }

    public boolean isPinned() {
        return this.pinIndex >= 0 || this.parent != null && this.parent.isPinned();
    }

    public int getPinIndex() {
        return this.parent == null ? this.pinIndex : this.parent.getPinIndex();
    }

    public void setPinIndex(int pinIndex) {
        this.pinIndex = pinIndex;
    }

    public boolean isOverFilterButton(int x, int y) {
        if (!this.isFilterable()) {
            return false;
        }
        Rectangle bounds = this.getBounds();
        Rectangle filterBounds = GridColumnRenderer.getFilterControlBounds();
        filterBounds.x = bounds.width - filterBounds.width - 6;
        filterBounds.y = bounds.y + 6;
        return filterBounds.contains(x, y);
    }

    public boolean isOverSortArrow(int x, int y) {
        IGridContentProvider contentProvider = this.grid.getContentProvider();
        if (contentProvider.getSortOrder(this) <= 0 && !contentProvider.isElementSupportsSort(this)) {
            return false;
        }
        Rectangle bounds = this.getBounds();
        Rectangle sortBounds = GridColumnRenderer.getSortControlBounds();
        sortBounds.x = bounds.width - sortBounds.width - 6;
        sortBounds.y = bounds.y + 6;
        if (this.isFilterable()) {
            sortBounds.x -= GridColumnRenderer.getFilterControlBounds().width + 3;
        }
        return sortBounds.contains(x, y);
    }

    public boolean isOverIcon(int x, int y) {
        Rectangle bounds = this.getBounds();
        Image image = this.grid.getLabelProvider().getImage(this);
        if (image == null) {
            return false;
        }
        Rectangle imgBounds = image.getBounds();
        imgBounds.x += bounds.x + 6;
        imgBounds.y += bounds.y + 6;
        return imgBounds.contains(x, y);
    }

    int getHeaderHeight(boolean includeChildren, boolean forceRefresh) {
        if (forceRefresh) {
            this.height = -1;
        }
        if (this.height < 0) {
            String description;
            this.height = 6 + this.grid.fontMetrics.getHeight() + 6;
            Image image = this.grid.getLabelProvider().getImage(this);
            if (image != null) {
                this.height = Math.max(this.height, 6 + image.getBounds().height + 6);
            }
            if (!CommonUtils.isEmpty((String)(description = this.grid.getLabelProvider().getDescription(this)))) {
                this.height += 6 + this.grid.fontMetrics.getHeight();
            }
        }
        int childHeight = 0;
        if (includeChildren && !CommonUtils.isEmpty(this.children)) {
            for (GridColumn child : this.children) {
                childHeight = Math.max(childHeight, child.getHeaderHeight(true, false));
            }
        }
        return this.height + childHeight;
    }

    int computeHeaderWidth(GC gc) {
        int textWidth;
        int x = 6;
        IGridLabelProvider labelProvider = this.grid.getLabelProvider();
        Image image = labelProvider.getImage(this);
        if (image != null) {
            x += image.getBounds().width + 3;
        }
        if (Boolean.TRUE.equals(labelProvider.getGridOption("OPTION_EXCLUDE_COLUMN_NAME_FOR_WIDTH_CALC"))) {
            textWidth = gc.stringExtent((String)"X").x;
        } else {
            int descWidth;
            String text = labelProvider.getText(this);
            String description = labelProvider.getDescription(this);
            textWidth = gc.stringExtent((String)text).x;
            if (!CommonUtils.isEmpty((String)description) && (descWidth = gc.stringExtent((String)description).x) > textWidth) {
                textWidth = descWidth;
            }
        }
        x += textWidth + 6;
        if (this.isSortable()) {
            x += 6 + GridColumnRenderer.getSortControlBounds().width + 3;
        }
        x += GridColumnRenderer.getFilterControlBounds().width;
        if (!CommonUtils.isEmpty(this.children)) {
            int childWidth = 0;
            for (GridColumn child : this.children) {
                childWidth += child.computeHeaderWidth(gc);
            }
            return Math.max(x, childWidth);
        }
        return x;
    }

    public boolean isSortable() {
        return this.grid.getContentProvider().getSortOrder(this) != 0;
    }

    public boolean isFilterable() {
        return this.grid.getContentProvider().isElementSupportsFilter(this);
    }

    void pack(GC gc, boolean reflect) {
        int newWidth = this.computeHeaderWidth(gc);
        if (CommonUtils.isEmpty(this.children)) {
            int topIndex = this.grid.getTopIndex();
            int bottomIndex = this.grid.getBottomIndex();
            if (topIndex >= 0 && bottomIndex >= topIndex) {
                int itemCount = this.grid.getItemCount();
                int i = topIndex;
                while (i <= bottomIndex && i < itemCount) {
                    newWidth = Math.max(newWidth, this.computeCellWidth(gc, this.grid.getRow(i)));
                    ++i;
                }
            }
        } else {
            int childrenWidth = 0;
            for (GridColumn child : this.children) {
                child.pack(gc, reflect);
                childrenWidth += child.getWidth();
            }
            if (newWidth > childrenWidth) {
                GridColumn lastChild = this.children.get(this.children.size() - 1);
                lastChild.setWidth(lastChild.getWidth() + newWidth - childrenWidth);
            } else {
                newWidth = childrenWidth;
            }
        }
        if (reflect) {
            this.setWidth(newWidth, false);
        } else {
            this.width = newWidth;
        }
    }

    private int computeCellWidth(GC gc, IGridRow row) {
        Rectangle imageBounds;
        int x = 0;
        x += 6;
        IGridContentProvider.CellInformation cellInfo = this.grid.getContentProvider().getCellInfo(this, row, false);
        String cellText = this.grid.getCellText(cellInfo.text);
        int state = cellInfo.state;
        if (GridCellRenderer.isLinkState(state)) {
            imageBounds = GridCellRenderer.LINK_IMAGE_BOUNDS;
        } else {
            DBPImage image = cellInfo.image;
            Rectangle rectangle = imageBounds = image == null ? null : DBeaverIcons.getImage((DBPImage)image).getBounds();
        }
        if (imageBounds != null) {
            x += imageBounds.width + 3;
        }
        return x += gc.textExtent((String)cellText).x + 6;
    }

    Rectangle getBounds() {
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        Point loc = this.grid.getOrigin(this, -1);
        bounds.x = loc.x;
        bounds.y = loc.y;
        bounds.width = this.getWidth();
        bounds.height = this.grid.getHeaderHeight();
        return bounds;
    }

    public LightGrid getGrid() {
        return this.grid;
    }

    @Nullable
    public String getHeaderTooltip() {
        String tip = this.grid.getLabelProvider().getToolTipText(this);
        if (tip == null) {
            tip = this.grid.getLabelProvider().getText(this);
        }
        return tip;
    }

    @Override
    public GridColumn getParent() {
        return this.parent;
    }

    @Override
    public List<GridColumn> getChildren() {
        return this.children;
    }

    private void addChild(GridColumn gridColumn) {
        if (this.children == null) {
            this.children = new ArrayList<GridColumn>();
        }
        this.children.add(gridColumn);
    }

    private void removeChild(GridColumn column) {
        this.children.remove(column);
    }

    public boolean isParent(GridColumn col) {
        GridColumn p = this.parent;
        while (p != null) {
            if (p == col) {
                return true;
            }
            p = p.parent;
        }
        return false;
    }

    public GridColumn getFirstLeaf() {
        if (this.children == null) {
            return this;
        }
        return this.children.get(0).getFirstLeaf();
    }

    public String toString() {
        return CommonUtils.toString((Object)this.element);
    }
}

