/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseObject;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseReplication;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.utils.CommonUtils;

public class AltibaseReplicationItem
extends AltibaseObject<AltibaseReplication> {
    private String tableOid;
    private String replObjFrom;
    private String replObjTo;
    private boolean isPartitionedRepl;
    private long invalidMaxSn;

    protected AltibaseReplicationItem(AltibaseReplication parent, JDBCResultSet resultSet) {
        super(parent, String.valueOf(JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"TABLE_OID")), true);
        this.tableOid = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"TABLE_OID");
        this.isPartitionedRepl = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"REPLICATION_UNIT", (String)"P");
        this.invalidMaxSn = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"INVALID_MAX_SN");
        this.replObjFrom = this.getDottedName(JDBCUtils.safeGetString((ResultSet)resultSet, (String)"LOCAL_USER_NAME"), JDBCUtils.safeGetString((ResultSet)resultSet, (String)"LOCAL_TABLE_NAME"), JDBCUtils.safeGetString((ResultSet)resultSet, (String)"LOCAL_PARTITION_NAME"));
        this.replObjTo = this.getDottedName(JDBCUtils.safeGetString((ResultSet)resultSet, (String)"REMOTE_USER_NAME"), JDBCUtils.safeGetString((ResultSet)resultSet, (String)"REMOTE_TABLE_NAME"), JDBCUtils.safeGetString((ResultSet)resultSet, (String)"REMOTE_PARTITION_NAME"));
    }

    private String getDottedName(String schema, String table, String partition) {
        return schema + "." + table + (String)(CommonUtils.isEmpty((String)partition) ? "" : "." + partition);
    }

    @Override
    @Property(viewable=false, order=1, hidden=true)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public String getTableOid() {
        return this.tableOid;
    }

    @Property(viewable=true, order=5)
    @NotNull
    public String getReplObjFrom() {
        return this.replObjFrom;
    }

    @Property(viewable=true, order=6)
    @NotNull
    public String getReplObjTo() {
        return this.replObjTo;
    }

    @Property(viewable=true, order=10)
    public boolean getIsPartitionedRepl() {
        return this.isPartitionedRepl;
    }

    @Property(viewable=true, order=11)
    public long getInvalidMaxSn() {
        return this.invalidMaxSn;
    }
}

