/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.altibase.model.AltibasePrivTable;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDPseudoAttribute;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.ByteNumberFormat;
import org.jkiss.utils.CommonUtils;

public class AltibaseTable
extends GenericTable
implements DBPNamedObject2,
DBPObjectStatistics {
    private static final Log log = Log.getLog(AltibaseTable.class);
    private volatile transient Long[] tableSize;
    private static final int SIZE_IDX_MEM = 0;
    private static final int SIZE_IDX_DISK = 1;
    private String tablespace;
    private boolean partitioned;
    private final TablePrivCache tablePrivCache = new TablePrivCache();

    public AltibaseTable(GenericStructContainer container, String tableName, String tableType, JDBCResultSet dbResult) {
        super(container, tableName, tableType, dbResult);
    }

    protected boolean isTruncateSupported() {
        return true;
    }

    protected void appendSelectSource(DBRProgressMonitor monitor, StringBuilder query, String tableAlias, DBDPseudoAttribute rowIdAttribute) {
        try {
            Object tableAliasName = tableAlias != null ? tableAlias + "." : "";
            List attributes = this.getAttributes(monitor);
            boolean hasGeometryColumns = CommonUtils.safeCollection((Collection)attributes).stream().anyMatch(e -> "GEOMETRY".equalsIgnoreCase(e.getTypeName()));
            if (!hasGeometryColumns) {
                super.appendSelectSource(monitor, query, tableAlias, rowIdAttribute);
                return;
            }
            int i = 0;
            for (GenericTableColumn col : CommonUtils.safeCollection((Collection)attributes)) {
                String columnName = DBUtils.getQuotedIdentifier((DBSObject)col);
                if (i++ > 0) {
                    query.append(",");
                }
                if ("GEOMETRY".equalsIgnoreCase(col.getTypeName())) {
                    query.append("ASEWKT(").append((String)tableAliasName).append(columnName).append(", 32000) as ").append(columnName);
                    continue;
                }
                query.append((String)tableAliasName).append(columnName).append(" as ").append(columnName);
            }
        }
        catch (DBException e2) {
            log.warn((Object)"Can't read table attributes.", (Throwable)e2);
        }
    }

    @Property(viewable=false, hidden=true)
    public String getTableType() {
        return super.getTableType();
    }

    @Property(viewable=true, order=20, editable=false, formatter=ByteNumberFormat.class, category="Statistics")
    public Long getTableSize(DBRProgressMonitor monitor) throws DBCException {
        if (!this.hasStatistics()) {
            this.loadSize(monitor);
        }
        return this.tableSize[0] + this.tableSize[1];
    }

    @Property(viewable=true, order=22, editable=false, formatter=ByteNumberFormat.class)
    public Long getTableSizeInMemory(DBRProgressMonitor monitor) throws DBCException {
        if (!this.hasStatistics()) {
            this.loadSize(monitor);
        }
        return this.tableSize[0];
    }

    @Property(viewable=true, order=23, editable=false, formatter=ByteNumberFormat.class)
    public Long getTableSizeInDisk(DBRProgressMonitor monitor) throws DBCException {
        if (!this.hasStatistics()) {
            this.loadSize(monitor);
        }
        return this.tableSize[1];
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.tableSize = null;
        this.getTableSize(monitor);
        this.getTablespace(monitor);
        this.tablePrivCache.clearCache();
        return super.refreshObject(monitor);
    }

    @Property(viewable=true, order=15, editable=false)
    public String getTablespace(DBRProgressMonitor monitor) throws DBException {
        if (this.tablespace != null) {
            return this.tablespace;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load tablespace");){
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT tbs_name, is_partitioned FROM system_.sys_tables_ t, system_.sys_users_ u WHERE u.user_id = t.user_id AND u.user_name = ? AND t.table_name = ?");){
                    dbStat.setString(1, this.getSchema().getName());
                    dbStat.setString(2, this.getName());
                    Throwable throwable3 = null;
                    Object var9_15 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        if (dbResult.next()) {
                            this.tablespace = JDBCUtils.safeGetString((ResultSet)dbResult, (int)1);
                            this.partitioned = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (int)2, (String)"Y");
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new DBCException("Error reading tablespace name", (Throwable)e);
        }
        return this.tablespace;
    }

    @Property(viewable=true, order=16, editable=false)
    public boolean getPartitionedTable(DBRProgressMonitor monitor) throws DBException {
        if (this.tablespace == null) {
            this.getTablespace(monitor);
        }
        return this.partitioned;
    }

    public boolean hasStatistics() {
        return this.tableSize != null;
    }

    public long getStatObjectSize() {
        return !this.hasStatistics() ? 0L : this.tableSize[0] + this.tableSize[1];
    }

    private void loadSize(DBRProgressMonitor monitor) throws DBCException {
        this.resetSize();
        try {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table status");){
                    Throwable throwable2 = null;
                    Object var6_10 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT memory_size, disk_size FROM system_.sys_table_size_ WHERE USER_NAME = ? AND TABLE_NAME = ?");){
                        dbStat.setString(1, this.getSchema().getName());
                        dbStat.setString(2, this.getName());
                        Throwable throwable3 = null;
                        Object var9_15 = null;
                        try (JDBCResultSet dbResult = dbStat.executeQuery();){
                            if (dbResult.next()) {
                                this.fetchTableSize(dbResult);
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new DBCException("Error reading table statistics", (Throwable)e);
            }
        }
        finally {
            if (!this.hasStatistics()) {
                this.resetSize();
            }
        }
    }

    protected void fetchTableSize(JDBCResultSet dbResult) throws SQLException {
        if (this.tableSize == null) {
            this.resetSize();
        }
        this.tableSize[0] = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"MEMORY_SIZE");
        this.tableSize[1] = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"DISK_SIZE");
    }

    protected void resetSize() {
        this.tableSize = new Long[2];
        int i = 0;
        while (i < 2) {
            this.tableSize[i] = 0L;
            ++i;
        }
    }

    @Nullable
    public DBPPropertySource getStatProperties() {
        return null;
    }

    @Association
    public Collection<AltibasePrivTable> getTablePrivs(DBRProgressMonitor monitor) throws DBException {
        return this.tablePrivCache.getAllObjects(monitor, (DBSObject)this);
    }

    static class TablePrivCache
    extends JDBCObjectCache<AltibaseTable, AltibasePrivTable> {
        TablePrivCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull AltibaseTable tableBase) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT grantor.user_name AS grantor_name , grantee.user_name AS grantee_name , DECODE(grantee.user_type, 'U', 'User', 'R', 'Role') as grantee_type ,p.priv_name AS priv_name ,g.with_grant_option AS with_grant_option FROM system_.sys_users_ schema ,system_.sys_users_ grantor ,system_.sys_users_ grantee ,system_.sys_grant_object_ g ,system_.sys_privileges_ p ,system_.sys_tables_ t WHERE schema.user_name = ? AND t.table_name = ? AND schema.user_id = t.user_id AND g.grantee_id = grantee.user_id AND g.grantor_id = grantor.user_id AND g.priv_id = p.priv_id AND p.priv_type = 1 AND g.obj_id = t.table_id ORDER BY priv_name, grantor_name, grantee_name");
            dbStat.setString(1, tableBase.getSchema().getName());
            dbStat.setString(2, tableBase.getName());
            return dbStat;
        }

        protected AltibasePrivTable fetchObject(@NotNull JDBCSession session, @NotNull AltibaseTable tableBase, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new AltibasePrivTable(tableBase, (ResultSet)resultSet);
        }
    }
}

