/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.import_config.dbvis;

import java.io.File;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.import_config.dbvis.DbvisAbstractConfigurationCreator;
import org.jkiss.dbeaver.ext.import_config.wizards.ImportConnectionInfo;
import org.jkiss.dbeaver.ext.import_config.wizards.ImportData;
import org.jkiss.dbeaver.ext.import_config.wizards.ImportDriverInfo;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLException;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DbvisConfigurationCreatorv7
extends DbvisAbstractConfigurationCreator {
    public static final String VERSION = "version.7.x.x";
    public static final String CONFIG_FOLDER = "config70";
    public static final String CONFIG_FILE = "dbvis.xml";

    @Override
    public ImportData create(ImportData importData, File configFile) throws DBException {
        try {
            Element databasesElement;
            Document configDocument = XMLUtils.parseDocument((File)configFile);
            Element driversElement = XMLUtils.getChildElement((Element)configDocument.getDocumentElement(), (String)"Drivers");
            if (driversElement != null) {
                for (Element driverElement : XMLUtils.getChildElementList((Element)driversElement, (String)"Driver")) {
                    String name = XMLUtils.getChildElementBody((Element)driverElement, (String)"Name");
                    String sampleURL = XMLUtils.getChildElementBody((Element)driverElement, (String)"URLFormat");
                    String driverClass = XMLUtils.getChildElementBody((Element)driverElement, (String)"DefaultClass");
                    String lastName = XMLUtils.getChildElementBody((Element)driverElement, (String)"LastName");
                    if (CommonUtils.isEmpty((String)name) || CommonUtils.isEmpty((String)sampleURL) || CommonUtils.isEmpty((String)driverClass)) continue;
                    ImportDriverInfo driver = new ImportDriverInfo(null, name, sampleURL, driverClass);
                    if (!CommonUtils.isEmpty((String)lastName)) {
                        driver.setDescription(lastName);
                    }
                    this.adaptSampleUrl(driver);
                    Element locationsElement = XMLUtils.getChildElement((Element)driverElement, (String)"Locations");
                    if (locationsElement != null) {
                        for (Element locationElement : XMLUtils.getChildElementList((Element)locationsElement, (String)"Location")) {
                            String path = XMLUtils.getChildElementBody((Element)locationElement, (String)"Path");
                            if (CommonUtils.isEmpty((String)path)) continue;
                            driver.addLibrary(path);
                        }
                    }
                    importData.addDriver(driver);
                }
            }
            if ((databasesElement = XMLUtils.getChildElement((Element)configDocument.getDocumentElement(), (String)"Databases")) != null) {
                for (Element dbElement : XMLUtils.getChildElementList((Element)databasesElement, (String)"Database")) {
                    ImportDriverInfo driver;
                    Element driverElement;
                    String alias = XMLUtils.getChildElementBody((Element)dbElement, (String)"Alias");
                    String url = XMLUtils.getChildElementBody((Element)dbElement, (String)"Url");
                    String driverName = XMLUtils.getChildElementBody((Element)dbElement, (String)"Driver");
                    String user = XMLUtils.getChildElementBody((Element)dbElement, (String)"Userid");
                    String password = null;
                    String hostName = null;
                    String port = null;
                    String database = null;
                    Element urlVarsElement = XMLUtils.getChildElement((Element)dbElement, (String)"UrlVariables");
                    if (urlVarsElement != null && (driverElement = XMLUtils.getChildElement((Element)urlVarsElement, (String)"Driver")) != null) {
                        for (Element urlVarElement : XMLUtils.getChildElementList((Element)driverElement, (String)"UrlVariable")) {
                            String varName = urlVarElement.getAttribute("UrlVariableName");
                            String varValue = XMLUtils.getElementBody((Element)urlVarElement);
                            if ("Server".equals(varName)) {
                                hostName = varValue;
                                continue;
                            }
                            if ("Port".equals(varName)) {
                                port = varValue;
                                continue;
                            }
                            if (!"Database".equals(varName)) continue;
                            database = varValue;
                        }
                    }
                    if (CommonUtils.isEmpty((String)alias) || CommonUtils.isEmpty((String)driverName) || CommonUtils.isEmpty((String)url) && CommonUtils.isEmpty(hostName) || (driver = importData.getDriver(driverName)) == null) continue;
                    ImportConnectionInfo connectionInfo = new ImportConnectionInfo(driver, dbElement.getAttribute("id"), alias, url, hostName, port, database, user, password);
                    importData.addConnection(connectionInfo);
                }
            }
        }
        catch (XMLException e) {
            throw new DBException("Configuration parse error: " + e.getMessage());
        }
        return importData;
    }

    @Override
    public String getConfigurationFile() {
        return CONFIG_FILE;
    }

    @Override
    public String getConfigurationFolder() {
        return CONFIG_FOLDER;
    }

    @Override
    protected String substituteDriverName(String name) {
        return name;
    }
}

