/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.import_config.wizards;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.import_config.ImportConfigMessages;
import org.jkiss.dbeaver.ext.import_config.wizards.ConfigImportWizard;
import org.jkiss.dbeaver.ext.import_config.wizards.ImportConnectionInfo;
import org.jkiss.dbeaver.ext.import_config.wizards.ImportData;
import org.jkiss.dbeaver.ext.import_config.wizards.ImportDriverInfo;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ConnectionFolderSelector;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.dialogs.ObjectListDialog;
import org.jkiss.utils.CommonUtils;

public abstract class ConfigImportWizardPage
extends ActiveWizardPage<ConfigImportWizard> {
    private Table connectionTable;
    private ImportData importData;
    private ConnectionFolderSelector folderSelector;

    protected ConfigImportWizardPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        Composite placeholder = new Composite(parent, 0);
        placeholder.setLayout((Layout)new GridLayout(1, true));
        UIUtils.createControlLabel((Composite)placeholder, (String)ImportConfigMessages.config_import_wizard_page_caption_connections);
        this.connectionTable = new Table(placeholder, 2082);
        this.getConnectionTable().setHeaderVisible(true);
        this.getConnectionTable().setLinesVisible(true);
        this.getConnectionTable().setLayoutData((Object)new GridData(1808));
        UIUtils.createTableColumn((Table)this.getConnectionTable(), (int)16384, (String)ImportConfigMessages.config_import_wizard_page_th_name);
        UIUtils.createTableColumn((Table)this.getConnectionTable(), (int)16384, (String)ImportConfigMessages.config_import_wizard_page_th_driver);
        UIUtils.createTableColumn((Table)this.getConnectionTable(), (int)16384, (String)ImportConfigMessages.config_import_wizard_page_th_url);
        Composite buttonsPanel = UIUtils.createComposite((Composite)placeholder, (int)5);
        UIUtils.createDialogButton((Composite)buttonsPanel, (String)ImportConfigMessages.config_import_wizard_btn_select_all, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = ConfigImportWizardPage.this.getConnectionTable().getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    ((ImportConnectionInfo)item.getData()).setChecked(true);
                    item.setChecked(true);
                    ++n2;
                }
                ConfigImportWizardPage.this.getContainer().updateButtons();
            }
        });
        UIUtils.createDialogButton((Composite)buttonsPanel, (String)ImportConfigMessages.config_import_wizard_btn_deselect_all, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = ConfigImportWizardPage.this.getConnectionTable().getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    item.setChecked(false);
                    ((ImportConnectionInfo)item.getData()).setChecked(false);
                    ++n2;
                }
                ConfigImportWizardPage.this.getContainer().updateButtons();
            }
        });
        UIUtils.createDialogButton((Composite)buttonsPanel, (String)ImportConfigMessages.config_import_wizard_btn_set_driver, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selection = ConfigImportWizardPage.this.getConnectionTable().getSelection();
                if (selection != null && selection.length > 0) {
                    TableItem[] tableItemArray = selection;
                    int n = selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        Object object = item.getData();
                        if (object instanceof ImportConnectionInfo) {
                            ImportConnectionInfo connectionInfo = (ImportConnectionInfo)object;
                            ConfigImportWizardPage.this.setConnectionInfoForItem(ConfigImportWizardPage.this.setDriverForConnection(connectionInfo), item);
                        }
                        ++n2;
                    }
                    ConfigImportWizardPage.this.isPageComplete();
                }
            }
        });
        this.folderSelector = new ConnectionFolderSelector(buttonsPanel);
        this.folderSelector.loadConnectionFolders(NavigatorUtils.getSelectedProject());
        UIUtils.packColumns((Table)this.getConnectionTable());
        this.getConnectionTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item = (TableItem)e.item;
                if (item == null) {
                    return;
                }
                Object object = item.getData();
                if (object instanceof ImportConnectionInfo) {
                    ImportConnectionInfo connectionInfo = (ImportConnectionInfo)object;
                    connectionInfo.setChecked(item.getChecked());
                }
                ConfigImportWizardPage.this.getContainer().updateButtons();
            }
        });
        this.setControl((Control)placeholder);
    }

    protected ImportConnectionInfo setDriverForConnection(ImportConnectionInfo connectionInfo) {
        DataSourceProviderRegistry registry = DataSourceProviderRegistry.getInstance();
        List<Object> matchedDrivers = new ArrayList();
        for (DataSourceProviderDescriptor dataSourceProvider : registry.getDataSourceProviders()) {
            for (DriverDescriptor driver : dataSourceProvider.getEnabledDrivers()) {
                matchedDrivers.add(driver);
            }
        }
        matchedDrivers = matchedDrivers.stream().sorted(Comparator.comparing(DriverDescriptor::getName)).collect(Collectors.toList());
        DriverDescriptor driver = (DriverDescriptor)ObjectListDialog.selectObject((Shell)this.getShell(), (String)("Choose driver for connection '" + connectionInfo.getAlias() + "'"), (String)"ImportDriverSelector", matchedDrivers);
        if (driver != null) {
            connectionInfo.setDriver(driver);
            connectionInfo.setDriverInfo(new ImportDriverInfo(connectionInfo.getAlias(), driver.getName(), driver.getSampleURL(), driver.getDriverClassName()));
        }
        return connectionInfo;
    }

    public void activatePage() {
        this.getConnectionTable().removeAll();
        this.importData = new ImportData();
        boolean loaded = false;
        try {
            this.loadConnections(this.importData);
            loaded = true;
        }
        catch (DBException e) {
            this.setMessage(e.getMessage(), 3);
        }
        this.getContainer().updateButtons();
        if (loaded) {
            if (CommonUtils.isEmpty(this.importData.getConnections())) {
                this.setMessage(ImportConfigMessages.config_import_wizard_page_label_connection_list, 2);
            } else {
                this.setMessage(null);
                for (ImportConnectionInfo connectionInfo : this.importData.getConnections()) {
                    TableItem item = new TableItem(this.getConnectionTable(), 0);
                    this.setConnectionInfoForItem(connectionInfo, item);
                }
            }
        }
        UIUtils.packColumns((Table)this.getConnectionTable());
    }

    private void setConnectionInfoForItem(ImportConnectionInfo connectionInfo, TableItem item) {
        if (connectionInfo.getDriverInfo() != null) {
            item.setImage(0, DBeaverIcons.getImage((DBPImage)DBIcon.TREE_DATABASE));
            item.setText(0, connectionInfo.getAlias());
            item.setText(1, connectionInfo.getDriverInfo().getName());
            String url = connectionInfo.getUrl();
            if (CommonUtils.isEmpty((String)url)) {
                url = connectionInfo.getHost();
            }
            if (CommonUtils.isEmpty((String)url)) {
                url = "jdbc:???";
            }
            item.setText(2, url);
            item.setData((Object)connectionInfo);
        } else {
            item.setImage(0, DBeaverIcons.getImage((DBPImage)DBIcon.DATABASE_DEFAULT));
            item.setText(0, connectionInfo.getAlias());
            item.setText(1, ImportConfigMessages.config_import_wizard_page_driver_unknown);
            item.setText(2, ImportConfigMessages.config_import_wizard_page_driver_unknown);
            item.setData((Object)connectionInfo);
        }
    }

    public void deactivatePage() {
        this.getImportData().setDataSourceFolder(this.folderSelector.getFolder());
        super.deactivatePage();
    }

    protected abstract void loadConnections(ImportData var1) throws DBException;

    public boolean isPageComplete() {
        if (this.getConnectionTable() == null) {
            return false;
        }
        TableItem[] tableItemArray = this.getConnectionTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Table getConnectionTable() {
        return this.connectionTable;
    }

    public ImportData getImportData() {
        return this.importData;
    }
}

