/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.editor;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PrintFigureOperation;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.gef.ui.actions.ZoomComboContributionItem;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.properties.UndoablePropertySheetEntry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.model.ERDAttributeVisibility;
import org.jkiss.dbeaver.erd.model.ERDContentProvider;
import org.jkiss.dbeaver.erd.model.ERDDiagram;
import org.jkiss.dbeaver.erd.model.ERDEntity;
import org.jkiss.dbeaver.erd.model.ERDNote;
import org.jkiss.dbeaver.erd.ui.action.DiagramLayoutAction;
import org.jkiss.dbeaver.erd.ui.action.DiagramToggleGridAction;
import org.jkiss.dbeaver.erd.ui.action.DiagramToggleHandAction;
import org.jkiss.dbeaver.erd.ui.directedit.StatusLineValidationMessageHandler;
import org.jkiss.dbeaver.erd.ui.dnd.DataEditDropTargetListener;
import org.jkiss.dbeaver.erd.ui.dnd.NodeDropTargetListener;
import org.jkiss.dbeaver.erd.ui.editor.ERDEditorContextMenuProvider;
import org.jkiss.dbeaver.erd.ui.editor.ERDGraphicalViewer;
import org.jkiss.dbeaver.erd.ui.editor.ERDHighlightingHandle;
import org.jkiss.dbeaver.erd.ui.editor.ERDHighlightingManager;
import org.jkiss.dbeaver.erd.ui.editor.ERDOutlinePage;
import org.jkiss.dbeaver.erd.ui.editor.ERDPalettePreferences;
import org.jkiss.dbeaver.erd.ui.editor.ERDPaletteViewerProvider;
import org.jkiss.dbeaver.erd.ui.editor.ERDViewStyle;
import org.jkiss.dbeaver.erd.ui.editor.tools.ChangeZOrderAction;
import org.jkiss.dbeaver.erd.ui.editor.tools.ResetPartColorAction;
import org.jkiss.dbeaver.erd.ui.editor.tools.SetPartColorAction;
import org.jkiss.dbeaver.erd.ui.editor.tools.SetPartSettingsAction;
import org.jkiss.dbeaver.erd.ui.export.ERDExportFormatHandler;
import org.jkiss.dbeaver.erd.ui.export.ERDExportFormatRegistry;
import org.jkiss.dbeaver.erd.ui.internal.ERDUIActivator;
import org.jkiss.dbeaver.erd.ui.internal.ERDUIMessages;
import org.jkiss.dbeaver.erd.ui.model.ERDContainerDecorated;
import org.jkiss.dbeaver.erd.ui.model.ERDContentProviderDecorated;
import org.jkiss.dbeaver.erd.ui.model.ERDDecorator;
import org.jkiss.dbeaver.erd.ui.model.ERDDecoratorDefault;
import org.jkiss.dbeaver.erd.ui.model.EntityDiagram;
import org.jkiss.dbeaver.erd.ui.notations.ERDNotationDescriptor;
import org.jkiss.dbeaver.erd.ui.notations.ERDNotationRegistry;
import org.jkiss.dbeaver.erd.ui.part.DBeaverNavigationKeyHandler;
import org.jkiss.dbeaver.erd.ui.part.DiagramPart;
import org.jkiss.dbeaver.erd.ui.part.EntityPart;
import org.jkiss.dbeaver.erd.ui.part.NodePart;
import org.jkiss.dbeaver.erd.ui.part.NotePart;
import org.jkiss.dbeaver.erd.ui.router.ERDConnectionRouterDescriptor;
import org.jkiss.dbeaver.erd.ui.router.ERDConnectionRouterRegistry;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceTask;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.EmptyAction;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.ISearchContextProvider;
import org.jkiss.dbeaver.ui.ISearchExecutor;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ProgressLoaderVisualizer;
import org.jkiss.dbeaver.ui.controls.ProgressPageControl;
import org.jkiss.dbeaver.ui.controls.PropertyPageStandard;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.IDatabaseModellerEditor;
import org.jkiss.dbeaver.ui.navigator.INavigatorModelView;
import org.jkiss.dbeaver.ui.navigator.actions.ToggleViewAction;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public abstract class ERDEditorPart
extends GraphicalEditorWithFlyoutPalette
implements DBPDataSourceTask,
IDatabaseModellerEditor,
ISearchContextProvider,
IRefreshablePart,
INavigatorModelView {
    private static final Log searcherLog = Log.getLog(Searcher.class);
    @Nullable
    protected ProgressControl progressControl;
    private PropertySheetPage undoablePropertySheetPage;
    private ScalableFreeformRootEditPart rootPart;
    private List<String> editPartActionIDs = new ArrayList<String>();
    private ERDOutlinePage outlinePage;
    private DefaultEditDomain editDomain;
    private boolean isDirty;
    private boolean isLoaded;
    protected LoadingJob<EntityDiagram> diagramLoadingJob;
    private IPropertyChangeListener configPropertyListener;
    private PaletteRoot paletteRoot;
    private volatile String errorMessage;
    private ERDContentProvider contentProvider;
    private ERDDecorator decorator;
    private ZoomComboContributionItem zoomCombo;
    private NavigatorViewerAdapter navigatorViewerAdapter;
    private ERDHighlightingManager highlightingManager = new ERDHighlightingManager();
    private String exportMruFilename = null;
    private ERDConnectionRouterDescriptor routerStyle;
    private ERDNotationDescriptor notationStyle;

    protected ERDEditorPart() {
    }

    public ERDContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = this.createContentProvider();
        }
        return this.contentProvider;
    }

    public ERDDecorator getDecorator() {
        if (this.decorator == null) {
            this.decorator = this.createDecorator();
        }
        return this.decorator;
    }

    @NotNull
    public ERDHighlightingManager getHighlightingManager() {
        return this.highlightingManager;
    }

    public DBNNode getRootNode() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof IDatabaseEditorInput) {
            return ((IDatabaseEditorInput)editorInput).getNavigatorNode();
        }
        return null;
    }

    @Nullable
    public Viewer getNavigatorViewer() {
        if (this.navigatorViewerAdapter == null) {
            this.navigatorViewerAdapter = new NavigatorViewerAdapter();
        }
        return this.navigatorViewerAdapter;
    }

    protected ERDContentProvider createContentProvider() {
        return new ERDContentProviderDecorated();
    }

    protected ERDDecorator createDecorator() {
        return new ERDDecoratorDefault();
    }

    protected ERDGraphicalViewer getGraphicalViewer() {
        return (ERDGraphicalViewer)super.getGraphicalViewer();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.rootPart = new ScalableFreeformRootEditPart();
        this.editDomain = new DefaultEditDomain((IEditorPart)this);
        this.setEditDomain(this.editDomain);
        super.init(site, input);
        this.configPropertyListener = new ConfigPropertyListener();
        ERDUIActivator.getDefault().getPreferenceStore().addPropertyChangeListener(this.configPropertyListener);
        if (this.routerStyle == null) {
            this.routerStyle = ERDConnectionRouterRegistry.getInstance().getActiveDescriptor();
        }
        if (this.notationStyle == null) {
            this.notationStyle = ERDNotationRegistry.getInstance().getActiveDescriptor();
        }
    }

    public void createPartControl(Composite parent) {
        Composite contentContainer = parent;
        if (this.hasProgressControl()) {
            this.progressControl = new ProgressControl(parent, 0x10000000);
            this.progressControl.setShowDivider(true);
            contentContainer = this.progressControl.createContentContainer();
        } else {
            this.isLoaded = true;
        }
        super.createPartControl(contentContainer);
        if (this.hasProgressControl()) {
            this.progressControl.createProgressPanel();
        }
    }

    public DBECommandContext getCommandContext() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof IDatabaseEditorInput) {
            return ((IDatabaseEditorInput)editorInput).getCommandContext();
        }
        return null;
    }

    protected void updateToolbarActions() {
        if (this.progressControl != null) {
            this.progressControl.updateActions();
        }
    }

    public void commandStackChanged(EventObject event) {
        ActionUtils.evaluatePropertyState((String)"org.jkiss.dbeaver.erd.ui.editor.canUndo");
        ActionUtils.evaluatePropertyState((String)"org.jkiss.dbeaver.erd.ui.editor.canRedo");
        this.setDirty(this.getCommandStack().isDirty());
        super.commandStackChanged(event);
    }

    public void dispose() {
        ERDUIActivator.getDefault().getPreferenceStore().removePropertyChangeListener(this.configPropertyListener);
        if (this.diagramLoadingJob != null) {
            this.diagramLoadingJob.cancel();
            this.diagramLoadingJob = null;
        }
        this.getActionRegistry().dispose();
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == GraphicalViewer.class || adapter == EditPartViewer.class) {
            return this.getGraphicalViewer();
        }
        if (adapter == CommandStack.class) {
            return this.getCommandStack();
        }
        if (adapter == EditDomain.class) {
            return this.getEditDomain();
        }
        if (adapter == ActionRegistry.class) {
            return this.getActionRegistry();
        }
        if (adapter == IPropertySheetPage.class) {
            return new PropertyPageStandard();
        }
        if (adapter == IContentOutlinePage.class) {
            return this.getOverviewOutlinePage();
        }
        if (adapter == ZoomManager.class) {
            return this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        }
        if (IWorkbenchAdapter.class.equals((Object)adapter)) {
            return new WorkbenchAdapter(){

                public String getLabel(Object o) {
                    return "ERD Editor";
                }
            };
        }
        return super.getAdapter(adapter);
    }

    public abstract void doSave(IProgressMonitor var1);

    public void doSaveAs() {
        this.saveDiagramAs();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isDirty() {
        return !this.isReadOnly() && this.isDirty;
    }

    public abstract boolean isReadOnly();

    protected boolean hasProgressControl() {
        return true;
    }

    public CommandStack getCommandStack() {
        return this.getEditDomain().getCommandStack();
    }

    public EntityDiagram getDiagram() {
        return this.getDiagramPart().getDiagram();
    }

    public DiagramPart getDiagramPart() {
        return this.rootPart == null ? null : (DiagramPart)this.rootPart.getContents();
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new ERDPaletteViewerProvider((EditDomain)this.editDomain);
    }

    public GraphicalViewer getViewer() {
        return super.getGraphicalViewer();
    }

    protected void createGraphicalViewer(Composite parent) {
        GraphicalViewer viewer = this.createViewer(parent);
        this.setGraphicalViewer(viewer);
        this.configureGraphicalViewer();
        this.hookGraphicalViewer();
        this.initializeGraphicalViewer();
        viewer.setContents((Object)new EntityDiagram(null, "empty", this.getContentProvider(), this.getDecorator()));
        ERDEditorContextMenuProvider provider = this.createContextProvider();
        viewer.setContextMenu((MenuManager)provider);
        IWorkbenchPartSite site = this.getSite();
        if (site instanceof IEditorSite) {
            ((IEditorSite)site).registerContextMenu(ERDEditorPart.class.getName() + ".EditorContext", (MenuManager)provider, (ISelectionProvider)viewer, false);
        } else {
            site.registerContextMenu(ERDEditorPart.class.getName() + ".EditorContext", (MenuManager)provider, (ISelectionProvider)viewer);
        }
    }

    @NotNull
    protected ERDEditorContextMenuProvider createContextProvider() {
        return new ERDEditorContextMenuProvider(this, true);
    }

    private GraphicalViewer createViewer(Composite parent) {
        StatusLineValidationMessageHandler validationMessageHandler = new StatusLineValidationMessageHandler(this.getEditorSite());
        ERDGraphicalViewer viewer = new ERDGraphicalViewer(this, validationMessageHandler);
        viewer.createControl(parent);
        viewer.getControl().setBackground(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.background"));
        viewer.setRootEditPart((RootEditPart)this.rootPart);
        this.installKeyHandler((GraphicalViewer)viewer);
        this.registerDropTargetListeners((GraphicalViewer)viewer);
        viewer.setEditPartFactory(this.getDecorator().createPartFactory());
        return viewer;
    }

    protected void installKeyHandler(GraphicalViewer viewer) {
        viewer.setKeyHandler((KeyHandler)new DBeaverNavigationKeyHandler(viewer));
    }

    protected void registerDropTargetListeners(GraphicalViewer viewer) {
        viewer.addDropTargetListener((TransferDropTargetListener)new DataEditDropTargetListener((EditPartViewer)viewer));
        viewer.addDropTargetListener((TransferDropTargetListener)new NodeDropTargetListener((EditPartViewer)viewer));
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.getGraphicalViewer().getControl().setBackground(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.background"));
        ERDGraphicalViewer graphicalViewer = this.getGraphicalViewer();
        DBPPreferenceStore store = ERDUIActivator.getDefault().getPreferences();
        graphicalViewer.setProperty("SnapToGrid.isEnabled", store.getBoolean("erd.grid.enabled"));
        graphicalViewer.setProperty("SnapToGrid.isVisible", store.getBoolean("erd.grid.enabled"));
        graphicalViewer.setProperty("SnapToGrid.GridSpacing", new Dimension(store.getInt("erd.grid.width"), store.getInt("erd.grid.height")));
        this.createActions();
        ZoomManager zoomManager = this.rootPart.getZoomManager();
        ArrayList<String> zoomLevels = new ArrayList<String>(3);
        zoomLevels.add(ZoomManager.FIT_ALL);
        zoomLevels.add(ZoomManager.FIT_WIDTH);
        zoomLevels.add(ZoomManager.FIT_HEIGHT);
        zoomManager.setZoomLevelContributions(zoomLevels);
        zoomManager.setZoomLevels(new double[]{0.1, 0.1, 0.2, 0.3, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9, 2.0, 2.5, 3.0, 4.0});
        ZoomInAction zoomIn = new ZoomInAction(zoomManager);
        ZoomOutAction zoomOut = new ZoomOutAction(zoomManager);
        this.addAction((IAction)zoomIn);
        this.addAction((IAction)zoomOut);
        if (this.editDomain.getPaletteViewer() != null) {
            this.addAction((IAction)new DiagramToggleHandAction(this.editDomain.getPaletteViewer()));
        }
        graphicalViewer.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object status = selection.isEmpty() ? "" : (selection.size() == 1 ? CommonUtils.toString((Object)selection.getFirstElement()) : selection.size() + " objects");
            if (this.progressControl != null) {
                this.progressControl.setInfo((String)status);
            }
            this.updateActions(this.editPartActionIDs);
        });
    }

    public void setDirty(boolean dirty) {
        if (this.isDirty != dirty) {
            this.isDirty = dirty;
            this.firePropertyChange(257);
        }
    }

    protected void addAction(IAction action) {
        this.getActionRegistry().registerAction(action);
        UIUtils.registerKeyBinding((IServiceLocator)this.getSite(), (IAction)action);
    }

    protected void updateActions(List actionIds) {
        for (Object actionId : actionIds) {
            IAction action = this.getActionRegistry().getAction(actionId);
            if (action == null || !(action instanceof UpdateAction)) continue;
            ((UpdateAction)action).update();
        }
    }

    protected ERDOutlinePage getOverviewOutlinePage() {
        RootEditPart rootEditPart;
        if ((this.outlinePage == null || this.outlinePage.getControl().isDisposed()) && this.getGraphicalViewer() != null && (rootEditPart = this.getGraphicalViewer().getRootEditPart()) instanceof ScalableFreeformRootEditPart) {
            this.outlinePage = new ERDOutlinePage((ScalableFreeformRootEditPart)rootEditPart);
        }
        return this.outlinePage;
    }

    protected PropertySheetPage getPropertySheetPage() {
        if (this.undoablePropertySheetPage == null) {
            this.undoablePropertySheetPage = new PropertySheetPage();
            this.undoablePropertySheetPage.setRootEntry((IPropertySheetEntry)new UndoablePropertySheetEntry(this.getCommandStack()));
        }
        return this.undoablePropertySheetPage;
    }

    protected ERDPalettePreferences getPalettePreferences() {
        return new ERDPalettePreferences();
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.paletteRoot == null) {
            this.paletteRoot = this.createPaletteRoot();
        }
        return this.paletteRoot;
    }

    public PaletteRoot createPaletteRoot() {
        PaletteRoot paletteRoot = new PaletteRoot();
        paletteRoot.setLabel("Entity Diagram");
        this.getDecorator().fillPalette(paletteRoot, this.isReadOnly());
        return paletteRoot;
    }

    protected FlyoutPaletteComposite createPaletteComposite(Composite parent) {
        FlyoutPaletteComposite paletteComposite = new FlyoutPaletteComposite(parent, 0, this.getSite().getPage(), this.getPaletteViewerProvider(), (FlyoutPaletteComposite.FlyoutPreferences)this.getPalettePreferences());
        paletteComposite.setBackground(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.background"));
        return paletteComposite;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void refreshDiagram(boolean rearrange, boolean reload, boolean refreshMetadata) {
        DiagramPart diagramPart = this.getDiagramPart();
        if (diagramPart == null) {
            return;
        }
        if (reload) {
            this.loadDiagram(refreshMetadata);
        }
        if (rearrange) {
            diagramPart.resetArrangement();
        }
    }

    public void refreshDiagram(boolean rearrange, boolean reload) {
        this.refreshDiagram(rearrange, reload, false);
    }

    public IRefreshablePart.RefreshResult refreshPart(Object source, boolean force) {
        this.refreshDiagram(force, true);
        return IRefreshablePart.RefreshResult.REFRESHED;
    }

    public void saveDiagramAs() {
        int extIndex;
        List<ERDExportFormatRegistry.FormatDescriptor> allFormats = ERDExportFormatRegistry.getInstance().getFormats();
        String[] extensions = new String[allFormats.size()];
        String[] filterNames = new String[allFormats.size()];
        int i = 0;
        while (i < allFormats.size()) {
            extensions[i] = "*." + allFormats.get(i).getExtension();
            filterNames[i] = allFormats.get(i).getLabel() + " (" + extensions[i] + ")";
            ++i;
        }
        Shell shell = this.getSite().getShell();
        FileDialog saveDialog = new FileDialog(shell, 8192);
        saveDialog.setFilterExtensions(extensions);
        saveDialog.setFilterNames(filterNames);
        String proposedFileName = this.exportMruFilename;
        if (CommonUtils.isEmpty((String)proposedFileName) && !CommonUtils.isEmpty((String)(proposedFileName = this.getTitle())) && (extIndex = proposedFileName.lastIndexOf(46)) != -1) {
            proposedFileName = proposedFileName.substring(0, extIndex);
        }
        if (CommonUtils.isEmpty((String)proposedFileName)) {
            LinkedList<String> parts = new LinkedList<String>();
            EntityDiagram diagram = this.getDiagram();
            DBSObjectContainer obj = diagram.getRootObjectContainer();
            if (obj == null && diagram.getEntities().size() > 0) {
                obj = (DBSObject)((ERDEntity)diagram.getEntities().get(0)).getObject();
            }
            while (obj != null && !(obj instanceof DBPDataSourceContainer)) {
                parts.addFirst(obj.getName());
                obj = obj.getParentObject();
            }
            if (parts.isEmpty()) {
                parts.add("unnammed");
            }
            proposedFileName = String.join((CharSequence)" - ", parts);
        }
        saveDialog.setFileName(proposedFileName);
        String filePath = DialogUtils.openFileDialog((FileDialog)saveDialog);
        if (filePath == null || filePath.trim().length() == 0) {
            return;
        }
        File outFile = new File(filePath);
        if (outFile.exists() && !UIUtils.confirmAction((Shell)shell, (String)"Overwrite file", (String)("File '" + filePath + "' already exists.\nOverwrite?"))) {
            return;
        }
        this.exportMruFilename = outFile.getName();
        int divPos = filePath.lastIndexOf(46);
        if (divPos == -1) {
            DBWorkbench.getPlatformUI().showError("ERD export", "No file extension was specified");
            return;
        }
        String ext = filePath.substring(divPos + 1);
        ERDExportFormatRegistry.FormatDescriptor targetFormat = null;
        for (ERDExportFormatRegistry.FormatDescriptor format : allFormats) {
            if (!format.getExtension().equals(ext)) continue;
            targetFormat = format;
            break;
        }
        if (targetFormat == null) {
            DBWorkbench.getPlatformUI().showError("ERD export", "No export format correspond to file extension '" + ext + "'");
            return;
        }
        try {
            ERDExportFormatHandler formatHandler = targetFormat.getInstance();
            IFigure figure = this.rootPart.getLayer((Object)"Printable Layers");
            formatHandler.exportDiagram(this.getDiagram(), figure, this.getDiagramPart(), outFile);
            int openFileDecision = ConfirmationDialog.confirmAction((Shell)this.getGraphicalControl().getShell(), (String)"erd_open_exported_file", (int)3, (Object[])new Object[0]);
            if (openFileDecision == 2) {
                ShellUtils.launchProgram((String)outFile.getAbsolutePath());
            }
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("ERD export failed", null, (Throwable)e);
        }
    }

    public void fillAttributeVisibilityMenu(IMenuManager menu) {
        MenuManager asMenu = new MenuManager(ERDUIMessages.menu_view_style);
        ERDViewStyle[] eRDViewStyleArray = ERDViewStyle.values();
        int n = eRDViewStyleArray.length;
        int n2 = 0;
        while (n2 < n) {
            ERDViewStyle style = eRDViewStyleArray[n2];
            if (this.decorator.supportsAttributeStyle(style)) {
                asMenu.add((IAction)new ChangeAttributePresentationAction(style));
            }
            ++n2;
        }
        if (!asMenu.isEmpty()) {
            menu.add((IContributionItem)asMenu);
        }
        if (this.getDiagram().getDecorator().supportsAttributeVisibility()) {
            MenuManager avMenu = new MenuManager(ERDUIMessages.menu_attribute_visibility);
            avMenu.add((IAction)new EmptyAction(ERDUIMessages.menu_attribute_visibility_default));
            avMenu.add((IAction)new ChangeAttributeVisibilityAction(true, ERDAttributeVisibility.ALL));
            avMenu.add((IAction)new ChangeAttributeVisibilityAction(true, ERDAttributeVisibility.KEYS));
            avMenu.add((IAction)new ChangeAttributeVisibilityAction(true, ERDAttributeVisibility.PRIMARY));
            avMenu.add((IAction)new ChangeAttributeVisibilityAction(true, ERDAttributeVisibility.NONE));
            ISelection selection = this.getGraphicalViewer().getSelection();
            if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                int totalEntities = 0;
                Object[] objectArray = ((IStructuredSelection)selection).toArray();
                int n3 = objectArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object item = objectArray[n4];
                    if (item instanceof EntityPart) {
                        ++totalEntities;
                    }
                    ++n4;
                }
                if (totalEntities > 0) {
                    avMenu.add((IContributionItem)new Separator());
                    Object avaTitle = ERDUIMessages.menu_attribute_visibility_entity;
                    avaTitle = ((IStructuredSelection)selection).size() == 1 ? (String)avaTitle + " (" + String.valueOf(((IStructuredSelection)selection).getFirstElement()) + ")" : (String)avaTitle + " (" + totalEntities + ")";
                    avMenu.add((IAction)new EmptyAction((String)avaTitle));
                    avMenu.add((IAction)new ChangeAttributeVisibilityAction(false, ERDAttributeVisibility.ALL));
                    avMenu.add((IAction)new ChangeAttributeVisibilityAction(false, ERDAttributeVisibility.KEYS));
                    avMenu.add((IAction)new ChangeAttributeVisibilityAction(false, ERDAttributeVisibility.PRIMARY));
                    avMenu.add((IAction)new ChangeAttributeVisibilityAction(false, ERDAttributeVisibility.NONE));
                }
            }
            menu.add((IContributionItem)avMenu);
        }
    }

    public void fillNotationsMenu(IMenuManager menu) {
        MenuManager ntMenu = new MenuManager(ERDUIMessages.menu_notation_style);
        for (ERDNotationDescriptor ntType : ERDNotationRegistry.getInstance().getNotations()) {
            ntMenu.add((IAction)new ChangeERDNotationStyleAction(ntType));
        }
        menu.add((IContributionItem)ntMenu);
    }

    public void fillRoutersMenu(IMenuManager menu) {
        MenuManager ntMenu = new MenuManager(ERDUIMessages.menu_router_style);
        for (ERDConnectionRouterDescriptor ntType : ERDConnectionRouterRegistry.getInstance().getDescriptors()) {
            ntMenu.add((IAction)new ChangeERDRouterStyleAction(ntType));
        }
        menu.add((IContributionItem)ntMenu);
    }

    public void fillPartContextMenu(IMenuManager menu, IStructuredSelection selection) {
        SetPartSettingsAction settingsAction;
        if (selection.isEmpty()) {
            return;
        }
        if (selection.getFirstElement() instanceof IMenuListener) {
            ((IMenuListener)selection.getFirstElement()).menuAboutToShow(menu);
        }
        menu.add((IAction)new ChangeZOrderAction(this, selection, true));
        menu.add((IAction)new ChangeZOrderAction(this, selection, false));
        menu.add((IAction)new SetPartColorAction(this, selection));
        ResetPartColorAction resetPartColorAction = new ResetPartColorAction(this, selection);
        if (resetPartColorAction.isEnabled()) {
            menu.add((IAction)resetPartColorAction);
        }
        if ((settingsAction = new SetPartSettingsAction(this, selection)).isEnabled()) {
            menu.add((IAction)settingsAction);
        }
    }

    public void printDiagram() {
        IFigure rootFigure;
        ERDGraphicalViewer viewer = this.getGraphicalViewer();
        PrintDialog dialog = new PrintDialog(viewer.getControl().getShell(), 0);
        PrinterData data = dialog.open();
        if (data != null && (rootFigure = this.rootPart.getLayer((Object)"Printable Layers")) != null) {
            PrintFigureOperation printOp = new PrintFigureOperation(new Printer(data), rootFigure);
            DBPPreferenceStore store = ERDUIActivator.getDefault().getPreferences();
            printOp.setPrintMode(store.getInt("erd.print.page-mode"));
            printOp.setPrintMargin(new Insets(store.getInt("erd.print.margin-top"), store.getInt("erd.print.margin-left"), store.getInt("erd.print.margin-bottom"), store.getInt("erd.print.margin-right")));
            printOp.run("Print ER diagram");
        }
    }

    public boolean isSearchPossible() {
        return true;
    }

    public boolean isSearchEnabled() {
        return this.progressControl != null && this.progressControl.isSearchEnabled();
    }

    public boolean performSearch(ISearchContextProvider.SearchType searchType) {
        return this.progressControl != null && this.progressControl.performSearch(searchType);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    protected void fillDefaultEditorContributions(IContributionManager toolBarManager) {
        ZoomManager zoomManager = this.rootPart.getZoomManager();
        String[] zoomStrings = new String[]{ZoomManager.FIT_ALL, ZoomManager.FIT_HEIGHT, ZoomManager.FIT_WIDTH};
        this.zoomCombo = new ZoomComboContributionItem(new IPartService(){

            public void addPartListener(IPartListener listener) {
            }

            public void addPartListener(IPartListener2 listener) {
            }

            public IWorkbenchPart getActivePart() {
                return ERDEditorPart.this;
            }

            public IWorkbenchPartReference getActivePartReference() {
                return null;
            }

            public void removePartListener(IPartListener listener) {
            }

            public void removePartListener(IPartListener2 listener) {
            }
        }, zoomStrings);
        this.zoomCombo.setZoomManager(zoomManager);
        toolBarManager.add((IContributionItem)this.zoomCombo);
        ZoomInAction zoomInAction = new ZoomInAction(zoomManager);
        zoomInAction.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ZOOM_IN));
        ZoomOutAction zoomOutAction = new ZoomOutAction(zoomManager);
        zoomOutAction.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ZOOM_OUT));
        toolBarManager.add((IAction)zoomInAction);
        toolBarManager.add((IAction)zoomOutAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)new DiagramLayoutAction(this));
        toolBarManager.add((IAction)new DiagramToggleGridAction());
        if (this.editDomain.getPaletteViewer() != null) {
            toolBarManager.add((IAction)new DiagramToggleHandAction(this.editDomain.getPaletteViewer()));
        }
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)new ToggleViewAction("org.eclipse.ui.views.PropertySheet"));
        toolBarManager.add((IAction)new ToggleViewAction("org.eclipse.ui.views.ContentOutline"));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.eclipse.ui.file.print", (String)ERDUIMessages.erd_editor_control_action_print_diagram, (DBPImage)UIIcon.PRINT));
        toolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.erd.diagram.saveAs"));
        this.fillConfigurationContribution(toolBarManager);
    }

    protected void fillConfigurationContribution(IContributionManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator("configuration"));
        Action configAction = new Action(ERDUIMessages.erd_editor_control_action_configuration){

            public void run() {
                UIUtils.showPreferencesFor((Shell)ERDEditorPart.this.getSite().getShell(), (Object)((Object)ERDEditorPart.this), (String[])new String[]{"org.jkiss.dbeaver.preferences.erd.general"});
                ERDEditorPart.this.getDiagram().setAttributeStyles(ERDViewStyle.getDefaultStyles(ERDUIActivator.getDefault().getPreferences()));
            }
        };
        configAction.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.CONFIGURATION));
        toolBarManager.add((IAction)configAction);
    }

    protected abstract void loadDiagram(boolean var1);

    @Nullable
    public abstract DBPProject getDiagramProject();

    public boolean isActiveTask() {
        return this.diagramLoadingJob != null && this.diagramLoadingJob.getState() == 4;
    }

    public boolean isModelEditEnabled() {
        return this.getDiagram().isEditEnabled();
    }

    public boolean containsModelObject(DBSObject object) {
        return object instanceof DBSEntity && this.getDiagram().getEntity((DBSEntity)object) != null;
    }

    private void refreshEntityAndAttributes() {
        this.getDiagram().getEntities().forEach(entity -> entity.reloadAttributes((ERDDiagram)this.getDiagram()));
        this.getGraphicalViewer().getContents().getChildren().forEach(editPart -> {
            if (editPart instanceof EntityPart) {
                ((EntityPart)editPart).refresh();
            }
        });
    }

    public EntityDiagram visuallize(DBRProgressMonitor monitor, EntityDiagram entityDiagram) {
        if (monitor.isCanceled()) {
            return entityDiagram;
        }
        monitor.beginTask(ERDUIMessages.erd_job_visuallize_content, 4);
        Control graphicalControl = this.getGraphicalControl();
        if (graphicalControl == null) {
            return entityDiagram;
        }
        UIUtils.syncExec(() -> graphicalControl.setBackground(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.background")));
        this.isLoaded = true;
        Control control = this.getGraphicalViewer().getControl();
        if (control == null || control.isDisposed()) {
            return entityDiagram;
        }
        if (monitor.isCanceled()) {
            return entityDiagram;
        }
        monitor.worked(1);
        UIUtils.syncExec(() -> this.getCommandStack().flush());
        if (entityDiagram != null) {
            DiagramPart diagramPart;
            if (entityDiagram.isDirty()) {
                this.getCommandStack().execute((Command)new MarkDirtyCommand());
            }
            if (monitor.isCanceled()) {
                return entityDiagram;
            }
            monitor.worked(1);
            EditPart oldContents = this.getGraphicalViewer().getContents();
            if (oldContents instanceof DiagramPart && this.restoreVisualSettings(diagramPart = (DiagramPart)oldContents, entityDiagram)) {
                entityDiagram.setLayoutManualAllowed(true);
                entityDiagram.setLayoutManualDesired(true);
            }
            if (monitor.isCanceled()) {
                return entityDiagram;
            }
            monitor.worked(1);
            UIUtils.syncExec(() -> this.getGraphicalViewer().setContents(entityDiagram));
        }
        if (monitor.isCanceled()) {
            return entityDiagram;
        }
        monitor.worked(1);
        if (this.zoomCombo != null) {
            this.zoomCombo.setZoomManager(this.rootPart.getZoomManager());
        }
        return entityDiagram;
    }

    protected boolean restoreVisualSettings(DiagramPart oldDiagram, EntityDiagram newDiagram) {
        ERDContainerDecorated.NodeVisualInfo vi;
        boolean hasChanges = false;
        for (ERDEntity newEntity : newDiagram.getEntities()) {
            NodePart oldEntity = oldDiagram.getChildByObject(newEntity.getObject());
            if (!(oldEntity instanceof EntityPart)) continue;
            vi = new ERDContainerDecorated.NodeVisualInfo((EntityPart)oldEntity);
            newDiagram.addVisualInfo((DBSEntity)newEntity.getObject(), vi);
            hasChanges = true;
        }
        for (ERDNote newNote : newDiagram.getNotes()) {
            NodePart oldNotePart = oldDiagram.getChildByObject(newNote.getObject());
            if (!(oldNotePart instanceof NotePart)) continue;
            vi = new ERDContainerDecorated.NodeVisualInfo((NotePart)oldNotePart);
            vi.initBounds = oldNotePart.getBounds();
            newDiagram.addVisualInfo(newNote, vi);
            hasChanges = true;
        }
        boolean hasLayout = false;
        for (ERDEntity entity : newDiagram.getEntities()) {
            ERDContainerDecorated.NodeVisualInfo visualInfo = newDiagram.getVisualInfo((DBSEntity)entity.getObject());
            if (visualInfo == null || visualInfo.initBounds == null || visualInfo.initBounds.x == 0 || visualInfo.initBounds.y == 0) continue;
            hasLayout = true;
            break;
        }
        return hasChanges && hasLayout;
    }

    public ERDNotationDescriptor getDiagramNotation() {
        return this.notationStyle;
    }

    public void setDiagramNotation(ERDNotationDescriptor notation) {
        this.notationStyle = notation;
    }

    public ERDConnectionRouterDescriptor getDiagramRouter() {
        return this.routerStyle;
    }

    public void setDiagramRouter(ERDConnectionRouterDescriptor router) {
        this.routerStyle = router;
    }

    public ProgressControl getProgressControl() {
        if (this.progressControl == null || this.progressControl.isDisposed()) {
            this.progressControl = new ProgressControl((Composite)super.getGraphicalControl(), 0x10000000);
            this.progressControl.setShowDivider(true);
        }
        return this.progressControl;
    }

    private class ChangeAttributePresentationAction
    extends Action {
        private final ERDViewStyle style;

        public ChangeAttributePresentationAction(ERDViewStyle style) {
            super(style.getActionTitle(), 2);
            this.style = style;
        }

        public boolean isChecked() {
            return ArrayUtils.contains((Object[])ERDViewStyle.getDefaultStyles(ERDUIActivator.getDefault().getPreferences()), (Object)((Object)this.style));
        }

        public void run() {
            ERDEditorPart.this.getDiagram().setAttributeStyle(this.style, !this.isChecked());
            ERDEditorPart.this.refreshEntityAndAttributes();
            ERDEditorPart.this.refreshDiagram(true, false);
        }
    }

    private class ChangeAttributeVisibilityAction
    extends Action {
        private final boolean defStyle;
        private final ERDAttributeVisibility visibility;

        private ChangeAttributeVisibilityAction(boolean defStyle, ERDAttributeVisibility visibility) {
            super(visibility.getTitle(), 2);
            this.defStyle = defStyle;
            this.visibility = visibility;
        }

        public boolean isChecked() {
            if (this.defStyle) {
                return this.visibility == ERDEditorPart.this.getDiagram().getAttributeVisibility();
            }
            Object[] objectArray = ((IStructuredSelection)ERDEditorPart.this.getGraphicalViewer().getSelection()).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof EntityPart) {
                    ERDAttributeVisibility entityAV = ((EntityPart)object).getEntity().getAttributeVisibility();
                    if (entityAV == null) {
                        return this.visibility == ERDEditorPart.this.getDiagram().getAttributeVisibility();
                    }
                    if (entityAV == this.visibility) {
                        return true;
                    }
                }
                ++n2;
            }
            return false;
        }

        public void runWithEvent(Event event) {
            super.runWithEvent(event);
        }

        public void run() {
            EntityDiagram diagram = ERDEditorPart.this.getDiagram();
            if (this.defStyle) {
                diagram.setAttributeVisibility(this.visibility);
                for (ERDEntity entity : diagram.getEntities()) {
                    entity.reloadAttributes((ERDDiagram)diagram);
                }
                ERDEditorPart.this.refreshEntityAndAttributes();
            } else {
                Object[] objectArray = ((IStructuredSelection)ERDEditorPart.this.getGraphicalViewer().getSelection()).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof EntityPart) {
                        ((EntityPart)object).getEntity().setAttributeVisibility(this.visibility);
                        UIUtils.asyncExec(() -> {
                            ((EntityPart)object).getEntity().reloadAttributes((ERDDiagram)diagram);
                            ((EntityPart)object).refresh();
                        });
                    }
                    ++n2;
                }
            }
            ERDEditorPart.this.refreshDiagram(true, false);
        }
    }

    private class ChangeERDNotationStyleAction
    extends Action {
        private final ERDNotationDescriptor notation;

        public ChangeERDNotationStyleAction(ERDNotationDescriptor notation) {
            super(notation.getName(), 2);
            this.notation = notation;
        }

        public boolean isChecked() {
            if (this.notation == null || ERDEditorPart.this.getDiagramNotation() == null) {
                return false;
            }
            return this.notation.getId().equals(ERDEditorPart.this.getDiagramNotation().getId());
        }

        public void run() {
            ERDEditorPart.this.setDiagramNotation(this.notation);
            ERDEditorPart.this.refreshDiagram(false, true);
        }
    }

    private class ChangeERDRouterStyleAction
    extends Action {
        private final ERDConnectionRouterDescriptor router;

        public ChangeERDRouterStyleAction(ERDConnectionRouterDescriptor router) {
            super(router.getName(), 2);
            this.router = router;
        }

        public boolean isChecked() {
            if (this.router == null || ERDEditorPart.this.getDiagramRouter() == null) {
                return false;
            }
            return this.router.getId().equals(ERDEditorPart.this.getDiagramRouter().getId());
        }

        public void run() {
            ERDEditorPart.this.setDiagramRouter(this.router);
            ERDEditorPart.this.refreshDiagram(false, true);
        }
    }

    private class ConfigPropertyListener
    implements IPropertyChangeListener {
        private ConfigPropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            ERDGraphicalViewer graphicalViewer = ERDEditorPart.this.getGraphicalViewer();
            if (graphicalViewer == null) {
                return;
            }
            if ("erd.grid.enabled".equals(event.getProperty())) {
                Boolean enabled = Boolean.valueOf(event.getNewValue().toString());
                graphicalViewer.setProperty("SnapToGrid.isEnabled", enabled);
                graphicalViewer.setProperty("SnapToGrid.isVisible", enabled);
            } else if ("erd.grid.width".equals(event.getProperty()) || "erd.grid.height".equals(event.getProperty())) {
                DBPPreferenceStore store = ERDUIActivator.getDefault().getPreferences();
                graphicalViewer.setProperty("SnapToGrid.GridSpacing", new Dimension(store.getInt("erd.grid.width"), store.getInt("erd.grid.height")));
            } else if ("erd.attr.visibility".equals(event.getProperty())) {
                EntityDiagram diagram = ERDEditorPart.this.getDiagram();
                ERDAttributeVisibility attrVisibility = (ERDAttributeVisibility)CommonUtils.valueOf(ERDAttributeVisibility.class, (String)CommonUtils.toString((Object)event.getNewValue()));
                diagram.setAttributeVisibility(attrVisibility);
                ERDEditorPart.this.refreshEntityAndAttributes();
            } else if ("erd.attr.styles".equals(event.getProperty())) {
                ERDEditorPart.this.refreshEntityAndAttributes();
            } else if ("erd.diagram.show.views".equals(event.getProperty()) || "erd.diagram.show.partitions".equals(event.getProperty())) {
                ERDEditorPart.this.doSave((IProgressMonitor)new NullProgressMonitor());
                ERDEditorPart.this.refreshDiagram(true, false);
            } else if ("erd.notation.type".equals(event.getProperty())) {
                ERDNotationDescriptor defaultNotation = ERDNotationRegistry.getInstance().getActiveDescriptor();
                ERDEditorPart.this.setDiagramNotation(defaultNotation);
                ERDEditorPart.this.doSave((IProgressMonitor)new NullProgressMonitor());
                ERDEditorPart.this.refreshDiagram(true, false);
            } else if ("erd.routing.type".equals(event.getProperty())) {
                ERDConnectionRouterDescriptor defaultRouter = ERDConnectionRouterRegistry.getInstance().getActiveDescriptor();
                ERDEditorPart.this.setDiagramRouter(defaultRouter);
                ERDEditorPart.this.doSave((IProgressMonitor)new NullProgressMonitor());
                ERDEditorPart.this.refreshDiagram(true, false);
            }
        }
    }

    protected abstract class DiagramLoaderVisualizer
    extends ProgressLoaderVisualizer<EntityDiagram> {
        protected DiagramLoaderVisualizer(ILoadService<EntityDiagram> loadingService, Composite control) {
            super(loadingService, control);
        }

        public void visualizeLoading() {
            super.visualizeLoading();
        }

        public void completeLoading(EntityDiagram entityDiagram) {
            super.completeLoading((Object)entityDiagram);
            super.visualizeLoading();
            if (entityDiagram != null && !entityDiagram.getEntities().isEmpty()) {
                ERDEditorPart.this.setErrorMessage(null);
            } else {
                List errorMessages = entityDiagram.getErrorMessages();
                if (!errorMessages.isEmpty()) {
                    ArrayList<Status> messageStatuses = new ArrayList<Status>(errorMessages.size());
                    for (String error : errorMessages) {
                        messageStatuses.add(new Status(4, "org.jkiss.dbeaver.erd.ui", error));
                    }
                    MultiStatus status = new MultiStatus("org.jkiss.dbeaver.erd.ui", 0, messageStatuses.toArray(new IStatus[0]), null, null);
                    DBWorkbench.getPlatformUI().showError("VQB Diagram loading errors", "Error(s) occurred during diagram loading. If these errors are recoverable then fix errors and then refresh/reopen diagram", (IStatus)status);
                }
            }
        }

        protected abstract void finishLoading();
    }

    private static class MarkDirtyCommand
    extends Command {
        private MarkDirtyCommand() {
        }

        public boolean canExecute() {
            return true;
        }

        public boolean canRedo() {
            return false;
        }

        public boolean canUndo() {
            return false;
        }
    }

    private class NavigatorViewerAdapter
    extends Viewer {
        private NavigatorViewerAdapter() {
        }

        public Control getControl() {
            return ERDEditorPart.this.getGraphicalViewer() == null ? null : ERDEditorPart.this.getGraphicalControl();
        }

        public Object getInput() {
            return ERDEditorPart.this.getRootNode();
        }

        public ISelection getSelection() {
            return ERDEditorPart.this.getViewer().getSelection();
        }

        public void refresh() {
            ERDEditorPart.this.refreshDiagram(false, false);
        }

        public void setInput(Object input) {
        }

        public void setSelection(ISelection selection, boolean reveal) {
        }
    }

    public class ProgressControl
    extends ProgressPageControl {
        private final Searcher searcher;

        private ProgressControl(Composite parent, int style) {
            super(parent, style);
            this.searcher = new Searcher();
        }

        protected boolean cancelProgress() {
            if (ERDEditorPart.this.diagramLoadingJob != null) {
                ERDEditorPart.this.diagramLoadingJob.cancel();
                return true;
            }
            return false;
        }

        public ProgressPageControl.ProgressVisualizer<EntityDiagram> createLoadVisualizer() {
            ERDEditorPart.this.getGraphicalControl().setBackground(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.background"));
            return new LoadVisualizer();
        }

        public void fillCustomActions(IContributionManager toolBarManager) {
            ERDEditorPart.this.fillDefaultEditorContributions(toolBarManager);
        }

        protected void populateCustomActions(ContributionManager contributionManager) {
            ToolBarManager extToolBar = new ToolBarManager();
            IMenuService menuService = (IMenuService)ERDEditorPart.this.getSite().getService(IMenuService.class);
            if (menuService != null) {
                menuService.populateContributionManager((ContributionManager)extToolBar, "toolbar:ERDEditorToolbar");
            }
            if (!extToolBar.isEmpty()) {
                boolean hasSave = contributionManager.find("save") != null;
                IContributionItem[] iContributionItemArray = extToolBar.getItems();
                int n = iContributionItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IContributionItem item = iContributionItemArray[n2];
                    if (hasSave) {
                        contributionManager.insertAfter("save", item);
                    } else {
                        contributionManager.insertAfter("configuration", item);
                    }
                    ++n2;
                }
                contributionManager.update(true);
            }
        }

        protected ISearchExecutor getSearchRunner() {
            return this.searcher;
        }

        public class LoadVisualizer
        extends ProgressPageControl.ProgressVisualizer<EntityDiagram> {
            public LoadVisualizer() {
                super((ProgressPageControl)ProgressControl.this);
            }

            public void visualizeLoading() {
                super.visualizeLoading();
            }

            public void completeLoading(EntityDiagram entityDiagram) {
                super.completeLoading((Object)entityDiagram);
                if (entityDiagram != null) {
                    List errorMessages = entityDiagram.getErrorMessages();
                    if (!errorMessages.isEmpty()) {
                        ArrayList<Status> messageStatuses = new ArrayList<Status>(errorMessages.size());
                        for (String error : errorMessages) {
                            messageStatuses.add(new Status(4, "org.jkiss.dbeaver.erd.ui", error));
                        }
                        MultiStatus status = new MultiStatus("org.jkiss.dbeaver.erd.ui", 0, messageStatuses.toArray(new IStatus[0]), null, null);
                        DBWorkbench.getPlatformUI().showError("Diagram loading errors", "Error(s) occurred during diagram loading. If these errors are recoverable then fix errors and then refresh/reopen diagram", (IStatus)status);
                    }
                    ProgressControl.this.setInfo(entityDiagram.getEntityCount() + " objects");
                } else {
                    ProgressControl.this.setInfo("Empty diagram due to error (see error log)");
                }
            }
        }
    }

    private class Searcher
    implements ISearchExecutor {
        @Nullable
        private String searchString = null;
        @Nullable
        private Pattern curSearchPattern;
        private boolean resultsFound;
        private Boolean isPrevStepWasFwd;
        @Nullable
        private List<Object> results = null;
        @Nullable
        private ListIterator<Object> resultsIterator = null;
        @Nullable
        private Object currentItem = null;
        @Nullable
        private List<ERDHighlightingHandle> highlightings = new LinkedList<ERDHighlightingHandle>();

        private Searcher() {
        }

        public boolean performSearch(@NotNull String searchString, int options) {
            if (this.results != null && this.searchString != null && this.searchString.equals(searchString)) {
                return this.findNextResult(options == 2);
            }
            this.cancelSearch();
            this.isPrevStepWasFwd = null;
            this.results = new ArrayList<Object>();
            this.searchString = searchString;
            String likePattern = SQLUtils.makeLikePattern((String)searchString);
            if (likePattern.isEmpty() || this.curSearchPattern != null && likePattern.equals(this.curSearchPattern.pattern())) {
                return this.resultsFound;
            }
            try {
                this.curSearchPattern = Pattern.compile(likePattern, 2);
            }
            catch (PatternSyntaxException e) {
                searcherLog.warn((Object)"Unable to perform search in ERD editor due to an inability to compile search pattern", (Throwable)e);
                if (ERDEditorPart.this.progressControl != null) {
                    ERDEditorPart.this.progressControl.setInfo(e.getMessage());
                }
                return false;
            }
            this.resultsFound = false;
            ERDGraphicalViewer graphicalViewer = ERDEditorPart.this.getGraphicalViewer();
            graphicalViewer.deselectAll();
            HashSet<DBPNamedObject> nodes = new HashSet<DBPNamedObject>();
            for (Object node : ERDEditorPart.this.getDiagramPart().getChildren()) {
                List children;
                if (node instanceof DBPNamedObject && node instanceof EditPart) {
                    nodes.add((DBPNamedObject)node);
                }
                if (!(node instanceof EntityPart) || CommonUtils.isEmpty((Collection)(children = ((EntityPart)node).getChildren()))) continue;
                for (Object child : children) {
                    if (!(child instanceof DBPNamedObject) || !(child instanceof EditPart)) continue;
                    nodes.add((DBPNamedObject)child);
                }
            }
            if (!CommonUtils.isEmpty(nodes)) {
                Color color = UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.search.highlighting");
                DBPNamedObject focusedNode = null;
                for (DBPNamedObject erdNode : nodes) {
                    if (!this.matchesSearch(erdNode)) continue;
                    if (!this.resultsFound) {
                        focusedNode = erdNode;
                    }
                    this.resultsFound = true;
                    this.results.add(erdNode);
                    if (!(erdNode instanceof GraphicalEditPart)) continue;
                    this.highlightings.add(ERDEditorPart.this.highlightingManager.highlight(((GraphicalEditPart)erdNode).getFigure(), color));
                }
                if (this.resultsFound && focusedNode != null) {
                    graphicalViewer.reveal((EditPart)focusedNode);
                }
            }
            this.resultsIterator = this.results.listIterator();
            return this.resultsFound;
        }

        private void jumpToNext(boolean isFindNext) {
            if (this.resultsIterator == null || isFindNext ? !this.resultsIterator.hasNext() : !this.resultsIterator.hasPrevious()) {
                this.resultsIterator = this.results.listIterator(isFindNext ? 0 : this.results.size());
            }
            this.currentItem = isFindNext ? this.resultsIterator.next() : this.resultsIterator.previous();
        }

        private boolean findNextResult(boolean isFindNext) {
            if (this.resultsFound && this.results != null) {
                if (this.isPrevStepWasFwd != null && this.isPrevStepWasFwd != isFindNext) {
                    this.jumpToNext(isFindNext);
                }
                this.isPrevStepWasFwd = isFindNext;
                this.jumpToNext(isFindNext);
                ERDGraphicalViewer graphicalViewer = ERDEditorPart.this.getGraphicalViewer();
                graphicalViewer.deselectAll();
                graphicalViewer.select((EditPart)this.currentItem);
                graphicalViewer.reveal((EditPart)this.currentItem);
                return true;
            }
            return false;
        }

        public void cancelSearch() {
            if (this.curSearchPattern != null) {
                this.curSearchPattern = null;
                if (this.resultsFound) {
                    this.resultsFound = false;
                    this.results = null;
                    this.currentItem = null;
                    this.resultsIterator = null;
                    this.highlightings.forEach(ERDHighlightingHandle::release);
                    this.highlightings.clear();
                    ERDEditorPart.this.getGraphicalViewer().deselectAll();
                }
            }
        }

        private boolean matchesSearch(@Nullable DBPNamedObject element) {
            if (this.curSearchPattern == null || element == null) {
                return false;
            }
            return this.curSearchPattern.matcher(element.getName()).find();
        }
    }
}

