/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSourceContainerProvider;
import org.jkiss.dbeaver.model.DBPDataSourceProviderSynchronizable;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSavepoint;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.qm.QMExecutionHandler;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.runtime.IPluginService;
import org.jkiss.dbeaver.runtime.qm.DefaultExecutionHandler;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.IStatefulEditor;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class DataSourcePropertyTester
extends PropertyTester {
    protected static final Log log = Log.getLog(DataSourcePropertyTester.class);
    public static final String NAMESPACE = "org.jkiss.dbeaver.core.datasource";
    public static final String PROP_CONNECTED = "connected";
    public static final String PROP_CONNECTING = "connecting";
    public static final String PROP_TRANSACTIONAL = "transactional";
    public static final String PROP_SYNCHRONIZABLE = "synchronizable";
    public static final String PROP_SUPPORTS_TRANSACTIONS = "supportsTransactions";
    public static final String PROP_TRANSACTION_ACTIVE = "transactionActive";
    public static final String PROP_EDITABLE = "editable";
    public static final String PROP_PROJECT_RESOURCE_EDITABLE = "projectResourceEditable";
    public static final String PROP_PROJECT_RESOURCE_VIEWABLE = "projectResourceViewable";

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        try {
            if (true) ** GOTO lbl5
            do {
                receiver = node.getParentNode();
lbl5:
                // 2 sources

                if (!(receiver instanceof DBNDatabaseNode)) break;
                node = (DBNDatabaseNode)receiver;
            } while (!(receiver instanceof DBNDataSource));
            if (!(receiver instanceof DBPContextProvider)) {
                return false;
            }
            var6_7 = (DBPContextProvider)receiver;
            context = contextProvider.getExecutionContext();
            var8_9 = property;
            tmp = -1;
            switch (var8_9.hashCode()) {
                case -775651656: {
                    if (!var8_9.equals("connecting")) break;
                    tmp = 1;
                    break;
                }
                case -649673585: {
                    if (!var8_9.equals("synchronizable")) break;
                    tmp = 2;
                    break;
                }
                case -579210487: {
                    if (!var8_9.equals("connected")) break;
                    tmp = 3;
                    break;
                }
                case 448241545: {
                    if (!var8_9.equals("transactional")) break;
                    tmp = 4;
                    break;
                }
                case 478309606: {
                    if (!var8_9.equals("projectResourceViewable")) break;
                    tmp = 5;
                    break;
                }
                case 608875001: {
                    if (!var8_9.equals("supportsTransactions")) break;
                    tmp = 6;
                    break;
                }
                case 884499915: {
                    if (!var8_9.equals("projectResourceEditable")) break;
                    tmp = 7;
                    break;
                }
                case 1602416228: {
                    if (!var8_9.equals("editable")) break;
                    tmp = 8;
                    break;
                }
                case 2021072772: {
                    if (!var8_9.equals("transactionActive")) break;
                    tmp = 9;
                    break;
                }
            }
            switch (tmp) {
                case 3: {
                    isConnected = context != null ? context.getDataSource().getContainer().isConnected() : (receiver instanceof DBPDataSourceContainerProvider != false ? (container = (containerProvider = (DBPDataSourceContainerProvider)receiver).getDataSourceContainer()) != null && container.isConnected() != false : false);
                    checkConnected = Boolean.TRUE.equals(expectedValue);
                    return checkConnected == isConnected;
                }
                case 1: {
                    if (!(receiver instanceof DBPDataSourceContainerProvider)) {
                        return false;
                    }
                    containerProvider = (DBPDataSourceContainerProvider)receiver;
                    container = containerProvider.getDataSourceContainer();
                    return container != null && container.isConnecting() != false;
                }
                case 4: {
                    if (context == null) {
                        return false;
                    }
                    if (!context.isConnected()) {
                        return Boolean.FALSE.equals(expectedValue);
                    }
                    txnManager = DBUtils.getTransactionManager((DBCExecutionContext)context);
                    try {
                        return txnManager != null && Boolean.valueOf(txnManager.isAutoCommit() == false).equals(expectedValue) != false;
                    }
                    catch (DBCException e) {
                        DataSourcePropertyTester.log.debug((Object)"Error checking auto-commit state", (Throwable)e);
                        return false;
                    }
                }
                case 2: {
                    if (context == null || !context.isConnected()) {
                        return false;
                    }
                    container = context.getDataSource().getContainer();
                    provider = container.getDriver().getDataSourceProvider();
                    providerSynchronizable = (DBPDataSourceProviderSynchronizable)GeneralUtils.adapt((Object)provider, DBPDataSourceProviderSynchronizable.class);
                    return providerSynchronizable != null && providerSynchronizable.isSynchronizationEnabled(container) != false;
                }
                case 6: {
                    if (context == null || !context.isConnected()) {
                        return false;
                    }
                    txnManager = DBUtils.getTransactionManager((DBCExecutionContext)context);
                    return txnManager != null && txnManager.isSupportsTransactions() != false;
                }
                case 9: {
                    if (context != null && context.isConnected()) {
                        txnManager = DBUtils.getTransactionManager((DBCExecutionContext)context);
                        return txnManager != null && txnManager.isAutoCommit() == false;
                    }
                    return Boolean.FALSE.equals(expectedValue);
                }
                case 8: {
                    resourceProject = DataSourcePropertyTester.getProject(receiver);
                    return resourceProject == null || resourceProject.hasRealmPermission("project-datasource-edit") != false;
                }
                case 7: {
                    resourceProject = DataSourcePropertyTester.getProject(receiver);
                    return resourceProject == null || resourceProject.hasRealmPermission("project-resource-edit") != false;
                }
                case 5: {
                    resourceProject = DataSourcePropertyTester.getProject(receiver);
                    return resourceProject == null || resourceProject.hasRealmPermission("project-resource-view") != false;
                }
            }
            return false;
        }
        catch (Exception e) {
            DataSourcePropertyTester.log.debug((Object)("Error testing property " + property + ": " + e.getMessage()));
            return false;
        }
    }

    @Nullable
    private static DBPProject getProject(Object receiver) {
        DBPProject dBPProject;
        if (receiver instanceof IEditorPart) {
            IEditorPart editorPart = (IEditorPart)receiver;
            dBPProject = EditorUtils.getFileProject((IEditorInput)editorPart.getEditorInput());
        } else {
            dBPProject = null;
        }
        return dBPProject;
    }

    public static void firePropertyChange(String propName) {
        ActionUtils.evaluatePropertyState((String)("org.jkiss.dbeaver.core.datasource." + propName));
    }

    private static void updateEditorsDirtyFlag() {
        IEditorReference[] editors;
        IWorkbenchWindow workbenchWindow = UIUtils.findActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            return;
        }
        IEditorReference[] iEditorReferenceArray = editors = workbenchWindow.getActivePage().getEditorReferences();
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            IEditorPart editor = ref.getEditor(false);
            if (editor instanceof IStatefulEditor) {
                UIUtils.asyncExec(() -> ((IStatefulEditor)((IStatefulEditor)editor)).updateDirtyFlag());
            }
            ++n2;
        }
    }

    private static class QMEventsHandler
    extends DefaultExecutionHandler {
        private QMEventsHandler() {
        }

        @NotNull
        public String getHandlerName() {
            return DataSourcePropertyTester.class.getName();
        }

        public synchronized void handleTransactionAutocommit(@NotNull DBCExecutionContext context, boolean autoCommit) {
            this.updateUI(() -> {
                DataSourcePropertyTester.firePropertyChange(DataSourcePropertyTester.PROP_TRANSACTIONAL);
                DataSourcePropertyTester.firePropertyChange(DataSourcePropertyTester.PROP_TRANSACTION_ACTIVE);
                ActionUtils.fireCommandRefresh((String[])new String[]{"org.jkiss.dbeaver.core.txn.autocommit"});
            });
        }

        public synchronized void handleTransactionCommit(@NotNull DBCExecutionContext context) {
            this.updateUI(() -> {
                DataSourcePropertyTester.firePropertyChange(DataSourcePropertyTester.PROP_TRANSACTION_ACTIVE);
                DataSourcePropertyTester.updateEditorsDirtyFlag();
            });
        }

        public synchronized void handleTransactionRollback(@NotNull DBCExecutionContext context, DBCSavepoint savepoint) {
            this.updateUI(() -> {
                DataSourcePropertyTester.firePropertyChange(DataSourcePropertyTester.PROP_TRANSACTION_ACTIVE);
                DataSourcePropertyTester.updateEditorsDirtyFlag();
            });
        }

        public synchronized void handleStatementExecuteBegin(@NotNull DBCStatement statement) {
            this.updateUI(() -> DataSourcePropertyTester.firePropertyChange(DataSourcePropertyTester.PROP_TRANSACTION_ACTIVE));
        }

        private void updateUI(Runnable runnable) {
            UIUtils.asyncExec((Runnable)runnable);
        }
    }

    public static class QMService
    implements IPluginService {
        private QMEventsHandler qmHandler;

        public void activateService() {
            this.qmHandler = new QMEventsHandler();
            QMUtils.registerHandler((QMExecutionHandler)this.qmHandler);
        }

        public void deactivateService() {
            QMUtils.unregisterHandler((QMExecutionHandler)this.qmHandler);
        }
    }
}

