/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.browser;

import java.net.MalformedURLException;
import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.ui.PlatformUI;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverActivator;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.browser.BrowserPopup;

public class BrowsePeerMethods {
    private static final Log log = Log.getLog(BrowsePeerMethods.class);

    public static boolean canBrowseInSWTBrowser() {
        DBPPreferenceStore store = DBeaverActivator.getInstance().getPreferences();
        boolean useEmbeddedAuth = store.getBoolean("ui.use.redirect.auth");
        if (!useEmbeddedAuth) {
            return false;
        }
        AtomicBoolean result = new AtomicBoolean(false);
        UIUtils.syncExec(() -> {
            boolean internalWebBrowserAvailable = PlatformUI.getWorkbench().getBrowserSupport().isInternalWebBrowserAvailable();
            result.set(internalWebBrowserAvailable);
            if (!internalWebBrowserAvailable) {
                log.warn((Object)"Embedded Browser is disabled or unavailable");
            }
        });
        return result.get();
    }

    public static boolean browseInSWTBrowser(URI uri) {
        DBPPreferenceStore store = DBeaverActivator.getInstance().getPreferences();
        if (store.getBoolean("ui.use.redirect.auth")) {
            AtomicBoolean result = new AtomicBoolean();
            UIUtils.syncExec(() -> {
                try {
                    BrowserPopup.openBrowser("redirect.auth", uri.toURL());
                    result.set(true);
                }
                catch (MalformedURLException e) {
                    log.warn((Object)"Error redirecting request to embedded browser", (Throwable)e);
                }
            });
            return result.get();
        }
        return false;
    }
}

