/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.resources.bookmarks;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.resources.bookmarks.BookmarkStorage;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class DBNBookmark
extends DBNResource {
    private BookmarkStorage storage;

    DBNBookmark(DBNNode parentNode, IResource resource, DBPResourceHandler handler) throws DBException, CoreException {
        super(parentNode, resource, handler);
        this.storage = new BookmarkStorage((IFile)resource, true);
    }

    protected void dispose(boolean reflect) {
        this.storage.dispose();
        super.dispose(reflect);
    }

    public BookmarkStorage getStorage() {
        return this.storage;
    }

    public String getNodeDisplayName() {
        return this.storage.getTitle();
    }

    public String getNodeDescription() {
        Object dsInfo = "";
        Collection dataSources = this.getAssociatedDataSources();
        if (!CommonUtils.isEmpty((Collection)dataSources)) {
            DBPDataSourceContainer dataSource = (DBPDataSourceContainer)dataSources.iterator().next();
            dsInfo = " ('" + dataSource.getName() + "' - " + dataSource.getDriver().getName() + ")";
        }
        return this.storage.getDescription() + (String)dsInfo;
    }

    @NotNull
    public DBPImage getResourceNodeIcon() {
        return this.storage.getImage();
    }

    public String getNodeTargetName() {
        List<String> dsPath = this.storage.getDataSourcePath();
        return CommonUtils.isEmpty(dsPath) ? super.getNodeDisplayName() : dsPath.get(dsPath.size() - 1);
    }

    public void rename(DBRProgressMonitor monitor, String newName) throws DBException {
        IFile file = (IFile)this.getResource();
        if (file != null) {
            try {
                this.storage.setTitle(newName);
                ByteArrayInputStream data = this.storage.serialize();
                file.setContents((InputStream)data, true, false, RuntimeUtils.getNestedMonitor((DBRProgressMonitor)monitor));
            }
            catch (Exception e) {
                throw new DBException("Can't rename bookmark", (Throwable)e);
            }
        }
    }
}

