/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModelDescriptor;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DatabaseURL;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceProvider;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class GenericDataSourceProvider
extends JDBCDataSourceProvider {
    private final Map<String, GenericMetaModelDescriptor> metaModels = new HashMap<String, GenericMetaModelDescriptor>();
    private static final String EXTENSION_ID = "org.jkiss.dbeaver.generic.meta";

    public GenericDataSourceProvider() {
        this.metaModels.put("standard", new GenericMetaModelDescriptor());
        ArrayList<String> replacedModels = new ArrayList<String>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] extElements = extensionRegistry.getConfigurationElementsFor(EXTENSION_ID);
        IConfigurationElement[] iConfigurationElementArray = extElements;
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            GenericMetaModelDescriptor metaModel = new GenericMetaModelDescriptor(ext);
            this.metaModels.put(metaModel.getId(), metaModel);
            replacedModels.addAll(metaModel.getModelReplacements());
            ++n2;
        }
        for (String rm : replacedModels) {
            this.metaModels.remove(rm);
        }
        for (GenericMetaModelDescriptor metaModel : new ArrayList<GenericMetaModelDescriptor>(this.metaModels.values())) {
            for (String driverClass : ArrayUtils.safeArray((Object[])metaModel.getDriverClass())) {
                this.metaModels.put(driverClass, metaModel);
            }
        }
    }

    public long getFeatures() {
        return 3L;
    }

    public String getConnectionURL(DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        return DatabaseURL.generateUrlByTemplate((DBPDriver)driver, (DBPConnectionConfiguration)connectionInfo);
    }

    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        GenericMetaModelDescriptor metaModel = null;
        Object metaModelId = container.getDriver().getDriverParameter("meta-model");
        if (metaModelId != null && !"standard".equals(metaModelId) && (metaModel = this.metaModels.get(metaModelId.toString())) == null) {
            log.warn((Object)("Meta model '" + String.valueOf(metaModelId) + "' not recognized. Default one will be used"));
        }
        if (metaModel == null) {
            metaModel = this.metaModels.get(container.getDriver().getDriverClassName());
        }
        if (metaModel == null) {
            metaModel = this.getStandardMetaModel();
        }
        GenericMetaModel metaModelInstance = metaModel.getInstance();
        return metaModelInstance.createDataSourceImpl(monitor, container);
    }

    protected GenericMetaModelDescriptor getStandardMetaModel() {
        return this.metaModels.get("standard");
    }

    public DBPPropertyDescriptor[] getConnectionProperties(DBRProgressMonitor monitor, DBPDriver driver, DBPConnectionConfiguration connectionInfo) throws DBException {
        String driverParametersString;
        DBPPropertyDescriptor[] connectionProperties = super.getConnectionProperties(monitor, driver, connectionInfo);
        if (!(connectionProperties != null && connectionProperties.length != 0 || (driverParametersString = CommonUtils.toString((Object)driver.getDriverParameter("driver-properties"))).isEmpty())) {
            String[] propList = driverParametersString.split(",");
            connectionProperties = new DBPPropertyDescriptor[propList.length];
            int i = 0;
            while (i < propList.length) {
                String propName = propList[i].trim();
                connectionProperties[i] = new PropertyDescriptor(ModelMessages.model_jdbc_driver_properties, propName, propName, null, String.class, false, null, null, true);
                ++i;
            }
        }
        return connectionProperties;
    }
}

