/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.ui.config;

import java.util.Arrays;
import java.util.Map;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.mssql.SQLServerConstants;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableBase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableColumn;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableIndex;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableIndexColumn;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.object.struct.AttributesSelectorPage;
import org.jkiss.dbeaver.ui.editors.object.struct.EditIndexPage;
import org.jkiss.utils.CommonUtils;

public class SQLServerIndexConfigurator
implements DBEObjectConfigurator<SQLServerTableIndex> {
    private static final DBSIndexType[] SQLSERVER_INDEX_TYPES = new DBSIndexType[]{SQLServerConstants.INDEX_TYPE_DEFAULT, SQLServerConstants.INDEX_TYPE_NON_CLUSTERED, DBSIndexType.CLUSTERED};

    public SQLServerTableIndex configureObject(@NotNull DBRProgressMonitor monitor, @Nullable DBECommandContext commandContext, @Nullable Object container, @NotNull SQLServerTableIndex index, @NotNull Map<String, Object> options) {
        return (SQLServerTableIndex)UITask.run(() -> {
            SQLServerEditIndexPage editPage = new SQLServerEditIndexPage((DBSTableIndex)index);
            if (!editPage.edit()) {
                return null;
            }
            index.setUnique(editPage.isUnique());
            index.setIndexType(editPage.getIndexType());
            index.setDescription(editPage.getDescription());
            StringBuilder idxName = new StringBuilder(64);
            idxName.append(CommonUtils.escapeIdentifier((String)((SQLServerTableBase)index.getTable()).getName()));
            int colIndex = 1;
            for (DBSEntityAttribute tableColumn : editPage.getSelectedAttributes()) {
                if (colIndex == 1) {
                    idxName.append("_").append(CommonUtils.escapeIdentifier((String)tableColumn.getName()));
                }
                index.addColumn(new SQLServerTableIndexColumn(index, 0L, (SQLServerTableColumn)tableColumn, colIndex++, !Boolean.TRUE.equals(editPage.getAttributeProperty(tableColumn, "desc")), Boolean.TRUE.equals(editPage.getAttributeProperty(tableColumn, "included"))));
            }
            idxName.append("_IDX");
            index.setName(DBObjectNameCaseTransformer.transformObjectName((DBSObject)index, (String)idxName.toString()));
            return index;
        });
    }

    private static class SQLServerEditIndexPage
    extends EditIndexPage {
        public static final String PROP_INCLUDED = "included";
        private int includedColumnIndex;

        public SQLServerEditIndexPage(@NotNull DBSTableIndex index) {
            super("Create index", index, Arrays.asList(SQLSERVER_INDEX_TYPES));
        }

        protected void createAttributeColumns(Table columnsTable) {
            super.createAttributeColumns(columnsTable);
            UIUtils.createTableColumn((Table)columnsTable, (int)0, (String)"Included");
        }

        protected int fillAttributeColumns(DBSEntityAttribute attribute, AttributesSelectorPage.AttributeInfo attributeInfo, TableItem columnItem) {
            this.includedColumnIndex = super.fillAttributeColumns(attribute, attributeInfo, columnItem) + 1;
            columnItem.setText(this.includedColumnIndex, Boolean.TRUE.equals(attributeInfo.getProperty(PROP_INCLUDED)) ? "YES" : "NO");
            return this.includedColumnIndex;
        }

        protected Control createCellEditor(Table table, int index, TableItem item, AttributesSelectorPage.AttributeInfo attributeInfo) {
            if (index == this.includedColumnIndex) {
                boolean isIncluded = Boolean.TRUE.equals(attributeInfo.getProperty(PROP_INCLUDED));
                CCombo combo = new CCombo((Composite)table, 12);
                combo.add("YES");
                combo.add("NO");
                combo.select(isIncluded ? 0 : 1);
                return combo;
            }
            return super.createCellEditor(table, index, item, attributeInfo);
        }

        protected void saveCellValue(Control control, int index, TableItem item, AttributesSelectorPage.AttributeInfo attributeInfo) {
            if (index == this.includedColumnIndex) {
                boolean isIncluded = ((CCombo)control).getSelectionIndex() == 0;
                item.setText(index, isIncluded ? "YES" : "NO");
                attributeInfo.setProperty(PROP_INCLUDED, (Object)isIncluded);
            } else {
                super.saveCellValue(control, index, item, attributeInfo);
            }
        }
    }
}

