/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.completion;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.create.view.CreateView;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.eclipse.jface.text.BadLocationException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDLabelValuePair;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableParametrized;
import org.jkiss.dbeaver.model.runtime.LocalCacheProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLSearchUtils;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.SQLTableAliasInsertMode;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.analyzer.TableReferencesAnalyzer;
import org.jkiss.dbeaver.model.sql.analyzer.TableReferencesAnalyzerImpl;
import org.jkiss.dbeaver.model.sql.analyzer.TableReferencesAnalyzerOld;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionProposalBase;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionRequest;
import org.jkiss.dbeaver.model.sql.completion.hippie.HippieProposalProcessor;
import org.jkiss.dbeaver.model.sql.parser.SQLWordPartDetector;
import org.jkiss.dbeaver.model.struct.DBSAlias;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSAttributeEnumerable;
import org.jkiss.dbeaver.model.struct.DBSDictionary;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import org.jkiss.dbeaver.model.text.TextUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class SQLCompletionAnalyzer
implements DBRRunnableParametrized<DBRProgressMonitor> {
    private static final Log log = Log.getLog(SQLCompletionAnalyzer.class);
    private static final String ALL_COLUMNS_PATTERN = "*";
    private static final String ENABLE_HIPPIE = "SQLEditor.ContentAssistant.activate.hippie";
    private static final String MATCH_ANY_PATTERN = "%";
    private static final String TABLE_TO_ATTRIBUTE_PATTERN = "%s%s%s";
    public static final int MAX_ATTRIBUTE_VALUE_PROPOSALS = 50;
    public static final int MAX_STRUCT_PROPOSALS = 100;
    private final SQLCompletionRequest request;
    private final TableReferencesAnalyzer tableRefsAnalyzer;
    private DBRProgressMonitor monitor;
    private final List<SQLCompletionProposalBase> proposals = new ArrayList<SQLCompletionProposalBase>();
    private boolean searchFinished = false;
    private boolean checkNavigatorNodes = true;

    public SQLCompletionAnalyzer(SQLCompletionRequest request) {
        this.request = request;
        DBPDataSource dataSource = request.getContext().getDataSource();
        DBPPreferenceStore prefStore = dataSource != null ? request.getContext().getDataSource().getContainer().getPreferenceStore() : DBWorkbench.getPlatform().getPreferenceStore();
        this.tableRefsAnalyzer = prefStore.getBoolean("SQLEditor.ContentAssistant.experimental.enable") ? new TableReferencesAnalyzerImpl(request) : new TableReferencesAnalyzerOld(request);
    }

    public void run(DBRProgressMonitor monitor) throws InvocationTargetException {
        try {
            this.runAnalyzer(monitor);
        }
        catch (DBException e) {
            throw new InvocationTargetException(e);
        }
    }

    public List<SQLCompletionProposalBase> getProposals() {
        return this.proposals;
    }

    public boolean isSearchFinished() {
        return this.searchFinished;
    }

    public void runAnalyzer(DBRProgressMonitor monitor) throws DBException {
        this.monitor = monitor;
        this.runAnalyzer();
    }

    private void runAnalyzer() throws DBException {
        SQLDialect sqlDialect;
        boolean isInQuotedIdentifier;
        boolean emptyWord;
        DBPDataSource dataSource;
        boolean isInLiteral;
        boolean isPrevWordEmpty;
        String prevKeyWord;
        SQLSyntaxManager syntaxManager;
        SQLWordPartDetector wordDetector;
        block97: {
            boolean procExec;
            String previousWord;
            List<String> prevWords;
            String wordPart;
            block91: {
                SQLCompletionRequest.QueryType queryType;
                block96: {
                    DBSObject selectedObject;
                    LinkedHashMap<String, Object> parameters;
                    block92: {
                        List<DBSObject> rootObjects;
                        block94: {
                            block93: {
                                String searchPrefix = this.request.getWordPart();
                                this.request.setQueryType(null);
                                wordDetector = this.request.getWordDetector();
                                syntaxManager = this.request.getContext().getSyntaxManager();
                                prevKeyWord = wordDetector.getPrevKeyWord();
                                isPrevWordEmpty = CommonUtils.isEmpty(wordDetector.getPrevWords());
                                isInLiteral = "sql_character".equals(this.request.getContentType());
                                String prevDelimiter = wordDetector.getPrevDelimiter();
                                if (this.request.getActiveQuery() == null || wordDetector.getPrevKeyWordOffset() < this.request.getActiveQuery().getOffset()) {
                                    prevKeyWord = null;
                                    isPrevWordEmpty = true;
                                }
                                if (!CommonUtils.isEmpty((String)prevKeyWord)) {
                                    if (syntaxManager.getDialect().isEntityQueryWord(prevKeyWord)) {
                                        if ("DELETE".equals(prevKeyWord) || "INSERT".equals(prevKeyWord)) {
                                            this.request.setQueryType(null);
                                        } else if ("INTO".equals(prevKeyWord) && !isPrevWordEmpty && ("(".equals(prevDelimiter) || ",".equals(prevDelimiter))) {
                                            this.request.setQueryType(SQLCompletionRequest.QueryType.COLUMN);
                                        } else if ("INTO".equals(prevKeyWord) && !isPrevWordEmpty && ("(*".equals(prevDelimiter) || "{*".equals(prevDelimiter) || "[*".equals(prevDelimiter))) {
                                            wordDetector.shiftOffset(-ALL_COLUMNS_PATTERN.length());
                                            searchPrefix = ALL_COLUMNS_PATTERN;
                                            this.request.setQueryType(SQLCompletionRequest.QueryType.COLUMN);
                                        } else if ("JOIN".equals(prevKeyWord) && isPrevWordEmpty) {
                                            this.request.setQueryType(SQLCompletionRequest.QueryType.JOIN);
                                        } else if (isPrevWordEmpty || !CommonUtils.isEmpty((String)prevDelimiter)) {
                                            if ("INTO".equals(prevKeyWord) && isInLiteral) {
                                                return;
                                            }
                                            this.request.setQueryType(SQLCompletionRequest.QueryType.TABLE);
                                        }
                                    } else if (syntaxManager.getDialect().isAttributeQueryWord(prevKeyWord)) {
                                        this.request.setQueryType(SQLCompletionRequest.QueryType.COLUMN);
                                        int curChar = 32;
                                        try {
                                            curChar = this.request.getDocument().getChar(wordDetector.getCursorOffset() - 1);
                                        }
                                        catch (BadLocationException e) {
                                            log.debug((Object)e);
                                        }
                                        if (!this.request.isSimpleMode() && CommonUtils.isEmpty((String)this.request.getWordPart()) && prevDelimiter.indexOf(curChar) != -1 && prevDelimiter.equals(ALL_COLUMNS_PATTERN) && !CommonUtils.isEmpty((String)wordDetector.getNextWord())) {
                                            wordDetector.shiftOffset(-ALL_COLUMNS_PATTERN.length());
                                            searchPrefix = ALL_COLUMNS_PATTERN;
                                        }
                                    } else if (SQLUtils.isExecQuery((SQLDialect)syntaxManager.getDialect(), (String)prevKeyWord)) {
                                        this.request.setQueryType(SQLCompletionRequest.QueryType.EXEC);
                                    }
                                }
                                this.request.setWordPart(searchPrefix);
                                dataSource = this.request.getContext().getDataSource();
                                if (dataSource == null) {
                                    return;
                                }
                                wordPart = this.request.getWordPart();
                                emptyWord = wordPart.isEmpty();
                                boolean isNumber = !CommonUtils.isEmpty((String)wordPart) && CommonUtils.isNumber((Object)wordPart);
                                isInQuotedIdentifier = "sql_quoted".equals(this.request.getContentType());
                                queryType = this.request.getQueryType();
                                parameters = new LinkedHashMap<String, Object>();
                                prevWords = wordDetector.getPrevWords();
                                previousWord = "";
                                if (!CommonUtils.isEmpty(prevWords)) {
                                    previousWord = prevWords.get(0).toUpperCase(Locale.ENGLISH);
                                }
                                if (!CommonUtils.isEmpty(prevWords) && ("PROCEDURE".equals(previousWord) || "FUNCTION".equals(previousWord))) {
                                    parameters.put("exec", false);
                                    procExec = false;
                                } else {
                                    parameters.put("exec", true);
                                    procExec = true;
                                }
                                if (queryType == null) break block91;
                                if (!emptyWord && !isInLiteral && !isNumber && !isInQuotedIdentifier) break block92;
                                rootObjects = null;
                                if (queryType != SQLCompletionRequest.QueryType.COLUMN || !(dataSource instanceof DBSObjectContainer)) break block93;
                                rootObjects = this.getTableListFromAlias((DBSObjectContainer)dataSource, null);
                                if (prevKeyWord == null) break block94;
                                switch (prevKeyWord) {
                                    case "ON": {
                                        for (DBSObject obj : rootObjects) {
                                            this.makeJoinColumnProposals((DBSObjectContainer)dataSource, (DBSEntity)obj);
                                        }
                                    }
                                    case "OR": 
                                    case "AND": 
                                    case "SET": 
                                    case "WHERE": {
                                        if (!this.request.isSimpleMode()) {
                                            boolean waitsForValue;
                                            boolean isLike = "LIKE".equals(previousWord) || "ILIKE".equals(previousWord);
                                            boolean bl = waitsForValue = isInLiteral || !CommonUtils.isEmpty(prevWords) && isLike || !CommonUtils.isEmpty((String)prevDelimiter) && !prevDelimiter.endsWith(")");
                                            if (waitsForValue && this.request.getContext().isShowValues()) {
                                                for (DBSObject obj : rootObjects) {
                                                    this.makeProposalsFromAttributeValues(dataSource, wordDetector, isInLiteral || isNumber, (DBSEntity)obj);
                                                }
                                            }
                                        }
                                        break block94;
                                    }
                                }
                                break block94;
                            }
                            if (dataSource instanceof DBSObjectContainer) {
                                Object rootObject;
                                selectedObject = this.getActiveInstanceObject();
                                if (selectedObject != null) {
                                    this.makeProposalsFromChildren((DBPObject)selectedObject, null, false, parameters);
                                    rootObject = DBUtils.getPublicObject((DBSObject)selectedObject.getParentObject());
                                } else {
                                    rootObject = dataSource;
                                }
                                if (!(rootObject instanceof DBPDataSource)) {
                                    this.makeDataSourceProposals(parameters);
                                }
                            }
                        }
                        if (!isInLiteral) {
                            DBSObject leftTable;
                            if (rootObjects != null) {
                                for (DBSObject obj : rootObjects) {
                                    this.makeProposalsFromChildren((DBPObject)obj, null, false, parameters);
                                }
                            } else if (this.getActiveInstanceObject() == null && dataSource != null) {
                                this.makeProposalsFromChildren((DBPObject)dataSource, null, false, parameters);
                            }
                            if (queryType == SQLCompletionRequest.QueryType.JOIN && !this.proposals.isEmpty() && dataSource instanceof DBSObjectContainer && (leftTable = this.getTableFromAlias((DBSObjectContainer)dataSource, null)) instanceof DBSEntity) {
                                this.filterNonJoinableProposals((DBSEntity)leftTable);
                            }
                        }
                        break block96;
                    }
                    if (!isInLiteral) {
                        DBSObject rootObject = null;
                        if (queryType == SQLCompletionRequest.QueryType.COLUMN && dataSource instanceof DBSObjectContainer) {
                            String prevWord;
                            DBSObjectContainer sc = (DBSObjectContainer)dataSource;
                            if (this.request.getContext().getExecutionContext() != null && (selectedObject = this.getActiveInstanceObject()) instanceof DBSObjectContainer) {
                                sc = (DBSObjectContainer)selectedObject;
                            }
                            sqlDialect = this.request.getContext().getDataSource().getSQLDialect();
                            String tableAlias = null;
                            if (ALL_COLUMNS_PATTERN.equals(wordPart) && !isPrevWordEmpty && !prevKeyWord.equalsIgnoreCase("INTO") && (prevWord = wordDetector.getPrevWords().get(0)).contains(sqlDialect.getCatalogSeparator())) {
                                int divPos = prevWord.lastIndexOf(sqlDialect.getCatalogSeparator());
                                tableAlias = prevWord.substring(0, divPos);
                            }
                            if (tableAlias == null) {
                                int divPos = wordPart.lastIndexOf(syntaxManager.getStructSeparator());
                                String string = tableAlias = divPos == -1 ? null : wordPart.substring(0, divPos);
                            }
                            if (tableAlias == null && !CommonUtils.isEmpty((String)wordPart) && (rootObject = this.getTableFromAlias(sc, wordPart)) != null) {
                                this.searchFinished = true;
                                return;
                            }
                            rootObject = this.getTableFromAlias(sc, tableAlias);
                            if (rootObject == null && tableAlias != null) {
                                String[] allNames = SQLUtils.splitFullIdentifier((String)tableAlias, (String)sqlDialect.getCatalogSeparator(), (String[][])sqlDialect.getIdentifierQuoteStrings(), (boolean)false);
                                rootObject = SQLSearchUtils.findObjectByFQN(this.monitor, sc, this.request, Arrays.asList(allNames));
                            }
                        }
                        if (rootObject != null) {
                            this.makeProposalsFromChildren((DBPObject)rootObject, wordPart, false, (Map<String, Object>)parameters);
                        } else if (queryType != SQLCompletionRequest.QueryType.COLUMN && queryType != SQLCompletionRequest.QueryType.EXEC) {
                            this.makeDataSourceProposals(parameters);
                        }
                    }
                }
                if (!this.request.isSimpleMode() && !isInLiteral && (queryType == SQLCompletionRequest.QueryType.EXEC || queryType == SQLCompletionRequest.QueryType.COLUMN && this.request.getContext().isSearchProcedures()) && dataSource instanceof DBSObjectContainer) {
                    this.makeProceduresProposals(dataSource, wordPart, procExec);
                }
                break block97;
            }
            if (!(isInLiteral || this.request.isSimpleMode() || CommonUtils.isEmpty(prevWords) || !"PROCEDURE".equals(previousWord) && !"FUNCTION".equals(previousWord))) {
                this.makeProceduresProposals(dataSource, wordPart, procExec);
            }
        }
        if (!(emptyWord || isInLiteral || isInQuotedIdentifier)) {
            this.makeProposalsFromQueryParts();
        }
        if (!(this.searchFinished || isInLiteral || isInQuotedIdentifier)) {
            List<String> matchedKeywords = Collections.emptyList();
            HashSet<String> allowedKeywords = null;
            sqlDialect = this.request.getContext().getDataSource().getSQLDialect();
            if (CommonUtils.isEmpty((String)prevKeyWord)) {
                allowedKeywords = new HashSet<String>();
                Collections.addAll(allowedKeywords, sqlDialect.getQueryKeywords());
                Collections.addAll(allowedKeywords, sqlDialect.getDMLKeywords());
                Collections.addAll(allowedKeywords, sqlDialect.getDDLKeywords());
                Collections.addAll(allowedKeywords, sqlDialect.getExecuteKeywords());
            } else if (ArrayUtils.contains((Object[])sqlDialect.getQueryKeywords(), (Object)prevKeyWord.toUpperCase(Locale.ENGLISH))) {
                String delimiter = wordDetector.getPrevDelimiter();
                if (delimiter.equals(ALL_COLUMNS_PATTERN) || !isPrevWordEmpty && (CommonUtils.isEmpty((String)delimiter) || delimiter.endsWith(")"))) {
                    allowedKeywords = new HashSet();
                    if (this.proposals.isEmpty() && CommonUtils.isEmpty(wordDetector.getPrevWords())) {
                        if (!"FROM".equalsIgnoreCase(wordDetector.getNextWord())) {
                            allowedKeywords.add("FROM");
                            if (CommonUtils.isEmpty((String)this.request.getWordPart()) || this.request.getWordPart().equals(ALL_COLUMNS_PATTERN)) {
                                matchedKeywords = Arrays.asList("FROM");
                            }
                        }
                    } else if (delimiter.equals(ALL_COLUMNS_PATTERN)) {
                        wordDetector.shiftOffset(1);
                    }
                }
            } else if (sqlDialect.isEntityQueryWord(prevKeyWord)) {
                allowedKeywords = new HashSet();
                if ("DELETE".equals(prevKeyWord)) {
                    allowedKeywords.add("FROM");
                } else if ("INSERT".equals(prevKeyWord)) {
                    allowedKeywords.add("INTO");
                } else if ("UPDATE".equals(prevKeyWord)) {
                    allowedKeywords.add("SET");
                } else if (!"WHERE".equalsIgnoreCase(wordDetector.getNextWord()) && !"INTO".equals(prevKeyWord)) {
                    allowedKeywords.add("WHERE");
                }
                if (CommonUtils.isEmpty((String)this.request.getWordPart())) {
                    matchedKeywords = new ArrayList<String>(allowedKeywords);
                }
            }
            if (matchedKeywords.isEmpty() && !CommonUtils.isEmpty((String)this.request.getWordPart())) {
                matchedKeywords = syntaxManager.getDialect().getMatchedKeywords(this.request.getWordPart());
                if (!this.request.isSimpleMode()) {
                    matchedKeywords.sort(Comparator.comparingInt(o -> TextUtils.fuzzyScore(o, this.request.getWordPart())));
                }
            }
            for (String keyWord : matchedKeywords) {
                DBPKeywordType keywordType = syntaxManager.getDialect().getKeywordType(keyWord);
                if (keywordType == null || keywordType == DBPKeywordType.TYPE || this.request.getQueryType() == SQLCompletionRequest.QueryType.COLUMN && keywordType != DBPKeywordType.FUNCTION && keywordType != DBPKeywordType.KEYWORD && keywordType != DBPKeywordType.OTHER || allowedKeywords != null && !allowedKeywords.contains(keyWord)) continue;
                this.proposals.add(SQLCompletionAnalyzer.createCompletionProposal(this.request, keyWord, keyWord, keywordType, null, false, null, Collections.emptyMap()));
            }
            if (dataSource.getContainer().getPreferenceStore().getBoolean(ENABLE_HIPPIE)) {
                this.makeProposalFromHippie(wordDetector);
            }
        }
        this.filterProposals(dataSource);
    }

    private void makeProposalFromHippie(@NotNull SQLWordPartDetector wordPartDetector) {
        String[] displayNames;
        HippieProposalProcessor hippieProposalProcessor = new HippieProposalProcessor(wordPartDetector);
        String[] stringArray = displayNames = hippieProposalProcessor.computeCompletionStrings(this.request.getDocument(), this.request.getDocumentOffset() - 1);
        int n = displayNames.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (!SQLCompletionAnalyzer.hasProposal(this.proposals, word) && !word.contains(".")) {
                this.proposals.add(this.request.getContext().createProposal(this.request, word, word, word.length(), null, DBPKeywordType.LITERAL, null, null, Collections.emptyMap()));
            }
            ++n2;
        }
    }

    @Nullable
    private DBSObject getActiveInstanceObject() {
        DBCExecutionContext context = this.request.getContext().getExecutionContext();
        if (context == null) {
            return null;
        }
        return DBUtils.getActiveInstanceObject((DBCExecutionContext)context);
    }

    private void makeProceduresProposals(@NotNull DBPDataSource dataSource, @NotNull String wordPart, boolean exec) throws DBException {
        DBSStructureAssistant structureAssistant = (DBSStructureAssistant)DBUtils.getAdapter(DBSStructureAssistant.class, (Object)dataSource);
        DBSObjectContainer sc = (DBSObjectContainer)dataSource;
        DBSObject selectedObject = this.getActiveInstanceObject();
        if (selectedObject instanceof DBSObjectContainer) {
            SQLWordPartDetector wordDetector = this.request.getWordDetector();
            if (!this.request.getContext().isSearchGlobally() || wordDetector.containsSeparator(wordPart)) {
                if (wordPart.length() > 1 && wordDetector.containsSeparator(wordPart) && !wordPart.contains(selectedObject.getName())) {
                    Object[] objectsNames = wordDetector.splitIdentifier(wordPart);
                    if (!ArrayUtils.isEmpty((Object[])objectsNames)) {
                        DBSObject ourContainer;
                        DBSObjectContainer selectedObjectParentObject;
                        boolean endsOnStructureSeparator = wordPart.charAt(wordPart.length() - 1) == wordDetector.getStructSeparator();
                        int arrayIndex = 0;
                        if (endsOnStructureSeparator) {
                            arrayIndex = objectsNames.length - 1;
                        } else if (objectsNames.length > 1) {
                            arrayIndex = objectsNames.length - 2;
                        }
                        String containerName = wordDetector.removeQuotes((String)objectsNames[arrayIndex]);
                        if (selectedObject instanceof DBSProcedureContainer && (selectedObjectParentObject = (DBSObjectContainer)DBUtils.getParentOfType(DBSObjectContainer.class, (DBSObject)selectedObject)) != null && (ourContainer = selectedObjectParentObject.getChild(this.monitor, containerName)) instanceof DBSProcedureContainer && ourContainer instanceof DBSObjectContainer) {
                            sc = (DBSObjectContainer)ourContainer;
                        }
                    }
                } else {
                    sc = (DBSObjectContainer)selectedObject;
                }
            }
        }
        if (structureAssistant != null) {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("exec", exec);
            this.makeProposalsFromAssistant(structureAssistant, sc, new DBSObjectType[]{RelationalObjectType.TYPE_PROCEDURE}, wordPart, params);
        }
    }

    private void makeProposalsFromAttributeValues(DBPDataSource dataSource, SQLWordPartDetector wordDetector, boolean isInLiteral, DBSEntity entity) throws DBException {
        List<String> prevWords = wordDetector.getPrevWords();
        if (!prevWords.isEmpty()) {
            DBSEntityAttribute attribute;
            int divPos;
            String columnName = prevWords.get(prevWords.size() - 1);
            if (!DBUtils.isQuotedIdentifier((DBPDataSource)dataSource, (String)columnName) && (divPos = columnName.indexOf(this.request.getContext().getSyntaxManager().getStructSeparator())) != -1) {
                columnName = columnName.substring(divPos + 1);
            }
            if ((attribute = entity.getAttribute(this.monitor, columnName = DBUtils.getUnQuotedIdentifier((DBPDataSource)dataSource, (String)columnName))) != null) {
                Throwable throwable = null;
                Object var9_11 = null;
                try (DBCSession session = this.request.getContext().getExecutionContext().openSession(this.monitor, DBCExecutionPurpose.META, "Read attribute values");){
                    DBSEntityAttribute refAttribute;
                    DBSEntity dictEntity;
                    List valueEnumeration = null;
                    DBSEntityReferrer enumConstraint = DBStructUtils.getEnumerableConstraint((DBRProgressMonitor)this.monitor, (DBSEntityAttribute)attribute);
                    if (enumConstraint instanceof DBSEntityAssociation && (dictEntity = DBStructUtils.getAssociatedEntity((DBRProgressMonitor)this.monitor, (DBSEntityConstraint)enumConstraint)) != null && (refAttribute = DBUtils.getReferenceAttribute((DBRProgressMonitor)this.monitor, (DBSEntityAssociation)((DBSEntityAssociation)enumConstraint), (DBSEntityAttribute)attribute, (boolean)false)) != null) {
                        valueEnumeration = ((DBSDictionary)dictEntity).getDictionaryEnumeration(this.monitor, refAttribute, null, null, Collections.emptyList(), true, true, false, 0, 50);
                    }
                    if (CommonUtils.isEmpty(valueEnumeration) && attribute instanceof DBSAttributeEnumerable) {
                        valueEnumeration = ((DBSAttributeEnumerable)attribute).getValueEnumeration(session, (Object)(isInLiteral ? wordDetector.getFullWord() : null), 50, false, false, false);
                    }
                    if (!CommonUtils.isEmpty(valueEnumeration)) {
                        valueEnumeration.sort((o1, o2) -> DBUtils.compareDataValues((Object)o1.getValue(), (Object)o2.getValue()));
                        DBDValueHandler valueHandler = DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)attribute);
                        DBPImage attrImage = null;
                        for (DBDLabelValuePair valuePair : valueEnumeration) {
                            Object displayString = SQLUtils.convertValueToSQL((DBPDataSource)session.getDataSource(), (DBSTypedObject)attribute, (DBDValueHandler)valueHandler, (Object)valuePair.getValue(), (DBDDisplayFormat)DBDDisplayFormat.UI);
                            if (!CommonUtils.isEmpty((String)valuePair.getLabel()) && !CommonUtils.equalObjects((Object)valuePair.getLabel(), (Object)valuePair.getValue())) {
                                displayString = (String)displayString + " - " + valuePair.getLabel();
                            }
                            String sqlValue = isInLiteral ? valueHandler.getValueDisplayString((DBSTypedObject)attribute, valuePair.getValue(), DBDDisplayFormat.NATIVE) : SQLUtils.convertValueToSQL((DBPDataSource)dataSource.getDataSource(), (DBSTypedObject)attribute, (DBDValueHandler)valueHandler, (Object)valuePair.getValue(), (DBDDisplayFormat)DBDDisplayFormat.NATIVE);
                            this.proposals.add(this.request.getContext().createProposal(this.request, (String)displayString, sqlValue, sqlValue.length(), attrImage, DBPKeywordType.LITERAL, null, null, Collections.emptyMap()));
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
    }

    private void filterProposals(DBPDataSource dataSource) {
        boolean hideDups;
        HashSet<String> proposalMap = new HashSet<String>(this.proposals.size());
        int i = 0;
        while (i < this.proposals.size()) {
            SQLCompletionProposalBase proposal = this.proposals.get(i);
            if (proposalMap.contains(proposal.getDisplayString())) {
                this.proposals.remove(i);
                continue;
            }
            proposalMap.add(proposal.getDisplayString());
            ++i;
        }
        DBSInstance defaultInstance = dataSource == null ? null : dataSource.getDefaultInstance();
        DBCExecutionContext executionContext = this.request.getContext().getExecutionContext();
        DBSObject selectedObject = defaultInstance == null || executionContext == null ? null : DBUtils.getActiveInstanceObject((DBCExecutionContext)executionContext);
        boolean bl = hideDups = this.request.getContext().isHideDuplicates() && selectedObject != null;
        if (hideDups) {
            int i2 = 0;
            while (i2 < this.proposals.size()) {
                SQLCompletionProposalBase proposal = this.proposals.get(i2);
                int n = 0;
                while (n < this.proposals.size()) {
                    SQLCompletionProposalBase proposal2 = this.proposals.get(n);
                    if (i2 != n && proposal.hasStructObject() && proposal2.hasStructObject() && CommonUtils.equalObjects((Object)proposal.getObject().getName(), (Object)proposal2.getObject().getName()) && proposal.getObjectContainer() == selectedObject) {
                        this.proposals.remove(n);
                        continue;
                    }
                    ++n;
                }
                ++i2;
            }
        }
        if (hideDups) {
            boolean cfr_ignored_0 = selectedObject instanceof DBSObjectContainer;
        }
        if (dataSource != null) {
            DBPDataSourceContainer dsContainer = dataSource.getContainer();
            HashMap<DBSObject, Map> containerMap = new HashMap<DBSObject, Map>();
            for (SQLCompletionProposalBase sQLCompletionProposalBase : this.proposals) {
                DBSObject container = sQLCompletionProposalBase.getObjectContainer();
                DBPNamedObject object = sQLCompletionProposalBase.getObject();
                if (object == null) continue;
                Map typeMap = containerMap.computeIfAbsent(container, k -> new HashMap());
                Class objectType = object instanceof DBSObjectReference ? ((DBSObjectReference)object).getObjectClass() : object.getClass();
                List list = typeMap.computeIfAbsent(objectType, k -> new ArrayList());
                list.add(sQLCompletionProposalBase);
            }
            for (Map.Entry entry : containerMap.entrySet()) {
                for (Map.Entry typeEntry : ((Map)entry.getValue()).entrySet()) {
                    DBSObjectFilter filter = dsContainer.getObjectFilter((Class)typeEntry.getKey(), (DBSObject)entry.getKey(), true);
                    if (filter == null || !filter.isEnabled()) continue;
                    for (SQLCompletionProposalBase proposal : (List)typeEntry.getValue()) {
                        if (filter.matches(proposal.getObject().getName())) continue;
                        this.proposals.remove(proposal);
                    }
                }
            }
        }
    }

    private void makeProposalsFromQueryParts() {
        if (this.request.getQueryType() == null && this.request.getWordDetector().getPrevKeyWord().equalsIgnoreCase("FROM")) {
            return;
        }
        String wordPart = this.request.getWordPart();
        SQLScriptElement activeQuery = this.request.getActiveQuery();
        if (activeQuery != null && !CommonUtils.isEmpty((String)activeQuery.getText()) && !CommonUtils.isEmpty((String)wordPart)) {
            if (wordPart.indexOf(this.request.getContext().getSyntaxManager().getStructSeparator()) != -1 || wordPart.equals(ALL_COLUMNS_PATTERN)) {
                return;
            }
            Map<String, String> names = this.tableRefsAnalyzer.getFilteredTableReferences(wordPart, true);
            for (Map.Entry<String, String> name : names.entrySet()) {
                String tableName = name.getKey();
                String tableAlias = name.getValue();
                if (!CommonUtils.isEmpty((String)tableName) && !SQLCompletionAnalyzer.hasProposal(this.proposals, tableName)) {
                    this.proposals.add(0, SQLCompletionAnalyzer.createCompletionProposal(this.request, tableName, tableName, DBPKeywordType.OTHER, null, false, null, Map.of("no-space", true)));
                }
                if (CommonUtils.isEmpty((String)tableAlias) || SQLCompletionAnalyzer.hasProposal(this.proposals, tableAlias)) continue;
                this.proposals.add(0, SQLCompletionAnalyzer.createCompletionProposal(this.request, tableAlias, tableAlias, DBPKeywordType.OTHER, null, false, null, Map.of("no-space", true)));
            }
        }
    }

    private static boolean hasProposal(List<SQLCompletionProposalBase> proposals, String displayName) {
        for (SQLCompletionProposalBase proposal : proposals) {
            if (!displayName.equals(proposal.getDisplayString())) continue;
            return true;
        }
        return false;
    }

    private boolean makeJoinColumnProposals(DBSObjectContainer sc, DBSEntity leftTable) {
        SQLWordPartDetector joinTableDetector = new SQLWordPartDetector(this.request.getDocument(), this.request.getContext().getSyntaxManager(), this.request.getWordDetector().getStartOffset(), 2);
        List<String> prevWords = joinTableDetector.getPrevWords();
        if (!CommonUtils.isEmpty(prevWords)) {
            DBPDataSource dataSource = this.request.getContext().getDataSource();
            SQLDialect sqlDialect = dataSource.getSQLDialect();
            String rightTableName = prevWords.get(0);
            String[] allNames = SQLUtils.splitFullIdentifier((String)rightTableName, (String)sqlDialect.getCatalogSeparator(), (String[][])sqlDialect.getIdentifierQuoteStrings(), (boolean)false);
            DBSObject rightTable = SQLSearchUtils.findObjectByFQN(this.monitor, sc, this.request, Arrays.asList(allNames));
            if (rightTable instanceof DBSEntity) {
                try {
                    String joinCriteria = SQLUtils.generateTableJoin((DBRProgressMonitor)this.monitor, (DBSEntity)leftTable, (String)DBUtils.getQuotedIdentifier((DBSObject)leftTable), (DBSEntity)((DBSEntity)rightTable), (String)DBUtils.getQuotedIdentifier((DBSObject)rightTable));
                    this.proposals.add(SQLCompletionAnalyzer.createCompletionProposal(this.request, joinCriteria, joinCriteria, DBPKeywordType.OTHER, "Join condition"));
                    return true;
                }
                catch (DBException e) {
                    log.error((Object)"Error generating join condition", (Throwable)e);
                }
            }
        }
        return false;
    }

    private void filterNonJoinableProposals(DBSEntity leftTable) {
        ArrayList<SQLCompletionProposalBase> joinableProposals = new ArrayList<SQLCompletionProposalBase>();
        for (SQLCompletionProposalBase proposal : this.proposals) {
            DBSEntity rightTable;
            if (!(proposal.getObject() instanceof DBSEntity) || !this.tableHaveJoins(rightTable = (DBSEntity)proposal.getObject(), leftTable) && !this.tableHaveJoins(leftTable, rightTable)) continue;
            proposal.setReplacementAfter(" ON");
            joinableProposals.add(proposal);
        }
        if (!joinableProposals.isEmpty()) {
            this.proposals.clear();
            this.proposals.addAll(joinableProposals);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean tableHaveJoins(DBSEntity table1, DBSEntity table2) {
        try {
            Collection associations = table1.getAssociations(this.monitor);
            if (!CommonUtils.isEmpty((Collection)associations)) {
                for (DBSEntityAssociation fk : associations) {
                    if (fk.getAssociatedEntity() != table2) continue;
                    return true;
                }
            }
            return false;
        }
        catch (DBException e) {
            log.error((Object)e);
            return false;
        }
    }

    private void makeDataSourceProposals(@NotNull Map<String, Object> parameters) throws DBException {
        Object sc;
        DBPDataSource dataSource = this.request.getContext().getDataSource();
        DBSObjectContainer rootContainer = (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)dataSource);
        if (rootContainer == null) {
            return;
        }
        DBCExecutionContext executionContext = this.request.getContext().getExecutionContext();
        if (executionContext == null) {
            return;
        }
        DBSObjectContainer childObject = sc = rootContainer;
        String[] tokens = (String[])Arrays.stream(this.request.getWordDetector().splitWordPart()).filter(CommonUtils::isNotEmpty).toArray(String[]::new);
        DBSObject[] selectedObjects = DBUtils.getSelectedObjects((DBCExecutionContext)executionContext);
        DBSObjectContainer[] selectedContainers = new DBSObjectContainer[selectedObjects.length];
        int i = 0;
        while (i < selectedObjects.length) {
            selectedContainers[i] = (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)selectedObjects[i]);
            ++i;
        }
        String lastToken = null;
        i = 0;
        while (i < tokens.length) {
            String token = tokens[i];
            if (i == tokens.length - 1 && !this.request.getWordDetector().getWordPart().endsWith(".")) {
                lastToken = token;
                break;
            }
            if (sc == null) break;
            String objectName = this.request.getWordDetector().isQuoted(token) ? this.request.getWordDetector().removeQuotes(token) : DBObjectNameCaseTransformer.transformName((DBPDataSource)dataSource, (String)token);
            sc.cacheStructure(this.monitor, 1);
            DBSObject dBSObject = childObject = objectName == null ? null : sc.getChild(this.monitor, objectName);
            if (!DBStructUtils.isConnectedContainer((DBPObject)childObject)) {
                childObject = null;
            }
            if (childObject == null && i == 0 && objectName != null) {
                DBSObjectContainer[] dBSObjectContainerArray = selectedContainers;
                int n = selectedContainers.length;
                int n2 = 0;
                while (n2 < n) {
                    DBSObjectContainer selectedContainer = dBSObjectContainerArray[n2];
                    if (selectedContainer != null) {
                        selectedContainer.cacheStructure(this.monitor, 1);
                        childObject = selectedContainer.getChild(this.monitor, objectName);
                        if (childObject != null) {
                            sc = selectedContainer;
                            break;
                        }
                    }
                    ++n2;
                }
            }
            if (childObject == null) {
                if (i == 0) {
                    DBSStructureAssistant structureAssistant;
                    childObject = this.getTableFromAlias((DBSObjectContainer)sc, token);
                    if (childObject == null && !this.request.isSimpleMode() && (structureAssistant = (DBSStructureAssistant)DBUtils.getAdapter(DBSStructureAssistant.class, (Object)sc)) != null) {
                        DBSStructureAssistant.ObjectsSearchParams params = new DBSStructureAssistant.ObjectsSearchParams(structureAssistant.getAutoCompleteObjectTypes(), this.request.getWordDetector().removeQuotes(token));
                        params.setCaseSensitive(this.request.getWordDetector().isQuoted(token));
                        params.setMaxResults(2);
                        List references = structureAssistant.findObjectsByMask(this.monitor, executionContext, params);
                        if (!references.isEmpty()) {
                            childObject = ((DBSObjectReference)references.iterator().next()).resolveObject(this.monitor);
                        }
                    }
                } else {
                    return;
                }
            }
            sc = childObject instanceof DBSObjectContainer ? childObject : null;
            ++i;
        }
        if (childObject == null) {
            return;
        }
        if (lastToken == null) {
            this.makeProposalsFromChildren((DBPObject)childObject, null, false, parameters);
        } else {
            this.makeProposalsFromChildren((DBPObject)childObject, lastToken, false, parameters);
            int cfr_ignored_0 = tokens.length;
            if (tokens.length == 1) {
                DBSObjectContainer[] dBSObjectContainerArray = selectedContainers;
                int n = selectedContainers.length;
                int token = 0;
                while (token < n) {
                    DBSObjectContainer selectedContainer = dBSObjectContainerArray[token];
                    if (selectedContainer != null && selectedContainer != childObject) {
                        this.makeProposalsFromChildren((DBPObject)selectedContainer, lastToken, true, parameters);
                    }
                    ++token;
                }
                if (this.proposals.isEmpty() && !this.request.isSimpleMode()) {
                    DBSStructureAssistant structureAssistant = null;
                    DBSObjectContainer object = childObject;
                    while (object != null) {
                        structureAssistant = (DBSStructureAssistant)DBUtils.getAdapter(DBSStructureAssistant.class, (Object)object);
                        if (structureAssistant != null) break;
                        object = object.getParentObject();
                    }
                    if (structureAssistant != null) {
                        this.makeProposalsFromAssistant(structureAssistant, (DBSObjectContainer)sc, null, lastToken, parameters);
                    }
                }
            }
        }
    }

    @Nullable
    private List<DBSObject> getTableListFromAlias(DBSObjectContainer sc, @Nullable String token) {
        if (token == null) {
            token = "";
        } else if (token.equals(ALL_COLUMNS_PATTERN)) {
            return null;
        }
        DBPDataSource dataSource = this.request.getContext().getDataSource();
        if (dataSource == null) {
            return null;
        }
        SQLDialect sqlDialect = dataSource.getSQLDialect();
        String catalogSeparator = sqlDialect.getCatalogSeparator();
        while (token.endsWith(catalogSeparator)) {
            token = token.substring(0, token.length() - 1);
        }
        Map<String, String> names = this.tableRefsAnalyzer.getFilteredTableReferences(token, false);
        ArrayList<DBSObject> objects = new ArrayList<DBSObject>();
        for (Map.Entry<String, String> name : names.entrySet()) {
            if (name == null || !CommonUtils.isNotEmpty((String)name.getKey())) continue;
            String[][] quoteStrings = sqlDialect.getIdentifierQuoteStrings();
            String[] allNames = SQLUtils.splitFullIdentifier((String)name.getKey(), (String)catalogSeparator, (String[][])quoteStrings, (boolean)false);
            DBSObject obj = SQLSearchUtils.findObjectByFQN(this.monitor, sc, this.request, Arrays.asList(allNames));
            if (obj == null) continue;
            objects.add(obj);
        }
        return objects;
    }

    @Nullable
    private DBSObject getTableFromAlias(DBSObjectContainer sc, @Nullable String token) {
        if (token == null) {
            token = "";
        } else if (token.equals(ALL_COLUMNS_PATTERN)) {
            return null;
        }
        DBPDataSource dataSource = this.request.getContext().getDataSource();
        if (dataSource == null) {
            return null;
        }
        SQLDialect sqlDialect = dataSource.getSQLDialect();
        String catalogSeparator = sqlDialect.getCatalogSeparator();
        while (token.endsWith(catalogSeparator)) {
            token = token.substring(0, token.length() - 1);
        }
        Map<String, String> names = this.tableRefsAnalyzer.getFilteredTableReferences(token, false);
        for (Map.Entry<String, String> name : names.entrySet()) {
            if (name == null || !CommonUtils.isNotEmpty((String)name.getKey())) continue;
            String[][] quoteStrings = sqlDialect.getIdentifierQuoteStrings();
            String[] allNames = SQLUtils.splitFullIdentifier((String)name.getKey(), (String)catalogSeparator, (String[][])quoteStrings, (boolean)false);
            return SQLSearchUtils.findObjectByFQN(this.monitor, sc, this.request, Arrays.asList(allNames));
        }
        return null;
    }

    public void setCheckNavigatorNodes(boolean check) {
        this.checkNavigatorNodes = check;
    }

    private void makeProposalsFromChildren(DBPObject parent, @Nullable String startPart, boolean addFirst, Map<String, Object> params) throws DBException {
        int divPos;
        DBRProgressMonitor mdMonitor;
        if (this.request.getQueryType() == SQLCompletionRequest.QueryType.EXEC) {
            return;
        }
        Object object = mdMonitor = this.request.getContext().getDataSource().getContainer().isExtraMetadataReadEnabled() ? this.monitor : new LocalCacheProgressMonitor(this.monitor);
        if (parent instanceof DBSAlias) {
            DBSAlias alias = (DBSAlias)parent;
            if (!mdMonitor.isForceCacheUsage()) {
                DBSObject realParent = alias.getTargetObject(mdMonitor);
                if (realParent == null) {
                    log.debug((Object)"Can't get synonym target object");
                } else {
                    parent = realParent;
                }
            }
        }
        SQLWordPartDetector wordDetector = this.request.getWordDetector();
        if (startPart != null && (divPos = (startPart = wordDetector.removeQuotes(startPart).toUpperCase(Locale.ENGLISH)).lastIndexOf(this.request.getContext().getSyntaxManager().getStructSeparator())) != -1) {
            startPart = startPart.substring(divPos + 1);
        }
        DBPDataSource dataSource = this.request.getContext().getDataSource();
        Collection children = null;
        if (parent instanceof DBSObjectContainer) {
            DBSObjectContainer objectContainer = (DBSObjectContainer)parent;
            if (DBStructUtils.isConnectedContainer((DBPObject)parent)) {
                children = objectContainer.getChildren(mdMonitor);
            }
        } else if (parent instanceof DBSEntity) {
            DBSEntity entity = (DBSEntity)parent;
            children = entity.getAttributes(mdMonitor);
        }
        if (children != null && !children.isEmpty()) {
            String prevWord;
            ArrayList<DBSObject> matchedObjects = new ArrayList<DBSObject>();
            HashMap<String, Integer> scoredMatches = new HashMap<String, Integer>();
            boolean simpleMode = this.request.isSimpleMode();
            boolean allObjects = !simpleMode && ALL_COLUMNS_PATTERN.equals(startPart);
            String objPrefix = null;
            if (allObjects && !CommonUtils.isEmpty(wordDetector.getPrevWords()) && !(prevWord = wordDetector.getPrevWords().get(0)).isEmpty() && prevWord.charAt(prevWord.length() - 1) == this.request.getContext().getSyntaxManager().getStructSeparator()) {
                objPrefix = prevWord;
            }
            StringBuilder combinedMatch = new StringBuilder();
            for (DBSObject child : children) {
                int score;
                if (DBUtils.isHiddenObject((Object)child)) continue;
                if (DBUtils.isVirtualObject((Object)child)) {
                    this.makeProposalsFromChildren((DBPObject)child, startPart, addFirst, Collections.emptyMap());
                    continue;
                }
                if (allObjects) {
                    if (!combinedMatch.isEmpty()) {
                        combinedMatch.append(", ");
                        if (objPrefix != null) {
                            combinedMatch.append(objPrefix);
                        }
                    }
                    combinedMatch.append(DBUtils.getQuotedIdentifier((DBSObject)child));
                    continue;
                }
                if (dataSource != null && !this.request.getContext().isSearchInsideNames()) {
                    if (!CommonUtils.isEmpty((String)startPart) && !CommonUtils.startsWithIgnoreCase((String)child.getName(), (String)startPart)) continue;
                    matchedObjects.add(child);
                    continue;
                }
                int n = score = CommonUtils.isEmpty((String)startPart) ? 1 : TextUtils.fuzzyScore(child.getName(), startPart);
                if (score <= 0) continue;
                matchedObjects.add(child);
                scoredMatches.put(child.getName(), score);
            }
            if (!combinedMatch.isEmpty()) {
                String replaceString = combinedMatch.toString();
                this.proposals.add(SQLCompletionAnalyzer.createCompletionProposal(this.request, replaceString, replaceString, DBPKeywordType.OTHER, "All objects"));
            } else if (!matchedObjects.isEmpty()) {
                if (startPart == null || scoredMatches.isEmpty()) {
                    if (dataSource != null && this.request.getContext().isSortAlphabetically()) {
                        matchedObjects.sort((o1, o2) -> {
                            if (o1 instanceof DBSAttributeBase && o2 instanceof DBSAttributeBase) {
                                return DBUtils.orderComparator().compare((DBSAttributeBase)o1, (DBSAttributeBase)o2);
                            }
                            return DBUtils.nameComparatorIgnoreCase().compare(o1, o2);
                        });
                    }
                } else {
                    matchedObjects.sort((o1, o2) -> {
                        int score2;
                        int score1 = (Integer)scoredMatches.get(o1.getName());
                        if (score1 == (score2 = ((Integer)scoredMatches.get(o2.getName())).intValue())) {
                            if (o1 instanceof DBSAttributeBase && o2 instanceof DBSAttributeBase) {
                                return DBUtils.orderComparator().compare((DBSAttributeBase)o1, (DBSAttributeBase)o2);
                            }
                            return DBUtils.nameComparatorIgnoreCase().compare(o1, o2);
                        }
                        return score2 - score1;
                    });
                }
                ArrayList<SQLCompletionProposalBase> childProposals = new ArrayList<SQLCompletionProposalBase>(matchedObjects.size());
                for (DBSObject child : matchedObjects) {
                    SQLCompletionProposalBase proposal = this.makeProposalsFromObject(child, !(parent instanceof DBPDataSource), params);
                    if (proposal == null) continue;
                    if (!scoredMatches.isEmpty()) {
                        int proposalScore = (Integer)scoredMatches.get(child.getName());
                        proposal.setProposalScore(proposalScore);
                    }
                    childProposals.add(proposal);
                }
                if (addFirst) {
                    this.proposals.addAll(0, childProposals);
                } else {
                    this.proposals.addAll(childProposals);
                }
            }
        }
    }

    private void makeProposalsFromAssistant(@NotNull DBSStructureAssistant assistant, @Nullable DBSObjectContainer rootSC, DBSObjectType[] objectTypes, String objectName, @NotNull Map<String, Object> params) throws DBException {
        DBSStructureAssistant.ObjectsSearchParams assistantParams = new DBSStructureAssistant.ObjectsSearchParams(objectTypes == null ? assistant.getAutoCompleteObjectTypes() : objectTypes, this.makeObjectNameMask(objectName, rootSC));
        assistantParams.setParentObject((DBSObject)rootSC);
        assistantParams.setCaseSensitive(this.request.getWordDetector().isQuoted(objectName));
        assistantParams.setGlobalSearch(this.request.getContext().isSearchGlobally());
        assistantParams.setMaxResults(100);
        List references = assistant.findObjectsByMask(this.monitor, this.request.getContext().getExecutionContext(), assistantParams);
        for (DBSObjectReference reference : references) {
            this.proposals.add(this.makeProposalsFromObject((DBPNamedObject)reference, !(rootSC instanceof DBPDataSource), reference.getObjectType().getImage(), params));
        }
    }

    private String makeObjectNameMask(String objectName, @Nullable DBSObjectContainer rootSC) {
        SQLWordPartDetector wordDetector = this.request.getWordDetector();
        if (wordDetector.containsSeparator(objectName)) {
            String[] strings = wordDetector.splitIdentifier(objectName);
            if (rootSC != null) {
                boolean endsOnStructureSeparator;
                boolean bl = endsOnStructureSeparator = objectName.charAt(objectName.length() - 1) == wordDetector.getStructSeparator();
                objectName = endsOnStructureSeparator ? "" : wordDetector.removeQuotes(strings[strings.length - 1]);
            }
        } else {
            objectName = wordDetector.removeQuotes(objectName);
        }
        if (this.request.getContext().isSearchInsideNames()) {
            if (CommonUtils.isEmpty((String)objectName)) {
                return MATCH_ANY_PATTERN;
            }
            return MATCH_ANY_PATTERN + objectName + MATCH_ANY_PATTERN;
        }
        return objectName + MATCH_ANY_PATTERN;
    }

    private SQLCompletionProposalBase makeProposalsFromObject(DBSObject object, boolean useShortName, Map<String, Object> params) {
        DBPImage objectIcon;
        DBNDatabaseNode node = this.request.getContext().getDataSource().getContainer().isExtraMetadataReadEnabled() ? DBNUtils.getNodeByObject((DBRProgressMonitor)this.monitor, (DBSObject)object, (boolean)false) : DBNUtils.getNodeByObject((DBSObject)object);
        if (this.checkNavigatorNodes && node == null && (object instanceof DBSEntity || object instanceof DBSObjectContainer)) {
            return null;
        }
        DBPImage dBPImage = objectIcon = node == null ? null : node.getNodeIconDefault();
        if (objectIcon == null) {
            objectIcon = DBValueFormatting.getObjectImage((DBPObject)object);
        }
        return this.makeProposalsFromObject((DBPNamedObject)object, useShortName, objectIcon, params);
    }

    private SQLCompletionProposalBase makeProposalsFromObject(DBPNamedObject object, boolean useShortName, @Nullable DBPImage objectIcon, @NotNull Map<String, Object> params) {
        String alias = null;
        String objectName = null;
        Object replaceString = null;
        boolean isSingleObject = true;
        SQLTableAliasInsertMode aliasMode = SQLTableAliasInsertMode.NONE;
        String prevWord = this.request.getWordDetector().getPrevKeyWord();
        if ("FROM".equals(prevWord) || "INTO".equals(prevWord) || "JOIN".equals(prevWord)) {
            SQLDialect dialect;
            if (object instanceof DBSEntity) {
                aliasMode = SQLTableAliasInsertMode.fromPreferences(((DBSEntity)object).getDataSource().getContainer().getPreferenceStore());
            }
            if (aliasMode != SQLTableAliasInsertMode.NONE && (dialect = SQLUtils.getDialectFromObject((DBPObject)object)).supportsAliasInSelect() && this.request.getActiveQuery() != null) {
                String firstKeyword = SQLUtils.getFirstKeyword((SQLDialect)dialect, (String)this.request.getActiveQuery().getText());
                if (dialect.supportsAliasInUpdate() || !ArrayUtils.contains((Object[])dialect.getDMLKeywords(), (Object)firstKeyword.toUpperCase(Locale.ENGLISH))) {
                    SQLDialect sqlDialect;
                    Statement sqlStatement;
                    final LinkedHashSet aliases = new LinkedHashSet();
                    if (this.request.getActiveQuery() instanceof SQLQuery && (sqlStatement = ((SQLQuery)this.request.getActiveQuery()).getStatement()) != null) {
                        TablesNamesFinder namesFinder = new TablesNamesFinder(){

                            public void visit(@Nullable Table table) {
                                if (table != null && table.getAlias() != null && table.getAlias().getName() != null) {
                                    aliases.add(table.getAlias().getName().toLowerCase(Locale.ENGLISH));
                                }
                            }

                            public void visit(@Nullable CreateView createView) {
                                if (createView != null && createView.getView().getAlias() != null && createView.getView().getName() != null) {
                                    aliases.add(createView.getView().getAlias().getName().toLowerCase(Locale.ENGLISH));
                                }
                            }
                        };
                        sqlStatement.accept((StatementVisitor)namesFinder);
                    }
                    if ((alias = SQLUtils.generateEntityAlias((DBSEntity)((DBSEntity)object), arg_0 -> this.lambda$8(aliases, sqlDialect = SQLUtils.getDialectFromObject((DBPObject)object), arg_0))).equalsIgnoreCase(object.getName())) {
                        alias = "";
                    }
                }
            }
        }
        if ("WHERE".equals(prevWord) || "AND".equals(prevWord)) {
            DBSEntity parentObject = null;
            if (object instanceof DBSTableColumn) {
                DBSTableColumn tableColumn = (DBSTableColumn)object;
                aliasMode = SQLTableAliasInsertMode.fromPreferences(tableColumn.getDataSource().getContainer().getPreferenceStore());
                parentObject = tableColumn.getParentObject();
            } else if (object instanceof DBSEntityAttribute) {
                DBSEntityAttribute tableColumn = (DBSEntityAttribute)object;
                aliasMode = SQLTableAliasInsertMode.fromPreferences(tableColumn.getDataSource().getContainer().getPreferenceStore());
                parentObject = tableColumn.getParentObject();
            }
            SQLDialect sqlDialect = SQLUtils.getDialectFromObject((DBPObject)object);
            String tableName = parentObject != null ? DBUtils.getQuotedIdentifier(parentObject) : object.getName();
            if (aliasMode != SQLTableAliasInsertMode.NONE) {
                Map<String, String> table2Alices = this.tableRefsAnalyzer.getTableAliasesFromQuery();
                alias = table2Alices.get(tableName);
                String wordPart = this.request.getWordDetector().getWordPart();
                objectName = DBUtils.getQuotedIdentifier((DBPNamedObject)object);
                if (wordPart.isEmpty()) {
                    objectName = String.format(TABLE_TO_ATTRIBUTE_PATTERN, Objects.requireNonNullElse(alias, tableName), Character.valueOf(sqlDialect.getStructSeparator()), objectName);
                }
                replaceString = objectName;
            }
        }
        if (objectName == null || objectName.isEmpty()) {
            String string = objectName = useShortName ? object.getName() : DBUtils.getObjectFullName((DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.DML);
        }
        if (replaceString == null || ((String)replaceString).isEmpty()) {
            DBSObject selectedObject;
            DBSObjectReference structObject;
            DBSObject objectContainer;
            DBPDataSource dataSource = this.request.getContext().getDataSource();
            if (dataSource != null && !this.request.getContext().isUseShortNames() && object instanceof DBSObjectReference && this.request.getWordDetector().getFullWord().indexOf(this.request.getContext().getSyntaxManager().getStructSeparator()) == -1 && (objectContainer = (structObject = (DBSObjectReference)object).getContainer()) != null && (selectedObject = this.getActiveInstanceObject()) != null && selectedObject != objectContainer) {
                replaceString = DBSProcedure.class.isAssignableFrom(structObject.getObjectClass()) ? DBUtils.getFullQualifiedName((DBPDataSource)dataSource, (DBPNamedObject[])new DBPNamedObject[]{objectContainer, structObject}) : structObject.getFullyQualifiedName(DBPEvaluationContext.DML);
                isSingleObject = false;
            }
            if (replaceString == null) {
                if (this.request.getContext().isUseFQNames() && object instanceof DBPQualifiedObject) {
                    DBPQualifiedObject qo = (DBPQualifiedObject)object;
                    replaceString = qo.getFullyQualifiedName(DBPEvaluationContext.DML);
                } else {
                    replaceString = DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)object.getName());
                }
            }
        }
        if (!("WHERE".equals(prevWord) || "AND".equals(prevWord) || CommonUtils.isEmpty(alias))) {
            if (aliasMode == SQLTableAliasInsertMode.EXTENDED) {
                replaceString = (String)replaceString + " " + SQLCompletionAnalyzer.convertKeywordCase(this.request, "as", false);
            }
            replaceString = (String)replaceString + " " + alias;
        }
        return SQLCompletionAnalyzer.createCompletionProposal(this.request, (String)replaceString, objectName, DBPKeywordType.OTHER, objectIcon, isSingleObject, object, params);
    }

    static SQLCompletionProposalBase createCompletionProposal(SQLCompletionRequest request, String replaceString, String displayString, DBPKeywordType proposalType, @Nullable DBPImage image, boolean isObject, @Nullable DBPNamedObject object, @NotNull Map<String, Object> params) {
        int cursorPos;
        boolean quotedString;
        DBPDataSource dataSource = request.getContext().getDataSource();
        if (dataSource != null) {
            // empty if block
        }
        if (!(quotedString = request.getWordDetector().isQuoted((String)replaceString))) {
            replaceString = SQLCompletionAnalyzer.convertKeywordCase(request, (String)replaceString, isObject);
        }
        if (proposalType == DBPKeywordType.FUNCTION) {
            replaceString = (String)replaceString + "()";
            cursorPos = ((String)replaceString).length() - 2;
        } else {
            cursorPos = ((String)replaceString).length();
        }
        return request.getContext().createProposal(request, displayString, (String)replaceString, cursorPos, image, proposalType, null, object, params);
    }

    public static String convertKeywordCase(SQLCompletionRequest request, String replaceString, boolean isObject) {
        int proposalCase = request.getContext().getInsertCase();
        switch (proposalCase) {
            case 1: {
                replaceString = replaceString.toUpperCase();
                break;
            }
            case 2: {
                replaceString = replaceString.toLowerCase();
                break;
            }
            default: {
                if (isObject) break;
                SQLDialect dialect = request.getContext().getSyntaxManager().getDialect();
                DBPKeywordType keywordType = dialect.getKeywordType(replaceString);
                replaceString = keywordType == DBPKeywordType.KEYWORD ? request.getContext().getSyntaxManager().getKeywordCase().transform(replaceString) : dialect.storesUnquotedCase().transform(replaceString);
            }
        }
        return replaceString;
    }

    protected static SQLCompletionProposalBase createCompletionProposal(SQLCompletionRequest request, String replaceString, String displayString, DBPKeywordType proposalType, String description) {
        return request.getContext().createProposal(request, displayString, replaceString, replaceString.length(), null, proposalType, description, null, Collections.emptyMap());
    }

    private /* synthetic */ Boolean lambda$8(Set set, SQLDialect sQLDialect, String s) {
        if (set.contains(s) || sQLDialect.getKeywordType(s) != null) {
            return true;
        }
        return !this.tableRefsAnalyzer.getFilteredTableReferences(s, false).isEmpty();
    }
}

