/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.antlr.v4.runtime.misc.Interval;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScopeItem;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryLexicalScope {
    @Nullable
    private SQLQueryDataContext context = null;
    @NotNull
    private final List<SQLQueryLexicalScopeItem> items = new ArrayList<SQLQueryLexicalScopeItem>();
    @NotNull
    private final List<STMTreeNode> syntaxNodes = new ArrayList<STMTreeNode>();
    @Nullable
    private Interval interval = null;

    @NotNull
    public Interval getInterval() {
        if (this.interval == null) {
            int a = Stream.concat(this.items.stream().map(x -> x.getSyntaxNode().getRealInterval().a), this.syntaxNodes.stream().map(x -> x.getRealInterval().a)).mapToInt(x -> x).min().orElse(0);
            int b = Stream.concat(this.items.stream().map(x -> x.getSyntaxNode().getRealInterval().b), this.syntaxNodes.stream().map(x -> x.getRealInterval().b)).mapToInt(x -> x).max().orElse(Integer.MAX_VALUE);
            this.interval = Interval.of((int)a, (int)b);
        }
        return this.interval;
    }

    public void setInterval(@NotNull Interval interval) {
        this.interval = interval;
    }

    @Nullable
    public SQLQueryDataContext getContext() {
        return this.context;
    }

    public void setContext(@Nullable SQLQueryDataContext context) {
        this.context = context;
    }

    public void registerItem(@NotNull SQLQueryLexicalScopeItem item) {
        this.items.add(item);
    }

    public void registerSyntaxNode(@NotNull STMTreeNode syntaxNode) {
        this.syntaxNodes.add(syntaxNode);
    }

    @Nullable
    public SQLQueryLexicalScopeItem findItem(int position) {
        return this.items.stream().filter(t -> t.getSyntaxNode().getRealInterval().properlyContains(Interval.of((int)position, (int)position))).min(Comparator.comparingInt(t -> t.getSyntaxNode().getRealInterval().a)).orElse(null);
    }
}

