/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.completion;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItemKind;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItemVisitor;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SourceResolutionResult;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;

public abstract class SQLQueryCompletionItem {
    private SQLQueryCompletionItem() {
    }

    @NotNull
    public abstract SQLQueryCompletionItemKind getKind();

    @Nullable
    public DBSObject getObject() {
        return null;
    }

    public final <R> R apply(SQLQueryCompletionItemVisitor<R> visitor) {
        return this.applyImpl(visitor);
    }

    protected abstract <R> R applyImpl(SQLQueryCompletionItemVisitor<R> var1);

    @NotNull
    public static SQLQueryCompletionItem forReservedWord(@NotNull String text) {
        return new SQLReservedWordCompletionItem(text);
    }

    @NotNull
    public static SQLQueryCompletionItem forSubqueryAlias(@NotNull SQLQuerySymbol aliasSymbol, @NotNull SQLQueryRowsSourceModel source) {
        return new SQLSubqueryAliasCompletionItem(aliasSymbol, source);
    }

    @NotNull
    public static SQLQueryCompletionItem forRealTable(@NotNull DBSEntity table, boolean isUsed) {
        return new SQLTableNameCompletionItem(table, isUsed);
    }

    @NotNull
    public static SQLQueryCompletionItem forSubsetColumn(@NotNull SQLQueryResultColumn columnInfo, @NotNull SourceResolutionResult sourceInfo, boolean absolute) {
        return new SQLColumnNameCompletionItem(columnInfo, sourceInfo, absolute);
    }

    @NotNull
    public static SQLQueryCompletionItem forDbObject(@NotNull DBSObject object) {
        return new SQLDbNamedObjectCompletionItem(object);
    }

    public static class SQLColumnNameCompletionItem
    extends SQLQueryCompletionItem {
        @NotNull
        public final SQLQueryResultColumn columnInfo;
        @NotNull
        public final SourceResolutionResult sourceInfo;
        public final boolean absolute;

        SQLColumnNameCompletionItem(@NotNull SQLQueryResultColumn columnInfo, @NotNull SourceResolutionResult sourceInfo, boolean absolute) {
            if (sourceInfo == null) {
                throw new IllegalArgumentException("sourceInfo should not be null");
            }
            if (columnInfo == null) {
                throw new IllegalArgumentException("columnInfo should not be null");
            }
            this.columnInfo = columnInfo;
            this.sourceInfo = sourceInfo;
            this.absolute = absolute;
        }

        @Override
        @NotNull
        public SQLQueryCompletionItemKind getKind() {
            return this.columnInfo.symbol.getSymbolClass() == SQLQuerySymbolClass.COLUMN_DERIVED ? SQLQueryCompletionItemKind.DERIVED_COLUMN_NAME : SQLQueryCompletionItemKind.TABLE_COLUMN_NAME;
        }

        @Override
        @Nullable
        public DBSObject getObject() {
            return this.columnInfo.realAttr;
        }

        @Override
        protected <R> R applyImpl(SQLQueryCompletionItemVisitor<R> visitor) {
            return visitor.visitColumnName(this);
        }
    }

    public static class SQLDbNamedObjectCompletionItem
    extends SQLQueryCompletionItem {
        @NotNull
        public final DBSObject object;

        SQLDbNamedObjectCompletionItem(@NotNull DBSObject object) {
            this.object = object;
        }

        @Override
        @NotNull
        public SQLQueryCompletionItemKind getKind() {
            return SQLQueryCompletionItemKind.UNKNOWN;
        }

        @Override
        @NotNull
        public DBSObject getObject() {
            return this.object;
        }

        @Override
        protected <R> R applyImpl(SQLQueryCompletionItemVisitor<R> visitor) {
            return visitor.visitNamedObject(this);
        }
    }

    public static class SQLReservedWordCompletionItem
    extends SQLQueryCompletionItem {
        public final String text;

        SQLReservedWordCompletionItem(@NotNull String text) {
            this.text = text;
        }

        @Override
        @NotNull
        public SQLQueryCompletionItemKind getKind() {
            return SQLQueryCompletionItemKind.RESERVED;
        }

        @Override
        @NotNull
        protected <R> R applyImpl(@NotNull SQLQueryCompletionItemVisitor<R> visitor) {
            return visitor.visitReservedWord(this);
        }
    }

    public static class SQLSubqueryAliasCompletionItem
    extends SQLQueryCompletionItem {
        @NotNull
        public final SQLQuerySymbol symbol;
        @NotNull
        public final SQLQueryRowsSourceModel source;

        SQLSubqueryAliasCompletionItem(@NotNull SQLQuerySymbol symbol, @NotNull SQLQueryRowsSourceModel source) {
            this.symbol = symbol;
            this.source = source;
        }

        @Override
        @NotNull
        public SQLQueryCompletionItemKind getKind() {
            return SQLQueryCompletionItemKind.SUBQUERY_ALIAS;
        }

        @Override
        protected <R> R applyImpl(SQLQueryCompletionItemVisitor<R> visitor) {
            return visitor.visitSubqueryAlias(this);
        }
    }

    public static class SQLTableNameCompletionItem
    extends SQLQueryCompletionItem {
        public final boolean isUsed;
        @NotNull
        public final DBSEntity table;

        SQLTableNameCompletionItem(@NotNull DBSEntity table, boolean isUsed) {
            this.isUsed = isUsed;
            this.table = table;
        }

        @Override
        @NotNull
        public SQLQueryCompletionItemKind getKind() {
            return this.isUsed ? SQLQueryCompletionItemKind.USED_TABLE_NAME : SQLQueryCompletionItemKind.NEW_TABLE_NAME;
        }

        @Override
        public DBSObject getObject() {
            return this.table;
        }

        @Override
        protected <R> R applyImpl(SQLQueryCompletionItemVisitor<R> visitor) {
            return visitor.visitTableName(this);
        }
    }
}

