/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLSearchUtils;
import org.jkiss.dbeaver.model.sql.parser.SQLIdentifierDetector;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsTableValueModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;

public class SQLQueryDataSourceContext
extends SQLQueryDataContext {
    @NotNull
    private final SQLDialect dialect;
    @NotNull
    private final DBCExecutionContext executionContext;
    @NotNull
    private final SQLIdentifierDetector identifierDetector;

    public SQLQueryDataSourceContext(@NotNull SQLDialect dialect, @NotNull DBCExecutionContext executionContext) {
        this.dialect = dialect;
        this.executionContext = executionContext;
        this.identifierDetector = new SQLIdentifierDetector(dialect);
    }

    @Override
    @NotNull
    public List<SQLQueryResultColumn> getColumnsList() {
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public DBSEntity findRealTable(@NotNull DBRProgressMonitor monitor, @NotNull List<String> tableName) {
        DBPDataSource dBPDataSource = this.executionContext.getDataSource();
        if (dBPDataSource instanceof DBSObjectContainer) {
            DBSTable dBSTable;
            DBSObjectContainer container = (DBSObjectContainer)dBPDataSource;
            ArrayList<String> tableName2 = new ArrayList<String>(tableName);
            DBSObject obj = SQLSearchUtils.findObjectByFQN(monitor, container, this.executionContext, tableName2, false, this.identifierDetector);
            if (obj instanceof DBSTable) {
                DBSTable table;
                dBSTable = table = (DBSTable)obj;
            } else if (obj instanceof DBSView) {
                DBSView view = (DBSView)obj;
                dBSTable = view;
            } else {
                dBSTable = null;
            }
            return dBSTable;
        }
        throw new UnsupportedOperationException("Should never happen");
    }

    @Override
    @Nullable
    public SQLQueryRowsSourceModel findRealSource(@NotNull DBSEntity table) {
        return null;
    }

    @Override
    @Nullable
    public SQLQueryResultColumn resolveColumn(@NotNull DBRProgressMonitor monitor, @NotNull String simpleName) {
        return null;
    }

    @Override
    @NotNull
    public SQLDialect getDialect() {
        return this.dialect;
    }

    @Override
    @NotNull
    public SQLQueryRowsSourceModel getDefaultTable(@NotNull STMTreeNode syntaxNode) {
        return new SQLQueryRowsTableValueModel(syntaxNode, Collections.emptyList());
    }

    @Override
    protected void collectKnownSourcesImpl(@NotNull SQLQueryDataContext.KnownSourcesInfo result) {
    }
}

