/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.dml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryModelRecognizer;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryModelContent;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.dml.SQLQueryUpdateSetClauseModel;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.STMKnownRuleNames;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.stm.STMUtils;

public class SQLQueryUpdateModel
extends SQLQueryModelContent {
    @Nullable
    private final SQLQueryRowsSourceModel targetRows;
    @Nullable
    private final List<SQLQueryUpdateSetClauseModel> setClauseList;
    @Nullable
    private final SQLQueryRowsSourceModel sourceRows;
    @Nullable
    private final SQLQueryValueExpression whereClause;
    @Nullable
    private final SQLQueryValueExpression orderByClause;
    @Nullable
    private SQLQueryDataContext givenContext = null;
    @Nullable
    private SQLQueryDataContext resultContext = null;

    public SQLQueryUpdateModel(@NotNull STMTreeNode syntaxNode, @Nullable SQLQueryRowsSourceModel targetRows, @Nullable List<SQLQueryUpdateSetClauseModel> setClauseList, @Nullable SQLQueryRowsSourceModel sourceRows, @Nullable SQLQueryValueExpression whereClause, @Nullable SQLQueryValueExpression orderByClause) {
        super(syntaxNode.getRealInterval(), syntaxNode, new SQLQueryNodeModel[0]);
        this.targetRows = targetRows;
        this.setClauseList = setClauseList;
        this.sourceRows = sourceRows;
        this.whereClause = whereClause;
        this.orderByClause = orderByClause;
    }

    @NotNull
    public static SQLQueryModelContent recognize(@NotNull SQLQueryModelRecognizer recognizer, @NotNull STMTreeNode node) {
        STMTreeNode fromClauseNode;
        STMTreeNode targetTableNode = node.findChildOfName(STMKnownRuleNames.tableReference);
        SQLQueryRowsSourceModel targetSet = targetTableNode == null ? null : recognizer.collectQueryExpression(targetTableNode);
        ArrayList<SQLQueryUpdateSetClauseModel> setClauseList = new ArrayList<SQLQueryUpdateSetClauseModel>();
        STMTreeNode setClauseListNode = node.findChildOfName(STMKnownRuleNames.setClauseList);
        if (setClauseListNode != null) {
            int i = 0;
            while (i < setClauseListNode.getChildCount()) {
                STMTreeNode setClauseNode = setClauseListNode.getStmChild(i);
                if (setClauseNode.getChildCount() > 0) {
                    STMTreeNode setTargetNode = setClauseNode.getStmChild(0);
                    List<SQLQueryValueExpression> targets = switch (setTargetNode.getNodeKindId()) {
                        case 250 -> List.of(recognizer.collectKnownValueExpression(setTargetNode.getStmChild(0)));
                        case 251 -> STMUtils.expandSubtree((STMTreeNode)setTargetNode, Set.of(STMKnownRuleNames.setTargetList), Set.of(STMKnownRuleNames.valueReference)).stream().map(recognizer::collectValueExpression).collect(Collectors.toList());
                        case 280 -> Collections.emptyList();
                        default -> throw new UnsupportedOperationException("Set target list expected while facing with " + setTargetNode.getNodeName());
                    };
                    List<SQLQueryValueExpression> sources = setClauseNode.getChildCount() < 3 ? Collections.emptyList() : STMUtils.expandSubtree((STMTreeNode)setClauseNode.getStmChild(2), Set.of(STMKnownRuleNames.updateSource), Set.of(STMKnownRuleNames.updateValue)).stream().map(v -> recognizer.collectValueExpression(v.getStmChild(0))).collect(Collectors.toList());
                    setClauseList.add(new SQLQueryUpdateSetClauseModel(setClauseNode, targets, sources, setClauseNode.getTextContent()));
                }
                i += 2;
            }
        }
        SQLQueryRowsSourceModel sourceSet = (fromClauseNode = node.findChildOfName(STMKnownRuleNames.fromClause)) == null ? null : recognizer.collectQueryExpression(fromClauseNode);
        STMTreeNode whereClauseNode = node.findChildOfName(STMKnownRuleNames.whereClause);
        SQLQueryValueExpression whereClauseExpr = whereClauseNode == null ? null : recognizer.collectValueExpression(whereClauseNode);
        STMTreeNode orderByClauseNode = node.findChildOfName(STMKnownRuleNames.orderByClause);
        SQLQueryValueExpression orderByExpr = orderByClauseNode == null ? null : recognizer.collectValueExpression(orderByClauseNode);
        return new SQLQueryUpdateModel(node, targetSet, setClauseList, sourceSet, whereClauseExpr, orderByExpr);
    }

    @Nullable
    public SQLQueryRowsSourceModel getTargetRows() {
        return this.targetRows;
    }

    @Nullable
    public List<SQLQueryUpdateSetClauseModel> getSetClauseList() {
        return this.setClauseList;
    }

    @Nullable
    public SQLQueryRowsSourceModel getSourceRows() {
        return this.sourceRows;
    }

    @Nullable
    public SQLQueryValueExpression getWhereClause() {
        return this.whereClause;
    }

    @Nullable
    public SQLQueryValueExpression getOrderByClause() {
        return this.orderByClause;
    }

    @Override
    protected void applyContext(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        SQLQueryDataContext sourceContext;
        SQLQueryDataContext targetContext;
        this.givenContext = context;
        if (this.targetRows != null) {
            targetContext = this.targetRows.propagateContext(context, statistics);
            if (this.setClauseList != null) {
                for (SQLQueryUpdateSetClauseModel updateSetClauseModel : this.setClauseList) {
                    for (SQLQueryValueExpression valueExpression : updateSetClauseModel.targets) {
                        valueExpression.propagateContext(targetContext, statistics);
                    }
                }
            }
        } else {
            targetContext = context;
        }
        SQLQueryDataContext sQLQueryDataContext = sourceContext = this.sourceRows != null ? this.sourceRows.propagateContext(context, statistics) : context;
        if (targetContext != context || sourceContext != context) {
            context = targetContext.combine(sourceContext);
        }
        if (this.setClauseList != null) {
            for (SQLQueryUpdateSetClauseModel setClauseModel : this.setClauseList) {
                for (SQLQueryValueExpression valueExpression : setClauseModel.sources) {
                    valueExpression.propagateContext(context, statistics);
                }
            }
        }
        if (this.whereClause != null) {
            this.whereClause.propagateContext(context, statistics);
        }
        if (this.orderByClause != null) {
            this.orderByClause.propagateContext(context, statistics);
        }
        this.resultContext = context;
    }

    @Override
    public SQLQueryDataContext getGivenDataContext() {
        return this.givenContext;
    }

    @Override
    public SQLQueryDataContext getResultDataContext() {
        return this.resultContext;
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitTableStatementUpdate(this, arg);
    }
}

