/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.select;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsCorrelatedSourceModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsCteSubqueryModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryRowsCteModel
extends SQLQueryRowsSourceModel {
    private final boolean isRecursive;
    @NotNull
    private final List<SQLQueryRowsCteSubqueryModel> subqueries;
    @NotNull
    private final SQLQueryRowsSourceModel resultQuery;

    public SQLQueryRowsCteModel(@NotNull STMTreeNode syntaxNode, boolean isRecursive, @NotNull List<SQLQueryRowsCteSubqueryModel> subqueries, @NotNull SQLQueryRowsSourceModel resultQuery) {
        super(syntaxNode, resultQuery);
        this.isRecursive = isRecursive;
        this.resultQuery = resultQuery;
        this.subqueries = List.copyOf(subqueries);
        this.subqueries.forEach(sQLQueryNodeModel -> super.registerSubnode((SQLQueryNodeModel)sQLQueryNodeModel));
    }

    @NotNull
    public List<SQLQueryRowsSourceModel> getAllQueries() {
        ArrayList<SQLQueryRowsSourceModel> queries = new ArrayList<SQLQueryRowsSourceModel>(this.subqueries.size() + 1);
        queries.addAll(this.subqueries);
        queries.add(this.resultQuery);
        return queries;
    }

    @Override
    @NotNull
    protected SQLQueryDataContext propagateContextImpl(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        SQLQueryDataContext aggregatedContext = context;
        if (this.isRecursive) {
            for (SQLQueryRowsCteSubqueryModel subquery : this.subqueries) {
                subquery.propagateContext(context, statistics);
                aggregatedContext = aggregatedContext.combine(aggregatedContext.hideSources().extendWithTableAlias(subquery.subqueryName.getSymbol(), subquery));
            }
            for (SQLQueryRowsCteSubqueryModel subquery : this.subqueries) {
                if (!subquery.subqueryName.isNotClassified()) continue;
                context = subquery.source.propagateContext(aggregatedContext, statistics).hideSources();
                subquery.propagateContext(context, statistics);
                subquery.prepareAliasDefinition();
            }
        } else {
            for (SQLQueryRowsCteSubqueryModel subquery : this.subqueries) {
                if (!subquery.subqueryName.isNotClassified()) continue;
                SQLQueryDataContext currCtx = subquery.source.propagateContext(aggregatedContext, statistics).hideSources().extendWithTableAlias(subquery.subqueryName.getSymbol(), subquery);
                subquery.prepareAliasDefinition();
                currCtx = SQLQueryRowsCorrelatedSourceModel.prepareColumnsCorrelation(currCtx, subquery.columNames, subquery);
                subquery.propagateContext(currCtx, statistics);
                aggregatedContext = aggregatedContext.combine(currCtx);
            }
        }
        return this.resultQuery.propagateContext(aggregatedContext, statistics).hideSources();
    }

    @Override
    @Nullable
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitRowsCte(this, arg);
    }
}

