/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.select;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.misc.Interval;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSetCorrespondingOperationKind;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSetOperationModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryRowsSetCorrespondingOperationModel
extends SQLQueryRowsSetOperationModel {
    @NotNull
    private final List<SQLQuerySymbolEntry> correspondingColumnNames;
    @NotNull
    private final SQLQueryRowsSetCorrespondingOperationKind kind;

    public SQLQueryRowsSetCorrespondingOperationModel(@NotNull Interval range, @NotNull STMTreeNode syntaxNode, @NotNull SQLQueryRowsSourceModel left, @NotNull SQLQueryRowsSourceModel right, @NotNull List<SQLQuerySymbolEntry> correspondingColumnNames, @NotNull SQLQueryRowsSetCorrespondingOperationKind kind) {
        super(range, syntaxNode, left, right);
        this.correspondingColumnNames = correspondingColumnNames;
        this.kind = kind;
    }

    @NotNull
    public SQLQueryRowsSetCorrespondingOperationKind getKind() {
        return this.kind;
    }

    @NotNull
    private SQLQueryExprType obtainCommonType(@Nullable SQLQueryResultColumn leftDef, @Nullable SQLQueryResultColumn rightDef) {
        SQLQueryExprType type;
        if (leftDef == null && rightDef == null) {
            type = SQLQueryExprType.UNKNOWN;
        } else if (leftDef == null) {
            type = rightDef.type;
        } else if (rightDef == null) {
            type = leftDef.type;
        } else {
            type = SQLQueryExprType.tryCombineIfMatches(leftDef.type, rightDef.type);
            if (type == null) {
                type = SQLQueryExprType.UNKNOWN;
            }
        }
        return type;
    }

    @Override
    @NotNull
    protected SQLQueryDataContext propagateContextImpl(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        ArrayList<SQLQueryResultColumn> resultColumns;
        SQLQueryDataContext left = this.left.propagateContext(context, statistics);
        SQLQueryDataContext right = this.right.propagateContext(context, statistics);
        boolean nonMatchingColumnSets = false;
        if (this.correspondingColumnNames.isEmpty()) {
            List<SQLQueryResultColumn> leftColumns = left.getColumnsList();
            List<SQLQueryResultColumn> rightColumns = right.getColumnsList();
            int resultColumnsCount = Math.max(leftColumns.size(), rightColumns.size());
            resultColumns = new ArrayList(resultColumnsCount);
            int i = 0;
            while (i < resultColumnsCount) {
                if (i >= leftColumns.size()) {
                    resultColumns.add(rightColumns.get(i));
                    nonMatchingColumnSets = true;
                } else if (i >= rightColumns.size()) {
                    resultColumns.add(leftColumns.get(i));
                    nonMatchingColumnSets = true;
                } else {
                    SQLQueryExprType type = this.obtainCommonType(leftColumns.get(i), rightColumns.get(i));
                    SQLQuerySymbol symbol = leftColumns.get((int)i).symbol.merge(rightColumns.get((int)i).symbol);
                    resultColumns.add(new SQLQueryResultColumn(i, symbol, this, null, null, type));
                }
                ++i;
            }
        } else {
            int resultColumnsCount = this.correspondingColumnNames.size();
            resultColumns = new ArrayList<SQLQueryResultColumn>(resultColumnsCount);
            int i = 0;
            while (i < resultColumnsCount) {
                SQLQuerySymbolEntry column = this.correspondingColumnNames.get(i);
                if (column.isNotClassified()) {
                    SQLQueryResultColumn leftDef = left.resolveColumn(statistics.getMonitor(), column.getName());
                    SQLQueryResultColumn rightDef = right.resolveColumn(statistics.getMonitor(), column.getName());
                    if (leftDef == null || rightDef == null) {
                        nonMatchingColumnSets = true;
                    }
                    SQLQueryExprType type = this.obtainCommonType(leftDef, rightDef);
                    column.getSymbol().setDefinition(column);
                    resultColumns.add(new SQLQueryResultColumn(i, column.getSymbol(), this, null, null, type));
                }
                ++i;
            }
        }
        if (nonMatchingColumnSets) {
            statistics.appendError(this.getSyntaxNode(), "UNION, EXCEPT and INTERSECT require subsets column tuples to match");
        }
        return this.correspondingColumnNames.isEmpty() ? left : context.overrideResultTuple(resultColumns);
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitRowsSetCorrespondingOp(this, arg);
    }
}

